/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp.mysql;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.wsdl.Definition;
import oracle.tip.adapter.db.sp.xsd.IXSDProcedure;
import oracle.tip.adapter.db.sp.xsd.mysql.XSDProcedure;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.AdapterWizardContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp.AbstractDataAccess;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp.ArgumentObject;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp.PackageObject;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp.ProcedureObject;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp.mysql.DBAdapterSPUserInput;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.wsdl.JcaOperation;

public class DataAccess
extends AbstractDataAccess {
    @Override
    public List getPackages(Connection conn, String catalogName) throws Exception {
        return this.getProcedures(conn, catalogName, null);
    }

    @Override
    public PackageObject getPackage(Connection conn, String catalogName, String schemaName) throws Exception {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getProcedures(Connection conn, String catalogName, PackageObject schemaObj) throws Exception {
        List procedureList = null;
        ResultSet routines = null;
        Statement stmt = null;
        String query = "select routine_schema, routine_name from information_schema.routines where routine_schema = '" + catalogName + "' " + "group by routine_schema, routine_name order by routine_name";
        try {
            stmt = conn.createStatement();
            this.traceQuery(query);
            routines = stmt.executeQuery(query);
            procedureList = this.generatePackagedProcedures(routines, catalogName, schemaObj);
        }
        catch (Throwable throwable) {
            this.closeResultSet(routines);
            throw throwable;
        }
        this.closeResultSet(routines);
        return procedureList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getSchemas(Connection conn) throws Exception {
        ArrayList<String> catalogList = new ArrayList<String>();
        ResultSet catalogNames = null;
        Statement stmt = null;
        String query = "select schema_name from information_schema.schemata";
        try {
            String currentSchema;
            stmt = conn.createStatement();
            this.traceQuery(query);
            catalogNames = stmt.executeQuery(query);
            while (catalogNames.next()) {
                catalogList.add(catalogNames.getString("schema_name"));
            }
            if (catalogList.size() == 0 && (currentSchema = this.getConnectionSchema(conn)) != null) {
                catalogList.add(currentSchema);
            }
        }
        catch (Throwable throwable) {
            this.closeResultSet(catalogNames);
            throw throwable;
        }
        this.closeResultSet(catalogNames);
        return catalogList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getArguments(Connection conn, ProcedureObject procObj) throws Exception {
        List argumentList = null;
        ResultSet arguments = null;
        Statement stmt = null;
        if (procObj != null) {
            String query = "select parameter_name, ordinal_position, parameter_mode, data_type, character_maximum_length from information_schema.parameters where specific_schema = '" + procObj.getSchema() + "' " + "and specific_name = '" + procObj.getName() + "' " + "order by ordinal_position";
            try {
                stmt = conn.createStatement();
                this.traceQuery(query);
                arguments = stmt.executeQuery(query);
                argumentList = this.generateArgumentList(arguments, procObj);
            }
            catch (Throwable throwable) {
                this.closeResultSet(arguments);
                throw throwable;
            }
            this.closeResultSet(arguments);
        }
        return argumentList;
    }

    private List generateArgumentList(ResultSet args, ProcedureObject procObj) throws Exception {
        ArrayList<ArgumentObject> argumentList = new ArrayList<ArgumentObject>();
        while (args.next()) {
            ArgumentObject argumentObj = new ArgumentObject(null, args.getString("parameter_name"), null, args.getString("ordinal_position"), null, args.getString("data_type"), null, procObj.getSchema(), args.getString("parameter_mode"), args.getInt("character_maximum_length"), 0, procObj);
            if (Integer.valueOf(argumentObj.getPosition()) == 0) {
                argumentObj.setInOut("OUT");
            }
            argumentList.add(argumentObj);
        }
        return argumentList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List searchProcedures(Connection conn, String searchString, PackageObject schemaObj, String catalogName) throws Exception {
        List procedureList = null;
        if (searchString != null) {
            String routineName = searchString;
            String schemaName = catalogName;
            ResultSet routines = null;
            Statement stmt = null;
            String query = "select routine_schema, routine_name from information_schema.routines where routine_schema like '" + schemaName + "' " + "and routine_name like '" + routineName + "' " + "group by routine_schema, routine_name order by routine_schema";
            try {
                stmt = conn.createStatement();
                this.traceQuery(query);
                routines = stmt.executeQuery(query);
                procedureList = this.generatePackagedProcedures(routines, catalogName, schemaObj);
            }
            catch (Throwable throwable) {
                this.closeResultSet(routines);
                throw throwable;
            }
            this.closeResultSet(routines);
        }
        return procedureList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getProcedureSourceCode(Connection conn, ProcedureObject procObj) throws Exception {
        ArrayList<String> sourceList = new ArrayList<String>();
        if (procObj != null) {
            ResultSet definition;
            block4: {
                definition = null;
                Statement stmt = null;
                String query = "select routine_definition from information_schema.routines where routine_name='" + procObj.getName() + "' " + "and routine_schema='" + procObj.getSchema() + "'";
                try {
                    String code;
                    stmt = conn.createStatement();
                    this.traceQuery(query);
                    definition = stmt.executeQuery(query);
                    if (!definition.next() || (code = definition.getString(1)) == null) break block4;
                    char[] chars = new char[]{'\n'};
                    StringTokenizer st = new StringTokenizer(code, new String(chars));
                    while (st.hasMoreTokens()) {
                        sourceList.add(st.nextToken() + '\n');
                    }
                }
                catch (Throwable throwable) {
                    this.closeResultSet(definition);
                    throw throwable;
                }
            }
            this.closeResultSet(definition);
        }
        return sourceList;
    }

    private List generatePackagedProcedures(ResultSet routines, String catalogName, PackageObject schemaObj) throws Exception {
        ArrayList<ProcedureObject> procedureList = new ArrayList<ProcedureObject>();
        routines.setFetchSize(500);
        while (routines.next()) {
            String schemaName = routines.getString("routine_schema");
            String routineName = routines.getString("routine_name");
            ProcedureObject procedureObj = new ProcedureObject(null, routineName, schemaName, null, 0, false);
            procedureList.add(procedureObj);
        }
        return procedureList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getProcedure(Connection conn, String catalogName, String schemaName, String procedureName) throws Exception {
        List procedureList = null;
        if (procedureName != null) {
            ResultSet routines = null;
            Statement stmt = null;
            PackageObject schemaObj = null;
            try {
                String query = "select routine_schema, routine_name from information_schema.routines where routine_schema = '" + catalogName + "' " + "and routine_name = '" + procedureName + "' " + "group by routine_schema, routine_name order by routine_name";
                stmt = conn.createStatement();
                this.traceQuery(query);
                routines = stmt.executeQuery(query);
                procedureList = this.generatePackagedProcedures(routines, catalogName, schemaObj);
            }
            catch (Throwable throwable) {
                this.closeResultSet(routines);
                throw throwable;
            }
            this.closeResultSet(routines);
        }
        return procedureList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getConnectionSchema(Connection conn) throws Exception {
        String catalogName = null;
        ResultSet db = null;
        Statement stmt = null;
        try {
            String query = "select schema()";
            stmt = conn.createStatement();
            this.traceQuery(query);
            db = stmt.executeQuery(query);
            if (db.next()) {
                catalogName = db.getString(1);
            }
        }
        catch (Throwable throwable) {
            this.closeResultSet(db);
            throw throwable;
        }
        this.closeResultSet(db);
        return catalogName;
    }

    @Override
    public IXSDProcedure convertToXSDStoredProcedure(AdapterWizardContext wcontext, ProcedureObject procObj) throws Exception {
        XSDProcedure xsdStoredProc = null;
        if (procObj != null) {
            String defaultCatalog = wcontext._bundle.getString("CM_WZ_DBSCHEMA_CONNECTION_USER_DEFAULT");
            String catalogName = procObj.getSchema();
            if (catalogName.equals(defaultCatalog)) {
                catalogName = this.getConnectionSchema(wcontext._connection);
            }
            xsdStoredProc = new XSDProcedure(catalogName, null, procObj.getName());
            List argList = procObj.getArgumentList();
            if (argList != null && argList.size() > 0) {
                for (int i = 0; i < argList.size(); ++i) {
                    ArgumentObject currentArg = (ArgumentObject)argList.get(i);
                    if (currentArg.getName() != null && currentArg.getName().equals("RowSet")) continue;
                    xsdStoredProc.addParameter(currentArg.getName(), currentArg.getTypeName().toUpperCase(), currentArg.getInOut(), Integer.valueOf(currentArg.getPosition()), currentArg.getCharLength());
                }
            }
        }
        return xsdStoredProc;
    }

    @Override
    protected void setJcaOperationInteractionSpec(AdapterWizardContext wcontext, JcaOperation jcaOp) {
        jcaOp.setAttributeValue("InteractionSpec", "oracle.tip.adapter.db.DBStoredProcedureInteractionSpec");
    }

    @Override
    protected IXSDProcedure getTheXsdStoredProcedure(AdapterWizardContext wcontext, ProcedureObject procObj) throws Exception {
        return this.convertToXSDStoredProcedure(wcontext, procObj);
    }

    @Override
    protected void setUiOverloadedProcedure(AdapterWizardContext wcontext, ProcedureObject procObj) {
    }

    @Override
    protected void setUiProcedureReturnStatus(AdapterWizardContext wcontext, ProcedureObject procObj) {
    }

    @Override
    public void setUiStrongXSD(AdapterWizardContext wcontext) {
    }

    private void importHeaderWSDL(AdapterWizardContext wcontext, Definition def) throws Exception {
    }

    public void printUserInput(DBAdapterSPUserInput userInput) {
        System.out.println("************ USER INPUT ***************");
        if (userInput != null) {
            List argList = null;
            ProcedureObject procObj = userInput.getProcedure();
            if (procObj != null) {
                argList = procObj.getArgumentList();
            }
            System.out.println("Schema: " + userInput.getSchema());
            if (procObj != null) {
                System.out.println("Procedure: " + procObj.getName());
            }
            if (argList != null && argList.size() > 0) {
                System.out.println("\nARGUMENTS - " + argList.size());
                System.out.println("--------------------");
                for (int i = 0; i < argList.size(); ++i) {
                    ArgumentObject argObj = (ArgumentObject)argList.get(i);
                    System.out.println(" >> " + i + " << ");
                    System.out.println("Name: " + argObj.getName());
                    System.out.println("Type: " + argObj.getTypeName());
                    System.out.println("Direction: " + argObj.getInOut());
                    System.out.println("Position: " + argObj.getPosition());
                    System.out.println("CharLength: " + argObj.getCharLength());
                }
            }
        }
        System.out.println("***************************************");
    }
}

