/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp.mysql;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.event.DocumentEvent;
import oracle.bali.ewt.event.Cancelable;
import oracle.bali.ewt.wizard.ImageWizardPage;
import oracle.bali.ewt.wizard.WizardEvent;
import oracle.tip.tools.ide.common.utils.MultiLineOptionPane;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.AdapterWizardContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp.AbstractStoredProcPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp.ProcedureObject;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp.mysql.MySQLDatabase;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp.mysql.SelectProcDialog;

public class DBAdapterStoredProcPage
extends AbstractStoredProcPage {
    public DBAdapterStoredProcPage(AdapterWizardContext wcontext, ImageWizardPage iwp) throws Exception {
        super(wcontext, iwp, new MySQLDatabase());
    }

    @Override
    protected void jbInitHelper(ProcedureObject procObj) {
        if (this.isUpdating) {
            this.m_page.setCanAdvance(true);
            this.isUpdating = false;
        } else {
            this.m_page.setCanAdvance(false);
        }
    }

    @Override
    protected void redrawPage() {
        this.revalidate();
    }

    @Override
    protected void loadProcedureBrowseDialog(boolean overloadedProcSpecified) {
        String selectedSchema = (String)this.schemaComboBox.getSelectedItem();
        this.userInput.setProcUserTextInput(this.procTextField.getText().trim());
        try {
            SelectProcDialog selectProcDialog = new SelectProcDialog(this.m_wcontext, selectedSchema, overloadedProcSpecified, this.userInput);
            if (selectProcDialog.runDialog()) {
                this.userInput = selectProcDialog.getUserInput();
                this.reflectUserInput();
            }
            this.userInput.setIsInSearchMode(false);
        }
        catch (Exception e) {
            MultiLineOptionPane.showMessageDialog((Component)this.m_wcontext._parentFrame, (Object)this.getTranslatedString("DB_SP_CONN_ERROR_STORED_PROCS"), (String)this.getTranslatedString("DB_SP_ERROR"), (int)0);
            e.printStackTrace();
        }
    }

    @Override
    protected void validatePage(WizardEvent event, String schema, String packageName, String procedureName) throws Exception {
        List procList = null;
        if (procedureName != null) {
            procList = this.dataAccess.getProcedure(this.m_wcontext._connection, schema, packageName, procedureName);
        } else {
            this.m_page.setCanAdvance(false);
            MultiLineOptionPane.showMessageDialog((Component)this.m_wcontext._parentFrame, (Object)this.getTranslatedString("DB_SP_PROCEDURE_NOT_FOUND_MSG"), (String)this.getTranslatedString("DB_SP_PROCEDURE_NOT_FOUND_TITLE"), (int)0);
            ((Cancelable)event).cancel();
        }
        if (procList != null && procList.size() == 1) {
            ProcedureObject procObj = (ProcedureObject)procList.get(0);
            List argList = this.dataAccess.getArguments(this.m_wcontext._connection, procObj);
            procObj.setArgumentList(argList);
            this.userInput.setProcedure(procObj);
            this.userInput.setPackage(procObj.getPackage());
        } else if (procList == null || procList.size() < 1) {
            MultiLineOptionPane.showMessageDialog((Component)this.m_wcontext._parentFrame, (Object)this.getTranslatedString("DB_SP_PROCEDURE_NOT_FOUND_MSG"), (String)this.getTranslatedString("DB_SP_PROCEDURE_NOT_FOUND_TITLE"), (int)0);
            ((Cancelable)event).cancel();
        }
    }

    @Override
    protected void schemaComboBox_actionPerformed(ActionEvent e) {
        if (!this.procTextField.getText().trim().equals("")) {
            this.m_page.setCanAdvance(true);
        } else {
            this.m_page.setCanAdvance(false);
        }
        this.clearAndHideArgsTable();
    }

    @Override
    protected void respondToUserInput(DocumentEvent e) {
        boolean procTextIsValid = false;
        String docName = (String)e.getDocument().getProperty("DOCUMENT_NAME_KEY");
        if (docName != null && docName.equals("PROC_TEXT_FIELD")) {
            this.argsLabel.setVisible(false);
            this.tableScrollPane.setVisible(false);
            this.revalidate();
        }
        if (this.procTextField.getText() != null && !this.procTextField.getText().trim().equals("")) {
            procTextIsValid = true;
        }
        this.m_page.setCanAdvance(procTextIsValid);
    }
}

