/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp.informix;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import oracle.tip.adapter.db.sp.informix.IfxUtil;
import oracle.tip.adapter.db.sp.xsd.IXSDProcedure;
import oracle.tip.adapter.db.sp.xsd.informix.XSDProcedure;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.AdapterWizardContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp.AbstractDataAccess;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp.ArgumentObject;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp.PackageObject;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp.ProcedureObject;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp.informix.DBAdapterSPUserInput;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.wsdl.JcaOperation;

public class DataAccess
extends AbstractDataAccess {
    private static final int MULTIPLE_RETURN_VALUE = 3;

    @Override
    public List getPackages(Connection conn, String catalogName) throws Exception {
        return this.getProcedures(conn, catalogName, null);
    }

    @Override
    public PackageObject getPackage(Connection conn, String catalogName, String schemaName) throws Exception {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getProcedures(Connection conn, String catalogName, PackageObject schemaObj) throws Exception {
        List procedureList = null;
        ResultSet routines = null;
        Statement stmt = null;
        String query = "select procname, owner, procid from sysprocedures where owner='" + catalogName + "'" + " group by owner, procname, procid order by procname";
        try {
            stmt = conn.createStatement();
            this.traceQuery(query);
            routines = stmt.executeQuery(query);
            procedureList = this.generatePackagedProcedures(routines, catalogName, schemaObj);
        }
        catch (Throwable throwable) {
            this.closeResultSet(routines);
            throw throwable;
        }
        this.closeResultSet(routines);
        return procedureList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getSchemas(Connection conn) throws Exception {
        ArrayList<String> schemaList = new ArrayList<String>();
        ResultSet schemaNames = null;
        Statement stmt = null;
        String query = "select username from sysusers order by username";
        try {
            String currentSchema;
            stmt = conn.createStatement();
            this.traceQuery(query);
            schemaNames = stmt.executeQuery(query);
            while (schemaNames.next()) {
                schemaList.add(schemaNames.getString("username").trim());
            }
            if (schemaList.size() == 0 && (currentSchema = this.getConnectionSchema(conn)) != null) {
                schemaList.add(currentSchema);
            }
        }
        catch (Throwable throwable) {
            this.closeResultSet(schemaNames);
            throw throwable;
        }
        this.closeResultSet(schemaNames);
        return schemaList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getArguments(Connection conn, ProcedureObject procObj) throws Exception {
        List argumentList = null;
        ResultSet arguments = null;
        Statement stmt = null;
        if (procObj != null) {
            String query = "select c.procid, p.procid, c.paramid, c.paramname, c.paramtype, c.paramlen, c.paramattr from sysproccolumns c, sysprocedures p where c.procid = p.procid and p.procid = " + procObj.getObjectID() + " order by c.paramid";
            try {
                stmt = conn.createStatement();
                this.traceQuery(query);
                arguments = stmt.executeQuery(query);
                argumentList = this.generateArgumentList(arguments, procObj);
            }
            catch (Throwable throwable) {
                this.closeResultSet(arguments);
                throw throwable;
            }
            this.closeResultSet(arguments);
        }
        return argumentList;
    }

    private List generateArgumentList(ResultSet args, ProcedureObject procObj) throws Exception {
        ArrayList<ArgumentObject> argumentList = new ArrayList<ArgumentObject>();
        int position = 1;
        while (args.next()) {
            int paramattr = args.getInt("paramattr");
            if (paramattr == 3) continue;
            ArgumentObject argumentObj = new ArgumentObject(null, args.getString("paramname"), null, Integer.valueOf(position++).toString(), null, IfxUtil.getJDBCTypeName((int)args.getInt("paramtype")), null, null, IfxUtil.getDirection((int)args.getInt("paramattr")), args.getInt("paramlen"), 0, procObj);
            argumentList.add(argumentObj);
        }
        return argumentList;
    }

    @Override
    public IXSDProcedure convertToXSDStoredProcedure(AdapterWizardContext wcontext, ProcedureObject procObj) throws Exception {
        IXSDProcedure xsdStoredProc = null;
        if (procObj != null) {
            String defaultCatalog = wcontext._bundle.getString("CM_WZ_DBSCHEMA_CONNECTION_USER_DEFAULT");
            String catalogName = procObj.getSchema();
            if (catalogName.equals(defaultCatalog)) {
                catalogName = this.getConnectionSchema(wcontext._connection);
            }
            xsdStoredProc = this.convertToXSDStoredProcedure(catalogName, procObj);
        }
        return xsdStoredProc;
    }

    private IXSDProcedure convertToXSDStoredProcedure(String catalogName, ProcedureObject procObj) {
        XSDProcedure xsdProcedure = new XSDProcedure(catalogName, null, procObj.getName());
        List argList = procObj.getArgumentList();
        if (argList != null && argList.size() > 0) {
            for (int i = 0; i < argList.size(); ++i) {
                ArgumentObject argument = (ArgumentObject)argList.get(i);
                if (argument.getName().equals("RowSet")) continue;
                xsdProcedure.addParameter(argument.getName(), argument.getTypeName(), argument.getInOut(), argument.getPosition(), argument.getCharLength());
            }
        }
        return xsdProcedure;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List searchProcedures(Connection conn, String searchString, PackageObject schemaObj, String catalogName) throws Exception {
        List procedureList = null;
        if (searchString != null) {
            String procName = searchString;
            String ownerName = catalogName;
            ResultSet routines = null;
            Statement stmt = null;
            String query = "select procname, owner, procid from sysprocedures where owner='" + ownerName + "'" + " and procname like '" + procName + "'" + " group by owner, procname, procid order by procname";
            try {
                stmt = conn.createStatement();
                this.traceQuery(query);
                routines = stmt.executeQuery(query);
                procedureList = this.generatePackagedProcedures(routines, catalogName, schemaObj);
            }
            catch (Throwable throwable) {
                this.closeResultSet(routines);
                throw throwable;
            }
            this.closeResultSet(routines);
        }
        return procedureList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getProcedureSourceCode(Connection conn, ProcedureObject procObj) throws Exception {
        ArrayList<String> sourceList = new ArrayList<String>();
        if (procObj != null) {
            ResultSet text;
            block5: {
                text = null;
                Statement stmt = null;
                String query = "select data from sysprocbody where procid=" + procObj.getObjectID() + " and datakey='T'";
                try {
                    stmt = conn.createStatement();
                    this.traceQuery(query);
                    text = stmt.executeQuery(query);
                    if (!text.next()) break block5;
                    StringBuffer code = new StringBuffer();
                    do {
                        code.append(text.getString("data"));
                    } while (text.next());
                    char[] chars = new char[]{'\n'};
                    StringTokenizer st = new StringTokenizer(code.toString(), new String(chars));
                    while (st.hasMoreTokens()) {
                        sourceList.add(st.nextToken() + '\n');
                    }
                }
                catch (Throwable throwable) {
                    this.closeResultSet(text);
                    throw throwable;
                }
            }
            this.closeResultSet(text);
        }
        return sourceList;
    }

    private List generatePackagedProcedures(ResultSet routines, String catalogName, PackageObject schemaObj) throws Exception {
        ArrayList<ProcedureObject> procedureList = new ArrayList<ProcedureObject>();
        routines.setFetchSize(500);
        while (routines.next()) {
            String procName = routines.getString("procname");
            String ownerName = routines.getString("owner").trim();
            int overload = routines.getInt("procid");
            String procId = Integer.valueOf(overload).toString();
            ProcedureObject procedureObj = new ProcedureObject(procId, procName, ownerName, null, overload, false);
            procedureList.add(procedureObj);
        }
        return procedureList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getProcedure(Connection conn, String catalogName, String schemaName, String procedureName) throws Exception {
        List procedureList = null;
        if (procedureName != null) {
            ResultSet routines = null;
            Statement stmt = null;
            PackageObject schemaObj = null;
            try {
                String query = "select procname, owner, procid from sysprocedures where owner='" + catalogName + "'" + " and procname='" + procedureName + "'" + " group by owner, procname, procid order by procname";
                stmt = conn.createStatement();
                this.traceQuery(query);
                routines = stmt.executeQuery(query);
                procedureList = this.generatePackagedProcedures(routines, catalogName, schemaObj);
            }
            catch (Throwable throwable) {
                this.closeResultSet(routines);
                throw throwable;
            }
            this.closeResultSet(routines);
        }
        return procedureList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getConnectionSchema(Connection conn) throws Exception {
        String catalogName = null;
        ResultSet db = null;
        Statement stmt = null;
        try {
            String query = "select user from sysmaster:sysdual";
            stmt = conn.createStatement();
            this.traceQuery(query);
            db = stmt.executeQuery(query);
            if (db.next()) {
                catalogName = db.getString(1).trim();
            }
        }
        catch (Throwable throwable) {
            this.closeResultSet(db);
            throw throwable;
        }
        this.closeResultSet(db);
        return catalogName;
    }

    @Override
    public void writeJcaOperationAttributes(AdapterWizardContext wcontext, boolean isDefaultSchema, ProcedureObject procObj) {
        JcaOperation jop = wcontext._write_jca_operation;
        if (!isDefaultSchema) {
            jop.setAttributeValue("PackageName", procObj.getSchema());
        }
        jop.setAttributeValue("ProcedureName", procObj.getName());
        this.setJcaOperationInteractionSpec(wcontext, jop);
    }

    @Override
    public void setJcaOperationInteractionSpec(AdapterWizardContext wcontext, JcaOperation jcaOp) {
        jcaOp.setAttributeValue("InteractionSpec", "oracle.tip.adapter.db.DBStoredProcedureInteractionSpec");
    }

    @Override
    public IXSDProcedure getTheXsdStoredProcedure(AdapterWizardContext wcontext, ProcedureObject procObj) throws Exception {
        return this.convertToXSDStoredProcedure(wcontext, procObj);
    }

    @Override
    public void setUiOverloadedProcedure(AdapterWizardContext wcontext, ProcedureObject procObj) {
        wcontext._write_jca_address.setUiOverloadedProcedure(String.valueOf(procObj.getOverload()));
    }

    @Override
    public void setUiProcedureReturnStatus(AdapterWizardContext wcontext, ProcedureObject procObj) {
    }

    @Override
    public void setUiStrongXSD(AdapterWizardContext wcontext) {
    }

    public void printUserInput(DBAdapterSPUserInput userInput) {
        System.out.println("************ USER INPUT ***************");
        if (userInput != null) {
            List argList = null;
            ProcedureObject procObj = userInput.getProcedure();
            if (procObj != null) {
                argList = procObj.getArgumentList();
            }
            if (procObj != null) {
                System.out.println("Procedure: " + procObj.getName());
            }
            if (argList != null && argList.size() > 0) {
                System.out.println("\nARGUMENTS - " + argList.size());
                System.out.println("--------------------");
                for (int i = 0; i < argList.size(); ++i) {
                    ArgumentObject argObj = (ArgumentObject)argList.get(i);
                    System.out.println(" >> " + i + " << ");
                    System.out.println("Name: " + argObj.getName());
                    System.out.println("Type: " + argObj.getTypeName());
                    System.out.println("Direction: " + argObj.getInOut());
                    System.out.println("Position: " + argObj.getPosition());
                    System.out.println("CharLength: " + argObj.getCharLength());
                }
            }
        }
        System.out.println("***************************************");
    }
}

