/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp.informix;

import java.util.List;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.AdapterWizardContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp.AbstractSPUserInput;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp.ProcedureObject;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp.informix.DataAccess;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.wsdl.JcaAddress;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.wsdl.JcaOperation;

public class DBAdapterSPUserInput
extends AbstractSPUserInput
implements Cloneable {
    public DBAdapterSPUserInput() {
        this.dataAccess = new DataAccess();
    }

    @Override
    public ProcedureObject getProcedureFromWSDL(AdapterWizardContext wcontext) throws Exception {
        ProcedureObject procObj = null;
        JcaOperation jop = wcontext._read_jca_operation;
        String wsdlSchema = jop.getAttributeValue("PackageName");
        String wsdlProcName = jop.getAttributeValue("ProcedureName");
        String schema = wsdlSchema;
        if (schema == null) {
            schema = this.dataAccess.getConnectionSchema(wcontext._connection);
        }
        if ((procObj = this.getWSDLProcedure(wcontext, schema, null, wsdlProcName)) != null) {
            procObj.setArgumentList(this.dataAccess.getArguments(wcontext._connection, procObj));
            if (wsdlSchema == null) {
                procObj.setSchema(wcontext._bundle.getString("CM_WZ_DBSCHEMA_CONNECTION_USER_DEFAULT"));
            }
        }
        return procObj;
    }

    @Override
    protected ProcedureObject getWSDLProcedure(AdapterWizardContext wcontext, String schema, String wsdlPackageName, String wsdlProcName) throws Exception {
        ProcedureObject procObj = null;
        List procList = this.dataAccess.getProcedure(wcontext._connection, schema, wsdlPackageName, wsdlProcName);
        if (procList != null && procList.size() == 1) {
            procObj = (ProcedureObject)procList.get(0);
        } else {
            JcaAddress jad = wcontext._read_jca_address;
            String wsdlOverload = jad.getUiOverloadedProcedure();
            if (wsdlOverload != null) {
                int overload = Integer.valueOf(wsdlOverload);
                for (int i = 0; i < procList.size() && (procObj = (ProcedureObject)procList.get(i)).getOverload() != overload; ++i) {
                }
            }
        }
        return procObj;
    }

    @Override
    protected String getArgsFilename(AdapterWizardContext wcontext, String schema, ProcedureObject procObj) {
        String argsFileName = schema + "_" + procObj.getName();
        if (procObj.getOverload() > 0) {
            argsFileName = argsFileName + "_" + Integer.toString(procObj.getOverload());
        }
        return argsFileName;
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        return (DBAdapterSPUserInput)super.clone();
    }
}

