/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp.db2.syscat;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import oracle.tip.adapter.db.sp.xsd.IXSDProcedure;
import oracle.tip.adapter.db.sp.xsd.db2.syscat.XSDProcedure;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.AdapterWizardContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp.ArgumentObject;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp.IDBAdapterSPUserInput;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp.PackageObject;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp.ProcedureObject;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp.db2.AbstractDB2DataAccess;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp.db2.syscat.DBAdapterSPUserInput;

public class DataAccess
extends AbstractDB2DataAccess {
    private static HashMap map = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getProcedures(Connection conn, String catalogName, PackageObject schemaObj) throws Exception {
        List procedureList = null;
        ResultSet routines = null;
        Statement stmt = null;
        String query = "select routineschema, routinename from syscat.routines where routinetype='P' and language='SQL' and routineschema='" + catalogName + "'" + " group by routineschema, routinename order by routinename";
        try {
            stmt = conn.createStatement();
            this.traceQuery(query);
            routines = stmt.executeQuery(query);
            procedureList = this.generatePackagedProcedures(routines, catalogName, schemaObj);
        }
        catch (Throwable throwable) {
            this.closeResultSet(routines);
            throw throwable;
        }
        this.closeResultSet(routines);
        return procedureList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getSchemas(Connection conn) throws Exception {
        ArrayList<String> schemaList = new ArrayList<String>();
        ResultSet schemaNames = null;
        Statement stmt = null;
        String query = "select schemaname from syscat.schemata";
        try {
            String currentSchema;
            stmt = conn.createStatement();
            this.traceQuery(query);
            schemaNames = stmt.executeQuery(query);
            while (schemaNames.next()) {
                schemaList.add(schemaNames.getString("schemaname").trim());
            }
            if (schemaList.size() == 0 && (currentSchema = this.getConnectionSchema(conn)) != null) {
                schemaList.add(currentSchema);
            }
        }
        catch (Throwable throwable) {
            this.closeResultSet(schemaNames);
            throw throwable;
        }
        this.closeResultSet(schemaNames);
        return schemaList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getArguments(Connection conn, ProcedureObject procObj) throws Exception {
        List argumentList = null;
        ResultSet arguments = null;
        Statement stmt = null;
        if (procObj != null) {
            String query = "select parmname, typeschema, typename, length, rowtype, ordinal, codepage from syscat.routineparms where routineschema='" + procObj.getSchema() + "'" + " and routinename='" + procObj.getName() + "' order by ordinal";
            try {
                stmt = conn.createStatement();
                this.traceQuery(query);
                arguments = stmt.executeQuery(query);
                argumentList = this.generateArgumentList(arguments, procObj);
            }
            catch (Throwable throwable) {
                this.closeResultSet(arguments);
                throw throwable;
            }
            this.closeResultSet(arguments);
        }
        return argumentList;
    }

    private List generateArgumentList(ResultSet args, ProcedureObject procObj) throws Exception {
        ArrayList<ArgumentObject> argumentList = new ArrayList<ArgumentObject>();
        while (args.next()) {
            ArgumentObject argumentObj = new ArgumentObject(null, args.getString("parmname"), null, args.getString("ordinal"), null, args.getString("typename"), null, args.getString("typeschema"), (String)map.get(args.getString("rowtype")), args.getInt("length"), args.getInt("codepage"), procObj);
            argumentList.add(argumentObj);
        }
        return argumentList;
    }

    @Override
    public IXSDProcedure convertToXSDStoredProcedure(String catalogName, ProcedureObject procObj) {
        XSDProcedure xsdProcedure = new XSDProcedure(catalogName, null, procObj.getName());
        List argList = procObj.getArgumentList();
        if (argList != null && argList.size() > 0) {
            for (int i = 0; i < argList.size(); ++i) {
                ArgumentObject argument = (ArgumentObject)argList.get(i);
                if (argument.getName().equals("RowSet")) continue;
                xsdProcedure.addParameter(argument.getName(), argument.getTypeSchema(), argument.getTypeName(), argument.getInOut(), argument.getPosition(), argument.getCharLength(), argument.getCodePage());
            }
        }
        return xsdProcedure;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List searchProcedures(Connection conn, String searchString, PackageObject schemaObj, String catalogName) throws Exception {
        List procedureList = null;
        if (searchString != null) {
            String routineName = searchString.toUpperCase();
            String schemaName = catalogName;
            ResultSet routines = null;
            Statement stmt = null;
            String query = "select routineschema, routinename from syscat.routines where routineschema='" + schemaName + "'" + " and routinetype='P' and language='SQL'" + " and routinename like '" + routineName + "'" + " group by routineschema, routinename order by routineschema";
            try {
                stmt = conn.createStatement();
                this.traceQuery(query);
                routines = stmt.executeQuery(query);
                procedureList = this.generatePackagedProcedures(routines, catalogName, schemaObj);
            }
            catch (Throwable throwable) {
                this.closeResultSet(routines);
                throw throwable;
            }
            this.closeResultSet(routines);
        }
        return procedureList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getProcedureSourceCode(Connection conn, ProcedureObject procObj) throws Exception {
        ArrayList<String> sourceList = new ArrayList<String>();
        if (procObj != null) {
            ResultSet text;
            block4: {
                text = null;
                Statement stmt = null;
                String query = "select text from syscat.routines where routinename='" + procObj.getName() + "'" + " and routineschema='" + procObj.getSchema() + "'";
                try {
                    String code;
                    stmt = conn.createStatement();
                    this.traceQuery(query);
                    text = stmt.executeQuery(query);
                    if (!text.next() || (code = text.getString(1)) == null) break block4;
                    char[] chars = new char[]{'\n'};
                    StringTokenizer st = new StringTokenizer(code, new String(chars));
                    while (st.hasMoreTokens()) {
                        sourceList.add(st.nextToken() + '\n');
                    }
                }
                catch (Throwable throwable) {
                    this.closeResultSet(text);
                    throw throwable;
                }
            }
            this.closeResultSet(text);
        }
        return sourceList;
    }

    private List generatePackagedProcedures(ResultSet routines, String catalogName, PackageObject schemaObj) throws Exception {
        ArrayList<ProcedureObject> procedureList = new ArrayList<ProcedureObject>();
        routines.setFetchSize(500);
        while (routines.next()) {
            String schemaName = routines.getString("routineschema").trim();
            String routineName = routines.getString("routinename");
            ProcedureObject procedureObj = new ProcedureObject(null, routineName, schemaName, null, 0, false);
            procedureList.add(procedureObj);
        }
        return procedureList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getProcedure(Connection conn, String catalogName, String schemaName, String procedureName) throws Exception {
        List procedureList = null;
        if (procedureName != null) {
            ResultSet routines = null;
            Statement stmt = null;
            PackageObject schemaObj = null;
            try {
                String query = "select routineschema, routinename from syscat.routines where routineschema='" + catalogName + "'" + " and routinename='" + procedureName + "'" + " group by routineschema, routinename order by routinename";
                stmt = conn.createStatement();
                this.traceQuery(query);
                routines = stmt.executeQuery(query);
                procedureList = this.generatePackagedProcedures(routines, catalogName, schemaObj);
            }
            catch (Throwable throwable) {
                this.closeResultSet(routines);
                throw throwable;
            }
            this.closeResultSet(routines);
        }
        return procedureList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getConnectionSchema(Connection conn) throws Exception {
        String catalogName = null;
        ResultSet db = null;
        Statement stmt = null;
        try {
            String query = "select current_schema from sysibm.sysdummy1";
            stmt = conn.createStatement();
            this.traceQuery(query);
            db = stmt.executeQuery(query);
            if (db.next()) {
                catalogName = db.getString(1).trim();
            }
        }
        catch (Throwable throwable) {
            this.closeResultSet(db);
            throw throwable;
        }
        this.closeResultSet(db);
        return catalogName;
    }

    @Override
    public void setUiStrongXSD(AdapterWizardContext wcontext) {
        IDBAdapterSPUserInput userInput = (IDBAdapterSPUserInput)wcontext._ascontext;
        wcontext._write_jca_address.setUiStrongXSD(userInput.isStrongXSD().toString());
    }

    @Override
    public void setUiProcedureReturnStatus(AdapterWizardContext wcontext, ProcedureObject procObj) {
    }

    public void printUserInput(DBAdapterSPUserInput userInput) {
        System.out.println("************ USER INPUT ***************");
        if (userInput != null) {
            List argList = null;
            ProcedureObject procObj = userInput.getProcedure();
            if (procObj != null) {
                argList = procObj.getArgumentList();
            }
            if (procObj != null) {
                System.out.println("Procedure: " + procObj.getName());
            }
            if (argList != null && argList.size() > 0) {
                System.out.println("\nARGUMENTS - " + argList.size());
                System.out.println("--------------------");
                for (int i = 0; i < argList.size(); ++i) {
                    ArgumentObject argObj = (ArgumentObject)argList.get(i);
                    System.out.println(" >> " + i + " << ");
                    System.out.println("Name: " + argObj.getName());
                    System.out.println("Type: " + argObj.getTypeName());
                    System.out.println("Direction: " + argObj.getInOut());
                    System.out.println("Position: " + argObj.getPosition());
                    System.out.println("CharLength: " + argObj.getCharLength());
                }
            }
        }
        System.out.println("***************************************");
    }

    static {
        map.put("P", "IN");
        map.put("B", "INOUT");
        map.put("O", "OUT");
    }
}

