/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp.db2.qsys2;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.event.DocumentEvent;
import oracle.bali.ewt.event.Cancelable;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.ewt.wizard.ImageWizardPage;
import oracle.bali.ewt.wizard.WizardEvent;
import oracle.tip.tools.ide.common.utils.MultiLineOptionPane;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.AdapterWizardContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp.AbstractStoredProcPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp.ProcedureObject;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp.db2.qsys2.Qsys2Database;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp.db2.qsys2.SelectProcDialog;

public class DBAdapterStoredProcPage
extends AbstractStoredProcPage {
    public DBAdapterStoredProcPage(AdapterWizardContext wcontext, ImageWizardPage iwp) throws Exception {
        super(wcontext, iwp, new Qsys2Database());
    }

    @Override
    protected void jbInitHelper(ProcedureObject procObj) {
        String returnStatusText = this.getTranslatedString("DB_SP_RETURNS_STATUS");
        this.returnStatusCheckBox.setText(returnStatusText);
        String usingReturnStatusText = this.getTranslatedString("DB_SP_USING_A_RETURN_STATUS");
        this.returnStatusLabel = new MultiLineLabel(WordWrapper.getTextWrapper(), usingReturnStatusText);
        boolean hasReturnStatus = false;
        boolean visible = false;
        if (procObj != null) {
            Boolean returnStatus;
            boolean bl = visible = !procObj.isFunction();
            if (visible && (returnStatus = Boolean.valueOf(procObj.hasReturnStatus())) != null) {
                hasReturnStatus = returnStatus;
            }
        }
        this.add((Component)this.returnStatusLabel, new GridBagConstraints(0, 5, 0, 1, 1.0, 0.0, 16, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.returnStatusLabel.setVisible(visible);
        this.add((Component)this.returnStatusCheckBox, new GridBagConstraints(0, 7, 3, 1, 1.0, 0.0, 16, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.returnStatusCheckBox.setVisible(visible);
        this.returnStatusCheckBox.setSelected(hasReturnStatus);
        if (this.isUpdating) {
            this.m_page.setCanAdvance(true);
            this.isUpdating = false;
        } else {
            this.m_page.setCanAdvance(false);
        }
    }

    @Override
    protected void redrawPage() {
        boolean visible;
        boolean hasReturnStatus = false;
        boolean bl = visible = !this.userInput.getProcedure().isFunction();
        if (visible) {
            hasReturnStatus = this.userInput.getProcedure().hasReturnStatus();
        }
        this.returnStatusLabel.setVisible(visible);
        this.returnStatusCheckBox.setVisible(visible);
        this.returnStatusCheckBox.setSelected(hasReturnStatus);
        this.revalidate();
    }

    @Override
    protected void loadProcedureBrowseDialog(boolean overloadedProcSpecified) {
        String selectedSchema = (String)this.schemaComboBox.getSelectedItem();
        this.userInput.setProcUserTextInput(this.procTextField.getText().trim());
        try {
            SelectProcDialog selectProcDialog = new SelectProcDialog(this.m_wcontext, selectedSchema, overloadedProcSpecified, this.userInput);
            if (selectProcDialog.runDialog()) {
                this.userInput = selectProcDialog.getUserInput();
                this.reflectUserInput();
            }
            this.userInput.setIsInSearchMode(false);
        }
        catch (Exception e) {
            MultiLineOptionPane.showMessageDialog((Component)this.m_wcontext._parentFrame, (Object)this.getTranslatedString("DB_SP_CONN_ERROR_STORED_PROCS"), (String)this.getTranslatedString("DB_SP_ERROR"), (int)0);
            e.printStackTrace();
        }
    }

    @Override
    protected void validatePage(WizardEvent event, String schema, String packageName, String procedureName) throws Exception {
        List procList = null;
        if (procedureName != null) {
            procList = this.dataAccess.getProcedure(this.m_wcontext._connection, schema, packageName, procedureName);
        } else {
            this.m_page.setCanAdvance(false);
            MultiLineOptionPane.showMessageDialog((Component)this.m_wcontext._parentFrame, (Object)this.getTranslatedString("DB_SP_PROCEDURE_NOT_FOUND_MSG"), (String)this.getTranslatedString("DB_SP_PROCEDURE_NOT_FOUND_TITLE"), (int)0);
            ((Cancelable)event).cancel();
        }
        if (procList != null && procList.size() == 1) {
            ProcedureObject procObj = (ProcedureObject)procList.get(0);
            List argList = this.dataAccess.getArguments(this.m_wcontext._connection, procObj);
            procObj.setArgumentList(argList);
            if (this.returnStatusCheckBox.isSelected()) {
                procObj.setHasReturnStatus(true);
            }
            this.userInput.setProcedure(procObj);
        } else if (procList == null || procList.size() < 1) {
            MultiLineOptionPane.showMessageDialog((Component)this.m_wcontext._parentFrame, (Object)this.getTranslatedString("DB_SP_PROCEDURE_NOT_FOUND_MSG"), (String)this.getTranslatedString("DB_SP_PROCEDURE_NOT_FOUND_TITLE"), (int)0);
            ((Cancelable)event).cancel();
        }
    }

    @Override
    protected void schemaComboBox_actionPerformed(ActionEvent e) {
        if (!this.procTextField.getText().trim().equals("")) {
            this.m_page.setCanAdvance(true);
        } else {
            this.m_page.setCanAdvance(false);
        }
        this.clearAndHideArgsTable();
    }

    @Override
    protected void respondToUserInput(DocumentEvent e) {
        boolean procTextIsValid = false;
        String docName = (String)e.getDocument().getProperty("DOCUMENT_NAME_KEY");
        if (docName != null && docName.equals("PROC_TEXT_FIELD")) {
            this.argsLabel.setVisible(false);
            this.tableScrollPane.setVisible(false);
            this.returnStatusLabel.setVisible(false);
            this.returnStatusCheckBox.setVisible(false);
            this.revalidate();
        }
        if (this.procTextField.getText() != null && !this.procTextField.getText().trim().equals("")) {
            procTextIsValid = true;
        }
        this.m_page.setCanAdvance(procTextIsValid);
    }
}

