/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import oracle.tip.adapter.db.sp.IDatabasePlatform;
import oracle.tip.adapter.db.sp.SPUtil;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.AdapterWizardContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp.ArgumentObject;
import oracle.xml.parser.schema.XSDTypeConstants;

public class TestArgumentTableModel
extends AbstractTableModel {
    private static final int COLUMN_SIZE = 3;
    private static final String REF = "REF";
    private static final String DISTINCT = "DISTINCT";
    private String[] columnNames = new String[3];
    private ArrayList<Datum> data = new ArrayList();
    private List argList;
    private AdapterWizardContext m_wcontext;
    private IDatabasePlatform platform = null;

    public TestArgumentTableModel(AdapterWizardContext wcontext, List argList, IDatabasePlatform platform) {
        this.argList = argList;
        this.platform = platform;
        this.m_wcontext = wcontext;
        this.init();
    }

    protected void init() {
        String nameText = this.getTranslatedString("DB_SP_NAME");
        String typeText = this.getTranslatedString("DB_SP_TYPE");
        String valueText = this.getTranslatedString("DB_SP_VALUE");
        this.columnNames[0] = nameText;
        this.columnNames[1] = typeText;
        this.columnNames[2] = valueText;
        if (this.argList != null && this.argList.size() > 0) {
            this.data = new ArrayList();
            for (int i = 0; i < this.argList.size(); ++i) {
                ArgumentObject argObj = (ArgumentObject)this.argList.get(i);
                if (!argObj.getInOut().contains("IN") || argObj.getDatatype() != null && argObj.getDatatype().equals("REF CURSOR")) continue;
                String typeColVal = "";
                if (argObj.getDatatype() != null) {
                    if (argObj.getDatatype().equals(REF)) {
                        typeColVal = argObj.getDatatype() + " " + argObj.getTypeName();
                    } else if (argObj.getTypeName().equals(DISTINCT)) {
                        typeColVal = argObj.getDatatype();
                    }
                }
                if (typeColVal.length() == 0 && (typeColVal = argObj.getTypeName()) != null) {
                    String[] sqlTypeMap = SPUtil.getSqlTypeMap((String)typeColVal.toUpperCase(), (HashMap)this.platform.getSqlTypeMappings());
                    boolean xsdString = false;
                    if (sqlTypeMap != null) {
                        xsdString = sqlTypeMap[1].equals(XSDTypeConstants.STRING);
                    }
                    if (argObj.getCharLength() > 0 && xsdString) {
                        typeColVal = typeColVal + "(" + argObj.getCharLength() + ")";
                    }
                }
                this.data.add(new Datum(argObj.getName(), typeColVal, ""));
            }
        }
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public Object getValueAt(int row, int col) {
        return this.data.get((int)row).data[col];
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    public Object getNamedValue(String name) {
        for (int i = 0; i < this.getRowCount(); ++i) {
            String testArgName = (String)this.getValueAt(i, 0);
            if (!testArgName.equals(name)) continue;
            return this.getValueAt(i, 2);
        }
        return null;
    }

    public String getTranslatedString(String messageKey) {
        return this.m_wcontext._bundle.getString(messageKey);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 2;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        this.data.get((int)rowIndex).data[columnIndex] = (String)aValue;
    }

    class Datum {
        String[] data = new String[3];

        Datum(String name, String type, String value) {
            this.data[0] = name;
            this.data[1] = type;
            this.data[2] = value;
        }
    }
}

