/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp;

import java.awt.Component;
import java.text.MessageFormat;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import oracle.tip.tools.ide.common.utils.ImageLoader;
import oracle.tip.tools.ide.common.utils.MultiLineOptionPane;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.AdapterWizardContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp.IDBAdapterSPUserInput;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp.IDataAccess;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp.ISelectProcPanel;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp.PackageNode;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp.PackageObject;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp.Platform;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp.ProcedureNode;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp.ProcedureObject;

public class StoredProcTree
extends JTree
implements TreeExpansionListener {
    private final String IMAGE_PATH = "oracle/tip/tools/ide/pm/modules/bizintegration/adapter/images/";
    private final String PROC_ICON_FILENAME = "oracle/tip/tools/ide/pm/modules/bizintegration/adapter/images/plsql_proc.gif";
    private final String PKG_ICON_FILENAME = "oracle/tip/tools/ide/pm/modules/bizintegration/adapter/images/plsql_package.gif";
    private DefaultMutableTreeNode root = null;
    private DefaultTreeModel treeModel = null;
    private IDBAdapterSPUserInput userInput = null;
    private AdapterWizardContext m_wcontext = null;
    private ISelectProcPanel selectProcPanel = null;
    private IDataAccess dataAccess = null;

    public StoredProcTree(AdapterWizardContext wcontext, IDBAdapterSPUserInput userInput, ISelectProcPanel selectProcPanel) throws Exception {
        String schema;
        this.setVisible(true);
        this.setRootVisible(true);
        this.addTreeExpansionListener(this);
        this.getSelectionModel().setSelectionMode(1);
        this.userInput = userInput;
        this.m_wcontext = wcontext;
        this.selectProcPanel = selectProcPanel;
        this.dataAccess = Platform.getDatabase(wcontext).getDataAccess();
        ImageIcon procIcon = ImageLoader.getImageIcon((String)"oracle/tip/tools/ide/pm/modules/bizintegration/adapter/images/plsql_proc.gif");
        ImageIcon pkgIcon = ImageLoader.getImageIcon((String)"oracle/tip/tools/ide/pm/modules/bizintegration/adapter/images/plsql_package.gif");
        if (procIcon != null && pkgIcon != null) {
            DefaultTreeCellRenderer renderer = (DefaultTreeCellRenderer)this.getCellRenderer();
            renderer.setLeafIcon(procIcon);
            renderer.setOpenIcon(pkgIcon);
            renderer.setClosedIcon(pkgIcon);
        }
        if ((schema = this.userInput.getSchema()).equals(this.getTranslatedString("CM_WZ_DBSCHEMA_CONNECTION_USER_DEFAULT"))) {
            schema = this.dataAccess.getConnectionSchema(this.m_wcontext._connection);
        }
        this.createNodes(schema);
    }

    public void createNodes(String schema) throws Exception {
        String rootText = this.getTranslatedString("DB_SP_STORED_PROCEDURES");
        List objList = this.dataAccess.getPackages(this.m_wcontext._connection, schema);
        this.root = new DefaultMutableTreeNode(rootText);
        this.treeModel = new DefaultTreeModel(this.root);
        if (objList != null && objList.size() > 0) {
            for (int i = 0; i < objList.size(); ++i) {
                Object currentObj = objList.get(i);
                if (currentObj instanceof PackageObject) {
                    PackageObject pkgObj = (PackageObject)currentObj;
                    this.root.add(new PackageNode(pkgObj));
                    continue;
                }
                if (!(currentObj instanceof ProcedureObject)) continue;
                ProcedureObject procObj = (ProcedureObject)currentObj;
                this.root.add(new ProcedureNode(procObj));
            }
        } else {
            rootText = this.getTranslatedString("DB_SP_NO_PROCEDURES_DEFINED");
            this.treeModel.setRoot(new DefaultMutableTreeNode(rootText));
        }
        this.setModel(this.treeModel);
        this.expandRow(0);
    }

    protected void showSearchResults(List objList) throws Exception {
        this.treeModel = new DefaultTreeModel(null);
        if (objList != null) {
            MessageFormat msgFormat = null;
            Object[] obj = null;
            msgFormat = new MessageFormat(this.getTranslatedString("DB_SP_SEARCH_RESULTS_MSG"));
            obj = new Object[]{Integer.toString(objList.size())};
            String searchResultsText = msgFormat.format(obj);
            PackageObject currentPackageObj = this.userInput.getPackage();
            this.selectProcPanel.disableProcDetailPane();
            DefaultMutableTreeNode root = new DefaultMutableTreeNode(searchResultsText);
            this.treeModel.setRoot(root);
            PackageNode currentPkgNode = null;
            for (int i = 0; i < objList.size(); ++i) {
                Object currentObj = objList.get(i);
                if (!(currentObj instanceof ProcedureObject)) continue;
                ProcedureObject procObj = (ProcedureObject)currentObj;
                ProcedureNode procNode = new ProcedureNode(procObj);
                PackageObject pkgObj = procObj.getPackage();
                if (pkgObj != null) {
                    if (currentPkgNode != null && !pkgObj.getName().equals(currentPkgNode.getPackage().getName())) {
                        currentPkgNode = null;
                    }
                } else {
                    currentPkgNode = null;
                }
                if (currentPkgNode != null) {
                    currentPkgNode.add(procNode);
                    continue;
                }
                if (pkgObj != null) {
                    currentPkgNode = new PackageNode(pkgObj);
                    root.add(currentPkgNode);
                    currentPkgNode.add(procNode);
                    continue;
                }
                root.add(procNode);
            }
        } else {
            MessageFormat msgFormat = null;
            Object[] obj = null;
            msgFormat = new MessageFormat(this.getTranslatedString("DB_SP_SEARCH_RESULTS_MSG"));
            obj = new Object[]{"0"};
            String searchResultsText = msgFormat.format(obj);
            DefaultMutableTreeNode root = new DefaultMutableTreeNode(searchResultsText);
            this.treeModel.setRoot(root);
        }
        this.setModel(this.treeModel);
        if (objList != null && objList.size() <= 50) {
            this.expandAll();
        }
    }

    @Override
    public void treeCollapsed(TreeExpansionEvent event) {
    }

    @Override
    public void treeExpanded(TreeExpansionEvent event) {
        if (!this.userInput.isInSearchMode()) {
            try {
                Object[] selectedPath;
                TreePath treePath = event.getPath();
                if (treePath != null && (selectedPath = treePath.getPath()) != null && selectedPath.length > 1) {
                    String schema = this.userInput.getSchema();
                    if (schema.equals(this.getTranslatedString("CM_WZ_DBSCHEMA_CONNECTION_USER_DEFAULT"))) {
                        schema = this.dataAccess.getConnectionSchema(this.m_wcontext._connection);
                    }
                    PackageNode pkgNode = (PackageNode)selectedPath[1];
                    this.removePackageNodeChildren(pkgNode);
                    List procList = this.dataAccess.getProcedures(this.m_wcontext._connection, schema, pkgNode.getPackage());
                    if (procList != null) {
                        for (int i = 0; i < procList.size(); ++i) {
                            ProcedureObject procObj = (ProcedureObject)procList.get(i);
                            ProcedureNode procNode = new ProcedureNode(procObj);
                            this.treeModel.insertNodeInto(procNode, pkgNode, i);
                        }
                    }
                    if (pkgNode != null && !pkgNode.isRoot()) {
                        this.userInput.setPackage(pkgNode.getPackage());
                    } else {
                        this.userInput.setPackage(null);
                    }
                }
            }
            catch (Exception e) {
                MultiLineOptionPane.showMessageDialog((Component)this.m_wcontext._parentFrame, (Object)this.getTranslatedString("DB_SP_CONN_ERROR_STORED_PROCS"), (String)this.getTranslatedString("DB_SP_ERROR"), (int)0);
                e.printStackTrace();
            }
        }
    }

    private void removePackageNodeChildren(PackageNode packageNode) {
        int childrenCount;
        if (packageNode != null && (childrenCount = this.treeModel.getChildCount(packageNode)) > 0) {
            --childrenCount;
            while (childrenCount >= 0) {
                ProcedureNode procNode = (ProcedureNode)this.treeModel.getChild(packageNode, childrenCount);
                this.treeModel.removeNodeFromParent(procNode);
                --childrenCount;
            }
        }
    }

    private void expandAll() {
        for (int i = 0; i < this.getRowCount(); ++i) {
            this.expandRow(i);
        }
    }

    protected void selectRow(IDBAdapterSPUserInput userInput) {
        int overload = 0;
        if (userInput != null) {
            String userInputPkgName = userInput.parsePackage(userInput.getProcUserTextInput());
            String userInputProcName = userInput.parseProcedure(userInput.getProcUserTextInput());
            if (userInput.getProcedure() != null && userInput.getProcedure().getOverload() > 0) {
                if (userInputPkgName == null && userInputProcName != null && userInput.getPackage() == null && userInput.getProcedure() != null && userInput.getProcedure().getName().equals(userInputProcName)) {
                    overload = userInput.getProcedure().getOverload();
                }
                if (userInputPkgName != null && userInputProcName != null && userInput.getPackage() != null && userInput.getProcedure() != null && userInput.getPackage().getName().equals(userInputPkgName) && userInput.getProcedure().getName().equals(userInputProcName)) {
                    overload = userInput.getProcedure().getOverload();
                }
            }
            TreePath treePath = null;
            int packageIndex = -1;
            if (userInputPkgName != null) {
                packageIndex = this.expandPackage(userInputPkgName);
                if (userInputProcName != null) {
                    treePath = this.selectProcedure(packageIndex, userInputPkgName, userInputProcName, overload);
                    this.scrollPathToVisible(treePath);
                }
                if (treePath == null) {
                    this.scrollRowToVisible(packageIndex);
                }
            } else if (userInputPkgName == null && userInputProcName != null) {
                treePath = this.selectProcedure(-1, null, userInputProcName, 0);
                this.scrollPathToVisible(treePath);
                if (treePath == null) {
                    packageIndex = this.expandPackage(userInputProcName);
                    this.scrollRowToVisible(packageIndex);
                }
            }
        }
    }

    protected int expandPackage(String packageName) {
        if (packageName != null) {
            for (int i = 0; i < this.getRowCount(); ++i) {
                PackageNode pkgNode;
                PackageObject pkgObj;
                TreePath currentPath = this.getPathForRow(i);
                Object currentObj = currentPath.getLastPathComponent();
                if (!(currentObj instanceof PackageNode) || (pkgObj = (pkgNode = (PackageNode)currentObj).getPackage()) == null || !packageName.equals(pkgObj.getName())) continue;
                this.expandRow(i);
                this.setSelectionPath(currentPath);
                return i;
            }
        }
        return -1;
    }

    protected TreePath selectProcedure(int packageIndex, String packageName, String procedureName, int overload) {
        block5: {
            block4: {
                if (packageName != null || procedureName == null || packageIndex >= 0) break block4;
                for (int i = 0; i < this.getRowCount(); ++i) {
                    ProcedureNode procNode;
                    ProcedureObject procObj;
                    TreePath currentPath = this.getPathForRow(i);
                    Object currentObj = currentPath.getLastPathComponent();
                    if (!(currentObj instanceof ProcedureNode) || (procObj = (procNode = (ProcedureNode)currentObj).getProcedure()) == null || !procedureName.equals(procObj.getName()) || procObj.getPackage() != null) continue;
                    if (overload <= 0) {
                        this.setSelectionPath(currentPath);
                        return currentPath;
                    }
                    if (procObj.getOverload() != overload) continue;
                    this.setSelectionPath(currentPath);
                    return currentPath;
                }
                break block5;
            }
            if (packageName == null || procedureName == null || packageIndex <= -1) break block5;
            for (int i = packageIndex; i < this.getRowCount(); ++i) {
                ProcedureNode procNode;
                ProcedureObject procObj;
                PackageObject procPkgObj;
                TreePath currentPath = this.getPathForRow(i);
                Object currentObj = currentPath.getLastPathComponent();
                if (!(currentObj instanceof ProcedureNode) || (procPkgObj = (procObj = (procNode = (ProcedureNode)currentObj).getProcedure()).getPackage()) == null || !packageName.equals(procPkgObj.getName()) || !procedureName.equals(procObj.getName())) continue;
                if (overload <= 0) {
                    this.setSelectionPath(currentPath);
                    return currentPath;
                }
                if (procObj.getOverload() != overload) continue;
                this.setSelectionPath(currentPath);
                return currentPath;
            }
        }
        return null;
    }

    public void displaySearching() {
        String searchingText = this.getTranslatedString("DB_SP_SEARCHING");
        this.selectProcPanel.disableProcDetailPane();
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(searchingText);
        this.treeModel = new DefaultTreeModel(root);
        this.setModel(this.treeModel);
    }

    public void displayReloading() {
        String reloadText = this.getTranslatedString("DB_SP_RELOADING");
        this.selectProcPanel.disableProcDetailPane();
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(reloadText);
        this.treeModel = new DefaultTreeModel(root);
        this.setModel(this.treeModel);
    }

    public void displayError() {
        String errorText = this.getTranslatedString("DB_SP_ERROR_OCCURRED");
        this.selectProcPanel.disableProcDetailPane();
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(errorText);
        this.treeModel = new DefaultTreeModel(root);
        this.setModel(this.treeModel);
    }

    public String getTranslatedString(String messageKey) {
        return this.m_wcontext._bundle.getString(messageKey);
    }
}

