/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp;

import java.util.HashMap;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.AdapterWizardContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp.DBAdapterSPAdvancedOptionsPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp.IDBAdapterRowSetPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp.PackageObject;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp.ProcedureObject;

public class SPUserInputBase
implements Cloneable {
    private String m_Schema = null;
    private ProcedureObject m_ProcObj = null;
    private PackageObject m_PkgObj = null;
    private String m_SearchString = null;
    private boolean m_IsInSearchMode = false;
    private String m_ProcUserTextInput = null;
    private boolean m_HasReturnStatus = false;
    private boolean m_HasResolvedOverloadedProcedure = false;
    private Boolean m_IsStrongXSD = null;
    private HashMap m_RowSets = null;
    private DBAdapterSPAdvancedOptionsPage m_AdvancedOptionsPage = null;
    private IDBAdapterRowSetPage m_RowSetPage = null;
    protected static final String SEPARATOR = ".";
    protected static final String RELATIVE_FILE_PATH_PREFIX = "";

    public void setSchema(String schema) {
        this.m_Schema = schema;
    }

    public void setProcedure(ProcedureObject procedureObject) {
        this.m_ProcObj = procedureObject;
    }

    public void setIsInSearchMode(boolean isInSearchMode) {
        this.m_IsInSearchMode = isInSearchMode;
    }

    public void setSearchString(String searchString) {
        this.m_SearchString = searchString;
    }

    public void setPackage(PackageObject packageObject) {
        this.m_PkgObj = packageObject;
    }

    public void setProcUserTextInput(String procUserTextInput) {
        this.m_ProcUserTextInput = procUserTextInput;
    }

    public void setHasResolvedOverloadedProcedure(boolean hasResolved) {
        this.m_HasResolvedOverloadedProcedure = hasResolved;
    }

    public void setHasReturnStatus(boolean returnStatus) {
        this.m_HasReturnStatus = returnStatus;
    }

    public void setAdvancedOptionsPage(DBAdapterSPAdvancedOptionsPage optionsPage) {
        this.m_AdvancedOptionsPage = optionsPage;
    }

    public void setIsStrongXSD(Boolean isStrongXSD) {
        this.m_IsStrongXSD = isStrongXSD;
    }

    public void setRowSets(HashMap rowSets) {
        this.m_RowSets = rowSets;
    }

    public String getSchema() {
        return this.m_Schema;
    }

    public ProcedureObject getProcedure() {
        return this.m_ProcObj;
    }

    public boolean isInSearchMode() {
        return this.m_IsInSearchMode;
    }

    public String getSearchString() {
        return this.m_SearchString;
    }

    public PackageObject getPackage() {
        return this.m_PkgObj;
    }

    public String getProcUserTextInput() {
        return this.m_ProcUserTextInput;
    }

    public boolean hasReturnStatus() {
        return this.m_HasReturnStatus;
    }

    public Boolean isStrongXSD() {
        return this.m_IsStrongXSD;
    }

    public HashMap getRowSets() {
        return this.m_RowSets;
    }

    public DBAdapterSPAdvancedOptionsPage getAdvancedOptionsPage() {
        return this.m_AdvancedOptionsPage;
    }

    public boolean hasResolvedOverloadedProcedure() {
        return this.m_HasResolvedOverloadedProcedure;
    }

    public String getProcedureDisplayName() {
        String name = null;
        if (this.m_ProcObj != null) {
            name = this.m_ProcObj.getName();
        }
        if (this.m_PkgObj != null) {
            name = this.m_PkgObj.getName() + SEPARATOR + name;
        }
        return name;
    }

    public String parsePackage(String procedureInputString) {
        int index;
        String packageName = null;
        if (procedureInputString != null && (index = procedureInputString.indexOf(SEPARATOR)) > 0) {
            packageName = procedureInputString.substring(0, index);
        }
        return packageName;
    }

    public String parseProcedure(String procedureInputString) {
        String procedureName = null;
        if (procedureInputString != null) {
            int index = procedureInputString.indexOf(SEPARATOR);
            if (index + 1 < procedureInputString.length()) {
                procedureName = procedureInputString.substring(index + 1, procedureInputString.length());
            }
        } else {
            procedureName = procedureInputString.trim();
        }
        return procedureName;
    }

    public String getXSDDir(AdapterWizardContext wcontext) {
        return wcontext.getSchemaFilePath();
    }

    protected Object clone() throws CloneNotSupportedException {
        SPUserInputBase base = (SPUserInputBase)super.clone();
        if (this.m_ProcObj != null) {
            this.m_ProcObj = (ProcedureObject)this.m_ProcObj.clone();
        }
        if (this.m_PkgObj != null) {
            this.m_PkgObj = (PackageObject)this.m_PkgObj.clone();
        }
        return base;
    }

    public IDBAdapterRowSetPage getRowSetPage() {
        return this.m_RowSetPage;
    }

    public void setRowSetPage(IDBAdapterRowSetPage rowSetPage) {
        this.m_RowSetPage = rowSetPage;
    }
}

