/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import oracle.tip.adapter.db.sp.RowSetMetaData;
import oracle.tip.adapter.db.sp.xsd.IXSDProcedure;
import oracle.tip.adapter.db.sp.xsd.oracle.JPublisher;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.AdapterWizardContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp.ArgumentObject;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp.PackageObject;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp.Platform;

public class ProcedureObject
implements Comparable,
Cloneable {
    private static final String OUT = "OUT";
    private static final String IN_OUT = "IN/OUT";
    private static final String INOUT = "INOUT";
    private static final String BOOLEAN = "BOOLEAN";
    private static final String RECORD = "PL/SQL RECORD";
    private static final String PLSQL_TABLE = "PL/SQL TABLE";
    private static final String TABLE = "TABLE";
    private static final String INTEGER = "INTEGER";
    private static final String OBJECT = "OBJECT";
    private String objectID = null;
    private String schema = null;
    private PackageObject packageObject = null;
    private String name = null;
    private List argList = null;
    private List sourceList = null;
    private IXSDProcedure xsdProcedure = null;
    HashMap<String, RowSetMetaData> rowSets = new HashMap();
    private int overload = 0;
    private boolean returnStatus = false;
    private String wrapperProcedureName = null;
    private String wrapperPackageName = null;

    public ProcedureObject(String objectID, String name, String schema, PackageObject packageObject, int overload, boolean returnStatus) {
        this.objectID = objectID;
        this.name = name;
        this.schema = schema;
        this.packageObject = packageObject;
        this.overload = overload;
        this.returnStatus = returnStatus;
    }

    public String getObjectID() {
        return this.objectID;
    }

    public String getSchema() {
        return this.schema;
    }

    public PackageObject getPackage() {
        return this.packageObject;
    }

    public String getName() {
        return this.name;
    }

    public int getOverload() {
        return this.overload;
    }

    public List getArgumentList() {
        return this.argList;
    }

    public List getSourceList() {
        return this.sourceList;
    }

    public boolean hasReturnStatus() {
        return this.returnStatus;
    }

    public IXSDProcedure getXSDProcedure() {
        return this.xsdProcedure;
    }

    public void setXSDProcedure(IXSDProcedure xsdProcedure) {
        this.xsdProcedure = xsdProcedure;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public void setOverload(int overload) {
        this.overload = overload;
    }

    public void setSourceList(List sourceList) {
        this.sourceList = sourceList;
    }

    public void setArgumentList(List argList) {
        this.argList = argList;
    }

    public void setHasReturnStatus(boolean returnStatus) {
        this.returnStatus = returnStatus;
    }

    protected void setPackage(PackageObject packageObject) {
        this.packageObject = packageObject;
    }

    public void setWrapperProcedureName(String wrapperProcedureName) {
        this.wrapperProcedureName = wrapperProcedureName.length() > 29 ? wrapperProcedureName.toUpperCase().substring(0, 29) : wrapperProcedureName.toUpperCase();
    }

    public String getWrapperProcedureName() {
        return this.wrapperProcedureName;
    }

    public void setWrapperPackageName(String wrapperPackageName) {
        this.wrapperPackageName = wrapperPackageName.length() > 30 ? wrapperPackageName.toUpperCase().substring(0, 30) : wrapperPackageName.toUpperCase();
    }

    public String getWrapperPackageName() {
        return this.wrapperPackageName;
    }

    public void addArgument(ArgumentObject argObj) {
        if (this.argList == null) {
            this.argList = new ArrayList();
        }
        this.argList.add(argObj);
    }

    public boolean hasArguments() {
        return this.getArgumentList() != null && this.getArgumentList().size() > 0;
    }

    public boolean hasOutArguments() {
        return this.xsdProcedure.getInOutParameters().size() > 0 || this.xsdProcedure.getOutParameters().size() > 0;
    }

    public boolean isFunction() {
        if (this.argList != null && this.argList.size() > 0) {
            for (int i = 0; i < this.argList.size(); ++i) {
                ArgumentObject argObj = (ArgumentObject)this.argList.get(i);
                if (argObj.getInOut() == null || !argObj.getInOut().equalsIgnoreCase(OUT) || !argObj.getPosition().equalsIgnoreCase("0")) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasPLSQLBooleanOrRecordTypes() {
        if (this.argList != null && this.argList.size() > 0) {
            for (int i = 0; i < this.argList.size(); ++i) {
                ArgumentObject arg = (ArgumentObject)this.argList.get(i);
                if (arg.getDatatype() != null && (arg.getDatatype().equals(BOOLEAN) || arg.getDatatype().equals(RECORD) || arg.getDatatype().equals(PLSQL_TABLE))) {
                    return true;
                }
                if (arg.getOriginalDatatype() == null || !arg.getOriginalDatatype().equals(TABLE) && !arg.getOriginalDatatype().equals("VARRAY") || arg.getTypeSubname() == null || arg.getTypeSubname().trim().equals("")) continue;
                return true;
            }
        }
        return false;
    }

    public void setWrapperInfo(AdapterWizardContext wcontext) throws Exception {
        if (this.hasPLSQLBooleanOrRecordTypes()) {
            this.setWrapperPackageName(wcontext._write_service_name);
            String wrapperProcName = JPublisher.findWrapperProcedureName((IXSDProcedure)this.getXSDProcedure(wcontext), (List)this.prepareConnectionInfo(wcontext));
            this.setWrapperProcedureName(wrapperProcName);
        }
    }

    public IXSDProcedure getXSDProcedure(AdapterWizardContext wcontext) throws Exception {
        return Platform.getDatabase(wcontext).getDataAccess().convertToXSDStoredProcedure(wcontext, this);
    }

    private List prepareConnectionInfo(AdapterWizardContext wcontext) throws Exception {
        String userParam = "-user=" + wcontext._connection.getMetaData().getUserName() + "/" + wcontext.dbConnectionInfo.getPassword();
        String urlParam = "-url=" + wcontext._connection.getMetaData().getURL();
        ArrayList<String> infoList = new ArrayList<String>();
        infoList.add(userParam);
        infoList.add(urlParam);
        return infoList;
    }

    public ProcedureObject convertToWrapperProcedure(String schema) throws Exception {
        ProcedureObject wrapperProcObj;
        String origPkgName = "";
        if (this.getPackage() != null) {
            origPkgName = this.getPackage().getName();
        }
        if ((wrapperProcObj = (ProcedureObject)this.clone()) != null) {
            PackageObject wrapperPkgObj = new PackageObject(this.getWrapperPackageName(), schema);
            wrapperProcObj.setPackage(wrapperPkgObj);
            wrapperProcObj.setName(this.getWrapperProcedureName());
            wrapperProcObj.setSchema(schema);
            List argList = wrapperProcObj.getArgumentList();
            if (argList != null && argList.size() > 0) {
                int recCounter = 0;
                for (int i = 0; i < argList.size(); ++i) {
                    ArgumentObject argObj = (ArgumentObject)argList.get(i);
                    if (argObj.getDatatype().equals(BOOLEAN)) {
                        argObj.setTypeName(INTEGER);
                        argObj.setDatatype(INTEGER);
                    } else if (argObj.getDatatype().equals(RECORD)) {
                        String wrapperTypeName;
                        if (RECORD.equals(argObj.getTypeName())) {
                            wrapperTypeName = recCounter > 0 ? origPkgName + "_" + "ROWTYPE_SQL" + String.valueOf(recCounter) : origPkgName + "_" + "ROWTYPE_SQL";
                            ++recCounter;
                        } else {
                            wrapperTypeName = origPkgName + "_" + argObj.getTypeName();
                        }
                        argObj.setTypeName(wrapperTypeName);
                        argObj.setDatatype(OBJECT);
                    } else if (argObj.getDatatype().equals(PLSQL_TABLE)) {
                        argObj.setTypeName(origPkgName + "_" + argObj.getTypeName());
                        argObj.setDatatype(TABLE);
                    }
                    argObj.setSequence(argObj.getPosition());
                }
            }
        }
        return wrapperProcObj;
    }

    public int compareTo(Object o) {
        ProcedureObject anotherProcObj = (ProcedureObject)o;
        return this.getName().compareTo(anotherProcObj.getName());
    }

    public boolean equals(Object o) {
        if (!(o instanceof ProcedureObject)) {
            return false;
        }
        ProcedureObject other = (ProcedureObject)o;
        if (this.getName() == null || !this.getName().equals(other.getName())) {
            return false;
        }
        if (this.getArgumentList() == null || other.getArgumentList() == null) {
            return this.getArgumentList() == other.getArgumentList();
        }
        if (this.getArgumentList().size() != other.getArgumentList().size()) {
            return false;
        }
        if (this.hasReturnStatus() != other.hasReturnStatus()) {
            return false;
        }
        Iterator otherIter = other.getArgumentList().iterator();
        for (Object argObj : this.getArgumentList()) {
            ArgumentObject arg = (ArgumentObject)argObj;
            ArgumentObject otherArg = (ArgumentObject)otherIter.next();
            if ((arg.getTypeName() == null || otherArg.getTypeName() == null || arg.getTypeName().equals(otherArg.getTypeName())) && (arg.getDatatype() == null || otherArg.getDatatype() == null || arg.getDatatype().equals(otherArg.getDatatype()))) continue;
            return false;
        }
        return true;
    }

    public Object clone() throws CloneNotSupportedException {
        PackageObject clonePkg = null;
        if (this.packageObject != null) {
            clonePkg = (PackageObject)this.getPackage().clone();
        }
        ProcedureObject cloneProcObj = new ProcedureObject(this.getObjectID(), this.getName(), this.getSchema(), clonePkg, this.getOverload(), this.hasReturnStatus());
        List argList = this.getArgumentList();
        if (argList != null && argList.size() > 0) {
            ArrayList<ArgumentObject> cloneArgs = new ArrayList<ArgumentObject>();
            for (int i = 0; i < argList.size(); ++i) {
                ArgumentObject argObj = (ArgumentObject)((ArgumentObject)argList.get(i)).clone();
                argObj.setProcedure(cloneProcObj);
                cloneArgs.add(argObj);
            }
            cloneProcObj.setArgumentList(cloneArgs);
        }
        return cloneProcObj;
    }

    public HashMap<String, RowSetMetaData> getRowSets() {
        return this.rowSets;
    }
}

