/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp;

import java.awt.Component;
import java.sql.DatabaseMetaData;
import java.text.MessageFormat;
import oracle.tip.adapter.db.sp.SPUtil;
import oracle.tip.tools.ide.common.utils.MultiLineOptionPane;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.AdapterWizardContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp.IDatabase;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp.db2.qsys2.Qsys2Database;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp.db2.syscat.SyscatDatabase;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp.informix.InformixDatabase;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp.mysql.MySQLDatabase;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp.oracle.OracleDatabase;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp.sqlserver.SQLServerDatabase;

public class Platform {
    private static final String DB2 = "DB2";
    private static final String INFORMIX = "Informix Dynamic Server";
    private static final String MYSQL = "MySQL";
    private static final String ORACLE = "Oracle";
    private static final String SQLSERVER = "Microsoft SQL Server";

    public static IDatabase getDatabase(AdapterWizardContext wcontext) throws Exception {
        IDatabase database = null;
        DatabaseMetaData metaData = wcontext._connection.getMetaData();
        String productName = metaData.getDatabaseProductName();
        if (ORACLE.equals(productName)) {
            database = new OracleDatabase();
        } else if (SQLSERVER.equals(productName)) {
            database = new SQLServerDatabase();
        } else if (DB2.equals(productName.substring(0, 3))) {
            if (SPUtil.isCatalogTable((DatabaseMetaData)metaData, (String)"SYSCAT", (String)"ROUTINES")) {
                database = new SyscatDatabase();
            } else if (SPUtil.isCatalogTable((DatabaseMetaData)metaData, (String)"QSYS2", (String)"SCHEMATA")) {
                database = new Qsys2Database();
            }
        } else if (MYSQL.equals(productName)) {
            database = new MySQLDatabase();
        } else if (INFORMIX.equals(productName)) {
            database = new InformixDatabase();
        }
        if (database == null) {
            MessageFormat msgFormat = new MessageFormat(wcontext._bundle.getString("DB_SP_WIZARD_UNSUPPORTED_DATABASE"));
            Object[] obj = new Object[]{productName};
            String unsupportedDatabaseMessage = msgFormat.format(obj);
            MultiLineOptionPane.showMessageDialog((Component)wcontext._parentFrame, (Object)unsupportedDatabaseMessage, (String)wcontext._bundle.getString("DB_SP_ERROR"), (int)0);
            throw new UnsupportedOperationException("The adapter configuration wizard does not support " + productName + " stored procedures.");
        }
        return database;
    }
}

