/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp;

import java.util.HashMap;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import oracle.tip.adapter.db.sp.IDatabasePlatform;
import oracle.tip.adapter.db.sp.SPUtil;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.AdapterWizardContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp.ArgumentObject;
import oracle.xml.parser.schema.XSDTypeConstants;

public class ArgumentTableModel
extends AbstractTableModel {
    private static final int COLUMN_SIZE = 4;
    private static final String REF = "REF";
    private static final String DISTINCT = "DISTINCT";
    private static final String INTERVAL = "INTERVAL";
    private String[] columnNames = new String[4];
    private String[][] data;
    private List argList;
    private AdapterWizardContext m_wcontext;
    private IDatabasePlatform platform = null;

    public ArgumentTableModel(AdapterWizardContext wcontext, List argList, IDatabasePlatform platform) {
        this.argList = argList;
        this.platform = platform;
        this.m_wcontext = wcontext;
        this.init();
    }

    protected void init() {
        String nameText = this.getTranslatedString("DB_SP_NAME");
        String typeText = this.getTranslatedString("DB_SP_TYPE");
        String inOutText = this.getTranslatedString("DB_SP_IN_OUT");
        String positionText = this.getTranslatedString("DB_SP_POSITION");
        this.columnNames[0] = nameText;
        this.columnNames[1] = typeText;
        this.columnNames[2] = inOutText;
        this.columnNames[3] = positionText;
        if (this.argList != null && this.argList.size() > 0) {
            this.data = new String[this.argList.size()][4];
            for (int i = 0; i < this.argList.size(); ++i) {
                String typeColVal = "";
                ArgumentObject argObj = (ArgumentObject)this.argList.get(i);
                if (argObj.getDatatype() != null) {
                    if (argObj.getDatatype().equals(REF)) {
                        typeColVal = argObj.getDatatype() + " " + argObj.getTypeName();
                    } else if (argObj.getTypeName().equals(DISTINCT)) {
                        typeColVal = argObj.getDatatype();
                    }
                }
                if (typeColVal.length() == 0 && (typeColVal = argObj.getTypeName()) != null) {
                    String[] sqlTypeMap = SPUtil.getSqlTypeMap((String)typeColVal.toUpperCase(), (HashMap)this.platform.getSqlTypeMappings());
                    boolean xsdString = false;
                    if (sqlTypeMap != null) {
                        xsdString = sqlTypeMap[1].equals(XSDTypeConstants.STRING);
                    }
                    if (argObj.getCharLength() > 0 && xsdString && !INTERVAL.equals(typeColVal.toUpperCase())) {
                        typeColVal = typeColVal + "(" + argObj.getCharLength() + ")";
                    }
                }
                this.data[i][0] = argObj.getName();
                this.data[i][1] = typeColVal;
                this.data[i][2] = argObj.getInOut();
                this.data[i][3] = argObj.getPosition();
            }
        }
    }

    @Override
    public int getRowCount() {
        return this.data.length;
    }

    @Override
    public Object getValueAt(int row, int col) {
        return this.data[row][col];
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    public String getTranslatedString(String messageKey) {
        return this.m_wcontext._bundle.getString(messageKey);
    }
}

