/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.text.MessageFormat;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.wsdl.WSDLException;
import oracle.bali.ewt.event.Cancelable;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.ewt.wizard.ImageWizardPage;
import oracle.bali.ewt.wizard.WizardEvent;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.help.HelpSystem;
import oracle.tip.adapter.db.sp.IDatabasePlatform;
import oracle.tip.tools.ide.common.utils.MultiLineOptionPane;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.AdapterWizardContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp.DBAdapterSPAdvancedOptionsPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp.DBAdapterSPFinish;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp.IDBAdapterRowSetPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp.IDBAdapterSPFinishPanel;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp.IDBAdapterSPUserInput;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp.IDBAdapterStoredProcPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp.IDataAccess;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp.IDatabase;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp.ProcedureObject;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp.StoredProcPageBase;

public abstract class AbstractStoredProcPage
extends StoredProcPageBase
implements IDBAdapterStoredProcPage {
    protected MultiLineLabel introLabel = null;
    protected JLabel procNameLabel = new JLabel();
    protected JLabel schemaLabel = new JLabel();
    protected GridBagLayout gridBagLayout = new GridBagLayout();
    protected boolean isUpdating = false;
    protected IDatabase database = null;
    protected IDatabasePlatform platform = null;
    protected IDataAccess dataAccess = null;
    protected IDBAdapterSPUserInput userInput = null;
    protected JTextField wrapperPackageTextField = null;
    protected MultiLineLabel wrapperPackageLabel = null;
    protected JCheckBox overwriteWrapperPkgCheckBox = new JCheckBox();
    protected MultiLineLabel returnStatusLabel = null;
    protected JCheckBox returnStatusCheckBox = new JCheckBox();
    protected static final String DOCUMENT_NAME_KEY = "DOCUMENT_NAME_KEY";
    protected static final String PROC_TEXT_FIELD = "PROC_TEXT_FIELD";

    protected abstract void jbInitHelper(ProcedureObject var1);

    protected abstract void redrawPage();

    protected abstract void loadProcedureBrowseDialog(boolean var1);

    protected abstract void validatePage(WizardEvent var1, String var2, String var3, String var4) throws Exception;

    protected abstract void schemaComboBox_actionPerformed(ActionEvent var1);

    protected abstract void respondToUserInput(DocumentEvent var1);

    public AbstractStoredProcPage(AdapterWizardContext wcontext, ImageWizardPage iwp, IDatabase database) throws Exception {
        try {
            this.database = database;
            this.platform = database.getPlatform();
            this.dataAccess = database.getDataAccess();
            this.setContextAndPage(wcontext, iwp);
            this.jbInit();
        }
        catch (Exception e) {
            MultiLineOptionPane.showMessageDialog((Component)wcontext._parentFrame, (Object)this.getTranslatedString("DB_SP_CONN_ERROR_SCHEMAS"), (String)this.getTranslatedString("DB_SP_ERROR"), (int)0);
            e.printStackTrace();
            throw e;
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this.gridBagLayout);
        this.setSize(new Dimension(400, 281));
        this.userInput = (IDBAdapterSPUserInput)this.m_wcontext._ascontext;
        this.m_wcontext._adapterWizardFinish = new DBAdapterSPFinish();
        this.currentConnection = this.m_wcontext._connection;
        this.userInput.setIsInSearchMode(false);
        this.userInput.setSchema(this.getTranslatedString("CM_WZ_DBSCHEMA_CONNECTION_USER_DEFAULT"));
        String procText = this.getTranslatedString("DB_SP_PROCEDURE");
        String schemaText = this.getTranslatedString("DB_SP_SCHEMA");
        String argsText = this.getTranslatedString("DB_SP_ARGUMENTS");
        String introText = this.getTranslatedString("DB_SP_PROC_PAGE_TEXT");
        String browseText = StringUtils.stripMnemonic((String)this.getTranslatedString("DB_SP_BROWSE"));
        this.introLabel = new MultiLineLabel(WordWrapper.getTextWrapper(), introText);
        this.procNameLabel.setText(procText);
        this.procNameLabel.getAccessibleContext().setAccessibleName(introText);
        this.browseProcButton.setText(browseText);
        int browseMN = StringUtils.getMnemonicKeyCode((String)this.getTranslatedString("DB_SP_BROWSE"));
        this.browseProcButton.setMnemonic(browseMN);
        this.browseProcButton.getAccessibleContext().setAccessibleName(browseText);
        this.schemaLabel.setText(schemaText);
        this.argsLabel.setText(argsText);
        this.argsLabel.setVisible(false);
        this.procTextField.setText(this.userInput.getProcedureDisplayName());
        this.procTextField.getAccessibleContext().setAccessibleName(procText);
        this.procTextField.getAccessibleContext().setAccessibleDescription(introText);
        this.initSchemaComboBox();
        this.schemaComboBox.getAccessibleContext().setAccessibleName(schemaText);
        if (this.userInput.getSchema() != null) {
            this.schemaComboBox.setSelectedItem(this.userInput.getSchema());
        }
        this.argsDetailTable = new JTable();
        this.tableScrollPane = new JScrollPane(this.argsDetailTable);
        this.tableScrollPane.getAccessibleContext().setAccessibleName(argsText);
        if (this.userInput.getProcedure() != null && this.userInput.getProcedure().hasArguments()) {
            this.displayArgsTable(this.userInput.getProcedure().getArgumentList(), this.platform);
        } else {
            this.clearAndHideArgsTable();
        }
        if (this.m_wcontext._read_service != null) {
            this.initFromWSDL();
        }
        this.schemaComboBox.addFocusListener(this);
        this.m_page.setInitialFocus((Component)this.schemaComboBox);
        this.browseProcButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractStoredProcPage.this.browseProcButton_actionPerformed(e);
            }
        });
        this.schemaComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractStoredProcPage.this.schemaComboBox_actionPerformed(e);
            }
        });
        this.add((Component)this.introLabel, new GridBagConstraints(0, 0, 0, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.schemaLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.add((Component)this.schemaComboBox, new GridBagConstraints(1, 1, 2, 1, 0.0, 0.0, 18, 0, new Insets(10, 10, 0, 0), 0, 0));
        this.add((Component)this.procNameLabel, new GridBagConstraints(0, 2, 1, 2, 0.0, 1.0, 18, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.add((Component)this.procTextField, new GridBagConstraints(1, 2, 1, 2, 1.0, 0.0, 18, 2, new Insets(10, 10, 0, 0), 0, 0));
        this.add((Component)this.browseProcButton, new GridBagConstraints(2, 2, 1, 2, 0.0, 0.0, 18, 0, new Insets(10, 10, 0, 0), 0, 0));
        this.add((Component)this.argsLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 16, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.add((Component)this.tableScrollPane, new GridBagConstraints(0, 4, 3, 1, 0.0, 5.0, 16, 1, new Insets(5, 0, 0, 0), 0, 0));
        this.jbInitHelper(this.userInput.getProcedure());
        this.procTextField.getDocument().addDocumentListener(this);
        this.procTextField.getDocument().putProperty(DOCUMENT_NAME_KEY, PROC_TEXT_FIELD);
    }

    protected void reflectUserInput() {
        this.schemaComboBox.setSelectedItem(this.userInput.getSchema());
        this.procTextField.setText(this.userInput.getProcedureDisplayName());
        if (this.userInput.getProcedure() != null && this.userInput.getProcedure().hasArguments()) {
            this.displayArgsTable(this.userInput.getProcedure().getArgumentList(), this.platform);
        } else {
            this.clearAndHideArgsTable();
        }
        this.redrawPage();
    }

    protected void browseProcButton_actionPerformed(ActionEvent e) {
        this.setCursor(new Cursor(3));
        this.loadProcedureBrowseDialog(false);
        this.setCursor(new Cursor(0));
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.respondToUserInput(e);
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.respondToUserInput(e);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.respondToUserInput(e);
    }

    @Override
    public void focusGained(FocusEvent event) {
        if (event.getSource().equals(this.schemaComboBox) && this.currentConnection != this.m_wcontext._connection) {
            this.currentConnection = this.m_wcontext._connection;
            try {
                this.initSchemaComboBox();
                this.browseProcButton.setEnabled(true);
            }
            catch (Exception e) {
                this.schemaComboBox.removeAllItems();
                this.refreshControls();
                MultiLineOptionPane.showMessageDialog((Component)this.m_wcontext._parentFrame, (Object)this.getTranslatedString("DB_SP_CONN_ERROR_SCHEMAS"), (String)this.getTranslatedString("DB_SP_ERROR"), (int)0);
                e.printStackTrace();
            }
        }
    }

    @Override
    public void focusLost(FocusEvent event) {
    }

    @Override
    public void wizardValidatePage(WizardEvent event) {
        try {
            this.setCursor(new Cursor(3));
            this.m_wcontext._db_sp_xsd_filename = null;
            this.userInput.setSchema((String)this.schemaComboBox.getSelectedItem());
            this.userInput.setProcUserTextInput(this.procTextField.getText().trim());
            String userInputPkgName = this.userInput.parsePackage(this.procTextField.getText().trim());
            String userInputProcName = this.userInput.parseProcedure(this.procTextField.getText().trim());
            String schema = this.userInput.getSchema();
            if (schema.equals(this.getTranslatedString("CM_WZ_DBSCHEMA_CONNECTION_USER_DEFAULT"))) {
                schema = this.dataAccess.getConnectionSchema(this.m_wcontext._connection);
            }
            this.validatePage(event, schema, userInputPkgName, userInputProcName);
            this.m_wcontext._ascontext = this.userInput;
            this.addRowSetPageIfNecessary(false);
            MessageFormat msgFormat = new MessageFormat(this.getTranslatedString("DB_SP_FINISH_TITLE"));
            Object[] obj = new Object[]{this.m_wcontext._write_service_name};
            String finishTitle = msgFormat.format(obj);
            IDBAdapterSPFinishPanel spFinishPanel = this.database.getDBAdapterSPFinishPanel(this.m_wcontext, this, this.userInput.getProcedure(), finishTitle);
            this.setCursor(new Cursor(0));
        }
        catch (Exception e) {
            MultiLineOptionPane.showMessageDialog((Component)this.m_wcontext._parentFrame, (Object)this.getTranslatedString("DB_SP_CONN_ERROR_SPEC_STORED_PROC"), (String)this.getTranslatedString("DB_SP_ERROR"), (int)0);
            ((Cancelable)event).cancel();
            e.printStackTrace();
        }
    }

    protected void addRowSetPageIfNecessary(boolean editMode) throws Exception {
        ProcedureObject proc = this.userInput.getProcedure();
        if (proc != null && this.database.hasRowSetArgument(proc)) {
            IDBAdapterRowSetPage rowSetPage = this.userInput.getRowSetPage();
            if (rowSetPage != null) {
                rowSetPage.setProcedureObject(proc);
            } else {
                if (!editMode) {
                    this.removePages();
                }
                ImageWizardPage tempCursors = new ImageWizardPage(null, this._getImage(), this.getTranslatedString("DB_SP_CURSORS"));
                if (!AdapterWizardContext.IS_STANDALONE_TESTING && !this.m_wcontext.isStandalone()) {
                    HelpSystem.getHelpSystem().registerTopic((JComponent)tempCursors.getContent(), "bpmjdev_adp_wiz_db_rowset");
                }
                this.userInput.setRowSetPage(this.database.getDBAdapterRowSetPage(this.m_wcontext, tempCursors));
                if (!editMode) {
                    this.addFollowingPages();
                }
            }
        } else {
            IDBAdapterRowSetPage rowSetPage = this.userInput.getRowSetPage();
            if (rowSetPage != null) {
                if (!editMode) {
                    this.removePages();
                }
                this.userInput.setRowSetPage(null);
                if (!editMode) {
                    this.addFollowingPages();
                }
            }
        }
    }

    private void addFollowingPages() throws Exception {
        ImageWizardPage tempAdv = new ImageWizardPage(null, this._getImage(), this.getTranslatedString("DB_AO_TITLE"));
        DBAdapterSPAdvancedOptionsPage nextPage = new DBAdapterSPAdvancedOptionsPage(this.m_wcontext, tempAdv);
        this.addFinishPage();
    }

    protected void initSchemaComboBox() throws Exception {
        this.schemaComboBox.removeAllItems();
        List schemaList = this.dataAccess.getSchemas(this.m_wcontext._connection);
        if (schemaList != null) {
            this.schemaComboBox.addItem(this.getTranslatedString("CM_WZ_DBSCHEMA_CONNECTION_USER_DEFAULT"));
            for (int i = 0; i < schemaList.size(); ++i) {
                this.schemaComboBox.addItem((String)schemaList.get(i));
            }
        }
    }

    private void initFromWSDL() throws Exception {
        this.isUpdating = true;
        ProcedureObject procObj = this.userInput.getProcedureFromWSDL(this.m_wcontext);
        if (procObj != null) {
            this.userInput.setSchema(procObj.getSchema());
            this.userInput.setPackage(procObj.getPackage());
            this.userInput.setProcedure(procObj);
            this.schemaComboBox.setSelectedItem(this.userInput.getSchema());
            this.procTextField.setText(this.userInput.getProcedureDisplayName());
            this.displayArgsTable(procObj.getArgumentList(), this.platform);
            this.addRowSetPageIfNecessary(true);
        }
    }

    @Override
    public void buildWSDL() throws WSDLException {
        this.createCommonOperationObjects(this.m_wcontext._write_service_name);
        String defaultSchema = this.getTranslatedString("CM_WZ_DBSCHEMA_CONNECTION_USER_DEFAULT");
        if (this.userInput.getSchema().equals(defaultSchema)) {
            this.userInput.getProcedure().setSchema(defaultSchema);
        }
        this.dataAccess.buildWSDLForStoredProcedure(this.m_wcontext, this.userInput.getProcedure());
    }
}

