/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.table.DefaultTableModel;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.share.nls.StringUtils;
import oracle.tip.adapter.db.sp.IDatabasePlatform;
import oracle.tip.tools.ide.common.utils.MultiLineOptionPane;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.AdapterWizardContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp.ArgumentTableModel;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp.IDBAdapterSPUserInput;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp.IDataAccess;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp.IDatabase;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp.ISelectProcPanel;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp.PackageNode;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp.PackageObject;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp.Platform;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp.ProcedureNode;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp.ProcedureObject;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp.StoredProcTree;

public abstract class AbstractSelectProcPanel
extends JPanel
implements ISelectProcPanel {
    protected AdapterWizardContext m_wcontext;
    private Highlighter.HighlightPainter highlightPainter;
    private GridBagLayout gridBagLayout = new GridBagLayout();
    private IDBAdapterSPUserInput userInput;
    private JButton searchButton = new JButton();
    private JButton showAllButton = new JButton();
    private JComboBox schemaComboBox = new JComboBox();
    private JEWTDialog parent;
    private JPanel searchPanel = new JPanel();
    private JPanel sourcePanel = new JPanel();
    private JScrollPane argDetailScrollPane;
    private JScrollPane sourceScrollPane;
    private JScrollPane treeView;
    private JSplitPane splitPane;
    private JTabbedPane procDetailTabbedPane = new JTabbedPane();
    private JTable argDetailTable;
    private JTextArea sourceTextArea = new JTextArea();
    private JTextField searchTextField = new JTextField();
    private MultiLineLabel introLabel;
    private MultiLineLabel schemaLabel;
    private StoredProcTree storedProcTree;
    private boolean overloadedSelected = false;
    private ProcedureObject prevSelProcObj = null;
    protected IDataAccess dataAccess = null;
    protected IDatabasePlatform platform = null;

    @Override
    public abstract void setSourceCode(ProcedureObject var1) throws Exception;

    @Override
    public abstract List getSourceCode(ProcedureObject var1);

    @Override
    public abstract boolean loadSourceTextArea(JTextArea var1, ProcedureObject var2, ProcedureObject var3, boolean var4);

    public AbstractSelectProcPanel(AdapterWizardContext wcontext, IDBAdapterSPUserInput userInput, JEWTDialog parent, boolean overloadedSelected) throws Exception {
        this.m_wcontext = wcontext;
        IDatabase database = Platform.getDatabase(wcontext);
        this.dataAccess = database.getDataAccess();
        this.platform = database.getPlatform();
        this.userInput = userInput;
        this.parent = parent;
        this.overloadedSelected = overloadedSelected;
        this.prevSelProcObj = null;
        this.jbInit();
    }

    private void jbInit() throws Exception {
        String searchText = StringUtils.stripMnemonic((String)this.getTranslatedString("DB_SP_SEARCH"));
        String showAllText = StringUtils.stripMnemonic((String)this.getTranslatedString("DB_SP_SHOW_ALL"));
        String schemaText = this.getTranslatedString("DB_SP_SCHEMA");
        String argumentsText = this.getTranslatedString("DB_SP_ARGUMENTS");
        String sourceText = this.getTranslatedString("DB_SP_SOURCE");
        String proceduresText = this.getTranslatedString("DB_SP_STORED_PROCEDURES");
        String introText = this.getTranslatedString("DB_SP_SELECT_PROC_TEXT");
        if (this.overloadedSelected) {
            introText = this.getTranslatedString("DB_SP_SELECT_OVERLOADED_PROC_TEXT");
        }
        this.setLayout(this.gridBagLayout);
        this.setSize(new Dimension(480, 400));
        this.highlightPainter = new DefaultHighlighter.DefaultHighlightPainter(Color.yellow);
        this.introLabel = new MultiLineLabel(WordWrapper.getTextWrapper(), introText);
        this.schemaLabel = new MultiLineLabel(WordWrapper.getTextWrapper(), schemaText);
        int searchMN = StringUtils.getMnemonicKeyCode((String)this.getTranslatedString("DB_SP_SEARCH"));
        this.searchButton.setText(searchText);
        this.searchButton.setMnemonic(searchMN);
        this.searchButton.getAccessibleContext().setAccessibleName(showAllText);
        this.searchButton.setEnabled(false);
        int showAllMN = StringUtils.getMnemonicKeyCode((String)this.getTranslatedString("DB_SP_SHOW_ALL"));
        this.showAllButton.setText(showAllText);
        this.showAllButton.setMnemonic(showAllMN);
        this.showAllButton.getAccessibleContext().setAccessibleName(showAllText);
        this.showAllButton.setEnabled(false);
        this.searchTextField.getAccessibleContext().setAccessibleName(searchText);
        this.searchTextField.getDocument().addDocumentListener(this);
        this.searchPanel.setLayout(new GridBagLayout());
        this.searchPanel.setBorder(BorderFactory.createTitledBorder(searchText));
        this.searchPanel.add((Component)this.searchTextField, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 10, 5, 0), 0, 0));
        this.searchPanel.add((Component)this.searchButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 10, 5, 0), 0, 0));
        this.searchPanel.add((Component)this.showAllButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 10, 5, 10), 0, 0));
        this.initSchemaComboBox();
        this.schemaComboBox.setEnabled(true);
        this.schemaComboBox.getAccessibleContext().setAccessibleName(schemaText);
        if (this.userInput.getSchema() != null) {
            this.schemaComboBox.setSelectedItem(this.userInput.getSchema());
        }
        this.storedProcTree = new StoredProcTree(this.m_wcontext, this.userInput, this);
        this.storedProcTree.addTreeSelectionListener(this);
        this.treeView = new JScrollPane(this.storedProcTree);
        this.treeView.getAccessibleContext().setAccessibleName(proceduresText);
        this.argDetailTable = new JTable();
        this.argDetailScrollPane = new JScrollPane(this.argDetailTable);
        this.argDetailScrollPane.getAccessibleContext().setAccessibleName(argumentsText);
        this.sourceTextArea.setEditable(false);
        this.sourceScrollPane = new JScrollPane(this.sourceTextArea);
        this.sourceScrollPane.getAccessibleContext().setAccessibleName(sourceText);
        this.sourcePanel.setLayout(this.gridBagLayout);
        this.sourcePanel.add((Component)this.sourceScrollPane, new GridBagConstraints(0, 0, 0, 0, 4.0, 4.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.procDetailTabbedPane.addTab(argumentsText, this.argDetailScrollPane);
        this.procDetailTabbedPane.addTab(sourceText, this.sourcePanel);
        this.procDetailTabbedPane.setEnabled(false);
        this.procDetailTabbedPane.addChangeListener(this);
        this.splitPane = new JSplitPane(1, this.treeView, this.procDetailTabbedPane);
        this.splitPane.setResizeWeight(0.45);
        this.storedProcTree.selectRow(this.userInput);
        this.schemaComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                AbstractSelectProcPanel.this.schemaComboBox_actionPerformed(e);
            }
        });
        this.showAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractSelectProcPanel.this.showAllButton_actionPerformed(e);
            }
        });
        this.searchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractSelectProcPanel.this.searchButton_actionPerformed(e);
            }
        });
        this.add((Component)this.introLabel, new GridBagConstraints(0, 0, 0, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.searchPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(10, 0, 0, 0), 0, 0));
        this.add((Component)this.schemaLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.add((Component)this.schemaComboBox, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.splitPane, new GridBagConstraints(0, 4, 0, 1, 3.0, 2.0, 18, 1, new Insets(10, 0, 0, 0), 0, 0));
    }

    private void searchButton_actionPerformed(ActionEvent e) {
        this.setCursor(new Cursor(3));
        this.schemaComboBox.setEnabled(false);
        this.showAllButton.setEnabled(false);
        this.searchButton.setEnabled(false);
        this.storedProcTree.displaySearching();
        this.userInput.setIsInSearchMode(true);
        this.userInput.setSearchString(this.searchTextField.getText());
        Thread worker = new Thread(new Searcher());
        worker.start();
    }

    private void showAllButton_actionPerformed(ActionEvent e) {
        this.setCursor(new Cursor(3));
        this.userInput.setIsInSearchMode(false);
        this.userInput.setPackage(null);
        this.userInput.setProcedure(null);
        this.storedProcTree.displayReloading();
        this.searchButton.setEnabled(false);
        this.searchTextField.setEnabled(false);
        this.schemaComboBox.setEnabled(false);
        this.showAllButton.setEnabled(false);
        this.disableProcDetailPane();
        Thread worker = new Thread(new SchemaReloader());
        worker.start();
    }

    private void schemaComboBox_actionPerformed(ItemEvent e) {
        this.setCursor(new Cursor(3));
        if (e.getStateChange() == 1) {
            this.userInput.setSchema((String)this.schemaComboBox.getSelectedItem());
            this.userInput.setPackage(null);
            this.userInput.setProcedure(null);
            this.parent.setOKButtonEnabled(false);
            if (!this.userInput.isInSearchMode()) {
                this.storedProcTree.displayReloading();
                this.searchButton.setEnabled(false);
                this.searchTextField.setEnabled(false);
                this.schemaComboBox.setEnabled(false);
                this.showAllButton.setEnabled(false);
                this.disableProcDetailPane();
                Thread worker = new Thread(new SchemaReloader());
                worker.start();
            }
        }
    }

    private void initSchemaComboBox() throws Exception {
        this.setCursor(new Cursor(3));
        this.schemaComboBox.removeAllItems();
        List schemaList = this.dataAccess.getSchemas(this.m_wcontext._connection);
        if (schemaList != null) {
            this.schemaComboBox.addItem(this.getTranslatedString("CM_WZ_DBSCHEMA_CONNECTION_USER_DEFAULT"));
            for (int i = 0; i < schemaList.size(); ++i) {
                String currentSchema = (String)schemaList.get(i);
                this.schemaComboBox.addItem(currentSchema);
            }
        }
        this.setCursor(new Cursor(0));
    }

    public String getTranslatedString(String messageKey) {
        return this.m_wcontext._bundle.getString(messageKey);
    }

    @Override
    public void valueChanged(TreeSelectionEvent event) {
        try {
            ProcedureObject currentProcObj = null;
            List argList = null;
            Object sourceList = null;
            TreePath treePath = event.getPath();
            if (treePath != null) {
                MutableTreeNode currentNode = (MutableTreeNode)treePath.getLastPathComponent();
                if (currentNode != null) {
                    if (currentNode instanceof ProcedureNode) {
                        ProcedureNode procNode = (ProcedureNode)currentNode;
                        currentProcObj = procNode.getProcedure();
                        argList = currentProcObj.getArgumentList();
                        if (argList == null) {
                            argList = this.dataAccess.getArguments(this.m_wcontext._connection, currentProcObj);
                            currentProcObj.setArgumentList(argList);
                        }
                        if (argList != null && argList.size() > 0) {
                            ArgumentTableModel argTableModel = new ArgumentTableModel(this.m_wcontext, argList, this.platform);
                            this.argDetailTable.setModel(argTableModel);
                        } else {
                            this.clearArgTable();
                        }
                        if (this.procDetailTabbedPane.getSelectedIndex() == 1) {
                            this.setCursor(new Cursor(3));
                            this.setSourceCode(currentProcObj);
                        }
                        if (currentProcObj != null) {
                            if (this.userInput.getProcedure() != null) {
                                PackageObject tempPkg = null;
                                if (this.userInput.getProcedure().getPackage() != null) {
                                    tempPkg = new PackageObject(this.userInput.getProcedure().getPackage().getName(), this.userInput.getProcedure().getSchema());
                                }
                                this.prevSelProcObj = new ProcedureObject(null, this.userInput.getProcedure().getName(), this.userInput.getProcedure().getSchema(), tempPkg, 0, false);
                            } else {
                                this.prevSelProcObj = null;
                            }
                            this.userInput.setPackage(currentProcObj.getPackage());
                            this.userInput.setProcedure(currentProcObj);
                        }
                        if (this.procDetailTabbedPane.getSelectedIndex() == 1) {
                            this.displaySourceCode(currentProcObj, false);
                        }
                        this.procDetailTabbedPane.setEnabled(true);
                        this.parent.setOKButtonEnabled(true);
                    } else if (currentNode instanceof PackageNode) {
                        PackageNode pkgNode = (PackageNode)currentNode;
                        this.userInput.setPackage(pkgNode.getPackage());
                        this.disableProcDetailPane();
                        this.parent.setOKButtonEnabled(false);
                    } else {
                        this.userInput.setPackage(null);
                        this.userInput.setProcedure(null);
                        this.disableProcDetailPane();
                        this.parent.setOKButtonEnabled(false);
                    }
                }
            } else {
                this.userInput.setPackage(null);
                this.userInput.setProcedure(null);
                this.disableProcDetailPane();
                this.parent.setOKButtonEnabled(false);
            }
            this.setCursor(new Cursor(0));
        }
        catch (Exception e) {
            this.setCursor(new Cursor(0));
            MultiLineOptionPane.showMessageDialog((Component)this.m_wcontext._parentFrame, (Object)this.getTranslatedString("DB_SP_CONN_ERROR_ARGS"), (String)this.getTranslatedString("DB_SP_ERROR"), (int)0);
            e.printStackTrace();
        }
    }

    protected void scrollToDocumentLine(int line) {
        Font font = this.sourceTextArea.getFont();
        FontMetrics fontMetrics = this.sourceTextArea.getFontMetrics(font);
        int height = fontMetrics.getHeight();
        int y = line * height;
        this.sourceScrollPane.getViewport().setViewPosition(new Point(0, y));
    }

    @Override
    public void disableProcDetailPane() {
        if (this.procDetailTabbedPane != null) {
            this.clearArgTable();
            this.clearSourceTextArea();
            this.procDetailTabbedPane.setSelectedIndex(0);
            this.procDetailTabbedPane.setEnabled(false);
        }
    }

    protected void clearArgTable() {
        if (this.argDetailTable != null) {
            this.argDetailTable.setModel(new DefaultTableModel());
        }
    }

    protected void clearSourceTextArea() {
        if (this.sourceTextArea != null) {
            this.sourceTextArea = new JTextArea();
            this.sourceTextArea.setEditable(false);
            this.sourceScrollPane.setViewportView(this.sourceTextArea);
        }
    }

    protected void loadSourceTextArea(List sourceList) {
        this.sourceTextArea = new JTextArea();
        this.sourceTextArea.setEditable(false);
        if (sourceList != null) {
            for (int i = 0; i < sourceList.size(); ++i) {
                this.sourceTextArea.append((String)sourceList.get(i));
            }
        }
        this.sourceScrollPane.setViewportView(this.sourceTextArea);
    }

    public int highlight(JTextComponent textComp, String pattern) {
        this.removeHighlights(textComp);
        try {
            Highlighter hilite = textComp.getHighlighter();
            Document doc = textComp.getDocument();
            String text = doc.getText(0, doc.getLength()).toLowerCase();
            pattern = pattern.toLowerCase();
            int pos = 0;
            int firstPosition = text.indexOf(pattern, pos);
            while ((pos = text.indexOf(pattern, pos)) >= 0) {
                hilite.addHighlight(pos, pos + pattern.length(), this.highlightPainter);
                pos += pattern.length();
            }
            if (firstPosition < 0) {
                firstPosition = 0;
            }
            return firstPosition;
        }
        catch (BadLocationException badLocationException) {
            return 0;
        }
    }

    public void removeHighlights(JTextComponent textComp) {
        Highlighter hilite = textComp.getHighlighter();
        Highlighter.Highlight[] hilites = hilite.getHighlights();
        for (int i = 0; i < hilites.length; ++i) {
            if (!(hilites[i].getPainter() instanceof DefaultHighlighter.DefaultHighlightPainter)) continue;
            hilite.removeHighlight(hilites[i]);
        }
    }

    public void displaySourceCode(ProcedureObject currentProcObj, boolean ignorePrevSelProc) {
        List sourceList;
        if (currentProcObj != null && this.procDetailTabbedPane != null && (sourceList = this.getSourceCode(currentProcObj)) != null) {
            if (this.loadSourceTextArea(this.sourceTextArea, currentProcObj, this.prevSelProcObj, ignorePrevSelProc)) {
                this.loadSourceTextArea(sourceList);
            }
            try {
                int pos = this.highlight(this.sourceTextArea, currentProcObj.getName().trim());
                int line = this.sourceTextArea.getLineOfOffset(pos);
                this.scrollToDocumentLine(line);
            }
            catch (BadLocationException e) {
                // empty catch block
            }
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        if (this.searchTextField.getText().trim().equals("")) {
            this.searchButton.setEnabled(true);
        } else {
            this.searchButton.setEnabled(false);
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        if (this.searchTextField.getText().trim().equals("")) {
            this.searchButton.setEnabled(false);
        } else {
            this.searchButton.setEnabled(true);
        }
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        if (this.searchTextField.getText().trim().equals("")) {
            this.searchButton.setEnabled(false);
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.setCursor(new Cursor(3));
        try {
            if (this.procDetailTabbedPane.getSelectedIndex() == 1) {
                ProcedureObject currentProcObj = this.userInput.getProcedure();
                this.setSourceCode(currentProcObj);
                this.displaySourceCode(currentProcObj, true);
            }
        }
        catch (Exception ex) {
            this.setCursor(new Cursor(0));
            MultiLineOptionPane.showMessageDialog((Component)this.m_wcontext._parentFrame, (Object)this.getTranslatedString("DB_SP_CONN_ERROR_SRC"), (String)this.getTranslatedString("DB_SP_ERROR"), (int)0);
            ex.printStackTrace();
        }
        this.setCursor(new Cursor(0));
    }

    private final class SchemaReloadUpdater
    implements Runnable {
        private Exception e = null;

        public SchemaReloadUpdater() {
        }

        public SchemaReloadUpdater(Exception e) {
            this.e = e;
        }

        @Override
        public void run() {
            try {
                if (this.e != null) {
                    AbstractSelectProcPanel.this.storedProcTree.displayError();
                    this.e.printStackTrace();
                }
                this.updateControls();
            }
            catch (Exception e) {
                AbstractSelectProcPanel.this.storedProcTree.displayError();
                this.updateControls();
                e.printStackTrace();
            }
        }

        private void updateControls() {
            if (AbstractSelectProcPanel.this.searchTextField.getText().trim().equals("")) {
                AbstractSelectProcPanel.this.searchButton.setEnabled(false);
            } else {
                AbstractSelectProcPanel.this.searchButton.setEnabled(true);
            }
            AbstractSelectProcPanel.this.searchTextField.setEnabled(true);
            AbstractSelectProcPanel.this.schemaComboBox.setEnabled(true);
            AbstractSelectProcPanel.this.parent.setOKButtonEnabled(false);
            AbstractSelectProcPanel.this.setCursor(new Cursor(0));
        }
    }

    private final class SchemaReloader
    implements Runnable {
        private SchemaReloader() {
        }

        @Override
        public void run() {
            try {
                String schema = AbstractSelectProcPanel.this.userInput.getSchema();
                String defaultSchema = AbstractSelectProcPanel.this.getTranslatedString("CM_WZ_DBSCHEMA_CONNECTION_USER_DEFAULT");
                if (AbstractSelectProcPanel.this.userInput.getSchema().equals(defaultSchema)) {
                    schema = AbstractSelectProcPanel.this.dataAccess.getConnectionSchema(AbstractSelectProcPanel.this.m_wcontext._connection);
                }
                AbstractSelectProcPanel.this.storedProcTree.createNodes(schema);
                SwingUtilities.invokeLater(new SchemaReloadUpdater());
            }
            catch (Exception e) {
                SwingUtilities.invokeLater(new SearchResultsUpdater(e));
            }
        }
    }

    private final class SearchResultsUpdater
    implements Runnable {
        private List searchResults = null;
        private Exception e = null;

        public SearchResultsUpdater(List searchResults) {
            this.searchResults = searchResults;
        }

        public SearchResultsUpdater(Exception e) {
            this.e = e;
        }

        @Override
        public void run() {
            try {
                if (this.e == null) {
                    AbstractSelectProcPanel.this.storedProcTree.showSearchResults(this.searchResults);
                    this.updateControls();
                } else {
                    AbstractSelectProcPanel.this.storedProcTree.displayError();
                    this.updateControls();
                    this.displaySearchErrorDialog();
                    this.e.printStackTrace();
                }
            }
            catch (Exception e) {
                this.updateControls();
                this.displaySearchErrorDialog();
                e.printStackTrace();
            }
        }

        private void updateControls() {
            if (AbstractSelectProcPanel.this.searchTextField.getText().trim().equals("")) {
                AbstractSelectProcPanel.this.searchButton.setEnabled(false);
            } else {
                AbstractSelectProcPanel.this.searchButton.setEnabled(true);
            }
            AbstractSelectProcPanel.this.schemaComboBox.setEnabled(false);
            AbstractSelectProcPanel.this.showAllButton.setEnabled(true);
            AbstractSelectProcPanel.this.parent.setOKButtonEnabled(false);
            AbstractSelectProcPanel.this.setCursor(new Cursor(0));
        }

        private void displaySearchErrorDialog() {
            String errTitle = AbstractSelectProcPanel.this.getTranslatedString("DB_SP_SEARCH_ERROR_TITLE");
            String errMsg = AbstractSelectProcPanel.this.getTranslatedString("DB_SP_SEARCH_ERROR_MSG");
            MultiLineOptionPane.showMessageDialog((Component)AbstractSelectProcPanel.this.m_wcontext._parentFrame, (Object)errMsg, (String)errTitle, (int)0);
        }
    }

    private final class Searcher
    implements Runnable {
        private Searcher() {
        }

        @Override
        public void run() {
            try {
                String schema = AbstractSelectProcPanel.this.userInput.getSchema();
                if (schema.equals(AbstractSelectProcPanel.this.getTranslatedString("CM_WZ_DBSCHEMA_CONNECTION_USER_DEFAULT"))) {
                    schema = AbstractSelectProcPanel.this.dataAccess.getConnectionSchema(AbstractSelectProcPanel.this.m_wcontext._connection);
                }
                List searchResults = AbstractSelectProcPanel.this.dataAccess.searchProcedures(AbstractSelectProcPanel.this.m_wcontext._connection, AbstractSelectProcPanel.this.userInput.getSearchString(), AbstractSelectProcPanel.this.userInput.getPackage(), schema);
                SwingUtilities.invokeLater(new SearchResultsUpdater(searchResults));
            }
            catch (Exception e) {
                SwingUtilities.invokeLater(new SearchResultsUpdater(e));
            }
        }
    }
}

