/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp;

import java.io.File;
import java.net.URL;
import java.net.URLEncoder;
import java.text.MessageFormat;
import oracle.ide.net.URLFactory;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.AdapterWizardContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp.IDBAdapterSPUserInput;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp.IDataAccess;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp.ProcedureObject;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp.SPUserInputBase;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.wsdl.JcaOperation;

public abstract class AbstractSPUserInput
extends SPUserInputBase
implements IDBAdapterSPUserInput,
Cloneable {
    protected IDataAccess dataAccess = null;
    protected static final String FILE_SEPARATOR = "_";
    protected static final String XSD_EXTENSION = ".xsd";
    protected boolean hasResolvedOverloadedProcedure = false;

    protected abstract ProcedureObject getWSDLProcedure(AdapterWizardContext var1, String var2, String var3, String var4) throws Exception;

    @Override
    public ProcedureObject getProcedureFromWSDL(AdapterWizardContext wcontext) throws Exception {
        ProcedureObject procObj = null;
        JcaOperation jop = wcontext._read_jca_operation;
        String wsdlSchema = jop.getAttributeValue("SchemaName");
        String wsdlPackageName = jop.getAttributeValue("PackageName");
        String wsdlProcName = jop.getAttributeValue("ProcedureName");
        String schema = wsdlSchema;
        if (schema == null) {
            schema = this.dataAccess.getConnectionSchema(wcontext._connection);
        }
        if ((procObj = this.getWSDLProcedure(wcontext, schema, wsdlPackageName, wsdlProcName)) != null) {
            procObj.setArgumentList(this.dataAccess.getArguments(wcontext._connection, procObj));
            if (wsdlSchema == null) {
                procObj.setSchema(wcontext._bundle.getString("CM_WZ_DBSCHEMA_CONNECTION_USER_DEFAULT"));
            }
        }
        return procObj;
    }

    @Override
    public String getFinishPageText(AdapterWizardContext wcontext, ProcedureObject procObj) {
        String message = "";
        MessageFormat msgFormat = new MessageFormat(wcontext._bundle.getString("DB_SP_FINISH_TEXT"));
        Object[] obj = new Object[]{wcontext._write_wsdl_name, this.getXSDFilename(wcontext, procObj)};
        message = msgFormat.format(obj);
        return message;
    }

    @Override
    public Boolean hasOutArguments(ProcedureObject procObj, String XSD) {
        if (this.isStrongXSD() == null) {
            return Boolean.TRUE;
        }
        return this.isStrongXSD() == false || this.isStrongXSD() != false && this.getRowSets().size() > 0 || procObj.hasOutArguments() || XSD.indexOf("name=\"OutputParameters\"") != -1;
    }

    protected abstract String getArgsFilename(AdapterWizardContext var1, String var2, ProcedureObject var3);

    @Override
    public String getXSDFilename(AdapterWizardContext wcontext, ProcedureObject procObj) {
        if (wcontext._db_sp_xsd_filename != null) {
            return wcontext._db_sp_xsd_filename;
        }
        String argsFilename = null;
        if (procObj != null) {
            String defaultSchema = wcontext._bundle.getString("CM_WZ_DBSCHEMA_CONNECTION_USER_DEFAULT");
            String schema = procObj.getSchema();
            if (schema.equals(defaultSchema)) {
                try {
                    schema = this.dataAccess.getConnectionSchema(wcontext._connection);
                }
                catch (Exception e) {
                    schema = "";
                }
            }
            argsFilename = this.getArgsFilename(wcontext, schema, procObj);
            String argsFileNameEncoded = null;
            try {
                argsFileNameEncoded = URLEncoder.encode(argsFilename, "UTF-8").replaceAll("%", "-");
            }
            catch (Exception e) {
                argsFileNameEncoded = argsFilename;
            }
            if (!argsFilename.equalsIgnoreCase(argsFileNameEncoded)) {
                String encodedArgsFilePath = this.getXSDDir(wcontext) + "/" + argsFileNameEncoded;
                URL xsdUrl = URLFactory.newURL((String)(encodedArgsFilePath + XSD_EXTENSION));
                File fileOut = new File(xsdUrl.getFile());
                if (fileOut.exists()) {
                    argsFileNameEncoded = argsFileNameEncoded + FILE_SEPARATOR + new Long(System.currentTimeMillis()).toString();
                }
                fileOut = null;
                xsdUrl = null;
            }
            argsFilename = argsFileNameEncoded;
        }
        wcontext._db_sp_xsd_filename = argsFilename = argsFilename + XSD_EXTENSION;
        return argsFilename;
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        return (AbstractSPUserInput)super.clone();
    }
}

