/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileReader;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.ewt.wizard.ImageWizardPage;
import oracle.bali.share.nls.StringUtils;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.tip.adapter.db.sp.IDatabasePlatform;
import oracle.tip.tools.ide.common.utils.MultiLineOptionPane;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.AdapterWizardContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp.ArgumentObject;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp.IDBAdapterRowSetPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp.IDBAdapterSPUserInput;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp.IDataAccess;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp.IDatabase;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp.ProcedureObject;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp.TestArgumentTableModel;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.techAdapterWizardPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.XRAdapterUtil;

public abstract class AbstractRowSetPage
extends techAdapterWizardPage
implements IDBAdapterRowSetPage {
    MultiLineLabel testArgumentsLabel;
    MultiLineLabel weakStrongLabel;
    JTable testArgsTable = null;
    JScrollPane tableScrollPane;
    JButton introspectButton = new JButton();
    JButton resetButton = new JButton();
    JPanel xsdPanel = new JPanel();
    JTextArea xsdTextArea = new JTextArea();
    TestArgumentTableModel argTableModel;
    protected ProcedureObject procedure = null;
    protected IDatabase database = null;
    protected IDatabasePlatform platform = null;
    protected IDataAccess dataAccess = null;
    protected IDBAdapterSPUserInput userInput = null;
    protected String xsdFromWSDL = null;

    public AbstractRowSetPage(AdapterWizardContext wcontext, ImageWizardPage iwp, IDatabase database) throws Exception {
        try {
            this.database = database;
            this.platform = database.getPlatform();
            this.dataAccess = database.getDataAccess();
            this.setContextAndPage(wcontext, iwp);
            this.jbInit();
        }
        catch (Exception e) {
            MultiLineOptionPane.showMessageDialog((Component)wcontext._parentFrame, (Object)this.getTranslatedString("DB_SP_CONN_ERROR_SCHEMAS"), (String)this.getTranslatedString("DB_SP_ERROR"), (int)0);
            e.printStackTrace();
            throw e;
        }
    }

    public String getRowSetPageIntroText() {
        return "DB_SP_CURSOR_PAGE_TEXT";
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this.setSize(new Dimension(400, 281));
        this.userInput = (IDBAdapterSPUserInput)this.m_wcontext._ascontext;
        this.procedure = this.userInput.getProcedure();
        String introText = this.getTranslatedString(this.getRowSetPageIntroText());
        MultiLineLabel introLabel = new MultiLineLabel(WordWrapper.getTextWrapper(), introText);
        String testArgumentsText = this.getTranslatedString("DB_SP_CURSOR_TEST_ARGS");
        this.testArgumentsLabel = new MultiLineLabel(WordWrapper.getTextWrapper(), testArgumentsText);
        this.testArgsTable = new JTable();
        this.tableScrollPane = new JScrollPane(this.testArgsTable);
        this.tableScrollPane.getAccessibleContext().setAccessibleName(testArgumentsText);
        String introspectTextMN = this.getTranslatedString("DB_SP_CURSOR_INTROSPECT");
        String introspectText = StringUtils.stripMnemonic((String)introspectTextMN);
        int introspectMN = StringUtils.getMnemonicKeyCode((String)introspectTextMN);
        this.introspectButton.setText(introspectText);
        this.introspectButton.setMnemonic(introspectMN);
        this.introspectButton.getAccessibleContext().setAccessibleName(introspectText);
        this.introspectButton.setEnabled(true);
        this.introspectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractRowSetPage.this.introspectButton_actionPerformed(e);
            }
        });
        String resetTextMN = this.getTranslatedString("DB_SP_CURSOR_RESET");
        String resetText = StringUtils.stripMnemonic((String)resetTextMN);
        int resetMN = StringUtils.getMnemonicKeyCode((String)resetTextMN);
        this.resetButton.setText(resetText);
        this.resetButton.setMnemonic(resetMN);
        this.resetButton.getAccessibleContext().setAccessibleName(resetText);
        this.resetButton.setEnabled(true);
        this.resetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractRowSetPage.this.resetButton_actionPerformed(e);
            }
        });
        String xsdText = this.getTranslatedString("DB_SP_CURSOR_XSD");
        MultiLineLabel xsdLabel = new MultiLineLabel(WordWrapper.getTextWrapper(), xsdText);
        this.weakStrongLabel = new MultiLineLabel(WordWrapper.getTextWrapper(), "");
        this.xsdTextArea.setEditable(true);
        JScrollPane xsdScrollPane = new JScrollPane(this.xsdTextArea);
        xsdScrollPane.getAccessibleContext().setAccessibleName(xsdText);
        this.xsdPanel.setLayout(new GridBagLayout());
        this.xsdPanel.add((Component)xsdScrollPane, new GridBagConstraints(0, 0, 0, 0, 4.0, 4.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.initPanes();
        this.xsdTextArea.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                AbstractRowSetPage.this.resetButton.setEnabled(true);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                AbstractRowSetPage.this.resetButton.setEnabled(true);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                AbstractRowSetPage.this.resetButton.setEnabled(true);
            }
        });
        this.add((Component)introLabel, new GridBagConstraints(0, 0, 0, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.testArgumentsLabel, new GridBagConstraints(0, 1, 1, 2, 0.0, 1.0, 18, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.add((Component)this.tableScrollPane, new GridBagConstraints(1, 1, 3, 2, 1.0, 2.0, 18, 1, new Insets(10, 10, 0, 0), 0, 0));
        this.add((Component)this.introspectButton, new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 10, 0, 0), 0, 0));
        this.add((Component)this.resetButton, new GridBagConstraints(4, 2, 1, 1, 0.0, 0.0, 18, 2, new Insets(10, 10, 0, 0), 0, 0));
        this.add((Component)xsdLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.add((Component)this.xsdPanel, new GridBagConstraints(1, 3, 4, 2, 0.0, 5.0, 18, 1, new Insets(10, 5, 0, 0), 0, 0));
        this.add((Component)this.weakStrongLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 0, 0, 0), 0, 0));
    }

    protected void initPanes() {
        if (this.procedure != null && this.procedure.hasArguments()) {
            this.displayArgsTable(this.procedure.getArgumentList(), this.platform);
        } else {
            this.clearAndHideArgsTable();
        }
        Boolean isWeakStrong = null;
        String xsd = null;
        if (this.m_wcontext._read_service != null && this.xsdFromWSDL == null && this.procedure.hasReturnStatus() == this.userInput.hasReturnStatus()) {
            xsd = this.xsdFromWSDL = this.loadPreExistingXSD();
            isWeakStrong = this.userInput.isStrongXSD();
        } else {
            isWeakStrong = this.procedure != null && this.procedure.getRowSets().size() > 0 ? Boolean.TRUE : Boolean.FALSE;
        }
        if (xsd == null) {
            try {
                xsd = this.generateXSD(true);
            }
            catch (Exception e) {
                ExceptionDialog.showExceptionDialog((Window)this.m_wcontext._parentFrame, (Exception)e);
                xsd = e.toString();
                e.printStackTrace();
            }
        }
        this.xsdTextArea.setText(xsd);
        this.toggleWeakStrong(isWeakStrong, this.xsdFromWSDL != null);
    }

    private String loadPreExistingXSD() {
        try {
            String schemaURI = XRAdapterUtil.getExistingXSDImportURI(this.m_wcontext);
            String xsdPath = this.m_wcontext.getFilePath() + File.separator + schemaURI;
            File xsdFile = new File(xsdPath);
            FileReader reader = new FileReader(xsdFile);
            char[] buff = new char[4096];
            StringBuffer sb = new StringBuffer();
            int chars = 4096;
            while (chars == 4096) {
                chars = reader.read(buff, 0, 4096);
                if (chars <= 0) continue;
                sb.append(buff, 0, chars);
            }
            return sb.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private String generateXSD(boolean initialize) throws Exception {
        return this.dataAccess.buildXSDForStoredProcedure(this.m_wcontext, this.procedure, initialize);
    }

    protected void clearAndHideArgsTable() {
        if (this.testArgsTable != null && this.tableScrollPane != null) {
            this.testArgsTable.setModel(new DefaultTableModel());
            this.revalidate();
        }
    }

    protected void displayArgsTable(List argList, IDatabasePlatform platform) {
        if (argList != null && argList.size() > 0) {
            this.argTableModel = new TestArgumentTableModel(this.m_wcontext, argList, platform);
            this.testArgsTable.setModel(this.argTableModel);
            this.tableScrollPane.setVisible(true);
            this.testArgumentsLabel.setVisible(true);
            this.revalidate();
        }
    }

    public String getQualifiedProcedureName(ProcedureObject procedure, Connection connection) throws Exception {
        String schema;
        String name = procedure.getName();
        if (procedure.getPackage() != null) {
            name = procedure.getPackage().getName() + "." + name;
        }
        if ((schema = procedure.getSchema()).equals(this.getTranslatedString("CM_WZ_DBSCHEMA_CONNECTION_USER_DEFAULT"))) {
            schema = this.dataAccess.getConnectionSchema(connection);
        }
        name = schema + "." + name;
        return name;
    }

    public Object getArgumentValue(ArgumentObject arg, int jdbcType, TestArgumentTableModel argTableModel, Connection connection) throws Exception {
        Object object = null;
        if (argTableModel != null) {
            String value = (String)argTableModel.getNamedValue(arg.getName());
            object = this.platform.getTypeConverter().toObject(connection, null, jdbcType, value, value == null);
        }
        return object;
    }

    public abstract String getCallSql(ProcedureObject var1, Connection var2) throws Exception;

    public abstract void bindAllParameters(ProcedureObject var1, CallableStatement var2, Connection var3, TestArgumentTableModel var4) throws Exception;

    public abstract boolean retrieveAllRowSets(ProcedureObject var1, CallableStatement var2, boolean var3, String var4) throws Exception;

    public Boolean introspectStrong(ProcedureObject procObj) {
        return procObj.getRowSets().size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void introspectButton_actionPerformed(ActionEvent e) {
        TableCellEditor cellEditor = this.testArgsTable.getCellEditor();
        if (cellEditor != null) {
            cellEditor.stopCellEditing();
        }
        Connection connection = this.m_wcontext._connection;
        CallableStatement cStmt = null;
        String SQL = null;
        try {
            SQL = this.getCallSql(this.procedure, connection);
            cStmt = connection.prepareCall(SQL);
            this.bindAllParameters(this.procedure, cStmt, connection, this.argTableModel);
            connection.setAutoCommit(false);
            boolean hasResults = cStmt.execute();
            boolean success = this.retrieveAllRowSets(this.procedure, cStmt, hasResults, SQL);
            cStmt.close();
            this.xsdTextArea.setText(this.generateXSD(!success));
            this.toggleWeakStrong(success && this.introspectStrong(this.procedure) != false, false);
        }
        catch (Exception ex) {
            String message = this.getTranslatedString("DB_SP_INTROSPECT_FAILED") + SQL;
            ExceptionDialog.showExceptionDialog((Window)this.m_wcontext._parentFrame, (Exception)ex, (String)message);
        }
        finally {
            try {
                connection.rollback();
                connection.setAutoCommit(true);
            }
            catch (Exception sqlEx) {
                sqlEx.printStackTrace();
            }
        }
    }

    private void resetButton_actionPerformed(ActionEvent e) {
        if (this.procedure != null) {
            this.procedure.getRowSets().clear();
        }
        try {
            this.xsdTextArea.setText(this.generateXSD(true));
            this.toggleWeakStrong(Boolean.FALSE, false);
        }
        catch (Exception ex) {
            ExceptionDialog.showExceptionDialog((Window)this.m_wcontext._parentFrame, (Exception)ex);
        }
    }

    private void toggleWeakStrong(Boolean strong, boolean editMode) {
        if (strong == null) {
            this.weakStrongLabel.setText("");
        } else if (strong.booleanValue()) {
            this.weakStrongLabel.setText(this.getTranslatedString("DB_SP_CURSORS_STRONG"));
            this.resetButton.setEnabled(true);
        } else {
            this.weakStrongLabel.setText(this.getTranslatedString("DB_SP_CURSORS_WEAK"));
            this.resetButton.setEnabled(editMode);
        }
        this.userInput.setIsStrongXSD(strong);
        this.userInput.setRowSets(this.procedure.getRowSets());
    }

    public ProcedureObject getProcedureObject() {
        return this.procedure;
    }

    @Override
    public void setProcedureObject(ProcedureObject procedure) {
        if (this.procedure == null || !this.procedure.equals(procedure)) {
            this.procedure = procedure;
            this.initPanes();
        }
    }

    @Override
    public String getStronglyTypedXSD() {
        return this.xsdTextArea.getText();
    }
}

