/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import javax.wsdl.Definition;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.Types;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.xml.namespace.QName;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.net.URLFactory;
import oracle.jdevimpl.xml.schema.XmlSchemaNode;
import oracle.tip.adapter.db.sp.RowSetMetaData;
import oracle.tip.adapter.db.sp.xsd.IXSDProcedure;
import oracle.tip.adapter.db.sp.xsd.XSDGenerator;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.AdapterWizardContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp.DataAccessBase;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp.IDBAdapterSPUserInput;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp.IDataAccess;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp.ProcedureObject;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.wsdl.DbSpSchema;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.wsdl.JcaOperation;

public abstract class AbstractDataAccess
extends DataAccessBase
implements IDataAccess {
    private static final String ARGS_IN = "args_in";
    private static final String ARGS_OUT = "args_out";
    protected ProcedureObject m_ProcObj = null;

    protected IXSDProcedure getXSDStoredProcedure(AdapterWizardContext wcontext, ProcedureObject procObj) throws Exception {
        this.m_ProcObj = procObj;
        IXSDProcedure xsdProcedure = this.getTheXsdStoredProcedure(wcontext, procObj);
        this.m_ProcObj.setXSDProcedure(xsdProcedure);
        return xsdProcedure;
    }

    protected abstract IXSDProcedure getTheXsdStoredProcedure(AdapterWizardContext var1, ProcedureObject var2) throws Exception;

    protected abstract void setJcaOperationInteractionSpec(AdapterWizardContext var1, JcaOperation var2);

    protected abstract void setUiOverloadedProcedure(AdapterWizardContext var1, ProcedureObject var2);

    protected abstract void setUiProcedureReturnStatus(AdapterWizardContext var1, ProcedureObject var2);

    protected abstract void setUiStrongXSD(AdapterWizardContext var1);

    private String urlEncode(String name) throws Exception {
        return URLEncoder.encode(name, "UTF-8").replaceAll("%", "-");
    }

    private String getQualifiedURLEncodedName(ProcedureObject procObj, String delimiter) throws Exception {
        String name = this.urlEncode(procObj.getName());
        if (procObj.getPackage() != null) {
            name = this.urlEncode(procObj.getPackage().getName()) + delimiter + name;
        }
        if (procObj.getSchema() != null) {
            name = this.urlEncode(procObj.getSchema()) + delimiter + name;
        }
        return name;
    }

    @Override
    public String buildXSDForStoredProcedure(AdapterWizardContext wcontext, ProcedureObject procObj, boolean initialize) throws Exception {
        XSDGenerator xsdGen = new XSDGenerator(wcontext._connection);
        IXSDProcedure xsdProcedure = this.getXSDStoredProcedure(wcontext, procObj);
        if (initialize) {
            xsdProcedure.addRowSetParameter("RowSet", 0);
        }
        HashMap<String, RowSetMetaData> rowSets = procObj.getRowSets();
        int i = 0;
        for (String name : rowSets.keySet()) {
            xsdProcedure.addRowSet(name, rowSets.get(name));
            xsdProcedure.addRowSetParameter(name, i++);
        }
        return xsdGen.generateXSD(xsdProcedure);
    }

    @Override
    public void buildWSDLForStoredProcedure(AdapterWizardContext wcontext, ProcedureObject procObj) throws WSDLException {
        try {
            if (wcontext != null && procObj != null) {
                IDBAdapterSPUserInput userInput = (IDBAdapterSPUserInput)wcontext._ascontext;
                boolean isDefaultSchema = false;
                String defaultSchema = wcontext._bundle.getString("CM_WZ_DBSCHEMA_CONNECTION_USER_DEFAULT");
                if (procObj.getSchema().equals(defaultSchema)) {
                    isDefaultSchema = true;
                }
                boolean hasOutArguments = false;
                String xsd = null;
                if (userInput.getRowSetPage() != null) {
                    xsd = userInput.getRowSetPage().getStronglyTypedXSD();
                    this.m_ProcObj = procObj;
                    this.m_ProcObj.setXSDProcedure(this.getTheXsdStoredProcedure(wcontext, procObj));
                    hasOutArguments = userInput.hasOutArguments(procObj, xsd);
                } else {
                    xsd = this.buildXSDForStoredProcedure(wcontext, procObj, false);
                    hasOutArguments = this.m_ProcObj.hasOutArguments();
                }
                procObj = this.m_ProcObj;
                if (procObj.getSchema().equals(defaultSchema)) {
                    procObj.setSchema(this.getConnectionSchema(wcontext._connection));
                }
                String procFullName = this.getQualifiedURLEncodedName(procObj, ".");
                String procFullNameWithSlashes = this.getQualifiedURLEncodedName(procObj, "/") + "/";
                String argsFileName = userInput.getXSDFilename(wcontext, procObj);
                String argsFilePath = userInput.getXSDDir(wcontext) + "/" + argsFileName;
                URL xsdFileURL = URLFactory.newURL((String)argsFilePath);
                File fileout = new File(xsdFileURL.getFile());
                FileOutputStream fos = new FileOutputStream(fileout);
                OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, "UTF-8");
                osw.write(xsd, 0, xsd.length());
                osw.close();
                fos.close();
                if (wcontext._project != null) {
                    URL xsdurl = URLFactory.newURL((String)argsFilePath);
                    Node xsdNode = NodeFactory.findOrCreate(XmlSchemaNode.class, (URL)xsdurl);
                    wcontext._project.add((Element)xsdNode, true);
                    wcontext.addURL(xsdurl);
                }
                String dbNamespace = "http://xmlns.oracle.com/pcbpel/adapter/db/" + procFullNameWithSlashes;
                String argsImportLocation = "" + argsFileName;
                Definition def = wcontext._write_definition;
                def.addNamespace("db", dbNamespace);
                Types types = def.createTypes();
                def.setTypes(types);
                DbSpSchema dbSpSchema = (DbSpSchema)wcontext._extReg.createExtension(DbSpSchema.PARENT_CLASS, DbSpSchema.FIELD_ELEMENT_TYPE);
                dbSpSchema.setContext(wcontext);
                dbSpSchema.setDbNamespace(dbNamespace);
                dbSpSchema.setProcedure(procObj);
                types.addExtensibilityElement((ExtensibilityElement)dbSpSchema);
                Message msgIn = def.createMessage();
                msgIn.setQName(new QName(wcontext._target_namespace, ARGS_IN + wcontext.Message_suffix));
                msgIn.setUndefined(false);
                Part partIn = def.createPart();
                partIn.setName("InputParameters");
                partIn.setElementName(new QName(dbNamespace, "InputParameters"));
                msgIn.addPart(partIn);
                def.addMessage(msgIn);
                Input input = def.createInput();
                input.setMessage(msgIn);
                wcontext._write_operation_abstract.setInput(input);
                if (hasOutArguments) {
                    Message msgOut = def.createMessage();
                    msgOut.setQName(new QName(wcontext._target_namespace, ARGS_OUT + wcontext.Message_suffix));
                    msgOut.setUndefined(false);
                    Part partOut = def.createPart();
                    partOut.setName("OutputParameters");
                    partOut.setElementName(new QName(dbNamespace, "OutputParameters"));
                    msgOut.addPart(partOut);
                    def.addMessage(msgOut);
                    Output output = def.createOutput();
                    output.setMessage(msgOut);
                    wcontext._write_operation_abstract.setOutput(output);
                }
                this.writeJcaOperationAttributes(wcontext, isDefaultSchema, procObj);
                if (wcontext._service_type.equals("DB")) {
                    String DB_OUTBOUND_HEADER_OPERATION_INPUT = "<jca:header message=\"hdr:OutboundHeader_msg\" part=\"outboundHeader\"/>";
                    wcontext._write_jca_operation.setInputString(DB_OUTBOUND_HEADER_OPERATION_INPUT);
                }
                this.setUiOverloadedProcedure(wcontext, procObj);
                this.setUiProcedureReturnStatus(wcontext, procObj);
                this.setUiStrongXSD(wcontext);
            }
        }
        catch (WSDLException wsdlEx) {
            throw wsdlEx;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new WSDLException("OTHER_ERROR", e.getMessage());
        }
    }

    public void writeJcaOperationAttributes(AdapterWizardContext wcontext, boolean isDefaultSchema, ProcedureObject procObj) {
        JcaOperation jop = wcontext._write_jca_operation;
        if (!isDefaultSchema) {
            jop.setAttributeValue("SchemaName", procObj.getSchema());
        }
        if (procObj.getPackage() != null) {
            jop.setAttributeValue("PackageName", procObj.getPackage().getName());
        }
        jop.setAttributeValue("ProcedureName", procObj.getName());
        this.setJcaOperationInteractionSpec(wcontext, jop);
    }
}

