/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.puresql;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.util.Iterator;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.Types;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.xml.namespace.QName;
import javax.xml.transform.dom.DOMSource;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.ewt.wizard.ImageWizardPage;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.net.URLFactory;
import oracle.j2ee.ws.wsdl.BindingInputImpl;
import oracle.j2ee.ws.wsdl.BindingOutputImpl;
import oracle.jdevimpl.xml.schema.XmlSchemaNode;
import oracle.tip.adapter.db.ox.Visitor;
import oracle.tip.adapter.db.puresql.SQL_XSDParser;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.AdapterWizardContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.puresql.DBAdapterPureSQLFinish;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.puresql.DBAdapterPureSQLMetaDataIntrospector;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.techAdapterWizardPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.wsdl.ImportSchema;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.wsdl.JcaOperation;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.XRAdapterUtil;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.XRAdapterWizardContext;

public class DBAdapterPureSQLPage
extends techAdapterWizardPage
implements DocumentListener,
FocusListener {
    boolean abbreviateInputXml = false;
    boolean abbreviateOutputXml = false;
    boolean returnsCollection = true;
    boolean inputsCollection = false;
    public String xSDNamespace;
    public String xSDFileName;
    public String xSDInputElementName;
    public String xSDOutputElementName;
    public Boolean isTransactional;
    public DBAdapterPureSQLMetaDataIntrospector sqlIntrospector;
    private MultiLineLabel instructionsLabel;
    private JTextArea sqlStringTextArea;
    private JLabel sqlStringLabel;
    private JTextArea xSDStringTextArea;
    private JLabel xSDStringLabel;
    private String[][] schemasToImport = null;
    private JTextField sqlExceptionTextField;
    private JLabel sqlExceptionLabel;
    private boolean shownWarning = false;
    private String nonModifiedXSDString = "";
    public static final String s_SQLString = "SqlString";

    public DBAdapterPureSQLPage(AdapterWizardContext context, ImageWizardPage page) {
        try {
            this.setContextAndPage(context, page);
            this.initialize();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initialize() {
        String serviceName;
        this.m_page.setCanAdvance(false);
        this.m_wizard.setMustFinish(!this.m_page.getCanAdvance());
        String encodedServiceName = serviceName = XRAdapterUtil.getServiceName(this.m_wcontext);
        this.xSDNamespace = "http://xmlns.oracle.com/pcbpel/adapter/db/" + encodedServiceName;
        this.m_wcontext._adapterWizardFinish = new DBAdapterPureSQLFinish();
        this.setLayout(new GridBagLayout());
        String instructionsText = this.getTranslatedString("DB_SQL_INTRO_PROMPT");
        this.instructionsLabel = new MultiLineLabel(WordWrapper.getTextWrapper(), instructionsText);
        this.sqlStringTextArea = new JTextArea();
        this.sqlStringTextArea.setLineWrap(true);
        this.sqlStringTextArea.setWrapStyleWord(true);
        this.sqlStringTextArea.addFocusListener(this);
        String sqlStringString = this.getTranslatedString("DB_SQL_SQL_STRING");
        JLabel sqlStringLabel = new JLabel(StringUtils.stripMnemonic((String)sqlStringString));
        sqlStringLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)sqlStringString));
        sqlStringLabel.setDisplayedMnemonicIndex(StringUtils.getMnemonicIndex((String)sqlStringString));
        sqlStringLabel.setLabelFor(this.sqlStringTextArea);
        this.xSDStringTextArea = new JTextArea();
        String xSDStringString = this.getTranslatedString("DB_SQL_XSD_STRING");
        JLabel xSDStringLabel = new JLabel(StringUtils.stripMnemonic((String)xSDStringString));
        xSDStringLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)xSDStringString));
        xSDStringLabel.setDisplayedMnemonicIndex(StringUtils.getMnemonicIndex((String)xSDStringString));
        xSDStringLabel.setLabelFor(this.xSDStringTextArea);
        JScrollPane xsdScrollPane = new JScrollPane(this.xSDStringTextArea);
        this.sqlExceptionTextField = new JTextField();
        this.sqlExceptionTextField.setBorder(new EmptyBorder(1, 1, 1, 1));
        this.sqlExceptionTextField.setForeground(Color.RED);
        this.sqlExceptionTextField.setBackground(new JPanel().getBackground());
        String sqlExceptionStringString = this.getTranslatedString("DB_SQL_SQL_MESSAGE");
        JLabel sqlExceptionLabel = new JLabel(StringUtils.stripMnemonic((String)sqlExceptionStringString));
        sqlExceptionLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)sqlExceptionStringString));
        sqlExceptionLabel.setDisplayedMnemonicIndex(StringUtils.getMnemonicIndex((String)sqlExceptionStringString));
        sqlExceptionLabel.setLabelFor(this.sqlExceptionTextField);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.insets = new Insets(0, 0, 0, 0);
        constraints.fill = 2;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 2;
        constraints.gridheight = 1;
        this.add((Component)this.instructionsLabel, constraints);
        constraints.anchor = 18;
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.insets = new Insets(30, 0, 0, 12);
        constraints.fill = 0;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        this.add((Component)sqlStringLabel, constraints);
        constraints.anchor = 17;
        constraints.gridx = 1;
        constraints.gridy = 1;
        constraints.insets = new Insets(30, 0, 0, 0);
        constraints.fill = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.15;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        this.add((Component)new JScrollPane(this.sqlStringTextArea), constraints);
        constraints.anchor = 18;
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.insets = new Insets(12, 0, 0, 12);
        constraints.fill = 0;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        this.add((Component)xSDStringLabel, constraints);
        constraints.anchor = 17;
        constraints.gridx = 1;
        constraints.gridy = 2;
        constraints.insets = new Insets(12, 0, 0, 0);
        constraints.fill = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.85;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        this.add((Component)xsdScrollPane, constraints);
        constraints.anchor = 17;
        constraints.gridx = 0;
        constraints.gridy = 3;
        constraints.insets = new Insets(12, 0, 0, 12);
        constraints.fill = 0;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.anchor = 17;
        constraints.gridx = 1;
        constraints.gridy = 3;
        constraints.insets = new Insets(12, 0, 0, 0);
        constraints.fill = 2;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        this.add((Component)this.sqlExceptionTextField, constraints);
        if (this.m_wcontext._read_service != null) {
            this.populateUIForEdit();
        }
        this.sqlStringTextArea.getDocument().addDocumentListener(this);
    }

    private void populateUIForEdit() {
        JcaOperation jop = this.m_wcontext._read_jca_operation;
        String sqlString = jop.getAttributeValue(s_SQLString);
        this.sqlStringTextArea.setText(sqlString);
        this.m_page.setCanAdvance(sqlString.trim().length() > 0);
        this.m_wizard.setMustFinish(!this.m_page.getCanAdvance());
        System.out.println("In populateUIForEdit, connection is ");
        System.out.println("Is " + this.m_wcontext._connection);
        this.loadPreExistingXSD();
    }

    private void loadPreExistingXSD() {
        try {
            Part part;
            Object part_obj;
            Iterator i$;
            String schemaURI = XRAdapterUtil.getExistingXSDImportURI(this.m_wcontext);
            if (this.m_wcontext._read_operation.getInput() != null && (i$ = this.m_wcontext._read_operation.getInput().getMessage().getParts().values().iterator()).hasNext()) {
                part_obj = i$.next();
                part = (Part)part_obj;
                this.xSDInputElementName = part.getElementName().getLocalPart();
            }
            if (this.m_wcontext._read_operation.getOutput() != null && (i$ = this.m_wcontext._read_operation.getOutput().getMessage().getParts().values().iterator()).hasNext()) {
                part_obj = i$.next();
                part = (Part)part_obj;
                this.xSDOutputElementName = part.getElementName().getLocalPart();
            }
            String xsdPath = this.m_wcontext.getFilePath() + File.separator + schemaURI;
            File xsdFile = new File(xsdPath);
            FileReader reader = new FileReader(xsdFile);
            char[] buff = new char[4096];
            StringBuffer sbuff = new StringBuffer();
            int chars = 4096;
            while (chars == 4096) {
                chars = reader.read(buff, 0, 4096);
                if (chars <= 0) continue;
                sbuff.append(buff, 0, chars);
            }
            String xsd = sbuff.toString();
            this.xSDStringTextArea.setText(xsd);
            this.xSDFileName = schemaURI;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.regenerate();
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.m_page.setCanAdvance(this.sqlStringTextArea.getText().trim().length() > 0);
        this.m_wizard.setMustFinish(!this.m_page.getCanAdvance());
        this.regenerate();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.m_page.setCanAdvance(this.sqlStringTextArea.getText().trim().length() > 0);
        this.m_wizard.setMustFinish(!this.m_page.getCanAdvance());
        this.regenerate();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.m_page.setCanAdvance(this.sqlStringTextArea.getText().trim().length() > 0);
        this.m_wizard.setMustFinish(!this.m_page.getCanAdvance());
        this.regenerate();
    }

    @Override
    public void focusGained(FocusEvent e) {
        if (!this.nonModifiedXSDString.equals(this.xSDStringTextArea.getText()) && !this.shownWarning) {
            String titleText = this.m_wcontext._bundle.getString("DB_SQL_LOSING_CHANGES_TITLE");
            String messageText = this.m_wcontext._bundle.getString("DB_SQL_LOSING_CHANGES_MESG");
            JOptionPane.showMessageDialog(this.m_wcontext._parentFrame, messageText, titleText, 2);
            this.shownWarning = true;
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
    }

    @Override
    public void buildWSDL() throws WSDLException {
        try {
            int i;
            AdapterWizardContext _wcontext = this.m_wcontext;
            String serviceName = this.m_wcontext._write_service_name;
            this.createCommonOperationObjects(serviceName);
            XRAdapterWizardContext dbContext = (XRAdapterWizardContext)this.m_wcontext._ascontext;
            String sqlString = this.sqlStringTextArea.getText();
            String xSDString = this.xSDStringTextArea.getText();
            String encodedServiceName = this.m_wcontext._write_encoded_service_name;
            boolean hasOutputMessage = this.xSDOutputElementName != null;
            String wsdlName = encodedServiceName + ".wsdl";
            String xsdName = encodedServiceName + ".xsd";
            Definition def = _wcontext._write_definition;
            def.addNamespace("db", this.xSDNamespace);
            Types types1 = _wcontext.getWriteTypes();
            ImportSchema impschema = (ImportSchema)_wcontext._extReg.createExtension(ImportSchema.PARENT_CLASS, ImportSchema.FIELD_ELEMENT_TYPE);
            impschema.setNamespace(this.xSDNamespace);
            if (this.xSDFileName != null) {
                impschema.setLocation(this.xSDFileName);
            } else {
                impschema.setLocation(_wcontext.IMPORT_SCHEMA_RELATIVE_LOC + xsdName);
            }
            types1.addExtensibilityElement((ExtensibilityElement)impschema);
            Message inputMessage = def.createMessage();
            inputMessage.setQName(new QName(_wcontext._target_namespace, this.xSDInputElementName + _wcontext.Message_suffix));
            inputMessage.setUndefined(false);
            Part partIn = def.createPart();
            partIn.setName(this.xSDInputElementName + _wcontext.Message_suffix);
            partIn.setElementName(new QName(this.xSDNamespace, this.xSDInputElementName));
            inputMessage.addPart(partIn);
            def.addMessage(inputMessage);
            Input input = def.createInput();
            input.setMessage(inputMessage);
            _wcontext._write_operation_abstract.setInput(input);
            if (hasOutputMessage) {
                Message outputMessage = null;
                if (!this.xSDInputElementName.equals(this.xSDOutputElementName)) {
                    outputMessage = def.createMessage();
                    outputMessage.setQName(new QName(_wcontext._target_namespace, this.xSDOutputElementName + _wcontext.Message_suffix));
                    outputMessage.setUndefined(false);
                    Part partOut = def.createPart();
                    partOut.setName(this.xSDOutputElementName);
                    partOut.setElementName(new QName(this.xSDNamespace, this.xSDOutputElementName));
                    outputMessage.addPart(partOut);
                    def.addMessage(outputMessage);
                } else {
                    outputMessage = inputMessage;
                }
                Output output = def.createOutput();
                output.setMessage(outputMessage);
                _wcontext._write_operation_abstract.setOutput(output);
            }
            JcaOperation jop = _wcontext._write_jca_operation;
            jop.setAttributeValue(s_SQLString, sqlString);
            jop.setAttributeValue("InteractionSpec", "oracle.tip.adapter.db.DBPureSQLInteractionSpec");
            BindingOperation bindingOperation = _wcontext._write_operation_physical;
            BindingInputImpl bindingInput = new BindingInputImpl();
            bindingOperation.setBindingInput((BindingInput)bindingInput);
            if (hasOutputMessage) {
                BindingOutputImpl bindingOutput = new BindingOutputImpl();
                bindingOperation.setBindingOutput((BindingOutput)bindingOutput);
            }
            URL xsdFileURL = null;
            xsdFileURL = this.xSDFileName != null ? URLFactory.newURL((String)(_wcontext.getFilePath() + File.separator + this.xSDFileName)) : URLFactory.newURL((String)(_wcontext.getSchemaFilePath() + File.separator + xsdName));
            File fileout = new File(xsdFileURL.getFile());
            OutputStreamWriter osw = null;
            FileOutputStream fos = null;
            fos = new FileOutputStream(fileout);
            osw = new OutputStreamWriter((OutputStream)fos, "UTF-8");
            osw.write(xSDString, 0, xSDString.length());
            osw.close();
            fos.close();
            URL[] schemaURLsToImport = null;
            if (this.schemasToImport != null) {
                schemaURLsToImport = new URL[this.schemasToImport.length + 1];
                for (i = 1; i < schemaURLsToImport.length; ++i) {
                    schemaURLsToImport[i] = URLFactory.newURL((String)(_wcontext.getSchemaFilePath() + File.separator + this.schemasToImport[i - 1][0] + "_xmltype.xsd"));
                    fileout = new File(schemaURLsToImport[i].getFile());
                    fos = new FileOutputStream(fileout);
                    osw = new OutputStreamWriter((OutputStream)fos, "UTF-8");
                    osw.write(this.schemasToImport[i - 1][1], 0, this.schemasToImport[i - 1][1].length());
                    osw.close();
                    fos.close();
                }
            } else {
                schemaURLsToImport = new URL[]{xsdFileURL};
            }
            if (_wcontext._project != null) {
                for (i = 0; i < schemaURLsToImport.length; ++i) {
                    Node xsdNode = NodeFactory.findOrCreate(XmlSchemaNode.class, (URL)schemaURLsToImport[i]);
                    _wcontext._project.add((Element)xsdNode, true);
                    _wcontext.addURL(schemaURLsToImport[i]);
                }
            }
            if (this.sqlIntrospector != null) {
                this.sqlIntrospector.die();
                this.sqlIntrospector = null;
            }
        }
        catch (WSDLException wsdlEx) {
            wsdlEx.printStackTrace();
            throw wsdlEx;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new WSDLException("OTHER_ERROR", e.getMessage());
        }
    }

    public void regenerate() {
        if (this.sqlIntrospector == null) {
            this.sqlIntrospector = new DBAdapterPureSQLMetaDataIntrospector();
            this.sqlIntrospector.setConn(this.m_wcontext._connection);
            this.sqlIntrospector.setPureSqlPage(this);
            new Thread(this.sqlIntrospector).start();
        }
        this.createXSD();
        this.sqlIntrospector.work(this.sqlStringTextArea.getText());
    }

    public synchronized void createXSD() {
        try {
            SQL_XSDParser parser = new SQL_XSDParser();
            String newXSD = Visitor.serialize((DOMSource)parser.parse(this.sqlStringTextArea.getText(), this.xSDNamespace, XRAdapterUtil.getServiceName(this.m_wcontext), this.sqlIntrospector.getInputMetaData(), this.sqlIntrospector.getOutputMetaData(), this.inputsCollection, this.returnsCollection, this.abbreviateInputXml, this.abbreviateOutputXml, this.sqlIntrospector.getXMLTypeIntrospector()));
            this.xSDStringTextArea.setText(newXSD);
            this.nonModifiedXSDString = newXSD;
            this.xSDInputElementName = parser.getXSDInputElementName();
            this.xSDOutputElementName = parser.getXSDOutputElementName();
            this.schemasToImport = this.sqlIntrospector.getXMLTypeIntrospector().getSchemasToImport();
            if (this.sqlIntrospector.getSqlException() == null) {
                this.sqlExceptionTextField.setText("");
            } else {
                this.sqlExceptionTextField.setText(this.sqlIntrospector.getSqlException().toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

