/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.puresql;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import oracle.tip.adapter.db.ox.Converter;
import oracle.tip.adapter.db.puresql.PureSQLInteraction;
import oracle.tip.adapter.db.puresql.SQL_XSDParser;
import oracle.tip.adapter.db.util.XMLTypeIntrospector;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.puresql.DBAdapterPureSQLPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.XRAdapterUtil;

public class DBAdapterPureSQLMetaDataIntrospector
implements Runnable {
    long vacationTime = 1L;
    boolean work = false;
    boolean die = false;
    String sqlString = null;
    Connection conn = null;
    String[][] inputMetaData;
    Map allTableMetaData = new HashMap();
    Map aliasMetaData = new HashMap();
    String[][] outputMetaData;
    private Converter converter = new Converter();
    XMLTypeIntrospector xmlTypeIntrospector = new XMLTypeIntrospector(null);
    SQLException sqlException;
    DBAdapterPureSQLPage pureSqlPage;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            while (true) {
                boolean workSoon = false;
                DBAdapterPureSQLMetaDataIntrospector dBAdapterPureSQLMetaDataIntrospector = this;
                synchronized (dBAdapterPureSQLMetaDataIntrospector) {
                    if (this.die) {
                        return;
                    }
                    if (this.work) {
                        this.work = !this.work;
                        workSoon = true;
                    } else {
                        this.wait();
                    }
                }
                if (!workSoon) continue;
                this.doWork(this.sqlString);
                Thread.sleep(this.vacationTime);
            }
        }
        catch (Exception e) {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void work(String sqlString) {
        DBAdapterPureSQLMetaDataIntrospector dBAdapterPureSQLMetaDataIntrospector = this;
        synchronized (dBAdapterPureSQLMetaDataIntrospector) {
            this.work = true;
            this.sqlString = sqlString;
            this.notifyAll();
        }
    }

    public void release() {
        this.die();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void die() {
        DBAdapterPureSQLMetaDataIntrospector dBAdapterPureSQLMetaDataIntrospector = this;
        synchronized (dBAdapterPureSQLMetaDataIntrospector) {
            this.die = true;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[][] calculateInputMetaData(String sqlString) {
        String bareSql = PureSQLInteraction.translateCustomQuery((String)this.getBareSQL(sqlString));
        int inputs = 0;
        for (int i = 0; i < bareSql.length(); ++i) {
            if (bareSql.charAt(i) != '?') continue;
            if (i > 0 && bareSql.charAt(i - 1) == '?') {
                return new String[0][0];
            }
            ++inputs;
        }
        String[][] inputMetaData = new String[inputs][2];
        inputs = 0;
        if (inputMetaData.length == 0) {
            // empty if block
        }
        String[] statements = bareSql.split(" FROM ");
        if (bareSql.startsWith("INSERT INTO ")) {
            statements = new String[]{"", bareSql.substring(12)};
        } else if (bareSql.startsWith("UPDATE ")) {
            statements = new String[]{"", bareSql.substring(7)};
        } else if (bareSql.startsWith("DELETE FROM ")) {
            statements = new String[]{"", bareSql.substring(12)};
        }
        block18: for (int i = 1; i < statements.length; ++i) {
            int k;
            String tableDeclaration;
            String[] tableDecTokens;
            String statement = statements[i];
            String[] tableDeclarations = statement.split(",");
            for (int j = 0; !(j >= tableDeclarations.length || (tableDecTokens = (tableDeclaration = tableDeclarations[j]).split(" ")).length == 1 && tableDeclaration.endsWith(" ") && j == tableDeclarations.length - 1); ++j) {
                String tableName = null;
                String alias = null;
                boolean hitEndOfFromClause = false;
                int insideAsOfClause = 0;
                boolean atStart = true;
                for (int k2 = 0; k2 < tableDecTokens.length; ++k2) {
                    --insideAsOfClause;
                    if (tableDecTokens[k2].equals("AS") || tableDecTokens[k2].equals("OF")) {
                        if (k2 <= 0 || k2 >= tableDecTokens.length - 1) continue;
                        insideAsOfClause = 2;
                        continue;
                    }
                    if (tableDecTokens[k2].equals("WHERE") || tableDecTokens[k2].equals("ORDER") || tableDecTokens[k2].equals("GROUP") || tableDecTokens[k2].equals("FOR") || tableDecTokens[k2].equals("SET") || tableDecTokens[k2].equals("VALUES") || tableDecTokens[k2].startsWith("(")) {
                        hitEndOfFromClause = true;
                        break;
                    }
                    if (tableDecTokens[k2].length() <= 0) continue;
                    if (atStart) {
                        tableName = tableDecTokens[k2];
                        atStart = false;
                        continue;
                    }
                    if (insideAsOfClause > 0) continue;
                    alias = tableDecTokens[k2];
                }
                if (tableName == null) break;
                if (!this.allTableMetaData.containsKey(tableName)) {
                    Statement preparedStatement = null;
                    ResultSet result = null;
                    try {
                        preparedStatement = this.conn.prepareStatement("SELECT * FROM " + tableName + " WHERE (1=0)");
                        result = preparedStatement.executeQuery();
                        ResultSetMetaData metaData = result.getMetaData();
                        String[][] columnMetaData = new String[metaData.getColumnCount()][2];
                        for (int k3 = 0; k3 < columnMetaData.length; ++k3) {
                            columnMetaData[k3][0] = metaData.getColumnName(k3 + 1);
                            columnMetaData[k3][1] = this.getXSDColumnType(tableName, metaData, k3 + 1);
                        }
                        this.allTableMetaData.put(tableName, new TableMetaData(columnMetaData));
                    }
                    catch (Exception e) {
                        this.allTableMetaData.put(tableName, new TableMetaData(null));
                    }
                    finally {
                        if (result != null) {
                            try {
                                result.close();
                            }
                            catch (Exception ignore) {}
                        }
                        if (preparedStatement != null) {
                            try {
                                preparedStatement.close();
                            }
                            catch (Exception ignore) {}
                        }
                    }
                }
                if (alias != null) {
                    this.aliasMetaData.put("alias " + alias, tableName);
                } else {
                    this.aliasMetaData.put("default table", tableName);
                }
                if (hitEndOfFromClause) break;
            }
            if (inputs >= inputMetaData.length) continue;
            if (bareSql.startsWith("INSERT INTO ")) {
                String tableName = (String)this.aliasMetaData.get("default table");
                String[][] tableMetaData = ((TableMetaData)this.allTableMetaData.get(tableName)).getMetaData();
                if (bareSql.indexOf("(") < bareSql.indexOf(" VALUES ") || bareSql.indexOf("(") < bareSql.indexOf(" VALUES(")) {
                    String insertColumnsBlock = bareSql.substring(bareSql.indexOf("(") + 1, bareSql.indexOf(")"));
                    String[] insertColumns = insertColumnsBlock.split(",");
                    for (int j = 0; j < insertColumns.length; ++j) {
                        String insertColumn = insertColumns[j].trim();
                        if (insertColumn.length() <= 0 || inputs >= inputMetaData.length) continue;
                        inputMetaData[inputs][0] = insertColumn;
                        if (tableMetaData != null) {
                            for (k = 0; k < tableMetaData.length; ++k) {
                                if (!insertColumn.equals(tableMetaData[k][0])) continue;
                                inputMetaData[inputs][1] = tableMetaData[k][1];
                                break;
                            }
                        } else {
                            inputMetaData[inputs][1] = "xs:string";
                        }
                        ++inputs;
                    }
                    continue;
                }
                if (tableMetaData == null) continue;
                for (int j = 0; j < tableMetaData.length && inputs < inputMetaData.length; ++inputs, ++j) {
                    inputMetaData[inputs][0] = tableMetaData[j][0];
                    inputMetaData[inputs][1] = tableMetaData[j][1];
                }
                continue;
            }
            String[] questionMarkSplits = statement.split("\\?");
            for (int j = 0; j < questionMarkSplits.length; ++j) {
                boolean gotIt = false;
                if (j == questionMarkSplits.length - 1) {
                    if (!statement.endsWith("?")) continue block18;
                    gotIt = true;
                }
                String column = null;
                String leftSide = questionMarkSplits[j].trim();
                if (leftSide.endsWith(">=") || leftSide.endsWith("<=")) {
                    leftSide = leftSide.substring(0, leftSide.length() - 2);
                    gotIt = true;
                } else if (leftSide.endsWith("=") || leftSide.endsWith(">") || leftSide.endsWith("<")) {
                    leftSide = leftSide.substring(0, leftSide.length() - 1);
                    gotIt = true;
                }
                if (gotIt) {
                    String[] words = leftSide.split(" ");
                    gotIt = false;
                    for (k = words.length - 1; k >= 0; --k) {
                        column = words[k];
                        if (column.length() == 0) continue;
                        if (column.endsWith(")")) {
                            gotIt = false;
                            break;
                        }
                        column = column.substring(column.lastIndexOf("(") + 1);
                        column = column.substring(column.lastIndexOf(",") + 1);
                        this.populateInputMetaData(inputMetaData, inputs, column);
                        ++inputs;
                        gotIt = true;
                        break;
                    }
                    if (gotIt) continue;
                    inputMetaData[inputs][0] = "arg" + (inputs + 1);
                    inputMetaData[inputs++][1] = "xs:string";
                    gotIt = true;
                    continue;
                }
                String rightSide = questionMarkSplits[j + 1].trim();
                if (rightSide.startsWith(">=") || rightSide.startsWith("<=")) {
                    rightSide = rightSide.substring(2).trim();
                    gotIt = true;
                } else if (rightSide.startsWith("=") || rightSide.startsWith(">") || rightSide.startsWith("<")) {
                    rightSide = rightSide.substring(1);
                    gotIt = true;
                }
                if (!gotIt) continue;
                String[] words = leftSide.split(" ");
                gotIt = false;
                for (int k4 = 0; k4 < words.length; ++k4) {
                    column = words[k4];
                    if (column.length() == 0 || column.equals("(")) continue;
                    if (column.indexOf(")") > -1) {
                        column = column.substring(0, column.indexOf(")"));
                    }
                    if (column.indexOf(",") > -1) {
                        column = column.substring(0, column.indexOf(","));
                    }
                    this.populateInputMetaData(inputMetaData, inputs, column);
                    ++inputs;
                    gotIt = true;
                    break;
                }
                if (gotIt) continue;
                inputMetaData[inputs][0] = "arg" + (inputs + 1);
                inputMetaData[inputs++][1] = "xs:string";
                gotIt = true;
            }
        }
        return inputMetaData;
    }

    protected void populateInputMetaData(String[][] inputMetaData, int inputs, String columnName) {
        String bareColumnName = columnName;
        String tableName = null;
        if (columnName.indexOf(".") > -1) {
            String alias = columnName.substring(0, columnName.indexOf("."));
            bareColumnName = columnName.substring(columnName.indexOf(".") + 1);
            tableName = (String)this.aliasMetaData.get("alias " + alias);
        } else {
            tableName = (String)this.aliasMetaData.get("default table");
        }
        String[][] tableMetaData = ((TableMetaData)this.allTableMetaData.get(tableName)).getMetaData();
        inputMetaData[inputs][0] = bareColumnName;
        inputMetaData[inputs][1] = "xs:string";
        for (int i = 0; i < tableMetaData.length; ++i) {
            if (!bareColumnName.equals(tableMetaData[i][0])) continue;
            inputMetaData[inputs][1] = tableMetaData[i][1];
            break;
        }
    }

    public String getXSDColumnType(String tableName, ResultSetMetaData metaData, int i) throws SQLException {
        if (tableName == null || tableName.length() == 0) {
            tableName = metaData.getTableName(i);
        } else if (this.aliasMetaData.containsKey(tableName)) {
            tableName = (String)this.aliasMetaData.get(tableName);
        }
        if (tableName == null || tableName.length() == 0) {
            tableName = (String)this.aliasMetaData.get("default table");
        }
        if (tableName == null || tableName.length() == 0) {
            tableName = "";
        }
        String ret = null;
        if (metaData.getColumnTypeName(i).equalsIgnoreCase("SYS.XMLTYPE") || metaData.getColumnTypeName(i).equalsIgnoreCase("XMLTYPE")) {
            String[] qName = this.xmlTypeIntrospector.getNamespaceAndElementName(metaData.getSchemaName(i), tableName, metaData.getColumnName(i));
            if (qName == null) {
                if (metaData.getColumnCount() == 1) {
                    qName = this.xmlTypeIntrospector.getNamespaceAndElementName(metaData.getSchemaName(i), tableName, null);
                }
                if (qName == null) {
                    ret = "xs:any";
                }
            }
            if (ret == null) {
                ret = qName[0] + "#" + qName[1];
            }
        } else {
            Class javaClass = XRAdapterUtil.getJavaTypeFromSQLType(metaData.getColumnTypeName(i), null, null, null);
            ret = this.converter.getType(javaClass);
        }
        return ret;
    }

    public String getBareSQL(String sqlString) {
        char[] chars = sqlString.toUpperCase().toCharArray();
        boolean insideSingleQuote = false;
        boolean insideDoubleQuote = false;
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] == '\'' && !insideDoubleQuote) {
                insideSingleQuote = !insideSingleQuote;
                continue;
            }
            if (chars[i] == '\"' && !insideSingleQuote) {
                insideDoubleQuote = !insideDoubleQuote;
                continue;
            }
            if (!insideSingleQuote && !insideDoubleQuote) continue;
            chars[i] = 76;
        }
        return new String(chars);
    }

    public String getTestSQL(String sqlString) {
        int whereClauseIndex;
        if (sqlString.indexOf("(") == 0 && sqlString.lastIndexOf(")") == sqlString.length() - 1) {
            return "(" + this.getTestSQL(sqlString.substring(1, sqlString.length() - 1).trim()) + ")";
        }
        String bareSQL = this.getBareSQL(sqlString);
        int extraStuffIndex = bareSQL.indexOf(" GROUP BY");
        if (extraStuffIndex == -1) {
            extraStuffIndex = bareSQL.indexOf(" HAVING ");
        }
        if (extraStuffIndex == -1) {
            extraStuffIndex = bareSQL.indexOf(" ORDER BY");
        }
        if (extraStuffIndex == -1) {
            extraStuffIndex = bareSQL.indexOf(" FOR READ ONLY UPDATE");
        }
        if (extraStuffIndex == -1) {
            extraStuffIndex = bareSQL.indexOf(" FOR UPDATE");
        }
        String extraStuff = "";
        if (extraStuffIndex > -1) {
            extraStuff = sqlString.substring(extraStuffIndex);
            sqlString = sqlString.substring(0, extraStuffIndex);
        }
        if ((whereClauseIndex = bareSQL.indexOf(" WHERE ")) == -1) {
            whereClauseIndex = bareSQL.indexOf(" WHERE(");
        }
        sqlString = whereClauseIndex > -1 ? sqlString.substring(0, whereClauseIndex + 6) + " (1 = 0) AND " + sqlString.substring(whereClauseIndex + 6, sqlString.length()) : sqlString + " WHERE 1 = 0";
        sqlString = sqlString + extraStuff;
        return sqlString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doWork(String sqlString) {
        this.conn = this.pureSqlPage.m_wcontext._connection;
        if (this.conn == null) {
            return;
        }
        this.xmlTypeIntrospector.setConnection(this.conn);
        Statement statement = null;
        ResultSet result = null;
        boolean isInTransaction = false;
        try {
            int i;
            SQL_XSDParser sqlInterpreter = new SQL_XSDParser();
            Vector returnColumns = sqlInterpreter.getReturnColumns(sqlString, (String[][])null);
            String[][] _inputMetaData = new String[0][0];
            try {
                _inputMetaData = this.calculateInputMetaData(sqlString);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Vector arguments = sqlInterpreter.getArguments(sqlString, _inputMetaData);
            int parameterCount = arguments.size();
            sqlString = PureSQLInteraction.translateCustomQuery((String)sqlString);
            statement = this.conn.prepareStatement(sqlString);
            ResultSetMetaData resultSetMetaData = null;
            if (returnColumns.size() > 0) {
                String testSQL = this.getTestSQL(sqlString);
                try {
                    statement = this.conn.prepareStatement(testSQL);
                    for (i = 0; i < parameterCount; ++i) {
                        if (_inputMetaData != null && _inputMetaData.length > i && (_inputMetaData[i][1].equals("xs:any") || _inputMetaData[i][1].indexOf("#") > -1)) {
                            statement.setNull(i + 1, 2007, "SYS.XMLTYPE");
                            continue;
                        }
                        statement.setObject(i + 1, null);
                    }
                    result = statement.executeQuery();
                    resultSetMetaData = result.getMetaData();
                }
                catch (Exception e) {
                    if (result != null) {
                        result.close();
                        result = null;
                    }
                    if (statement != null) {
                        statement.close();
                        statement = null;
                    }
                    this.conn.setAutoCommit(false);
                    isInTransaction = true;
                    statement = this.conn.prepareStatement(sqlString);
                    for (int i2 = 0; i2 < parameterCount; ++i2) {
                        statement.setObject(i2 + 1, null);
                    }
                    result = statement.executeQuery();
                    resultSetMetaData = result.getMetaData();
                }
            }
            String[][] _outputMetaData = null;
            if (resultSetMetaData != null) {
                _outputMetaData = new String[resultSetMetaData.getColumnCount()][2];
                for (i = 0; i < _outputMetaData.length; ++i) {
                    _outputMetaData[i][1] = this.getXSDColumnType(null, resultSetMetaData, i + 1);
                    _outputMetaData[i][0] = resultSetMetaData.getColumnLabel(i + 1);
                }
            }
            try {
                if (result != null) {
                    result.close();
                    result = null;
                }
            }
            catch (Exception cleanup) {
                // empty catch block
            }
            this.setSqlException(null);
            this.setInputMetaData(_inputMetaData);
            this.setOutputMetaData(_outputMetaData);
            this.pureSqlPage.createXSD();
        }
        catch (SQLException sqlException) {
            sqlException.printStackTrace();
            this.setSqlException(sqlException);
            this.pureSqlPage.createXSD();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                    statement = null;
                }
                if (isInTransaction) {
                    this.conn.rollback();
                    this.conn.setAutoCommit(true);
                }
            }
            catch (Exception letGCChoke) {}
        }
    }

    public void setConn(Connection conn) {
        this.conn = conn;
    }

    public Connection getConn() {
        return this.conn;
    }

    public synchronized String[][] getInputMetaData() {
        return this.inputMetaData;
    }

    public synchronized String[][] getOutputMetaData() {
        return this.outputMetaData;
    }

    public synchronized SQLException getSqlException() {
        return this.sqlException;
    }

    public void setPureSqlPage(DBAdapterPureSQLPage pureSqlPage) {
        this.pureSqlPage = pureSqlPage;
    }

    public void finalize() {
        this.die();
    }

    public synchronized void setInputMetaData(String[][] inputMetaData) {
        this.inputMetaData = inputMetaData;
    }

    public synchronized void setOutputMetaData(String[][] outputMetaData) {
        this.outputMetaData = outputMetaData;
    }

    public synchronized void setSqlException(SQLException sqlException) {
        this.sqlException = sqlException;
    }

    public XMLTypeIntrospector getXMLTypeIntrospector() {
        return this.xmlTypeIntrospector;
    }

    class TableMetaData {
        String[][] metaData;

        public TableMetaData(String[][] metaData) {
            this.metaData = metaData;
        }

        String[][] getMetaData() {
            return this.metaData;
        }
    }
}

