/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import oracle.javatools.db.Column;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.Database;
import oracle.javatools.db.FKConstraint;
import oracle.javatools.db.PKConstraint;
import oracle.javatools.db.Relation;
import oracle.javatools.db.SQLServer.SQLServerDatabase;
import oracle.javatools.db.Schema;
import oracle.javatools.db.Table;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeRegistry;
import oracle.jdeveloper.db.panels.DatabaseFinder;
import oracle.jdeveloper.offlinedb.OfflineDBObjectProvider;
import oracle.tip.adapter.db.toplinkext.NameEnquoter;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.AdapterWizardContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.XRAdapterUtil;
import org.eclipse.persistence.internal.helper.DatabaseTable;

public class DBAdapterOfflineTablesImporter {
    static Hashtable sqlTypes = new Hashtable();
    static Hashtable currentlyUnsupportedSqlTypes;
    protected long timeToCreateOfflineDBObjects = 0L;

    public DBAdapterOfflineTablesImporter(OfflineDBObjectProvider offlineDatabase) {
    }

    public DBAdapterOfflineTablesImporter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Table[] generate(AdapterWizardContext context, String[] tableNames) {
        long startTime = System.currentTimeMillis();
        this.timeToCreateOfflineDBObjects = 0L;
        if (tableNames == null || tableNames.length == 0) {
            return new Table[0];
        }
        Hashtable<String, Schema> createdSchemas = new Hashtable<String, Schema>();
        Hashtable<DatabaseTable, Table> createdTables = new Hashtable<DatabaseTable, Table>();
        Hashtable<DatabaseTable, PKConstraint> createdPrimaryKeys = new Hashtable<DatabaseTable, PKConstraint>();
        Hashtable allColumns = new Hashtable();
        Table[] allTables = new Table[tableNames.length];
        Database database = null;
        try {
            String schemaNameToUse;
            String schemaName;
            String tableName;
            int i;
            database = DatabaseFinder.findDatabase((String)context.dbConnectionInfo.getConnectionName());
            NameEnquoter nameEnquoter = null;
            DatabaseMetaData dbMetaData = null;
            boolean schemaMissingForDb2 = false;
            this.timeToCreateOfflineDBObjects += System.currentTimeMillis() - startTime;
            String catalog = null;
            try {
                catalog = database.getConnection().getCatalog();
            }
            catch (Exception catalogsNotSupported) {
                // empty catch block
            }
            DatabaseTable[] databaseTables = new DatabaseTable[tableNames.length];
            for (int i2 = 0; i2 < tableNames.length; ++i2) {
                databaseTables[i2] = new DatabaseTable(tableNames[i2]);
                if (!databaseTables[i2].getTableQualifier().equals(catalog)) continue;
                try {
                    dbMetaData = database.getConnection().getMetaData();
                    ResultSet possibleTables = dbMetaData.getTables(catalog, null, databaseTables[i2].getName(), null);
                    Vector<String> schemasV = new Vector<String>();
                    while (possibleTables.next()) {
                        String possibleSchema = possibleTables.getString(2);
                        if (possibleSchema == null || possibleSchema.length() <= 0) continue;
                        schemasV.add(possibleSchema);
                    }
                    if (schemasV.contains(catalog)) {
                        schemaMissingForDb2 = false;
                        continue;
                    }
                    if (schemasV.size() > 0 && !((String)schemasV.get(0)).equals("")) {
                        if (schemasV.contains(context.dbConnectionInfo.getUsername())) {
                            databaseTables[i2].setTableQualifier(context.dbConnectionInfo.getUsername());
                        }
                        databaseTables[i2].setTableQualifier((String)schemasV.get(0));
                        schemaMissingForDb2 = false;
                        continue;
                    }
                    databaseTables[i2].setTableQualifier("");
                    schemaMissingForDb2 = true;
                    continue;
                }
                catch (SQLException sqle) {
                    databaseTables[i2].setTableQualifier("");
                    schemaMissingForDb2 = true;
                }
            }
            boolean databaseMetaDataWayWorks = true;
            boolean resultSetMetaDataWayWorks = true;
            for (i = 0; i < databaseTables.length; ++i) {
                int isNullable;
                int scale;
                int precision;
                int sqlType;
                tableName = databaseTables[i].getName();
                schemaNameToUse = schemaName = databaseTables[i].getTableQualifier();
                if ("".equals(schemaName)) {
                    schemaNameToUse = null;
                }
                Hashtable<String, Column> createdColumns = new Hashtable<String, Column>();
                allColumns.put(databaseTables[i], createdColumns);
                Schema schema = (Schema)createdSchemas.get(schemaName);
                if (schema == null) {
                    schema = new Schema(schemaName);
                    createdSchemas.put(schemaName, schema);
                }
                Table table1 = new Table(tableName, schema);
                Table table2 = null;
                Table table = null;
                table1.setID(TemporaryObjectID.createID((DBObject)table1));
                int columns = 0;
                String columnName = null;
                String columnTypeName = null;
                if (!(!databaseMetaDataWayWorks && resultSetMetaDataWayWorks || schemaNameToUse == null && !schemaMissingForDb2)) {
                    table1 = new Table(tableName, schema);
                    table1.setID(TemporaryObjectID.createID((DBObject)table1));
                    ResultSet columnMetaData = null;
                    try {
                        dbMetaData = database.getConnection().getMetaData();
                        columnMetaData = dbMetaData.getColumns(catalog, schemaNameToUse, tableName, "%");
                        while (columnMetaData.next()) {
                            Column column;
                            columnName = columnMetaData.getString(4);
                            columnTypeName = null;
                            sqlType = 12;
                            precision = -1;
                            scale = -1;
                            isNullable = 1;
                            try {
                                columnTypeName = columnMetaData.getString(6);
                            }
                            catch (Exception e) {
                                databaseMetaDataWayWorks = false;
                            }
                            try {
                                sqlType = columnMetaData.getInt(5);
                            }
                            catch (Exception e) {
                                databaseMetaDataWayWorks = false;
                            }
                            try {
                                precision = columnMetaData.getInt(7);
                                scale = columnMetaData.getInt(9);
                            }
                            catch (Exception e) {
                                databaseMetaDataWayWorks = false;
                            }
                            try {
                                isNullable = columnMetaData.getInt(11);
                            }
                            catch (Exception e) {
                                databaseMetaDataWayWorks = false;
                            }
                            if ((column = this.createColumn(columnName, columnTypeName, sqlType, precision, scale, isNullable, database)) == null) continue;
                            table1.addColumn(column);
                        }
                        if (table1.getColumns().length == 0) {
                            databaseMetaDataWayWorks = false;
                        }
                    }
                    catch (Exception e) {
                        databaseMetaDataWayWorks = false;
                        System.out.println("going off of the database meta data did not work for getting column info, " + e);
                        e.printStackTrace();
                    }
                    finally {
                        if (columnMetaData != null) {
                            try {
                                columnMetaData.close();
                            }
                            catch (Exception ignore) {}
                        }
                    }
                }
                if (!databaseMetaDataWayWorks || schemaNameToUse == null) {
                    table2 = new Table(tableName, schema);
                    table2.setID(TemporaryObjectID.createID((DBObject)table2));
                    ResultSet actualRows = null;
                    ResultSetMetaData metaData = null;
                    try {
                        if (nameEnquoter == null) {
                            nameEnquoter = new NameEnquoter(context._connection);
                        }
                        String enquotedName = nameEnquoter.enquoteName(databaseTables[i].getQualifiedName());
                        String sql = "select * from " + enquotedName + " where (1 = 2)";
                        actualRows = context._connection.prepareStatement(sql).executeQuery();
                        metaData = actualRows.getMetaData();
                        columns = metaData.getColumnCount();
                        for (int c = 0; c < columns; ++c) {
                            columnName = metaData.getColumnName(c + 1);
                            columnTypeName = null;
                            sqlType = 12;
                            precision = -1;
                            scale = -1;
                            isNullable = 1;
                            try {
                                columnTypeName = metaData.getColumnTypeName(c + 1);
                            }
                            catch (Exception e) {
                                resultSetMetaDataWayWorks = false;
                            }
                            try {
                                sqlType = metaData.getColumnType(c + 1);
                            }
                            catch (Exception e) {
                                resultSetMetaDataWayWorks = false;
                            }
                            try {
                                precision = metaData.getPrecision(c + 1);
                                scale = metaData.getScale(c + 1);
                            }
                            catch (Exception e) {
                                resultSetMetaDataWayWorks = false;
                            }
                            try {
                                isNullable = metaData.isNullable(c + 1);
                            }
                            catch (Exception e) {
                                resultSetMetaDataWayWorks = false;
                            }
                            Column column = this.createColumn(columnName, columnTypeName, sqlType, precision, scale, isNullable, database);
                            if (column == null) continue;
                            table2.addColumn(column);
                        }
                    }
                    catch (Exception e) {
                        System.out.println("going off of the result set meta data did not work: " + e.toString());
                        resultSetMetaDataWayWorks = false;
                    }
                    finally {
                        if (actualRows != null) {
                            try {
                                actualRows.close();
                            }
                            catch (Exception ignore) {}
                        }
                    }
                }
                table = table2 != null && table2.getColumns().length > table1.getColumns().length ? table2 : table1;
                Column[] jdevColumns = table.getColumns();
                for (int c = 0; c < jdevColumns.length; ++c) {
                    createdColumns.put(jdevColumns[c].getName(), jdevColumns[c]);
                }
                allTables[i] = table;
                createdTables.put(databaseTables[i], table);
                ResultSet primaryKeyMetaData = null;
                PKConstraint pk = null;
                try {
                    dbMetaData = database.getConnection().getMetaData();
                    primaryKeyMetaData = dbMetaData.getPrimaryKeys(catalog, schemaNameToUse, tableName);
                    String pkConstraintName = null;
                    while (primaryKeyMetaData.next()) {
                        columnName = primaryKeyMetaData.getString(4);
                        Column pkColumn = null;
                        if (columnName != null) {
                            pkColumn = (Column)createdColumns.get(columnName);
                        }
                        if (pkColumn == null) continue;
                        if (pkConstraintName == null) {
                            pkConstraintName = primaryKeyMetaData.getString(6);
                            if (pkConstraintName == null) {
                                pkConstraintName = schemaName + "_" + tableName + "_PK";
                            }
                            pk = new PKConstraint(pkConstraintName, (Relation)table);
                            pk.setID(TemporaryObjectID.createID((DBObject)pk));
                        }
                        pk.addColumn(pkColumn);
                    }
                }
                catch (Exception e) {
                    System.out.println("\nCould not extract the primary key.");
                    e.printStackTrace();
                }
                finally {
                    if (primaryKeyMetaData != null) {
                        try {
                            primaryKeyMetaData.close();
                        }
                        catch (Exception ignore) {}
                    }
                }
                if (pk == null) continue;
                table.addConstraint(pk);
                createdPrimaryKeys.put(databaseTables[i], pk);
            }
            for (i = 0; i < databaseTables.length; ++i) {
                tableName = databaseTables[i].getName();
                schemaName = databaseTables[i].getTableQualifier();
                schemaNameToUse = "".equals(schemaName) ? null : schemaName;
                Schema schema = (Schema)createdSchemas.get(schemaName);
                PKConstraint pk = (PKConstraint)createdPrimaryKeys.get(databaseTables[i]);
                if (pk == null) continue;
                Vector<String> vectorPKColumns = new Vector<String>();
                Column[] arrayPKcolumns = pk.getColumns();
                for (int ci = 0; ci < arrayPKcolumns.length; ++ci) {
                    vectorPKColumns.add(ci, arrayPKcolumns[ci].getName());
                }
                ResultSet fkInfo = null;
                try {
                    Table fkTable = null;
                    Hashtable fkTableColumns = null;
                    FKConstraint fk = null;
                    dbMetaData = database.getConnection().getMetaData();
                    fkInfo = dbMetaData.getExportedKeys(catalog, schemaNameToUse, tableName);
                    String currentFk = null;
                    short LAST_KEY_SEQ = -1;
                    Column[] orderedFKColumns = null;
                    while (fkInfo.next()) {
                        String fkName = fkInfo.getString(12);
                        short KEY_SEQ = fkInfo.getShort(9);
                        boolean startNewKey = false;
                        if (fkName == null) {
                            if (KEY_SEQ < LAST_KEY_SEQ || LAST_KEY_SEQ == -1) {
                                startNewKey = true;
                            }
                        } else if (currentFk == null || !currentFk.equals(fkName)) {
                            startNewKey = true;
                        }
                        LAST_KEY_SEQ = KEY_SEQ;
                        currentFk = fkName;
                        if (KEY_SEQ > arrayPKcolumns.length) continue;
                        if (startNewKey) {
                            String fkTableName;
                            String fkSchemaName = fkInfo.getString(6);
                            DatabaseTable fkDbTable = new DatabaseTable(fkSchemaName, fkTableName = fkInfo.getString(7));
                            fkTable = (Table)createdTables.get(fkDbTable);
                            if (fkTable == null) {
                                fkDbTable = new DatabaseTable(fkTableName);
                                fkTable = (Table)createdTables.get(fkDbTable);
                            }
                            fkTableColumns = (Hashtable)allColumns.get(fkDbTable);
                            orderedFKColumns = new Column[arrayPKcolumns.length];
                            if (fkTable == null) continue;
                            if (fkName == null) {
                                fkName = fkTableName + "_" + tableName + "_FK";
                            }
                            fk = new FKConstraint(fkName, (Relation)fkTable);
                            fk.setID(TemporaryObjectID.createID((DBObject)fk));
                            fk.setReferenceID(TemporaryObjectID.createID((DBObject)pk));
                            fkTable.addConstraint((Constraint)fk);
                        } else if (fkTable == null) continue;
                        String fkColumnName = fkInfo.getString(8);
                        String pkColumnName = fkInfo.getString(4);
                        Column fkColumn = (Column)fkTableColumns.get(fkColumnName);
                        if (fkColumn != null) {
                            int indexOfColumnInPK = vectorPKColumns.indexOf(pkColumnName);
                            orderedFKColumns[indexOfColumnInPK] = fkColumn;
                        }
                        if (KEY_SEQ != arrayPKcolumns.length) continue;
                        for (int j = 0; j < orderedFKColumns.length; ++j) {
                            fk.addColumn(orderedFKColumns[j]);
                        }
                    }
                    fkInfo.close();
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
                finally {
                    if (fkInfo != null) {
                        try {
                            fkInfo.close();
                        }
                        catch (Exception ignore) {}
                    }
                }
            }
            Enumeration schemas = createdSchemas.elements();
            while (schemas.hasMoreElements()) {
                Schema schema = (Schema)schemas.nextElement();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Table[] tableArray = allTables;
            return tableArray;
        }
        finally {
            context._connection = database.getConnection();
        }
        System.out.println("Time to import tables: " + (double)(System.currentTimeMillis() - startTime) / 1000.0 + " seconds");
        return allTables;
    }

    protected Column createColumn(String columnName, String columnTypeName, int sqlType, int precision, int scale, int isNullable, Database database) {
        long startTime = System.currentTimeMillis();
        if (currentlyUnsupportedSqlTypes.containsKey(new Integer(sqlType))) {
            return null;
        }
        if (columnName == null) {
            return null;
        }
        if (columnTypeName == null || columnTypeName.length() == 0) {
            columnTypeName = (String)sqlTypes.get(new Integer(sqlType));
            if (columnTypeName == null) {
                columnTypeName = "VARCHAR";
            }
        } else if (XRAdapterUtil.getJavaTypeFromSQLType(columnTypeName, null, null, null) == null) {
            String alternateTypeName = (String)sqlTypes.get(new Integer(sqlType));
            if (alternateTypeName != null && XRAdapterUtil.getJavaTypeFromSQLType(alternateTypeName, null, null, null) != null) {
                columnTypeName = alternateTypeName;
            }
        }
        Column column = new Column(columnName);
        column.setID(TemporaryObjectID.createID((DBObject)column));
        DataType dataType = null;
        if (database instanceof SQLServerDatabase && columnTypeName.toUpperCase().indexOf("IDENTITY") > -1) {
            dataType = DataTypeRegistry.getInstance().findDataType(columnTypeName, database.getClass());
            if (dataType == null) {
                dataType = DataTypeRegistry.getInstance().createUserDataType(columnTypeName, database.getClass());
            }
        } else {
            dataType = database.getDataType(columnTypeName);
            if (dataType == null && (dataType = DataTypeRegistry.getInstance().findDataType(columnTypeName, database.getClass())) == null) {
                dataType = DataTypeRegistry.getInstance().createUserDataType(columnTypeName, database.getClass());
            }
        }
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("name", columnTypeName);
        if (precision >= 0) {
            attributes.put("size", DataTypeHelper.getAttributeValue((Object)new Long(precision), (DataType)dataType, (String)"size"));
            attributes.put("precision", DataTypeHelper.getAttributeValue((Object)new Long(precision), (DataType)dataType, (String)"precision"));
        }
        if (scale >= 0) {
            attributes.put("scale", DataTypeHelper.getAttributeValue((Object)new Long(scale), (DataType)dataType, (String)"scale"));
            column.setScale(new Long(scale));
        }
        column.setDataTypeUsage(dataType.createUsage(attributes));
        if (isNullable == 0) {
            column.setNotNull(true);
        }
        this.timeToCreateOfflineDBObjects += System.currentTimeMillis() - startTime;
        return column;
    }

    static {
        sqlTypes.put(new Integer(2003), "ARRAY");
        sqlTypes.put(new Integer(-5), "BIGINT");
        sqlTypes.put(new Integer(-2), "BINARY");
        sqlTypes.put(new Integer(-7), "BIT");
        sqlTypes.put(new Integer(2004), "BLOB");
        sqlTypes.put(new Integer(16), "BOOLEAN");
        sqlTypes.put(new Integer(1), "CHAR");
        sqlTypes.put(new Integer(2005), "CLOB");
        sqlTypes.put(new Integer(91), "DATE");
        sqlTypes.put(new Integer(3), "DECIMAL");
        sqlTypes.put(new Integer(2001), "DISTINCT");
        sqlTypes.put(new Integer(8), "DOUBLE");
        sqlTypes.put(new Integer(6), "FLOAT");
        sqlTypes.put(new Integer(4), "INTEGER");
        sqlTypes.put(new Integer(2000), "JAVA_OBJECT");
        sqlTypes.put(new Integer(-4), "LONGVARBINARY");
        sqlTypes.put(new Integer(-1), "LONGVARCHAR");
        sqlTypes.put(new Integer(0), "NULL");
        sqlTypes.put(new Integer(2), "NUMERIC");
        sqlTypes.put(new Integer(1111), "OTHER");
        sqlTypes.put(new Integer(7), "REAL");
        sqlTypes.put(new Integer(2006), "REF");
        sqlTypes.put(new Integer(5), "SMALLINT");
        sqlTypes.put(new Integer(2002), "STRUCT");
        sqlTypes.put(new Integer(92), "TIME");
        sqlTypes.put(new Integer(93), "TIMESTAMP");
        sqlTypes.put(new Integer(-6), "TINYINT");
        sqlTypes.put(new Integer(-3), "VARBINARY");
        sqlTypes.put(new Integer(12), "VARCHAR");
        currentlyUnsupportedSqlTypes = new Hashtable();
    }
}

