/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.bam;

import com.collaxa.cube.engine.sensor.sa.publisher.bam.DataObjectKeys;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.InputStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.bali.ewt.shuttle.ItemPicker;
import oracle.bali.ewt.shuttle.ListPicker;
import oracle.bali.ewt.shuttle.Shuttle;
import oracle.bali.ewt.shuttle.ShuttleEvent;
import oracle.bali.ewt.shuttle.ShuttleListener;
import oracle.bali.share.nls.StringUtils;
import oracle.javatools.util.BundleLoader;
import oracle.tip.tools.ide.bam.common.connection.BAMConnection;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.ui.treeexplorer.PopupListener;
import oracle.tip.tools.ide.common.ui.treeexplorer.TreeExplorer;
import oracle.tip.tools.ide.common.utils.BamUtils;
import oracle.tip.tools.ide.common.utils.MultiLineOptionPane;
import oracle.tip.tools.ide.common.utils.URLFetcher;
import oracle.tip.tools.ide.pm.modules.bam.BAMDOChooser;
import oracle.tip.tools.ide.pm.modules.bam.BAMDOChooserPopupListener;
import oracle.tip.tools.ide.pm.modules.bam.BAMDODataSource;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.bam.BAMKey;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.bam.BAMUIComponent;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.bam.BAMUIContext;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;

public class BAMDataObjectPanel
extends JPanel
implements ActionListener,
DocumentListener,
ShuttleListener {
    public static final String RESOURCE_BUNDLE = "oracle.tip.tools.ide.pm.modules.bizintegration.adapter.techAdapterResource";
    public static final String WSDL_DEFAULT_OPERATION_NAME = "writetoBAM";
    private BAMUIContext bamUIContext;
    private ResourceBundle resourceBundle;
    private Vector selectedKeyList;
    private Vector availableKeyList;
    private BAMUIComponent bamUIComponent;
    private BAMConnection bamConnection;
    private URL doURL;
    private JLabel doLabel = new JLabel();
    private JTextField doTextField = new JTextField();
    private JButton browseButton = new JButton();
    private Shuttle keysShuttle = new Shuttle();
    private ListPicker availableKeysPicker;
    private ListPicker selectedKeysPicker;
    private JList availJList;
    private JList selJList;
    private KeyListRenderer keyListRenderer;
    private JLabel opLabel = new JLabel();
    private JComboBox opComboBox = new JComboBox();
    private JLabel opNameLabel = new JLabel();
    private JTextField opNameTextField = new JTextField();
    private JCheckBox enableBatchingCheckBox = new JCheckBox();
    private JPanel spacer = new JPanel();
    private Frame parentFrame;

    public BAMDataObjectPanel(Frame parentFrame, BAMUIContext bamUIContext, BAMUIComponent bamUIComponent) {
        this.init(parentFrame, bamUIContext, bamUIComponent);
    }

    public BAMDataObjectPanel(BAMUIContext bamUIContext) {
        this.init(this.parentFrame, bamUIContext, null);
    }

    private void init(Frame parentFrame, BAMUIContext bamUIContext, BAMUIComponent bamUIComponent) {
        this.bamUIComponent = bamUIComponent;
        this.bamUIContext = bamUIContext;
        this.parentFrame = parentFrame;
        this.availableKeyList = new Vector();
        this.selectedKeyList = new Vector();
        this.resourceBundle = BundleLoader.getBundle((String)RESOURCE_BUNDLE);
        this.keyListRenderer = new KeyListRenderer();
        try {
            this.uiControlsInit();
            if (bamUIContext == null) {
                this.bamUIContext = new BAMUIContext();
            } else {
                this.bamConnection = bamUIContext.getBAMConnection();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void uiControlsInit() throws Exception {
        String dataObjectText = this.getTranslatedString("BAM_DO_DATA_OBJECT");
        String browseText = this.getTranslatedString("BAM_DO_BROWSE");
        String browseTip = this.getTranslatedString("BAM_DO_BROWSE_TIP");
        String opText = this.getTranslatedString("BAM_DO_OPERATION");
        String opNameText = this.getTranslatedString("BAM_DO_OPERATION_NAME");
        String enableBatchingText = this.getTranslatedString("BAM_DO_ENABLE_BATCHING");
        String insertText = this.getTranslatedString("BAM_INSERT");
        String updateText = this.getTranslatedString("BAM_UPDATE");
        String deleteText = this.getTranslatedString("BAM_DELETE");
        String upsertText = this.getTranslatedString("BAM_UPSERT");
        this.setLayout(new GridBagLayout());
        this.doLabel.setText(StringUtils.stripMnemonic((String)dataObjectText));
        this.doLabel.setLabelFor(this.doTextField);
        this.doTextField.setEditable(false);
        this.browseButton.setText(StringUtils.stripMnemonic((String)browseText));
        this.browseButton.setToolTipText(browseTip);
        this.browseButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)browseText));
        this.browseButton.addActionListener(this);
        this.opLabel.setText(StringUtils.stripMnemonic((String)opText));
        this.opLabel.setLabelFor(this.opComboBox);
        this.opLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)opText));
        this.opComboBox.addItem(new BAMNameValuePair(insertText, "Insert"));
        this.opComboBox.addItem(new BAMNameValuePair(updateText, "Update"));
        this.opComboBox.addItem(new BAMNameValuePair(deleteText, "Delete"));
        this.opComboBox.addItem(new BAMNameValuePair(upsertText, "Upsert"));
        this.opComboBox.addActionListener(this);
        this.opNameLabel.setText(StringUtils.stripMnemonic((String)opNameText));
        this.opNameLabel.setLabelFor(this.opNameTextField);
        this.opNameLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)opNameText));
        this.opNameTextField.setText(WSDL_DEFAULT_OPERATION_NAME);
        this.opNameTextField.getDocument().addDocumentListener(this);
        this.enableBatchingCheckBox.setText(StringUtils.stripMnemonic((String)enableBatchingText));
        this.enableBatchingCheckBox.setMnemonic(StringUtils.getMnemonicKeyCode((String)enableBatchingText));
        this.setupKeyShuttle(this.availableKeyList, this.selectedKeyList);
        this.keysShuttle.addShuttleListener((ShuttleListener)this);
        this.add((Component)this.doLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 10, 0, 0), 0, 0));
        this.add((Component)this.doTextField, new GridBagConstraints(1, 0, 1, 1, 2.0, 0.0, 18, 2, new Insets(0, 5, 0, 0), 0, 0));
        this.add((Component)this.browseButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.add((Component)this.opLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 10, 0, 0), 0, 0));
        this.add((Component)this.opComboBox, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 5, 0, 10), 0, 0));
        this.add((Component)this.opNameLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 10, 0, 0), 0, 0));
        this.add((Component)this.opNameTextField, new GridBagConstraints(1, 2, 0, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 0, 10), 0, 0));
        this.add((Component)this.enableBatchingCheckBox, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)this.keysShuttle, new GridBagConstraints(0, 4, 0, 1, 0.0, 10.0, 18, 1, new Insets(5, 10, 0, 10), 0, 0));
        this.add((Component)this.spacer, new GridBagConstraints(0, 5, 1, 1, 0.0, 1.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.refreshShuttle();
        if (this.bamUIContext != null) {
            this.updateControls(this.bamUIContext);
        }
    }

    public BAMUIContext getBAMUIContext() {
        this.updateContextObject();
        return this.bamUIContext;
    }

    public String getTranslatedString(String messageKey) {
        return this.resourceBundle.getString(messageKey);
    }

    private void updateControls(BAMUIContext bamUIContext) {
        if (bamUIContext != null) {
            this.doTextField.setText(bamUIContext.getDataObjectName());
            this.opComboBoxSetSelectedItem(bamUIContext.getOperation());
            this.opNameTextField.setText(bamUIContext.getOperationName());
            if (bamUIContext.isBatchingEnabled()) {
                this.enableBatchingCheckBox.setSelected(true);
            } else {
                this.enableBatchingCheckBox.setSelected(false);
            }
            BAMConnection bamConn = bamUIContext.getBAMConnection();
            if (bamConn != null) {
                try {
                    URL rootURL = BAMDODataSource.getURL(bamConn);
                    this.doURL = this.getURL(rootURL, bamUIContext.getDataObjectName());
                    URLFetcher urlFetcher = bamConn.getURLFetcher();
                    InputStream is = urlFetcher.getURL(this.doURL);
                    DataObjectKeys doKeys = new DataObjectKeys(is);
                    is.close();
                    Vector availKeyNameList = doKeys.parseKeys();
                    this.availableKeyList = this.convertToBAMKeys(availKeyNameList);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    MessageFormat msgformat = new MessageFormat(this.resourceBundle.getString("BAM_DO_ACCESS_ERROR"));
                    Object[] obj = new Object[]{bamUIContext.getDataObjectName(), bamConn.getName()};
                    MultiLineOptionPane.showMessageDialog((Component)this.parentFrame, (Object)msgformat.format(obj), (String)this.resourceBundle.getString("BAM_ERROR_TITLE"), (int)0);
                }
            }
            this.stampSelectedKeys();
            List selKeys = bamUIContext.getSelectedKeys();
            this.selectedKeyList = selKeys != null && selKeys.size() > 0 ? new Vector(selKeys) : new Vector();
            this.removeDuplicatesFromAvailableKeys(this.availableKeyList, this.selectedKeyList);
            this.setupKeyShuttle(this.availableKeyList, this.selectedKeyList);
        }
    }

    private void opComboBoxSetSelectedItem(String operation) {
        if (operation == null || this.opComboBox == null) {
            return;
        }
        int count = this.opComboBox.getItemCount();
        for (int i = 0; i < count; ++i) {
            BAMNameValuePair opItem = (BAMNameValuePair)this.opComboBox.getItemAt(i);
            if (!opItem.getValue().equals(operation)) continue;
            this.opComboBox.setSelectedIndex(i);
            return;
        }
    }

    private void removeDuplicatesFromAvailableKeys(Vector availableKeys, Vector selectedKeys) {
        if (availableKeys != null && selectedKeys != null) {
            for (int i = 0; i < selectedKeys.size(); ++i) {
                BAMKey curSelKey = (BAMKey)selectedKeys.get(i);
                for (int j = 0; j < availableKeys.size(); ++j) {
                    BAMKey curAvailKey = (BAMKey)availableKeys.get(j);
                    if (!curSelKey.getKey().equals(curAvailKey.getKey())) continue;
                    availableKeys.remove(j);
                }
            }
        }
    }

    private URL getURL(URL rootURL, String doLocation) throws Exception {
        String BAM_DIR = "/OracleBAMWS/WebServices/Wsil/DataObjects";
        String urlPrefix = rootURL.getProtocol() + "://" + rootURL.getHost() + ":" + rootURL.getPort();
        if (!doLocation.startsWith("/")) {
            doLocation = "/" + doLocation;
        }
        String doEncoded = BamUtils.encodeDataObjectName4InspectionService((String)doLocation);
        String urlStr = urlPrefix + BAM_DIR + doEncoded;
        URL url = null;
        try {
            url = new URL(urlStr);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return url;
    }

    private void refreshShuttle() {
        BAMNameValuePair opItem = (BAMNameValuePair)this.opComboBox.getSelectedItem();
        String selOperation = opItem.getValue();
        if ("Insert".equalsIgnoreCase(selOperation) && this.keysShuttle.isVisible()) {
            this.keysShuttle.setVisible(false);
        } else if (!"Insert".equalsIgnoreCase(selOperation) && !this.keysShuttle.isVisible()) {
            this.keysShuttle.setVisible(true);
        }
    }

    private void handleDOBrowseEvent() {
        BAMDOChooser browser = new BAMDOChooser(GraphUtils.getFrame((Component)this), true);
        browser.setTitle(this.getTranslatedString("BAM_DO_CHOOSER_DIALOG_TITLE"));
        try {
            BAMDODataSource ds = new BAMDODataSource();
            TreeExplorer explorer = browser.getExplorer();
            if (explorer != null) {
                BAMDOChooserPopupListener popupListener = new BAMDOChooserPopupListener();
                explorer.addPopupListener((PopupListener)popupListener);
                BAMDOChooserPopupListener.NewBAMConnectionAction action = new BAMDOChooserPopupListener.NewBAMConnectionAction(explorer);
                explorer.setToolBarActions(new Action[]{action});
            }
            browser.display(ds);
            if (browser.getReturnValue() == 0) {
                this.doURL = browser.getUrl();
                URLFetcher urlFetcher = browser.getURLFetcher();
                this.bamConnection = (BAMConnection)urlFetcher;
                String doName = urlFetcher.getName(this.doURL);
                this.doTextField.setText(doName);
                InputStream is = urlFetcher.getURL(this.doURL);
                DataObjectKeys doKeys = new DataObjectKeys(is);
                is.close();
                Vector availKeyNameList = doKeys.parseKeys();
                this.availableKeyList = this.convertToBAMKeys(availKeyNameList);
                this.selectedKeyList = new Vector();
                this.setupKeyShuttle(this.availableKeyList, this.selectedKeyList);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            MessageFormat msgformat = new MessageFormat(this.resourceBundle.getString("BAM_DO_ACCESS_ERROR"));
            Object[] obj = new Object[]{e.getLocalizedMessage()};
            MultiLineOptionPane.showMessageDialog(null, (Object)msgformat.format(obj), (String)this.resourceBundle.getString("BAM_ERROR_TITLE"), (int)0);
        }
    }

    private void componentCallback() {
        if (this.bamUIComponent != null) {
            this.bamUIComponent.updateControls();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isUserInputValid() {
        boolean isValid = false;
        BAMNameValuePair opItem = (BAMNameValuePair)this.opComboBox.getSelectedItem();
        String selOperation = opItem.getValue();
        if (!this.doTextField.getText().trim().equals("")) {
            if ("Insert".equalsIgnoreCase(selOperation) && !this.opNameTextField.getText().trim().equals("")) {
                return true;
            }
        }
        if (this.doTextField.getText().trim().equals("")) return false;
        if ("Insert".equalsIgnoreCase(selOperation)) return false;
        if (this.opNameTextField.getText().trim().equals("")) return false;
        if (this.selectedKeyList == null) return false;
        if (this.selectedKeyList.size() <= 0) return false;
        return true;
    }

    private void updateContextObject() {
        BAMNameValuePair opItem = (BAMNameValuePair)this.opComboBox.getSelectedItem();
        this.bamUIContext.setDataObjectName(this.doTextField.getText());
        this.bamUIContext.setOperation(opItem.getValue());
        this.bamUIContext.setOperationName(this.opNameTextField.getText());
        this.bamUIContext.setBAMConnection(this.bamConnection);
        this.bamUIContext.setDataObjectURL(this.doURL);
        if (!"Insert".equals(this.bamUIContext.getOperation())) {
            this.updateSelectedKeysList();
        } else {
            this.bamUIContext.setSelectedKeys(null);
        }
        if (this.enableBatchingCheckBox.isSelected()) {
            this.bamUIContext.setIsBatchingEnabled(true);
        } else {
            this.bamUIContext.setIsBatchingEnabled(false);
        }
    }

    private void updateSelectedKeysList() {
        this.selectedKeyList = new Vector();
        Transferable[] transArray = this.selectedKeysPicker.getAllSelectableItems();
        if (transArray != null && transArray.length > 0) {
            for (int i = 0; i < transArray.length; ++i) {
                try {
                    Class<?> bamKeyClass = Class.forName("oracle.tip.tools.ide.pm.modules.bizintegration.adapter.bam.BAMKey");
                    DataFlavor bamKeyDF = new DataFlavor(bamKeyClass, "BAMKey");
                    BAMKey currentKey = (BAMKey)transArray[i].getTransferData(bamKeyDF);
                    this.selectedKeyList.add(currentKey);
                    this.bamUIContext.setSelectedKeys(this.selectedKeyList);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void setupKeyShuttle(Vector availableKeys, Vector selectedKeys) {
        this.availJList = new JList(availableKeys);
        this.availJList.setCellRenderer(this.keyListRenderer);
        this.availableKeysPicker = new ListPicker(this.availJList);
        this.availableKeysPicker.setItemsSorted(true);
        this.selJList = new JList(selectedKeys);
        this.selJList.setCellRenderer(this.keyListRenderer);
        this.selectedKeysPicker = new ListPicker(this.selJList);
        this.selectedKeysPicker.setItemsSorted(true);
        this.keysShuttle.setFromPicker((ItemPicker)this.availableKeysPicker);
        this.keysShuttle.setToPicker((ItemPicker)this.selectedKeysPicker);
        this.revalidate();
    }

    private void stampSelectedKeys() {
        List selKeys;
        if (this.bamUIContext != null && (selKeys = this.bamUIContext.getSelectedKeys()) != null && selKeys.size() > 0) {
            for (int i = 0; i < selKeys.size(); ++i) {
                BAMKey currentKey = (BAMKey)selKeys.get(i);
                if (this.availableKeyList != null && this.availableKeyList.size() > 0 && this.keyExists(this.availableKeyList, currentKey)) {
                    currentKey.setIsAvailable(true);
                    continue;
                }
                currentKey.setIsAvailable(false);
            }
        }
    }

    private Vector convertToBAMKeys(Vector availKeyNameList) {
        Vector<BAMKey> availKeyList = new Vector<BAMKey>();
        if (availKeyNameList != null && availKeyNameList.size() > 0) {
            for (int i = 0; i < availKeyNameList.size(); ++i) {
                BAMKey bamKey = new BAMKey((String)availKeyNameList.get(i), true);
                availKeyList.add(bamKey);
            }
        }
        return availKeyList;
    }

    private boolean keyExists(Vector availableKeys, BAMKey key) {
        if (key != null && availableKeys != null && availableKeys.size() > 0) {
            for (int i = 0; i < availableKeys.size(); ++i) {
                BAMKey currAvailKey = (BAMKey)availableKeys.get(i);
                if (currAvailKey == null || !key.getKey().equals(currAvailKey.getKey())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.browseButton) {
            this.handleDOBrowseEvent();
        }
        this.refreshShuttle();
        this.componentCallback();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.componentCallback();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.componentCallback();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.componentCallback();
    }

    public void shuttleItemsMoved(ShuttleEvent event) {
        this.updateSelectedKeysList();
        this.refreshShuttle();
        this.componentCallback();
    }

    public void shuttleItemsRemoved(ShuttleEvent event) {
        this.updateSelectedKeysList();
        this.refreshShuttle();
        this.componentCallback();
    }

    public void shuttleItemsReordered(ShuttleEvent event) {
    }

    class KeyListRenderer
    extends JPanel
    implements ListCellRenderer {
        private JLabel label = new JLabel();
        private JLabel text = new JLabel();
        private ImageIcon icon = (ImageIcon)ImageCache.getIcon("graph/bpel/flag_red16.png");

        KeyListRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.layoutComponents((BAMKey)value);
            this.setComponentOrientation(list.getComponentOrientation());
            Color backGround = list.getBackground();
            Color foreGround = list.getForeground();
            if (isSelected) {
                backGround = list.getSelectionBackground();
                foreGround = list.getSelectionForeground();
            }
            this.setBackground(backGround);
            this.setForeground(foreGround);
            this.label.setForeground(foreGround);
            this.label.setBackground(backGround);
            this.text.setForeground(foreGround);
            this.text.setBackground(backGround);
            return this;
        }

        private void layoutComponents(BAMKey bamKey) {
            if (bamKey != null) {
                this.removeAll();
                if (!bamKey.isAvailable()) {
                    this.label.setIcon(this.icon);
                    this.setToolTipText(BAMDataObjectPanel.this.resourceBundle.getString("BAM_DO_UNAVAILABLE_KEY"));
                } else {
                    this.label.setIcon(null);
                    this.setToolTipText(null);
                }
                this.text.setText(bamKey.getKey());
                int x = 0;
                int y = 0;
                GridBagLayout gbl = new GridBagLayout();
                this.setLayout(gbl);
                gbl.setConstraints(this.text, new GridBagConstraints(x, y, -1, 0, 1.0, 1.0, 21, 2, new Insets(0, 0, 0, 0), 0, 0));
                this.add(this.text);
                gbl.setConstraints(this.label, new GridBagConstraints(++x, y, 0, 0, 0.0, 1.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
                this.add(this.label);
            }
        }
    }

    public class BAMNameValuePair {
        String name;
        String value;

        public BAMNameValuePair(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return this.name;
        }
    }
}

