/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.bam;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.ewt.wizard.ImageWizardPage;
import oracle.bali.share.nls.StringUtils;
import oracle.tip.tools.ide.bam.common.connection.BAMConnection;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.AdapterWizardContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.bam.BAMUIContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.techAdapterWizardPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.wsdl.JcaAddress;

public class BAMAdapterNetworkProtocolPage
extends techAdapterWizardPage
implements DocumentListener {
    private MultiLineLabel jndiIntroPrompt;
    private JLabel jndiNameLabel = new JLabel();
    private JTextField jndiNameTextField = new JTextField();
    private BAMUIContext bamUIContext;

    public BAMAdapterNetworkProtocolPage(AdapterWizardContext wcontext, ImageWizardPage iwp) {
        try {
            this.setHelpTopicID("bamjdev_config_adapter_jndi");
            this.setContextAndPage(wcontext, iwp);
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        String jndiIntroText = this.getTranslatedString("BAM_NP_JNDI_INTRO");
        String jndiNameText = this.getTranslatedString("BAM_NP_JNDI_NAME");
        this.jndiIntroPrompt = new MultiLineLabel(WordWrapper.getTextWrapper(), jndiIntroText);
        this.jndiNameLabel.setText(StringUtils.stripMnemonic((String)jndiNameText));
        this.jndiNameLabel.setLabelFor(this.jndiNameTextField);
        this.jndiNameLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)jndiNameText));
        this.jndiNameTextField.getDocument().addDocumentListener(this);
        this.add((Component)this.jndiIntroPrompt, new GridBagConstraints(0, 0, 0, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.jndiNameLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.add((Component)this.jndiNameTextField, new GridBagConstraints(1, 1, 0, 1, 0.0, 1.0, 18, 2, new Insets(10, 5, 0, 0), 0, 0));
        if (this.m_wcontext._read_service != null) {
            this.initFromWSDL();
        }
        this.updateControls();
    }

    private void initFromWSDL() {
        JcaAddress jcaa = this.m_wcontext._read_jca_address;
        this.jndiNameTextField.setText(jcaa.getAdapterInstanceJndi());
    }

    public void updatePage() {
        String jndiName = this.jndiNameTextField.getText().trim();
        this.bamUIContext = (BAMUIContext)this.m_wcontext._ascontext;
        String rmiJNDIName = this.bamUIContext.getBAMConnection().getRMIAdapterFactoryJNDI();
        if (jndiName == null || jndiName.equals("") || jndiName.equals(rmiJNDIName)) {
            jndiName = rmiJNDIName;
        }
        this.jndiNameTextField.setText(jndiName);
        this.updateControls();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.updateControls();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.updateControls();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.updateControls();
    }

    private void updateControls() {
        if (this.jndiNameTextField.getText().trim().equals("")) {
            this.m_page.setCanAdvance(false);
        } else {
            this.m_page.setCanAdvance(true);
        }
    }

    @Override
    public void buildWSDL() throws WSDLException {
        try {
            this.bamUIContext = (BAMUIContext)this.m_wcontext._ascontext;
            BAMConnection bamConn = this.bamUIContext.getBAMConnection();
            JcaAddress jcaa = (JcaAddress)this.m_wcontext._extReg.createExtension(JcaAddress.PARENT_CLASS, JcaAddress.FIELD_ELEMENT_TYPE);
            this.m_wcontext._write_port.addExtensibilityElement((ExtensibilityElement)jcaa);
            this.m_wcontext._write_jca_address = jcaa;
            jcaa.setAdapterInstanceJndi(this.jndiNameTextField.getText().trim());
            jcaa.setUiConnectionName(bamConn.getName());
        }
        catch (WSDLException wsdlEx) {
            throw wsdlEx;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new WSDLException("OTHER_ERROR", e.getMessage());
        }
    }
}

