/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.bam;

import com.collaxa.cube.engine.sensor.sa.publisher.bam.DataObjectKeys;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.naming.NamingException;
import javax.wsdl.Definition;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Part;
import javax.wsdl.Types;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.xml.namespace.QName;
import oracle.bali.ewt.event.Cancelable;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.ewt.wizard.ImageWizardPage;
import oracle.bali.ewt.wizard.WizardEvent;
import oracle.tip.tools.ide.bam.common.connection.BAMConnection;
import oracle.tip.tools.ide.bam.common.connection.BAMConnectionLookup;
import oracle.tip.tools.ide.common.utils.MultiLineOptionPane;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.AdapterWizardContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.bam.BAMAdapterNetworkProtocolPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.bam.BAMDataObjectPanel;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.bam.BAMKey;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.bam.BAMUIComponent;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.bam.BAMUIContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.techAdapterWizardPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.wsdl.ImportSchema;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.wsdl.JcaOperation;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class BAMAdapterDataObjectPage
extends techAdapterWizardPage
implements BAMUIComponent {
    public static final String KEY_SEPARATOR = ",";
    public static final String WSDL_DATA_OBJECT_NAME = "DataObjectName";
    public static final String WSDL_OPERATION_TYPE = "OperationType";
    public static final String WSDL_ENABLE_BATCHING = "InBatch";
    public static final String WSDL_KEYS = "Keys";
    public static final String XSD_NAMESPACE_PREFIX = "imp1";
    public static final String TRUE = "true";
    public static final String FALSE = "false";
    private MultiLineLabel introPrompt;
    private BAMDataObjectPanel bamDOPanel;
    private BAMUIContext bamUIContext;
    private String bamXSDContent;
    private String rootElement;
    private String xsdNamespace;
    private String xsdFileName;

    public BAMAdapterDataObjectPage(AdapterWizardContext wcontext, ImageWizardPage iwp) {
        try {
            this.setHelpTopicID("bamjdev_config_adapter_do");
            this.setContextAndPage(wcontext, iwp);
            this.bamUIContext = (BAMUIContext)wcontext._ascontext;
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        String introText = this.getTranslatedString("BAM_DO_INTRO");
        this.introPrompt = new MultiLineLabel(WordWrapper.getTextWrapper(), introText);
        if (this.m_wcontext._read_service != null) {
            this.initFromWSDL();
            this.bamDOPanel = new BAMDataObjectPanel(this.m_wcontext._parentFrame, this.bamUIContext, this);
        } else {
            this.bamDOPanel = new BAMDataObjectPanel(this.m_wcontext._parentFrame, null, this);
        }
        this.add((Component)this.introPrompt, new GridBagConstraints(0, 0, 0, 1, 0.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.bamDOPanel, new GridBagConstraints(0, 1, 0, 1, 1.0, 1.0, 18, 1, new Insets(10, 0, 0, 0), 0, 0));
        this.updateControls();
    }

    private void initFromWSDL() {
        JcaOperation jop = this.m_wcontext._read_jca_operation;
        String dataObjectName = jop.getAttributeValue(WSDL_DATA_OBJECT_NAME);
        String operation = jop.getAttributeValue(WSDL_OPERATION_TYPE);
        String enableBatching = jop.getAttributeValue(WSDL_ENABLE_BATCHING);
        String selKeysStr = jop.getAttributeValue(WSDL_KEYS);
        String operationName = this.m_wcontext._read_operation_name;
        List selKeysList = this.convertSelKeysToList(selKeysStr);
        if (this.bamUIContext == null) {
            this.bamUIContext = new BAMUIContext();
        }
        this.bamUIContext.setDataObjectName(dataObjectName);
        this.bamUIContext.setOperation(operation);
        this.bamUIContext.setOperationName(operationName);
        this.bamUIContext.setSelectedKeys(selKeysList);
        if (enableBatching != null && enableBatching.equalsIgnoreCase(TRUE)) {
            this.bamUIContext.setIsBatchingEnabled(true);
        } else {
            this.bamUIContext.setIsBatchingEnabled(false);
        }
        String connName = this.m_wcontext._read_jca_address.getUiConnectionName();
        try {
            BAMConnection bamConn = new BAMConnectionLookup().lookup(connName);
            this.bamUIContext.setBAMConnection(bamConn);
        }
        catch (NamingException e) {
            // empty catch block
        }
    }

    private List convertSelKeysToList(String selKeysStr) {
        ArrayList<BAMKey> selKeysList = null;
        if (selKeysStr != null && !selKeysStr.trim().equals("")) {
            StringTokenizer tokenizer = new StringTokenizer(selKeysStr, KEY_SEPARATOR);
            selKeysList = new ArrayList<BAMKey>();
            while (tokenizer.hasMoreTokens()) {
                selKeysList.add(new BAMKey(tokenizer.nextToken(), true));
            }
        }
        return selKeysList;
    }

    private void setFinishContents() {
        String finishInfo;
        String finishPrompt;
        if (this.m_wcontext._read_service != null) {
            MessageFormat msgformat = new MessageFormat(this.getTranslatedString("BAM_FN_UPDATE_PROMPT"));
            Object[] obj = new Object[]{this.m_wcontext._write_service_name};
            finishPrompt = msgformat.format(obj);
            msgformat = new MessageFormat(this.getTranslatedString("BAM_FN_UPDATE_SUMMARY"));
            obj = new Object[]{this.m_wcontext._write_wsdl_name, this.xsdFileName};
            finishInfo = msgformat.format(obj);
        } else {
            MessageFormat msgformat = new MessageFormat(this.getTranslatedString("BAM_FN_CREATE_PROMPT"));
            Object[] obj = new Object[]{this.m_wcontext._write_service_name};
            finishPrompt = msgformat.format(obj);
            msgformat = new MessageFormat(this.getTranslatedString("BAM_FN_CREATE_SUMMARY"));
            obj = new Object[]{this.m_wcontext._write_wsdl_name, this.xsdFileName};
            finishInfo = msgformat.format(obj);
        }
        this.setFinishPageContents(finishPrompt, finishInfo);
    }

    @Override
    public void wizardValidatePage(WizardEvent event) {
        this.bamUIContext = this.bamDOPanel.getBAMUIContext();
        if (this.bamUIContext.getBAMConnection() != null) {
            this.m_wcontext._isInboundOperation = false;
            this.xsdFileName = this.getXSDFilename(this.bamUIContext);
            this.setFinishContents();
            this.m_wcontext._ascontext = this.bamUIContext;
            int currentPageIndex = this.m_wizard.getCurrentPageIndex();
            ImageWizardPage page = (ImageWizardPage)this.m_wizard.getPageAt(currentPageIndex + 1);
            BAMAdapterNetworkProtocolPage nextPage = (BAMAdapterNetworkProtocolPage)page.getInteractiveArea();
            nextPage.updatePage();
        } else {
            MultiLineOptionPane.showMessageDialog((Component)this.m_wcontext._parentFrame, (Object)this.getTranslatedString("BAM_CONN_ERROR_NONAME"), (String)this.m_wcontext._bundle.getString("BAM_ERROR_TITLE"), (int)0);
            ((Cancelable)event).cancel();
        }
    }

    private String getXSDFilename(BAMUIContext bamContext) {
        String SEPARATOR = "_";
        String xsdFilename = null;
        if (bamContext != null) {
            String connName = bamContext.getBAMConnection().getName();
            String doName = bamContext.getDataObjectName().replace("/", "_");
            doName = doName.replace(" ", "_");
            xsdFilename = connName + doName + ".xsd";
            try {
                xsdFilename = URLEncoder.encode(xsdFilename, "UTF-8").replaceAll("%", "-");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return xsdFilename;
    }

    private void createXSDFile(String xsd) throws Exception {
        String xsdFilePath = this.m_wcontext.getSchemaFilePath() + File.separator + this.getXSDFilename(this.bamUIContext);
        if (xsd != null) {
            FileOutputStream out = new FileOutputStream(xsdFilePath);
            out.write(xsd.getBytes("UTF-8"));
            OutputStreamWriter xsdWriter = new OutputStreamWriter((OutputStream)out, "UTF-8");
            xsdWriter.flush();
            xsdWriter.close();
        }
    }

    private String getXSDFromWSDL(InputStream wsdlStream) throws Exception {
        String XSD_NAMESPACE_KEY = "xmlns:xsd";
        String TNS_NAMESPACE_KEY = "xmlns:tns";
        String XSD_BEGIN = "<schema";
        String XSD_END = "</schema>";
        StringBuffer wsdl = new StringBuffer();
        String xsdPart0 = "<?xml version = '1.0' encoding = 'UTF-8'?>";
        String xsdPart1 = null;
        String xsdPart2 = null;
        String xsd = null;
        int xsdBeginIndex = -1;
        int xsdEndIndex = -1;
        if (wsdlStream != null) {
            String str;
            BufferedReader in = new BufferedReader(new InputStreamReader(wsdlStream, "UTF-8"));
            while ((str = in.readLine()) != null) {
                wsdl.append(str);
            }
            if (wsdl.length() > 0) {
                xsdBeginIndex = wsdl.indexOf("<schema", 0);
                if (xsdBeginIndex > -1) {
                    xsdEndIndex = wsdl.indexOf("</schema>", xsdBeginIndex);
                }
                if (xsdBeginIndex > -1 && xsdEndIndex > -1) {
                    xsdPart2 = wsdl.substring(xsdBeginIndex + 7, xsdEndIndex + 9);
                    ArrayList<String> nsKeyList = new ArrayList<String>();
                    nsKeyList.add("xmlns:xsd");
                    nsKeyList.add("xmlns:tns");
                    List nsList = this.getNamespaces(nsKeyList, wsdl.toString());
                    if (nsList != null && nsList.size() > 0) {
                        xsdPart1 = "<schema ";
                        String namespaces = null;
                        for (int j = 0; j < nsList.size(); ++j) {
                            String nsKey;
                            String ns = (String)nsList.get(j);
                            if (ns == null || ns.trim().equals("") || xsdPart2.indexOf(nsKey = (String)nsKeyList.get(j), 0) != -1) continue;
                            namespaces = namespaces != null ? namespaces + " " + ns : ns;
                        }
                        if (namespaces != null) {
                            xsdPart1 = xsdPart1 + namespaces;
                        }
                    }
                    xsd = xsdPart0 + xsdPart1 + xsdPart2;
                }
            }
        }
        return xsd;
    }

    private List getNamespaces(List nsKeyList, String wsdl) throws Exception {
        ArrayList<String> nsList = new ArrayList<String>();
        if (wsdl != null && wsdl.length() > 0 && nsKeyList != null && nsKeyList.size() > 0) {
            StringReader reader = new StringReader(wsdl);
            DOMParser parser = new DOMParser();
            parser.parse((Reader)reader);
            XMLDocument doc = parser.getDocument();
            Element docElem = doc.getDocumentElement();
            NamedNodeMap nodeMap = docElem.getAttributes();
            if (nodeMap != null) {
                for (int i = 0; i < nsKeyList.size(); ++i) {
                    String nsKey = (String)nsKeyList.get(i);
                    Node nsNode = nodeMap.getNamedItem(nsKey);
                    if (nsNode != null) {
                        String ns = nsKey + "=\"" + nsNode.getNodeValue() + "\"";
                        nsList.add(ns);
                        continue;
                    }
                    nsList.add("");
                }
            }
        }
        return nsList;
    }

    private String selectedKeysToString(List selectedKeys) {
        String selKeysStr = null;
        boolean firstKey = true;
        if (selectedKeys != null && selectedKeys.size() > 0) {
            for (int i = 0; i < selectedKeys.size(); ++i) {
                BAMKey currentKey = (BAMKey)selectedKeys.get(i);
                if (!currentKey.isAvailable()) continue;
                if (firstKey) {
                    selKeysStr = currentKey.getKey();
                    firstKey = false;
                    continue;
                }
                selKeysStr = selKeysStr + KEY_SEPARATOR + currentKey.getKey();
            }
        }
        return selKeysStr;
    }

    @Override
    public void updateControls() {
        if (this.bamDOPanel != null) {
            if (this.bamDOPanel.isUserInputValid()) {
                this.m_page.setCanAdvance(true);
            } else {
                this.m_page.setCanAdvance(false);
            }
        }
    }

    @Override
    public void buildWSDL() throws WSDLException {
        try {
            URL doURL = this.bamUIContext.getDataObjectURL();
            BAMConnection bamConn = this.bamUIContext.getBAMConnection();
            InputStream is = bamConn.getURLFetcher().getURL(doURL);
            this.bamXSDContent = this.getXSDFromWSDL(is);
            is.close();
            this.createXSDFile(this.bamXSDContent);
            is = bamConn.getURLFetcher().getURL(doURL);
            DataObjectKeys doKeys = new DataObjectKeys(is);
            this.rootElement = doKeys.getDataObjectSchemaRootName();
            this.xsdNamespace = doKeys.getDataObjectNamespace();
            is.close();
            this.createCommonOperationObjects(this.bamUIContext.getOperationName().trim());
            Definition def = this.m_wcontext._write_definition;
            Types types = this.m_wcontext.getWriteTypes();
            ImportSchema impschema = (ImportSchema)this.m_wcontext._extReg.createExtension(ImportSchema.PARENT_CLASS, ImportSchema.FIELD_ELEMENT_TYPE);
            impschema.setContext(this.m_wcontext);
            impschema.setNamespace(this.xsdNamespace);
            impschema.setLocation(this.m_wcontext.IMPORT_SCHEMA_RELATIVE_LOC + this.xsdFileName);
            types.addExtensibilityElement((ExtensibilityElement)impschema);
            def.addNamespace(XSD_NAMESPACE_PREFIX, this.xsdNamespace);
            Message msg = def.createMessage();
            msg.setQName(new QName(this.m_wcontext._target_namespace, this.rootElement + this.m_wcontext.Message_suffix));
            msg.setUndefined(false);
            Part part = def.createPart();
            part.setName(this.rootElement);
            part.setElementName(new QName(this.xsdNamespace, this.rootElement));
            msg.addPart(part);
            def.addMessage(msg);
            Input input = def.createInput();
            input.setMessage(msg);
            this.m_wcontext._write_operation_abstract.setInput(input);
            JcaOperation jop = this.m_wcontext._write_jca_operation;
            jop.setAttributeValue("InteractionSpec", "oracle.bam.adapter.adc.ADCInteractionSpec");
            jop.setAttributeValue(WSDL_DATA_OBJECT_NAME, this.bamUIContext.getDataObjectName());
            jop.setAttributeValue(WSDL_OPERATION_TYPE, this.bamUIContext.getOperation());
            if (this.bamUIContext.isBatchingEnabled()) {
                jop.setAttributeValue(WSDL_ENABLE_BATCHING, TRUE);
            } else {
                jop.setAttributeValue(WSDL_ENABLE_BATCHING, FALSE);
            }
            String selKeysStr = this.selectedKeysToString(this.bamUIContext.getSelectedKeys());
            if (selKeysStr != null && !selKeysStr.trim().equals("")) {
                jop.setAttributeValue(WSDL_KEYS, selKeysStr);
            }
        }
        catch (WSDLException wsdlEx) {
            throw wsdlEx;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new WSDLException("OTHER_ERROR", e.getMessage());
        }
    }
}

