/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.b2b;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import oracle.tip.b2b.ws.client.B2BMetadataWSPortClient;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.b2b.DocDefObj;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.b2b.ParentObj;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DataAccess {
    private static final String ROOT_TEXT = "Document Definitions";
    private static final String DOCUMENT_PROTOCOL = "DocumentProtocol";
    private static final String DOCUMENT_VERSION = "DocumentProtocolVersion";
    private static final String DOCUMENT_TYPE = "DocumentType";
    private static final String DOCUMENT_DEFINITION = "DocumentDefinition";
    private static final String NAME = "name";
    private static final String DEFINITION_FILE_NAME = "definitionFileName";
    private static final String DOC_REF = "docRef";
    private static final String DOC_ROUTING_ID = "docRoutingId";
    private ParentObj docDefRoot;
    private boolean routingIdFlag = false;
    private B2BMetadataWSPortClient b2bWSClient;

    public DataAccess(B2BMetadataWSPortClient b2bWSClient) {
        this.b2bWSClient = b2bWSClient;
    }

    public ParentObj getDocumentDefinitions() throws Exception {
        this.docDefRoot = this.getDocDefsFromServer();
        return this.docDefRoot;
    }

    public ParentObj getDocumentDefinitions(String name) throws Exception {
        ParentObj searchResultsRoot = this.search(this.docDefRoot, name);
        return searchResultsRoot;
    }

    private ParentObj search(ParentObj root, String name) {
        List dpList;
        String lowerCaseName = name.toLowerCase();
        ParentObj rootCopy = this.copyDocDefs(root);
        if (rootCopy != null && (dpList = rootCopy.getChildren()) != null && dpList.size() > 0) {
            for (int i = 0; i < dpList.size(); ++i) {
                ParentObj dp = (ParentObj)dpList.get(i);
                List dvList = dp.getChildren();
                if (dvList == null || dvList.size() <= 0) continue;
                for (int j = 0; j < dvList.size(); ++j) {
                    ParentObj dv = (ParentObj)dvList.get(j);
                    List dtList = dv.getChildren();
                    if (dtList == null || dtList.size() <= 0) continue;
                    for (int k = 0; k < dtList.size(); ++k) {
                        ParentObj dt = (ParentObj)dtList.get(k);
                        List ddList = dt.getChildren();
                        if (ddList == null || ddList.size() <= 0) continue;
                        for (int l = ddList.size() - 1; l >= 0; --l) {
                            DocDefObj dd = (DocDefObj)ddList.get(l);
                            if (!dd.getName().toLowerCase().startsWith(lowerCaseName)) {
                                ddList.remove(l);
                                continue;
                            }
                            if (!this.getRoutingIdFlag()) continue;
                            if (dd.getRoutingId() == null || dd.getRoutingId().equals("")) {
                                ddList.remove(l);
                                continue;
                            }
                            dd.setDisplayName(dd.getName() + " [" + dd.getRoutingId() + "]");
                        }
                    }
                }
            }
        }
        this.cleanupDocDefs(rootCopy);
        return rootCopy;
    }

    public ParentObj getDocDefsWithRouting() throws Exception {
        List dpList;
        ParentObj rootCopy = null;
        rootCopy = this.docDefRoot != null ? this.copyDocDefs(this.docDefRoot) : this.getDocDefsFromServer();
        if (rootCopy != null && (dpList = rootCopy.getChildren()) != null && dpList.size() > 0) {
            for (int i = 0; i < dpList.size(); ++i) {
                ParentObj dp = (ParentObj)dpList.get(i);
                List dvList = dp.getChildren();
                if (dvList == null || dvList.size() <= 0) continue;
                for (int j = 0; j < dvList.size(); ++j) {
                    ParentObj dv = (ParentObj)dvList.get(j);
                    List dtList = dv.getChildren();
                    if (dtList == null || dtList.size() <= 0) continue;
                    for (int k = 0; k < dtList.size(); ++k) {
                        ParentObj dt = (ParentObj)dtList.get(k);
                        List ddList = dt.getChildren();
                        if (ddList == null || ddList.size() <= 0) continue;
                        for (int l = ddList.size() - 1; l >= 0; --l) {
                            DocDefObj dd = (DocDefObj)ddList.get(l);
                            if (dd.getRoutingId() == null || dd.getRoutingId().equals("")) {
                                ddList.remove(l);
                                continue;
                            }
                            dd.setDisplayName(dd.getName() + " [" + dd.getRoutingId() + "]");
                        }
                    }
                }
            }
        }
        this.cleanupDocDefs(rootCopy);
        return rootCopy;
    }

    private void cleanupDocDefs(ParentObj root) {
        if (root != null) {
            List dpList = root.getChildren();
            if (dpList != null && dpList.size() > 0) {
                for (int i = dpList.size() - 1; i >= 0; --i) {
                    ParentObj dp = (ParentObj)dpList.get(i);
                    List dvList = dp.getChildren();
                    if (dvList != null && dvList.size() > 0) {
                        for (int k = dvList.size() - 1; k >= 0; --k) {
                            ParentObj dv = (ParentObj)dvList.get(k);
                            List dtList = dv.getChildren();
                            if (dtList != null && dtList.size() > 0) {
                                for (int l = dtList.size() - 1; l >= 0; --l) {
                                    ParentObj dt = (ParentObj)dtList.get(l);
                                    List ddList = dt.getChildren();
                                    if (ddList != null && ddList.size() >= 1) continue;
                                    dtList.remove(l);
                                }
                            }
                            if (dtList != null && dtList.size() >= 1) continue;
                            dvList.remove(k);
                        }
                    }
                    if (dvList != null && dvList.size() >= 1) continue;
                    dpList.remove(i);
                }
            }
            if (dpList == null || dpList.size() < 1) {
                root = null;
            }
        }
    }

    private ParentObj copyDocDefs(ParentObj root) {
        ParentObj copyRoot = null;
        if (root != null) {
            copyRoot = new ParentObj(null, root.getName());
            List dpList = root.getChildren();
            if (dpList != null) {
                for (int i = 0; i < dpList.size(); ++i) {
                    ParentObj dp = (ParentObj)dpList.get(i);
                    ParentObj dpCopy = new ParentObj(copyRoot, dp.getName());
                    copyRoot.addChild(dpCopy);
                    List dvList = dp.getChildren();
                    if (dvList == null) continue;
                    for (int j = 0; j < dvList.size(); ++j) {
                        ParentObj dv = (ParentObj)dvList.get(j);
                        ParentObj dvCopy = new ParentObj(dpCopy, dv.getName());
                        dpCopy.addChild(dvCopy);
                        List dtList = dv.getChildren();
                        if (dtList == null) continue;
                        for (int k = 0; k < dtList.size(); ++k) {
                            ParentObj dt = (ParentObj)dtList.get(k);
                            ParentObj dtCopy = new ParentObj(dvCopy, dt.getName());
                            dvCopy.addChild(dtCopy);
                            List ddList = dt.getChildren();
                            if (ddList == null) continue;
                            for (int l = 0; l < ddList.size(); ++l) {
                                DocDefObj dd = (DocDefObj)ddList.get(l);
                                DocDefObj ddCopy = new DocDefObj(dtCopy, dd.getName(), dd.getDefinitionFilename(), dd.getDocRef(), dd.getRoutingId());
                                dtCopy.addChild(ddCopy);
                            }
                        }
                    }
                }
            }
        }
        return copyRoot;
    }

    private ParentObj getDocDefsFromServer() throws Exception {
        if (this.b2bWSClient == null) {
            throw new Exception("Exception: invalid web service client");
        }
        String docDefXML = this.b2bWSClient.getAllDocuments(null);
        if (docDefXML == null) {
            return null;
        }
        ByteArrayInputStream is = new ByteArrayInputStream(docDefXML.getBytes());
        ParentObj root = null;
        DOMParser parser = new DOMParser();
        parser.parse((InputStream)is);
        XMLDocument doc = parser.getDocument();
        Element docElem = doc.getDocumentElement();
        root = new ParentObj(null, ROOT_TEXT);
        this.getElements(root, docElem, DOCUMENT_PROTOCOL);
        return root;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void getElements(ParentObj currentParent, Node currentNode, String elemType) throws Exception {
        if (currentParent == null || elemType == null || currentNode == null) return;
        String exceptionMsg = "Exception: Necessary Document Definition attributes not defined in XML.";
        NodeList nodeList = currentNode.getChildNodes();
        if (nodeList == null) return;
        if (nodeList.getLength() <= 0) return;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node nameAttr;
            NamedNodeMap nodeMap;
            Node node = nodeList.item(i);
            String nodeName = node.getNodeName();
            if (nodeName == null || !nodeName.equals(elemType) || (nodeMap = node.getAttributes()) == null || (nameAttr = nodeMap.getNamedItem(NAME)) == null) continue;
            boolean isDocDef = false;
            String nextElemType = null;
            if (elemType.equals(DOCUMENT_PROTOCOL)) {
                nextElemType = DOCUMENT_VERSION;
            } else if (elemType.equals(DOCUMENT_VERSION)) {
                nextElemType = DOCUMENT_TYPE;
            } else if (elemType.equals(DOCUMENT_TYPE)) {
                nextElemType = DOCUMENT_DEFINITION;
            } else if (elemType.equals(DOCUMENT_DEFINITION)) {
                Node defFileNameAttr = nodeMap.getNamedItem(DEFINITION_FILE_NAME);
                Node docRefAttr = nodeMap.getNamedItem(DOC_REF);
                Node docRoutingIdAttr = nodeMap.getNamedItem(DOC_ROUTING_ID);
                if (nameAttr == null || defFileNameAttr == null || docRefAttr == null) throw new Exception("Exception: Necessary Document Definition attributes not defined in XML.");
                String defFilename = defFileNameAttr.getNodeValue();
                String docRef = docRefAttr.getNodeValue();
                String name = nameAttr.getNodeValue();
                String routingId = "";
                if (docRoutingIdAttr != null) {
                    routingId = docRoutingIdAttr.getNodeValue();
                }
                if (name == null || name.trim().equals("") || defFilename == null || defFilename.trim().equals("") || docRef == null || docRef.trim().equals("")) throw new Exception("Exception: Necessary Document Definition attributes not defined in XML.");
                DocDefObj docDef = new DocDefObj(currentParent, name, defFilename, docRef, routingId);
                if (this.getRoutingIdFlag() && routingId != "") {
                    docDef.setDisplayName(name + " [" + routingId + "]");
                }
                currentParent.addChild(docDef);
                isDocDef = true;
            }
            if (isDocDef || nextElemType == null) continue;
            ParentObj newParent = new ParentObj(currentParent, nameAttr.getNodeValue());
            currentParent.addChild(newParent);
            this.getElements(newParent, node, nextElemType);
        }
    }

    public void setRoutingIdFlag(boolean routingIdFlag) {
        this.routingIdFlag = routingIdFlag;
    }

    public boolean getRoutingIdFlag() {
        return this.routingIdFlag;
    }
}

