/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.b2b;

import oracle.rc.asadapter.connection.ConnectionDescriptor;
import oracle.rc.asadapter.weblogic.connection.Weblogic10Descriptor;

public class ConnInfo {
    private static final String URL_PATH = "integration/services/b2b/B2BMetadataWSPort";
    private static final String B2B_CONFIG_URL_PATH = "b2b";
    private ConnectionDescriptor connDesc;
    private String httpPort;
    private String soaHostName;
    private boolean isSOASSLPort = false;

    public ConnInfo(ConnectionDescriptor connDesc) throws Exception {
        if (connDesc == null) {
            throw new Exception("Invalid connection descriptor");
        }
        this.connDesc = connDesc;
    }

    public String getConnectionName() {
        return this.connDesc.get("ConnectionName");
    }

    public String getType() {
        return this.connDesc.getAppServerType();
    }

    public String getEndpoint() {
        String endpoint = "";
        try {
            if (this.connDesc != null) {
                String hostname = this.soaHostName;
                String port = this.httpPort;
                endpoint = this.isSOASSLPort ? "https://" + hostname + ":" + port + "/" + URL_PATH : "http://" + hostname + ":" + port + "/" + URL_PATH;
            }
        }
        catch (Exception e) {
            System.out.println("ERROR: Unable to form endpoint.");
            e.printStackTrace();
        }
        return endpoint;
    }

    public String getB2BConfigURL() {
        String url = "";
        try {
            if (this.connDesc != null) {
                String hostname = this.soaHostName;
                String port = this.httpPort;
                url = this.isSOASSLPort ? "https://" + hostname + ":" + port + "/" + B2B_CONFIG_URL_PATH : "http://" + hostname + ":" + port + "/" + B2B_CONFIG_URL_PATH;
            }
        }
        catch (Exception e) {
            System.out.println("ERROR: Unable to form B2B Configuration URL.");
            e.printStackTrace();
        }
        return url;
    }

    public String getUsername() {
        return this.connDesc.getUserName();
    }

    public String getPassword() {
        return this.connDesc.getPassword();
    }

    public String toString() {
        return this.connDesc.get("ConnectionName");
    }

    public String getHttpPort() throws Exception {
        String port = null;
        if (this.connDesc.getAppServerType().equals("WebLogic_10.x")) {
            Weblogic10Descriptor desc = (Weblogic10Descriptor)this.connDesc;
            port = desc.getHTTPPort();
        }
        return port;
    }

    public void setHttpPort(String httpPort) {
        this.httpPort = httpPort;
    }

    public void setSoaHostName(String soaHostName) {
        this.soaHostName = soaHostName;
    }

    public String getSoaHostName() {
        return this.soaHostName;
    }

    public void setSOASSLPort(boolean isSSL) {
        this.isSOASSLPort = isSSL;
    }

    public boolean isSOASSLPort() {
        return this.isSOASSLPort;
    }

    public String getJMXHostName() {
        return this.connDesc.get("JMX_CONNECTOR_HOST");
    }
}

