/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.b2b;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.ewt.wizard.ImageWizardPage;
import oracle.bali.ewt.wizard.WizardEvent;
import oracle.ide.help.HelpSystem;
import oracle.javatools.util.BundleLoader;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.AdapterWizardContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.b2b.B2BAppServerConnPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.b2b.B2BContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.b2b.B2BDocDefPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.b2b.B2BMDSConnPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.b2b.B2BOperationPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.techAdapterWizardPage;

public class B2BTypePage
extends techAdapterWizardPage {
    private JPanel pagePanel;
    private MultiLineLabel introLabel;
    private JRadioButton defaultRadioButton;
    private JRadioButton aqRadioButton;
    private JRadioButton jmsRadioButton;
    private ButtonGroup typeRBGroup;
    private B2BContext ctx;

    public B2BTypePage(AdapterWizardContext wcontext, ImageWizardPage iwp) {
        this.setContextAndPage(wcontext, iwp);
        if (!AdapterWizardContext.IS_STANDALONE_TESTING && !this.m_wcontext.isStandalone()) {
            HelpSystem.getHelpSystem().registerTopic((JComponent)this.m_page.getContent(), "b2bjdev_integ_type");
        }
        this.ctx = (B2BContext)wcontext._ascontext;
        this.init();
    }

    private void init() {
        this.setLayout(new GridBagLayout());
        this.pagePanel = new JPanel();
        this.pagePanel.setLayout(new GridBagLayout());
        String introTxt = this.ctx.getResourceBundle().getString("B2B_TYPE_INTRO");
        String defaultOptionTxt = this.ctx.getResourceBundle().getString("B2B_TYPE_DEF");
        String aqOptionTxt = this.ctx.getResourceBundle().getString("B2B_TYPE_AQ");
        String jmsOptionTxt = this.ctx.getResourceBundle().getString("B2B_TYPE_JMS");
        this.introLabel = new MultiLineLabel(WordWrapper.getTextWrapper(), introTxt);
        this.defaultRadioButton = new JRadioButton(defaultOptionTxt);
        this.defaultRadioButton.setSelected(true);
        this.aqRadioButton = new JRadioButton(aqOptionTxt);
        this.jmsRadioButton = new JRadioButton(jmsOptionTxt);
        this.typeRBGroup = new ButtonGroup();
        this.typeRBGroup.add(this.defaultRadioButton);
        this.typeRBGroup.add(this.aqRadioButton);
        this.typeRBGroup.add(this.jmsRadioButton);
        this.add((Component)this.introLabel, new GridBagConstraints(0, 0, 0, 1, 0.0, 0.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.defaultRadioButton, new GridBagConstraints(0, 1, 0, 1, 0.0, 0.0, 18, 0, new Insets(20, 20, 0, 0), 0, 0));
        this.add((Component)this.aqRadioButton, new GridBagConstraints(0, 2, 0, 1, 1.0, 1.0, 18, 0, new Insets(5, 20, 0, 0), 0, 0));
        this.add((Component)this.jmsRadioButton, new GridBagConstraints(0, 3, 0, 1, 1.0, 35.0, 18, 0, new Insets(0, 20, 0, 0), 0, 0));
        if (this.m_wcontext._read_service != null) {
            this.initFromExistingWSDL();
        }
        this.m_page.setCanAdvance(true);
    }

    protected void initFromExistingWSDL() {
        block6: {
            block7: {
                block10: {
                    String interspec;
                    block9: {
                        block8: {
                            interspec = null;
                            if (this.m_wcontext.isStandalone() || AdapterWizardContext.IS_STANDALONE_TESTING) break block6;
                            if (this.m_wcontext._read_jca_operation == null) break block7;
                            interspec = !this.m_wcontext._isInboundOperation ? this.m_wcontext._read_jca_operation.getAttributeValue("InteractionSpec") : this.m_wcontext._read_jca_operation.getAttributeValue("ActivationSpec");
                            if (interspec.equals("oracle.tip.adapter.aq.outbound.AQEnqueueInteractionSpec")) break block8;
                            if (!interspec.equals("oracle.tip.adapter.aq.inbound.AQDequeueActivationSpec")) break block9;
                        }
                        this.aqRadioButton.setSelected(true);
                    }
                    if (interspec.equals("oracle.tip.adapter.jms.inbound.JmsConsumeActivationSpec")) break block10;
                    if (interspec.equals("oracle.tip.adapter.jms.outbound.JmsProduceInteractionSpec")) break block10;
                    if (interspec.equals("oracle.tip.adapter.jms.inbound.JmsMapMessageConsumeActivationSpec")) break block10;
                    if (!interspec.equals("oracle.tip.adapter.jms.outbound.JmsMapMessageProduceInteractionSpec")) break block7;
                }
                this.jmsRadioButton.setSelected(true);
            }
            this.defaultRadioButton.setEnabled(false);
            this.aqRadioButton.setEnabled(false);
            this.jmsRadioButton.setEnabled(false);
        }
    }

    @Override
    public void wizardValidatePage(WizardEvent wizardEvent) {
        if (!(this.m_wcontext._ascontext instanceof B2BContext)) {
            this.ctx = new B2BContext();
            this.ctx.setResourceBundle(BundleLoader.getBundle((String)"oracle.tip.tools.ide.pm.modules.bizintegration.adapter.b2b.B2BConfigWizardResource"));
            this.m_wcontext._ascontext = this.ctx;
        }
        if (this.defaultRadioButton.isSelected()) {
            this.ctx.setAqType(false);
            this.ctx.setJmsType(false);
            this.removePages();
            this.addCommonB2BPages();
        } else if (this.aqRadioButton.isSelected()) {
            this.ctx.setAqType(true);
            this.ctx.setJmsType(false);
            this.removePages();
            this.addCommonB2BPages();
        } else if (this.jmsRadioButton.isSelected()) {
            this.ctx.setJmsType(true);
            this.ctx.setAqType(false);
            this.removePages();
            this.addCommonB2BPages();
        }
    }

    private void addCommonB2BPages() {
        ImageWizardPage tempwp = null;
        tempwp = new ImageWizardPage(null, this._getImage(), this.ctx.getResourceBundle().getString("ASC_CONN"));
        B2BAppServerConnPage apcPage = new B2BAppServerConnPage(this.m_wcontext, tempwp);
        tempwp = new ImageWizardPage(null, this._getImage(), this.ctx.getResourceBundle().getString("OP_TITLE"));
        B2BOperationPage opPage = new B2BOperationPage(this.m_wcontext, tempwp);
        this.ctx.addPage(opPage);
        tempwp = new ImageWizardPage(null, this._getImage(), this.ctx.getResourceBundle().getString("SCHEMA"));
        B2BMDSConnPage mdsConnPage = new B2BMDSConnPage(this.m_wcontext, tempwp);
        this.ctx.addPage(mdsConnPage);
        tempwp = new ImageWizardPage(null, this._getImage(), this.ctx.getResourceBundle().getString("DDP_TITLE"));
        B2BDocDefPage docDefPage = new B2BDocDefPage(this.m_wcontext, tempwp);
        this.ctx.addPage(docDefPage);
    }
}

