/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.b2b;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.wsdl.Definition;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Part;
import javax.wsdl.PortType;
import javax.xml.namespace.QName;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.ewt.wizard.ImageWizardPage;
import oracle.bali.ewt.wizard.WizardEvent;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.AdapterWizardContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.b2b.B2BContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.techAdapterWizardPage;

public class B2BRootElementPage
extends techAdapterWizardPage {
    private B2BContext ctx;
    private JPanel pagePanel;
    private MultiLineLabel introLabel;
    private JComboBox rootElementComboBox;
    private List availableRootElements;

    public B2BRootElementPage(AdapterWizardContext wcontext, ImageWizardPage iwp, List availableRootElements) {
        this.setContextAndPage(wcontext, iwp);
        this.ctx = (B2BContext)this.m_wcontext._ascontext;
        this.availableRootElements = availableRootElements;
        this.init();
    }

    private void init() {
        String rootElementName;
        this.setLayout(new GridBagLayout());
        this.pagePanel = new JPanel();
        this.pagePanel.setLayout(new GridBagLayout());
        String titleStr = this.ctx.getResourceBundle().getString("RE_TITLE");
        String introTxt = this.ctx.getResourceBundle().getString("RE_INTRO");
        this.m_page.setPageTitle(titleStr);
        this.introLabel = new MultiLineLabel(WordWrapper.getTextWrapper(), introTxt);
        this.rootElementComboBox = new JComboBox();
        if (this.availableRootElements != null && this.availableRootElements.size() > 0) {
            for (int i = 0; i < this.availableRootElements.size(); ++i) {
                String rootElem = (String)this.availableRootElements.get(i);
                this.rootElementComboBox.addItem(rootElem);
            }
        }
        this.add((Component)this.introLabel, new GridBagConstraints(0, 0, 0, 1, 0.0, 0.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.rootElementComboBox, new GridBagConstraints(0, 1, 0, 1, 1.0, 2.0, 18, 0, new Insets(20, 0, 0, 0), 0, 0));
        this.m_page.setCanAdvance(true);
        if (this.m_wcontext._read_operation != null && (rootElementName = this.getRootElementFromWSDL()) != null) {
            this.rootElementComboBox.setSelectedItem(rootElementName);
        }
        if (this.ctx.isFileSystem()) {
            this.rootElementComboBox.setSelectedItem(this.ctx.getBrowseSchemaRootElement());
        }
    }

    private String getRootElementFromWSDL() {
        Input in1;
        QName pqname;
        Definition def = this.m_wcontext._read_definition;
        PortType portt1 = (PortType)def.getPortTypes().values().iterator().next();
        String operationName = this.m_wcontext._read_operation_name;
        Message message = null;
        Part part = null;
        List operations = portt1.getOperations();
        Operation oper1 = null;
        if (operationName != null) {
            for (Operation toper : operations) {
                if (!toper.getName().equals(operationName)) continue;
                oper1 = toper;
                break;
            }
        } else {
            oper1 = (Operation)operations.get(0);
        }
        if ((pqname = (part = (Part)(message = (in1 = oper1.getInput()).getMessage()).getParts().values().iterator().next()).getTypeName()) == null) {
            pqname = part.getElementName();
            return pqname.getLocalPart();
        }
        return null;
    }

    @Override
    public void wizardValidatePage(WizardEvent wizardEvent) {
        this.ctx.setSelectedRootElement((String)this.rootElementComboBox.getSelectedItem());
    }
}

