/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.b2b;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.ewt.wizard.ImageWizardPage;
import oracle.bali.ewt.wizard.WizardEvent;
import oracle.ide.help.HelpSystem;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.AdapterWizardContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.aq.AQAdapterContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.b2b.B2BContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.techAdapterWizardPage;

public class B2BOperationPage
extends techAdapterWizardPage {
    private static final String SEND = "send";
    private static final String RECEIVE = "receive";
    private JPanel pagePanel;
    private MultiLineLabel introLabel;
    private JRadioButton sendRadioButton;
    private JRadioButton receiveRadioButton;
    private ButtonGroup opRBGroup;
    private B2BContext ctx;

    public B2BOperationPage(AdapterWizardContext wcontext, ImageWizardPage iwp) {
        this.setContextAndPage(wcontext, iwp);
        if (!AdapterWizardContext.IS_STANDALONE_TESTING && !this.m_wcontext.isStandalone()) {
            HelpSystem.getHelpSystem().registerTopic((JComponent)this.m_page.getContent(), "b2bjdev_wiz_oper");
        }
        this.ctx = (B2BContext)wcontext._ascontext;
        this.init();
    }

    private void init() {
        this.setLayout(new GridBagLayout());
        this.pagePanel = new JPanel();
        this.pagePanel.setLayout(new GridBagLayout());
        String introTxt = this.ctx.getResourceBundle().getString("OP_INTRO");
        String sendTxt = this.ctx.getResourceBundle().getString("OP_SEND");
        String receiveTxt = this.ctx.getResourceBundle().getString("OP_RECEIVE");
        this.introLabel = new MultiLineLabel(WordWrapper.getTextWrapper(), introTxt);
        this.sendRadioButton = new JRadioButton(sendTxt);
        this.sendRadioButton.setSelected(true);
        this.receiveRadioButton = new JRadioButton(receiveTxt);
        this.opRBGroup = new ButtonGroup();
        this.opRBGroup.add(this.sendRadioButton);
        this.opRBGroup.add(this.receiveRadioButton);
        this.add((Component)this.introLabel, new GridBagConstraints(0, 0, 0, 1, 0.0, 0.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.sendRadioButton, new GridBagConstraints(0, 1, 0, 1, 0.0, 0.0, 18, 0, new Insets(20, 20, 0, 0), 0, 0));
        this.add((Component)this.receiveRadioButton, new GridBagConstraints(0, 2, 0, 1, 1.0, 1.0, 18, 0, new Insets(0, 20, 0, 0), 0, 0));
        if (this.m_wcontext._read_service != null) {
            this.initFromExistingWSDL();
        }
        this.m_page.setCanAdvance(true);
    }

    protected void initFromExistingWSDL() {
        if (this.m_wcontext._read_operation != null && !this.m_wcontext.isStandalone() && !AdapterWizardContext.IS_STANDALONE_TESTING) {
            String opName = this.m_wcontext._read_operation_name;
            if (this.m_wcontext._read_jca_operation == null) {
                if (opName.equals(SEND)) {
                    this.sendRadioButton.setSelected(true);
                } else {
                    this.receiveRadioButton.setSelected(true);
                }
            } else if (this.m_wcontext._isInboundOperation) {
                this.receiveRadioButton.setSelected(true);
            } else {
                this.sendRadioButton.setSelected(true);
            }
            this.sendRadioButton.setEnabled(false);
            this.receiveRadioButton.setEnabled(false);
        }
    }

    @Override
    public void wizardValidatePage(WizardEvent wizardEvent) {
        if (this.sendRadioButton.isSelected()) {
            this.ctx.setIsInbound(false);
            this.ctx.setOperation(SEND);
            this.m_wcontext._isInboundOperation = false;
            if (this.ctx.isAqType()) {
                AQAdapterContext.direction = "Inbound";
            }
        } else {
            this.ctx.setIsInbound(true);
            this.ctx.setOperation(RECEIVE);
            this.m_wcontext._isInboundOperation = true;
            if (this.ctx.isAqType()) {
                AQAdapterContext.direction = "Outbound";
            }
        }
    }
}

