/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.b2b;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.wsdl.WSDLException;
import oracle.adf.rc.core.RCInstance;
import oracle.adf.share.jndi.AdfJndiContext;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.ewt.wizard.ImageWizardPage;
import oracle.bali.ewt.wizard.WizardEvent;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Context;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Project;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.jdeveloper.rescat2.RescatContextRegistry;
import oracle.jdeveloper.rescat2.nodes.RescatContext;
import oracle.tip.tools.ide.common.datasources.CompoundDataSource;
import oracle.tip.tools.ide.common.datasources.schema.ProjectSchemaDataSource;
import oracle.tip.tools.ide.common.resourcepalette.adapter.mds.MDSHelper;
import oracle.tip.tools.ide.common.resourcepalette.adapter.mds.wizard.MDSProviderWizard;
import oracle.tip.tools.ide.common.typeexplorer.SchemaImportHandler;
import oracle.tip.tools.ide.common.typeexplorer.TypeChooser;
import oracle.tip.tools.ide.common.typeexplorer.TypeObject;
import oracle.tip.tools.ide.common.ui.GlobalImageCache;
import oracle.tip.tools.ide.common.ui.UIHelper;
import oracle.tip.tools.ide.common.ui.tabpane.DefaultTab;
import oracle.tip.tools.ide.common.ui.treeexplorer.TreeExplorerDataSource;
import oracle.tip.tools.ide.common.utils.MultiLineOptionPane;
import oracle.tip.tools.ide.common.utils.URLUtil;
import oracle.tip.tools.ide.fabric.addin.SCAProject;
import oracle.tip.tools.ide.pm.ide.bpel.jdeveloper.JDevBPELProject;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.AdapterWizardContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.AdapterWizardSchemaImportHandler;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.ConnectionPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.aq.AQAdapterContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.b2b.B2BContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.b2b.B2BDocDefPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.file.FileAdapterFinish;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.jms.JMSContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.jms.JmsAdapterFinish;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.jms.JmsAdapterProviderPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.techAdapterWizardPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.wsdl.JcaOperation;

public class B2BMDSConnPage
extends techAdapterWizardPage
implements ActionListener {
    public static final String B2B_NAMESPACE_NAME = "/soa/b2b";
    private static EmptyBorder s_emptyBorder = new EmptyBorder(2, 2, 2, 2);
    private static EtchedBorder s_etchedBorder = new EtchedBorder();
    private B2BContext ctx;
    private JPanel pagePanel;
    private JPanel advPagePanel;
    private JPanel basePagePanel;
    private MultiLineLabel introLabel;
    private MultiLineLabel repDescLabel;
    private MultiLineLabel mdsDescLabel;
    private MultiLineLabel opqDescLabel;
    private MultiLineLabel anyDescLabel;
    private ButtonGroup optGroup;
    private ButtonGroup docDefGroup;
    private JRadioButton docSchemaRB;
    private JRadioButton repRB;
    private JLabel repLabel;
    private JRadioButton mdsRB;
    private JRadioButton opaqueRB;
    private JRadioButton anyRB;
    private JComboBox mdsConnCB;
    private JButton newButton;
    private JPanel mdsPanel;
    private JTabbedPane tabPane;
    private JPanel spacerPanel = new JPanel();
    private DefaultTab basicTab;
    private DefaultTab advancedTab;
    private JCheckBox attachCB;
    private JRadioButton browseRB;
    private JLabel schemaLB = new JLabel();
    private JTextField schemaLoc = new JTextField();
    private JButton browseSchemaButton;
    private int currentTabId;
    private static final int BASIC = 0;
    private static final int ADVANCED = 1;

    public B2BMDSConnPage(AdapterWizardContext wcontext, ImageWizardPage iwp) {
        this.setContextAndPage(wcontext, iwp);
        this.ctx = (B2BContext)wcontext._ascontext;
        String schemaTxt = this.ctx.getResourceBundle().getString("SCHEMA");
        this.tabPane = new JTabbedPane();
        this.initBasicTab();
        this.initAdvancedTab();
        this.setLayout(new GridBagLayout());
        this.add((Component)this.tabPane, new GridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.tabPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (e.getSource() instanceof JTabbedPane) {
                    int tabindex = ((JTabbedPane)e.getSource()).getSelectedIndex();
                    B2BMDSConnPage.this.setHelpTopic(tabindex);
                    if (tabindex == 0) {
                        B2BMDSConnPage.this.m_page.setCanAdvance(true);
                    }
                }
            }
        });
        if (this.m_wcontext._read_service != null) {
            this.initFromExistingWSDL();
        } else {
            this.tabPane.setSelectedIndex(0);
            this.setHelpTopic(0);
        }
    }

    private void setHelpTopic(int tabid) {
        if (tabid == 0) {
            HelpSystem.getHelpSystem().registerTopic((JComponent)this.m_page.getContent(), "b2bjdev_wiz_doc_def");
        } else {
            HelpSystem.getHelpSystem().registerTopic((JComponent)this.m_page.getContent(), "b2bjdev_wiz_doc_def_adv");
        }
    }

    protected void initFromExistingWSDL() {
        if (this.m_wcontext._read_b2b_uiext != null && !this.m_wcontext.isStandalone() && !AdapterWizardContext.IS_STANDALONE_TESTING) {
            String docRefType = this.m_wcontext._read_b2b_uiext.getAttributeValue("UIDocRefType");
            String attachSupportValue = this.m_wcontext._read_b2b_uiext.getAttributeValue("UIAttachment");
            if (docRefType != null || attachSupportValue != null && attachSupportValue.equals("true")) {
                this.tabPane.setSelectedIndex(1);
                this.setHelpTopic(1);
                if (docRefType != null) {
                    if (docRefType.equals("MDS")) {
                        String mdsConnName = this.m_wcontext._read_b2b_uiext.getAttributeValue("UIMDSConnectionName");
                        this.mdsRB.setSelected(true);
                        this.updateControls();
                        if (this.validateMDSConnName(mdsConnName)) {
                            this.mdsConnCB.setSelectedItem(mdsConnName);
                        }
                    } else if (docRefType.equals("FileSystem")) {
                        String schemaLocation = this.m_wcontext._read_b2b_uiext.getAttributeValue("UISchemaFile");
                        String schemaElement = this.m_wcontext._read_b2b_uiext.getAttributeValue("UISchemaRootElement");
                        this.browseRB.setSelected(true);
                        this.updateControls();
                        if (schemaLocation != null) {
                            this.schemaLoc.setText(schemaLocation);
                        }
                        if (schemaElement != null) {
                            this.ctx.setBrowseSchemaRootElement(schemaElement);
                        }
                    } else if (docRefType.equals("Opaque")) {
                        this.opaqueRB.setSelected(true);
                        this.disableDocSchemaControls();
                    } else if (docRefType.equals("anyType")) {
                        this.anyRB.setSelected(true);
                        this.disableDocSchemaControls();
                    }
                }
                if (!this.ctx.isAqType() && !this.ctx.isJmsType() && attachSupportValue.equals("true")) {
                    this.attachCB.setSelected(true);
                }
            } else {
                this.tabPane.setSelectedIndex(0);
                this.setHelpTopic(0);
            }
        }
    }

    private boolean validateMDSConnName(String connName) {
        List mdsConnList = this.getMDSConnComboBoxItems();
        if (!mdsConnList.contains(connName)) {
            String errTitle = this.ctx.getResourceBundle().getString("ERROR_TITLE");
            MessageFormat errmsgformat = new MessageFormat(this.ctx.getResourceBundle().getString("MDS_CONN_LIST_ERROR"));
            Object[] obj = new Object[]{connName};
            MultiLineOptionPane.showMessageDialog((Component)this.ctx.getParentFrame(), (Object)errmsgformat.format(obj), (String)errTitle, (int)2);
            return false;
        }
        return true;
    }

    private void initBasicTab() {
        String introTxt = this.ctx.getResourceBundle().getString("SCHEMA_PAGE_INTRO");
        String repDescTxt = this.ctx.getResourceBundle().getString("REP_DESC");
        String repOptionTxt = this.ctx.getResourceBundle().getString("REPOSITORY_OPTION");
        String basictabText = this.ctx.getResourceBundle().getString("BASIC_MODE");
        this.basePagePanel = new JPanel();
        this.basePagePanel.setLayout(new GridBagLayout());
        this.basicTab = new DefaultTab((JComponent)this.basePagePanel);
        this.basicTab.setText(basictabText);
        this.tabPane.addTab(basictabText, this.basePagePanel);
        this.introLabel = new MultiLineLabel(WordWrapper.getTextWrapper(), introTxt);
        this.repDescLabel = new MultiLineLabel(WordWrapper.getTextWrapper(), repDescTxt);
        this.repLabel = new JLabel(repOptionTxt);
        this.basePagePanel.add((Component)this.introLabel, new GridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 18, 1, new Insets(10, 10, 0, 0), 0, 0));
        this.basePagePanel.add((Component)this.repLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 1.0, 18, 0, new Insets(10, 45, 0, 0), 0, 0));
        this.basePagePanel.add((Component)this.repDescLabel, new GridBagConstraints(0, 2, 1, 1, 1.0, 8.0, 18, 2, new Insets(5, 45, 0, 0), 0, 100));
    }

    private void initAdvancedTab() {
        String introTxt = this.ctx.getResourceBundle().getString("SCHEMA_PAGE_INTRO");
        String repDescTxt = this.ctx.getResourceBundle().getString("REP_DESC");
        String repOptionTxt = this.ctx.getResourceBundle().getString("REPOSITORY_OPTION");
        String repOptionTip = this.ctx.getResourceBundle().getString("REPOSITORY_OPTION_TIP");
        String mdsDescTxt = this.ctx.getResourceBundle().getString("MDS_DESC");
        String mdsOptionTxt = this.ctx.getResourceBundle().getString("MDS_OPTION");
        String mdsOptionTip = this.ctx.getResourceBundle().getString("MDS_OPTION_TIP");
        String newTxt = this.ctx.getResourceBundle().getString("NEW");
        String docDefSchemaTxt = this.ctx.getResourceBundle().getString("DOCDEF_SCHEMA_TEXT");
        String opaqueOptionTip = this.ctx.getResourceBundle().getString("OPQ_OPTION_TIP");
        String opaqueDescTxt = this.ctx.getResourceBundle().getString("OPAQUE_DESC");
        String opaqueRBText = this.ctx.getResourceBundle().getString("OPAQUE_OPTION");
        String anyOptionTip = this.ctx.getResourceBundle().getString("ANY_OPTION_TIP");
        String anyDescTxt = this.ctx.getResourceBundle().getString("ANYTYPE_DESC");
        String anyRBText = this.ctx.getResourceBundle().getString("ANYTYPE_OPTION");
        String advModeText = this.ctx.getResourceBundle().getString("ADVANCED_MODE");
        String attachCBText = this.ctx.getResourceBundle().getString("ATTACH_SUPPORT");
        String browseOptionTxt = this.ctx.getResourceBundle().getString("BROWSE_OPTION");
        String browseOptionTip = this.ctx.getResourceBundle().getString("BROWSE_OPTION_TIP");
        String browseSchemaButtonText = this.ctx.getResourceBundle().getString("BROWSE_BTN_TEXT");
        String browseSchemaButtonTip = this.ctx.getResourceBundle().getString("BROWSE_BTN_TEXT");
        String schemaLocText = this.ctx.getResourceBundle().getString("SCHEMA_LABEL");
        String schematip = this.ctx.getResourceBundle().getString("SCHEMA_TOOLTIP");
        this.advPagePanel = new JPanel();
        this.advPagePanel.setLayout(new GridBagLayout());
        this.advancedTab = new DefaultTab((JComponent)this.advPagePanel);
        this.advancedTab.setText(advModeText);
        this.tabPane.addTab(advModeText, this.advPagePanel);
        this.introLabel = new MultiLineLabel(WordWrapper.getTextWrapper(), introTxt);
        this.repDescLabel = new MultiLineLabel(WordWrapper.getTextWrapper(), repDescTxt);
        this.mdsDescLabel = new MultiLineLabel(WordWrapper.getTextWrapper(), mdsDescTxt);
        this.opqDescLabel = new MultiLineLabel(WordWrapper.getTextWrapper(), opaqueDescTxt);
        this.anyDescLabel = new MultiLineLabel(WordWrapper.getTextWrapper(), anyDescTxt);
        this.docSchemaRB = new JRadioButton(docDefSchemaTxt);
        this.repRB = new JRadioButton(repOptionTxt);
        this.mdsRB = new JRadioButton(mdsOptionTxt);
        this.browseRB = new JRadioButton(browseOptionTxt);
        this.opaqueRB = new JRadioButton(opaqueRBText);
        this.anyRB = new JRadioButton(anyRBText);
        this.repRB.setToolTipText(repOptionTip);
        this.mdsRB.setToolTipText(mdsOptionTip);
        this.opaqueRB.setToolTipText(opaqueOptionTip);
        this.anyRB.setToolTipText(anyOptionTip);
        this.browseRB.setToolTipText(browseOptionTip);
        this.docSchemaRB.setSelected(true);
        this.repRB.setSelected(true);
        this.repRB.addActionListener(this);
        this.mdsRB.addActionListener(this);
        this.opaqueRB.addActionListener(this);
        this.anyRB.addActionListener(this);
        this.docSchemaRB.addActionListener(this);
        this.browseRB.addActionListener(this);
        this.optGroup = new ButtonGroup();
        this.optGroup.add(this.docSchemaRB);
        this.optGroup.add(this.opaqueRB);
        this.optGroup.add(this.anyRB);
        this.docDefGroup = new ButtonGroup();
        this.docDefGroup.add(this.repRB);
        this.docDefGroup.add(this.mdsRB);
        this.docDefGroup.add(this.browseRB);
        this.mdsConnCB = new JComboBox();
        this.newButton = new JButton(newTxt);
        this.newButton.addActionListener(this);
        this.attachCB = new JCheckBox(attachCBText);
        this.schemaLB.setText(StringUtils.stripMnemonic((String)schemaLocText));
        this.schemaLB.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)schemaLocText));
        this.schemaLB.setLabelFor(this.schemaLoc);
        this.schemaLoc.setToolTipText(schematip);
        this.schemaLoc.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)schemaLocText));
        this.schemaLoc.getAccessibleContext().setAccessibleDescription(schematip);
        this.schemaLoc.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                if (!B2BMDSConnPage.this.schemaLoc.getText().equals("")) {
                    B2BMDSConnPage.this.m_page.setCanAdvance(true);
                } else {
                    B2BMDSConnPage.this.m_page.setCanAdvance(false);
                }
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                if (!B2BMDSConnPage.this.schemaLoc.getText().equals("")) {
                    B2BMDSConnPage.this.m_page.setCanAdvance(true);
                } else {
                    B2BMDSConnPage.this.m_page.setCanAdvance(false);
                }
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                if (!B2BMDSConnPage.this.schemaLoc.getText().equals("")) {
                    B2BMDSConnPage.this.m_page.setCanAdvance(true);
                } else {
                    B2BMDSConnPage.this.m_page.setCanAdvance(false);
                }
            }
        });
        this.browseSchemaButton = new JButton(GlobalImageCache.getIcon((String)"browse16"));
        this.browseSchemaButton.setToolTipText(browseSchemaButtonText);
        this.browseSchemaButton.setBorder(s_emptyBorder);
        this.browseSchemaButton.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                JButton button;
                Object object = e.getSource();
                if (object instanceof JButton && (button = (JButton)object).isEnabled()) {
                    button.setBorder(s_etchedBorder);
                    button.setCursor(Cursor.getPredefinedCursor(12));
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                Object object = e.getSource();
                if (object instanceof JButton) {
                    JButton button = (JButton)object;
                    button.setBorder(s_emptyBorder);
                    button.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        });
        this.browseSchemaButton.setRequestFocusEnabled(false);
        this.browseSchemaButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)browseSchemaButtonText));
        this.browseSchemaButton.setToolTipText(browseSchemaButtonTip);
        this.browseSchemaButton.getAccessibleContext().setAccessibleDescription(browseSchemaButtonTip);
        this.browseSchemaButton.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)browseSchemaButtonText));
        this.browseSchemaButton.addActionListener(this);
        this.initMDSConnComboBox();
        this.updateControls();
        this.advPagePanel.add((Component)this.introLabel, new GridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 18, 1, new Insets(10, 10, 0, 0), 0, 0));
        this.advPagePanel.add((Component)this.docSchemaRB, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 25, 0, 0), 0, 0));
        this.advPagePanel.add((Component)this.repRB, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 50, 0, 0), 0, 0));
        this.advPagePanel.add((Component)this.repDescLabel, new GridBagConstraints(0, 3, 3, 1, 0.0, 0.0, 18, 2, new Insets(3, 60, 0, 0), 40, 0));
        this.advPagePanel.add((Component)this.mdsRB, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 50, 0, 0), 0, 0));
        this.advPagePanel.add((Component)this.mdsConnCB, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 18, 2, new Insets(10, 10, 0, 0), 0, 0));
        this.advPagePanel.add((Component)this.newButton, new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 5, 0, 0), 0, 0));
        this.advPagePanel.add((Component)this.mdsDescLabel, new GridBagConstraints(0, 5, 4, 1, 0.0, 0.0, 18, 2, new Insets(3, 65, 0, 0), 0, 0));
        this.advPagePanel.add((Component)this.browseRB, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 50, 0, 0), 0, 0));
        this.advPagePanel.add((Component)this.schemaLoc, new GridBagConstraints(1, 6, 1, 1, 1.0, 0.0, 18, 2, new Insets(10, 10, 0, 0), 0, 0));
        this.advPagePanel.add((Component)this.browseSchemaButton, new GridBagConstraints(2, 6, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 5, 0, 0), 0, 0));
        this.advPagePanel.add((Component)this.opaqueRB, new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 25, 0, 0), 0, 0));
        this.advPagePanel.add((Component)this.opqDescLabel, new GridBagConstraints(0, 8, 3, 1, 0.0, 0.0, 18, 0, new Insets(3, 60, 0, 0), 40, 0));
        if (!this.ctx.isJmsType()) {
            this.advPagePanel.add((Component)this.anyRB, new GridBagConstraints(0, 9, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 25, 0, 0), 0, 0));
            this.advPagePanel.add((Component)this.anyDescLabel, new GridBagConstraints(0, 10, 3, 1, 0.0, 0.0, 18, 2, new Insets(3, 60, 0, 0), 40, 0));
        }
        this.advPagePanel.add((Component)this.attachCB, new GridBagConstraints(0, 11, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 10, 0, 0), 0, 0));
        if (!this.ctx.isJmsType()) {
            this.advPagePanel.add((Component)this.spacerPanel, new GridBagConstraints(0, 12, 1, 1, 0.0, 1.0, 18, 0, new Insets(0, 0, 0, 0), 0, 40));
        } else {
            this.advPagePanel.add((Component)this.spacerPanel, new GridBagConstraints(0, 12, 1, 1, 0.0, 1.0, 18, 0, new Insets(0, 0, 0, 0), 0, 75));
        }
    }

    private void initMDSConnComboBox() {
        try {
            List connNames = MDSHelper.getResourcePaletteMDSConnections();
            if (connNames == null) {
                return;
            }
            this.mdsConnCB.removeAllItems();
            for (String connName : connNames) {
                this.mdsConnCB.addItem(connName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            String errTitle = this.ctx.getResourceBundle().getString("ERROR_TITLE");
            String errMsg = this.ctx.getResourceBundle().getString("MDS_CONN_LIST_ERROR");
            MultiLineOptionPane.showMessageDialog((Component)this.ctx.getParentFrame(), (Object)errMsg, (String)errTitle, (int)0);
        }
    }

    private void reloadMDSConnections() {
        List origConnList = this.getMDSConnComboBoxItems();
        this.initMDSConnComboBox();
        List newConnList = this.getMDSConnComboBoxItems();
        if (origConnList == null || newConnList == null) {
            return;
        }
        for (String newConn : newConnList) {
            if (this.connNameInList(newConn, origConnList)) continue;
            this.mdsConnCB.setSelectedItem(newConn);
        }
    }

    private boolean connNameInList(String connName, List connList) {
        if (connList == null || connName == null) {
            return false;
        }
        for (String currConn : connList) {
            if (!currConn.equals(connName)) continue;
            return true;
        }
        return false;
    }

    private List getMDSConnComboBoxItems() {
        int totalItems = this.mdsConnCB.getItemCount();
        ArrayList<String> connList = new ArrayList<String>();
        for (int i = 0; i < totalItems; ++i) {
            String currentConn = (String)this.mdsConnCB.getItemAt(i);
            connList.add(currentConn);
        }
        return connList;
    }

    @Override
    public void wizardValidatePage(WizardEvent wizardEvent) {
        this.ctx.removeOpAttribute("UIDocRefType");
        this.ctx.removeOpAttribute("UIMDSConnectionName");
        this.ctx.removeOpAttribute("UISchemaFile");
        this.ctx.removeOpAttribute("UISchemaRootElement");
        if (this.tabPane.getSelectedIndex() == 1) {
            if (this.docSchemaRB.isSelected()) {
                this.ctx.setAny(false);
                this.ctx.setOpaque(false);
                this.removePages();
                this.revertB2BPages();
                this.addFinishPage();
                this.setFinishPage();
                if (this.repRB.isSelected()) {
                    this.ctx.setMDSConnectionName(null);
                    this.ctx.setFileSystem(false);
                } else if (this.mdsRB.isSelected()) {
                    this.ctx.setMDSConnectionName((String)this.mdsConnCB.getSelectedItem());
                    this.ctx.setOpAttribute("UIDocRefType", "MDS");
                    this.ctx.setOpAttribute("UIMDSConnectionName", this.ctx.getMDSConnectionName());
                    this.ctx.setFileSystem(false);
                } else if (this.browseRB.isSelected()) {
                    this.ctx.setFileSystem(true);
                    this.ctx.setMDSConnectionName(null);
                    this.ctx.setRelativeBrowseSchemaPath(this.schemaLoc.getText());
                    this.ctx.setOpAttribute("UIDocRefType", "FileSystem");
                    this.ctx.setOpAttribute("UISchemaFile", this.schemaLoc.getText());
                    this.ctx.setOpAttribute("UISchemaRootElement", this.ctx.getBrowseSchemaRootElement());
                }
            } else {
                this.ctx.setMDSConnectionName(null);
                if (this.opaqueRB.isSelected()) {
                    this.ctx.setOpaque(true);
                    this.ctx.setAny(false);
                    this.ctx.setOpAttribute("UIDocRefType", "Opaque");
                }
                if (this.anyRB.isSelected()) {
                    this.ctx.setAny(true);
                    this.ctx.setOpaque(false);
                    this.ctx.setOpAttribute("UIDocRefType", "anyType");
                }
                if (this.ctx.isAqType()) {
                    this.removePages();
                    this.addAnyTypeOpaquePagesForAQ();
                }
                if (this.ctx.isJmsType()) {
                    this.removePages();
                    this.addAnyTypeOpaquePagesForJMS();
                }
                this.addFinishPage();
                this.setFinishPage();
            }
            if (!this.ctx.isAqType() && !this.ctx.isJmsType()) {
                this.ctx.setAttachment(this.attachCB.isSelected());
                if (this.attachCB.isSelected()) {
                    this.ctx.setOpAttribute("UIAttachment", "true");
                } else {
                    this.ctx.setOpAttribute("UIAttachment", "false");
                }
            }
        } else if (this.tabPane.getSelectedIndex() == 0) {
            this.ctx.setAny(false);
            this.ctx.setOpaque(false);
            this.ctx.setFileSystem(false);
            this.removePages();
            this.revertB2BPages();
            this.addFinishPage();
            this.setFinishPage();
            if (this.repRB.isSelected()) {
                this.ctx.setMDSConnectionName(null);
            }
        }
        ArrayList pages = (ArrayList)this.ctx.getPages();
        for (JPanel page : pages) {
            if (!(page instanceof B2BDocDefPage)) continue;
            ((B2BDocDefPage)page).updatePage(this.ctx);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.docSchemaRB) {
            this.repRB.setSelected(true);
            this.repRB.setEnabled(true);
            this.mdsRB.setEnabled(true);
            this.browseRB.setEnabled(true);
            this.updateControls();
        } else if (e.getSource() == this.repRB || e.getSource() == this.mdsRB || e.getSource() == this.browseRB) {
            this.updateControls();
        }
        if (e.getSource() == this.opaqueRB || e.getSource() == this.anyRB) {
            this.disableDocSchemaControls();
            if (this.opaqueRB.isSelected() || this.anyRB.isSelected()) {
                this.m_page.setCanAdvance(true);
            }
        }
        if (e.getSource() == this.newButton) {
            MDSProviderWizard mdsWiz = new MDSProviderWizard();
            RescatContextRegistry registry = RescatContextRegistry.getInstance();
            RescatContext rescatCtx = registry.getResourcePaletteContext();
            if (rescatCtx == null) {
                RuntimeException re = new RuntimeException("No RescatContext registered for IDE context");
                throw re;
            }
            RCInstance rcInstance = rescatCtx.getRcInstance();
            try {
                AdfJndiContext connCtx = rcInstance.getConnectionContext();
                mdsWiz.invokeCreate(Context.newIdeContext(), (javax.naming.Context)connCtx);
            }
            catch (Exception e1) {
                // empty catch block
            }
            this.reloadMDSConnections();
            this.updateControls();
        }
        if (e.getSource() == this.browseSchemaButton) {
            this.handleBrowseSchema();
        }
    }

    private void updateControls() {
        if (this.repRB.isSelected()) {
            this.mdsConnCB.setEnabled(false);
            this.schemaLoc.setEnabled(false);
            this.browseSchemaButton.setEnabled(false);
            this.newButton.setEnabled(false);
            this.m_page.setCanAdvance(true);
        } else if (this.mdsRB.isSelected()) {
            this.mdsConnCB.setEnabled(true);
            this.newButton.setEnabled(true);
            this.schemaLoc.setEnabled(false);
            this.browseSchemaButton.setEnabled(false);
            if (this.mdsConnCB.getItemCount() > 0) {
                this.m_page.setCanAdvance(true);
            } else {
                this.m_page.setCanAdvance(false);
            }
        } else if (this.browseRB.isSelected()) {
            this.schemaLoc.setEnabled(true);
            this.schemaLoc.setEnabled(true);
            this.browseSchemaButton.setEnabled(true);
            if (!this.schemaLoc.getText().equals("")) {
                this.m_page.setCanAdvance(true);
            } else {
                this.m_page.setCanAdvance(false);
            }
        }
        if (this.ctx.isAqType() || this.ctx.isJmsType()) {
            this.attachCB.setVisible(false);
        }
    }

    private void disableDocSchemaControls() {
        this.repRB.setEnabled(false);
        this.mdsRB.setEnabled(false);
        this.browseRB.setEnabled(false);
        this.repRB.setSelected(false);
        this.mdsRB.setSelected(false);
        this.browseRB.setSelected(false);
        this.mdsConnCB.setEnabled(false);
        this.newButton.setEnabled(false);
        this.schemaLoc.setEnabled(false);
        this.browseSchemaButton.setEnabled(false);
    }

    private void addAnyTypeOpaquePagesForAQ() {
        ImageWizardPage tempwp = null;
        this.m_wcontext._target_namespace_prefix = "http://xmlns.oracle.com/pcbpel/adapter/aq/";
        String encodedname = null;
        try {
            encodedname = URLEncoder.encode(this.getCleanName(this.m_wcontext._write_service_name), "UTF-8").replaceAll("%", "-");
        }
        catch (UnsupportedEncodingException eexcep) {
            eexcep.printStackTrace();
        }
        this.m_wcontext._target_namespace = this.m_wcontext._target_namespace_prefix + encodedname + "/";
        AQAdapterContext aqContext = new AQAdapterContext();
        this.m_wcontext._ascontext = aqContext;
        this.m_wcontext._service_type = "AQ";
        aqContext.b2bContext = this.ctx;
        this.m_wcontext._adapterWizardFinish = new FileAdapterFinish();
        tempwp = new ImageWizardPage(null, this._getImage(), this.getTranslatedString("CM_CN_PAGE_TITLE"));
        if (!AdapterWizardContext.IS_STANDALONE_TESTING && !this.m_wcontext.isStandalone()) {
            HelpSystem.getHelpSystem().registerTopic((JComponent)tempwp.getContent(), "bpmjdev_adp_wiz_servconn");
        }
        ConnectionPage connPage = new ConnectionPage(this.m_wcontext, tempwp);
    }

    private void revertB2BPages() {
        ImageWizardPage tempwp = null;
        this.m_wcontext._ascontext = this.ctx;
        this.m_wcontext._service_type = "B2B";
        this.m_wcontext._adapterWizardFinish = null;
        ArrayList pages = (ArrayList)this.ctx.getPages();
        for (Object o : pages) {
            JPanel page = (JPanel)o;
            if (!(page instanceof B2BDocDefPage)) continue;
            this.ctx.removePage(o);
            break;
        }
        tempwp = new ImageWizardPage(null, this._getImage(), this.ctx.getResourceBundle().getString("DDP_TITLE"));
        B2BDocDefPage docDefPage = new B2BDocDefPage(this.m_wcontext, tempwp);
        this.ctx.addPage(docDefPage);
    }

    private void addAnyTypeOpaquePagesForJMS() {
        ImageWizardPage tempwp = null;
        this.m_wcontext._target_namespace_prefix = "http://xmlns.oracle.com/pcbpel/adapter/jms/";
        String encodedname = null;
        try {
            encodedname = URLEncoder.encode(this.getCleanName(this.m_wcontext._write_service_name), "UTF-8").replaceAll("%", "-");
        }
        catch (UnsupportedEncodingException eexcep) {
            eexcep.printStackTrace();
        }
        this.m_wcontext._target_namespace = this.m_wcontext._target_namespace_prefix + encodedname + "/";
        JMSContext jmsContext = new JMSContext();
        this.m_wcontext._ascontext = jmsContext;
        this.m_wcontext._service_type = "Jms";
        jmsContext.b2bContext = this.ctx;
        this.m_wcontext._adapterWizardFinish = new JmsAdapterFinish();
        tempwp = new ImageWizardPage(null, this._getImage(), this.getTranslatedString("JMS_PR_PAGE_TITLE"));
        JmsAdapterProviderPage dsp = new JmsAdapterProviderPage(this.m_wcontext, tempwp);
    }

    private String getCleanName(String displayName) {
        return displayName.replaceAll("[\\x2e\\s\\n\\r!\"#$%&'()*+,-./:;<=>?@[\\\\]^_`{|}~]", "_");
    }

    private void setFinishPage() {
        String finish_info = null;
        String finish_prompt = null;
        MessageFormat msgformat = null;
        Object[] obj = null;
        if (this.m_wcontext._read_service != null) {
            msgformat = new MessageFormat(this.ctx.getResourceBundle().getString("FP_FN_UPD_PROMPT"));
            obj = new Object[]{this.m_wcontext._read_service_name};
            finish_prompt = msgformat.format(obj);
            msgformat = new MessageFormat(this.ctx.getResourceBundle().getString("FP_FN_SUMMARY"));
            obj = new Object[]{this.m_wcontext._write_wsdl_name};
            finish_info = msgformat.format(obj);
        } else {
            msgformat = new MessageFormat(this.ctx.getResourceBundle().getString("FP_FN_PROMPT"));
            obj = new Object[]{this.m_wcontext._write_service_name};
            finish_prompt = msgformat.format(obj);
            msgformat = new MessageFormat(this.ctx.getResourceBundle().getString("FP_FN_SUMMARY"));
            obj = new Object[]{this.m_wcontext._write_wsdl_name};
            finish_info = msgformat.format(obj);
        }
        this.setFinishPageContents(finish_prompt, finish_info);
    }

    @Override
    public void buildWSDL() throws WSDLException, Exception {
        String operationName = null;
        if (this.ctx.isAny() || this.ctx.isOpaque()) {
            if (this.m_wcontext._isInboundOperation) {
                if (this.ctx.isAqType()) {
                    operationName = this.getTranslatedString("AQ_OP_NAME_DEQUEUE_SUFFIX");
                } else if (this.ctx.isJmsType()) {
                    operationName = this.getTranslatedString("JMS_OP_NAME_CONSUME_SUFFIX");
                }
            } else if (this.ctx.isAqType()) {
                operationName = this.getTranslatedString("AQ_OP_NAME_ENQUEUE_SUFFIX");
            } else if (this.ctx.isJmsType()) {
                operationName = this.getTranslatedString("JMS_OP_NAME_PRODUCE_SUFFIX");
            }
            this.createCommonOperationObjects(operationName);
            if (this.ctx.isAqType()) {
                JcaOperation jop = this.m_wcontext._write_jca_operation;
                if (this.m_wcontext._isInboundOperation) {
                    jop.setAttributeValue("ActivationSpec", "oracle.tip.adapter.aq.inbound.AQDequeueActivationSpec");
                } else {
                    jop.setAttributeValue("InteractionSpec", "oracle.tip.adapter.aq.outbound.AQEnqueueInteractionSpec");
                }
            }
        }
    }

    private void handleBrowseSchema() {
        String m_dirPath = SCAProject.getScaDirectoryPath((Project)this.m_wcontext._project);
        SCAProject m_scaproj = SCAProject.getSCAProject((Project)this.m_wcontext._project);
        URL m_projURL = m_scaproj.getSCARoot();
        URL m_xsdDirURL = m_scaproj.getXSDRoot();
        Context jdevcontext = Context.newIdeContext();
        TypeChooser chooser = new TypeChooser(UIHelper.getFrame((Component)this));
        CompoundDataSource ds = new CompoundDataSource();
        ds.addDataSource((TreeExplorerDataSource)new ProjectSchemaDataSource(jdevcontext, false, true));
        chooser.getTypeExplorer().setSchemaImportHandler((SchemaImportHandler)new AdapterWizardSchemaImportHandler(new JDevBPELProject(this.m_wcontext._project)));
        chooser.setTargetSchemaDirLocation(m_xsdDirURL);
        int rcint = chooser.display((TreeExplorerDataSource)ds);
        if (rcint == 0) {
            TypeObject m_elementTypeObj = chooser.getTypeObject();
            URL fileUrl = (URL)m_elementTypeObj.getData("RESOURCE_URL_KEY");
            String file_name = this.convertUriRelativeProject(m_xsdDirURL, fileUrl);
            this.schemaLoc.setText(file_name);
            String elname = m_elementTypeObj.getQName().getLocalPart();
            this.ctx.setBrowseSchemaRootElement(elname);
            return;
        }
    }

    private URL getBaseURL(String directoryPath) {
        String dirpath = directoryPath;
        if (!dirpath.endsWith(File.separator)) {
            dirpath = dirpath + File.separator;
        }
        return URLFactory.newURL((String)dirpath);
    }

    private String convertUriRelativeProject(URL dirurl, URL inurl) {
        String filestr = null;
        filestr = URLFileSystem.isBaseURLFor((URL)dirurl, (URL)inurl) ? URLFileSystem.toRelativeSpec((URL)inurl, (URL)dirurl) : URLUtil.toString((URL)inurl);
        return filestr;
    }
}

