/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.b2b;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.b2b.B2BContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.b2b.B2BDocDefPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.b2b.DocDefObj;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.b2b.DocDefTreeNode;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.b2b.ParentObj;

public class B2BDocDefTree
extends JTree
implements TreeSelectionListener {
    private DefaultTreeModel treeModel = null;
    private B2BContext ctx;
    private B2BDocDefPage parentPage;

    public B2BDocDefTree(B2BContext ctx, B2BDocDefPage parentPage) throws Exception {
        this.ctx = ctx;
        this.parentPage = parentPage;
        this.setVisible(true);
        this.setRootVisible(true);
        this.addTreeSelectionListener(this);
        this.getSelectionModel().setSelectionMode(1);
    }

    public void loadTree(ParentObj root) throws Exception {
        if (root != null && root.getChildren() != null && root.getChildren().size() > 0) {
            DocDefTreeNode rootNode = new DocDefTreeNode(root);
            this.treeModel = new DefaultTreeModel(rootNode);
            this.treeModel.setRoot(rootNode);
            this.addNode(null, rootNode);
            this.expandRow(0);
            this.setSelectionPath(this.getPathForRow(0));
        } else {
            String msg = this.ctx.getResourceBundle().getString("DDP_NO_DOC_DEF_FOUND");
            this.displayMessage(msg);
        }
        this.setModel(this.treeModel);
    }

    public void addNode(DocDefTreeNode parentTreeNode, DocDefTreeNode currTreeNode) throws Exception {
        if (currTreeNode != null) {
            Object obj = currTreeNode.getUserObject();
            if (obj instanceof ParentObj) {
                List children;
                ParentObj parent = (ParentObj)obj;
                if (parent.getParent() != null) {
                    parentTreeNode.add(currTreeNode);
                }
                if ((children = parent.getChildren()) != null && children.size() > 0) {
                    for (int i = 0; i < children.size(); ++i) {
                        Object childObj = children.get(i);
                        DocDefTreeNode childTreeNode = new DocDefTreeNode(childObj);
                        this.addNode(currTreeNode, childTreeNode);
                    }
                }
            } else if (obj instanceof DocDefObj) {
                parentTreeNode.add(currTreeNode);
            }
        }
    }

    public void displayMessage(String message) {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(message);
        this.treeModel = new DefaultTreeModel(root);
        this.setModel(this.treeModel);
    }

    public void displayError() {
        String errorMsg = this.ctx.getResourceBundle().getString("ERROR_TITLE");
        this.displayMessage(errorMsg);
    }

    private DocDefObj getDocDefObject(TreePath treePath) {
        Object userObj;
        MutableTreeNode currentNode;
        DocDefTreeNode treeNode = null;
        DocDefObj docDefObj = null;
        if (treePath != null && (currentNode = (MutableTreeNode)treePath.getLastPathComponent()) != null && currentNode instanceof DocDefTreeNode && (treeNode = (DocDefTreeNode)currentNode) != null && treeNode.isLeaf() && (userObj = treeNode.getUserObject()) != null && userObj instanceof DocDefObj) {
            docDefObj = (DocDefObj)userObj;
        }
        return docDefObj;
    }

    @Override
    public void valueChanged(TreeSelectionEvent event) {
        TreePath treePath = event.getPath();
        this.ctx.setDocumentDefinition(this.getDocDefObject(treePath));
        this.parentPage.updateNav();
    }

    public void selectDocDefNode(String docRefName, boolean routingFlag) {
        DocDefTreeNode node = this.findDocDefNode(docRefName, routingFlag);
        if (node != null) {
            TreePath nodeParentPath = new TreePath(((DocDefTreeNode)node.getParent()).getPath());
            TreePath nodepath = new TreePath(node.getPath());
            this.expandPath(nodeParentPath);
            this.setSelectionPath(nodepath);
        }
    }

    private DocDefTreeNode findDocDefNode(String docRef, boolean rflag) {
        DocDefTreeNode findNode = null;
        TreePath p = this.getPathForRow(0);
        try {
            DocDefTreeNode node = (DocDefTreeNode)p.getLastPathComponent();
            ArrayList docdefnodes = new ArrayList();
            this.getDocDefNodes(node, docdefnodes);
            for (DocDefTreeNode nde : docdefnodes) {
                if (rflag) {
                    if (!((DocDefObj)nde.getUserObject()).getRoutingId().equals(docRef)) continue;
                    findNode = nde;
                } else {
                    if (!((DocDefObj)nde.getUserObject()).getDocRef().equals(docRef)) continue;
                    findNode = nde;
                }
                break;
            }
        }
        catch (Exception e1) {
            // empty catch block
        }
        return findNode;
    }

    private List getDocDefNodes(DocDefTreeNode parentnode, List nodes) {
        Enumeration<TreeNode> e = parentnode.children();
        while (e.hasMoreElements()) {
            DocDefTreeNode nde = (DocDefTreeNode)e.nextElement();
            if (nde.getUserObject() instanceof DocDefObj) {
                nodes.add(nde);
                continue;
            }
            this.getDocDefNodes(nde, nodes);
        }
        return nodes;
    }
}

