/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.b2b;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.wsdl.WSDLException;
import oracle.bali.ewt.event.Cancelable;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.ewt.wizard.ImageWizardPage;
import oracle.bali.ewt.wizard.WizardEvent;
import oracle.ide.Ide;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFactory;
import oracle.tip.tools.ide.common.resourcepalette.adapter.mds.MDSHelper;
import oracle.tip.tools.ide.common.resourcepalette.adapter.mds.MDSProvider;
import oracle.tip.tools.ide.common.utils.MultiLineOptionPane;
import oracle.tip.tools.ide.common.xsdgrammar.GrammarInfo;
import oracle.tip.tools.ide.fabric.addin.SCAProject;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.AdapterWizardContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.ConnectionPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.aq.AQAdapterContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.b2b.B2BContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.b2b.B2BDocDefTree;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.b2b.B2BRootElementPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.b2b.DataAccess;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.b2b.ParentObj;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.file.FileAdapterFinish;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.jms.JMSContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.jms.JmsAdapterFinish;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.jms.JmsAdapterProviderPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.techAdapterWizardPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.wsdl.JcaOperation;
import oracle.tip.tools.ide.tx.util.BrowserLauncher;
import oracle.xml.parser.schema.XMLSchema;
import oracle.xml.parser.schema.XMLSchemaNode;
import oracle.xml.parser.schema.XSDBuilder;
import oracle.xml.parser.schema.XSDNode;

public class B2BDocDefPage
extends techAdapterWizardPage
implements ActionListener {
    private B2BContext ctx;
    private JPanel pagePanel;
    private MultiLineLabel introLabel;
    private JTextField searchTextField;
    private JButton searchButton;
    private JButton showAllButton;
    private JScrollPane docDefScrollPane;
    private B2BDocDefTree docDefTree;
    private JButton b2bConfigButton;
    private JCheckBox routingCB;
    public static final String OPAQUE_NAMESPACE = "http://xmlns.oracle.com/pcbpel/adapter/opaque/";
    public static final String OPAQUE_ROOTELEMENT = "opaqueElement";
    public static final String ATTACHMENT_DOCREF = "B2B--1.0--B2BAttachment--Attachment_def";
    public static final String ORAMDS_ATTACHMENT = "oramds:/soa/b2b/seed/b2bAttachments.xsd";

    public B2BDocDefPage(AdapterWizardContext wcontext, ImageWizardPage iwp) {
        try {
            this.setContextAndPage(wcontext, iwp);
            if (!AdapterWizardContext.IS_STANDALONE_TESTING && !this.m_wcontext.isStandalone()) {
                HelpSystem.getHelpSystem().registerTopic((JComponent)this.m_page.getContent(), "b2bjdev_wiz_doc_def_select");
            }
            this.ctx = (B2BContext)wcontext._ascontext;
            this.init();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void init() throws Exception {
        this.setLayout(new GridBagLayout());
        this.pagePanel = new JPanel();
        this.pagePanel.setLayout(new GridBagLayout());
        String introTxt = this.ctx.getResourceBundle().getString("DDP_INTRO");
        String searchTxt = this.ctx.getResourceBundle().getString("SEARCH");
        String searchTip = this.ctx.getResourceBundle().getString("DDP_SEARCH_TIP");
        String showAllTxt = this.ctx.getResourceBundle().getString("SHOW_ALL");
        String b2bConfigTxt = this.ctx.getResourceBundle().getString("DDP_B2B_CONFIG");
        String routingCBText = this.ctx.getResourceBundle().getString("ROUTING_ID");
        this.introLabel = new MultiLineLabel(WordWrapper.getTextWrapper(), introTxt);
        this.searchButton = new JButton(searchTxt);
        this.showAllButton = new JButton(showAllTxt);
        this.searchTextField = new JTextField();
        this.searchTextField.setToolTipText(searchTip);
        this.docDefTree = new B2BDocDefTree(this.ctx, this);
        this.docDefScrollPane = new JScrollPane(this.docDefTree);
        this.b2bConfigButton = new JButton(b2bConfigTxt);
        this.routingCB = new JCheckBox(routingCBText);
        this.searchButton.addActionListener(this);
        this.showAllButton.addActionListener(this);
        this.b2bConfigButton.addActionListener(this);
        this.routingCB.addActionListener(this);
        this.add((Component)this.introLabel, new GridBagConstraints(0, 0, 0, 1, 0.0, 0.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.searchTextField, new GridBagConstraints(0, 1, 3, 1, 5.0, 0.0, 18, 2, new Insets(20, 0, 0, 0), 0, 0));
        this.add((Component)this.searchButton, new GridBagConstraints(-1, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(20, 5, 0, 0), 0, 0));
        this.add((Component)this.showAllButton, new GridBagConstraints(-1, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(20, 5, 0, 0), 0, 0));
        this.add((Component)this.b2bConfigButton, new GridBagConstraints(-1, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(20, 5, 0, 0), 0, 0));
        this.add((Component)this.routingCB, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.add((Component)this.docDefScrollPane, new GridBagConstraints(0, 3, 0, 1, 1.0, 1.0, 18, 1, new Insets(10, 0, 0, 0), 0, 0));
    }

    public void updatePage(B2BContext ctx) {
        String routingFlag;
        ctx.setDataAccess(new DataAccess(ctx.getB2BWebServiceClient()));
        if (this.m_wcontext._read_b2b_uiext != null && (routingFlag = this.m_wcontext._read_b2b_uiext.getAttributeValue("UIRouting")) != null && routingFlag.equals("true")) {
            this.routingCB.setSelected(true);
            ctx.setRoutingFlag(this.routingCB.isSelected());
        }
        this.loadTree(false);
    }

    private void loadTree(boolean searching) {
        this.updateControlsBeforeTreeLoad(searching);
        if (searching) {
            String searchStr = this.searchTextField.getText().trim();
            Thread worker = new Thread(new DocDefGetter(searchStr, this.ctx.getRoutingFlag()));
            worker.start();
        } else {
            Thread worker = new Thread(new DocDefGetter(this.ctx.getRoutingFlag()));
            worker.start();
        }
    }

    private void updateControlsBeforeTreeLoad(boolean searching) {
        this.setCursor(new Cursor(3));
        this.searchTextField.setEnabled(false);
        this.searchButton.setEnabled(false);
        this.showAllButton.setEnabled(false);
        this.m_page.setCanAdvance(false);
        this.m_page.setCanGoBack(false);
        if (searching) {
            String msg = this.ctx.getResourceBundle().getString("DDP_SEARCHING");
            this.docDefTree.displayMessage(msg);
        } else {
            String msg = this.ctx.getResourceBundle().getString("DDP_LOADING");
            this.docDefTree.displayMessage(msg);
        }
    }

    private void updateControlsAfterTreeLoad() {
        this.searchTextField.setEnabled(true);
        this.searchButton.setEnabled(true);
        this.showAllButton.setEnabled(true);
        this.m_page.setCanGoBack(true);
        this.setCursor(new Cursor(0));
    }

    protected void updateNav() {
        if (this.ctx.getDocumentDefinition() != null) {
            this.m_page.setCanAdvance(true);
        } else {
            this.m_page.setCanAdvance(false);
        }
    }

    private void launchWebBrowser() {
        try {
            BrowserLauncher.openURL((String)this.ctx.getB2BConfigURL());
        }
        catch (Exception e) {
            e.printStackTrace();
            String errTitle = this.ctx.getResourceBundle().getString("ERROR_TITLE");
            MessageFormat msgFormat = new MessageFormat(this.ctx.getResourceBundle().getString("DDP_LAUNCH_BROWSER_ERROR"));
            Object[] msgVals = new Object[]{e.getLocalizedMessage()};
            String errMsg = msgFormat.format(msgVals);
            MultiLineOptionPane.showMessageDialog((Component)this.ctx.getParentFrame(), (Object)errMsg, (String)errTitle, (int)0);
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.searchButton) {
            this.loadTree(true);
        } else if (event.getSource() == this.showAllButton) {
            this.loadTree(false);
        } else if (event.getSource() == this.b2bConfigButton) {
            this.launchWebBrowser();
        } else if (event.getSource() == this.routingCB) {
            this.ctx.setRoutingFlag(this.routingCB.isSelected());
            this.loadTree(false);
        }
    }

    @Override
    public void buildWSDL() throws WSDLException, Exception {
        String operationName = null;
        if (this.m_wcontext._isInboundOperation) {
            if (this.ctx.isAqType()) {
                operationName = this.getTranslatedString("AQ_OP_NAME_DEQUEUE_SUFFIX");
            } else if (this.ctx.isJmsType()) {
                operationName = this.getTranslatedString("JMS_OP_NAME_CONSUME_SUFFIX");
            }
        } else if (this.ctx.isAqType()) {
            operationName = this.getTranslatedString("AQ_OP_NAME_ENQUEUE_SUFFIX");
        } else if (this.ctx.isJmsType()) {
            operationName = this.getTranslatedString("JMS_OP_NAME_PRODUCE_SUFFIX");
        }
        this.createCommonOperationObjects(operationName);
        if (this.ctx.isAqType()) {
            JcaOperation jop = this.m_wcontext._write_jca_operation;
            if (this.m_wcontext._isInboundOperation) {
                jop.setAttributeValue("ActivationSpec", "oracle.tip.adapter.aq.inbound.AQDequeueActivationSpec");
            } else {
                jop.setAttributeValue("InteractionSpec", "oracle.tip.adapter.aq.outbound.AQEnqueueInteractionSpec");
            }
        }
    }

    @Override
    public void wizardValidatePage(WizardEvent wizardEvent) {
        try {
            if (!this.ctx.isOpaque() && !this.ctx.isAny()) {
                if (this.ctx.getMDSConnectionName() == null) {
                    if (this.ctx.isFileSystem()) {
                        SCAProject m_scaproj = SCAProject.getSCAProject((Project)this.m_wcontext._project);
                        URL m_xsdDirURL = m_scaproj.getXSDRoot();
                        this.getSchemaInfoFromURL(m_xsdDirURL.getPath() + this.ctx.getRelativeBrowseSchemaPath());
                    } else {
                        String docRef = this.ctx.getDocumentDefinition().getDocRef();
                        String xsdContent = this.ctx.getB2BWebServiceClient().getDocDef(docRef);
                        if (xsdContent == null || xsdContent.trim().equals("")) {
                            String errTitle = this.ctx.getResourceBundle().getString("ERROR_TITLE");
                            String errMsg = this.ctx.getResourceBundle().getString("DDP_NO_SCHEMA_FOUND");
                            MultiLineOptionPane.showMessageDialog((Component)this.ctx.getParentFrame(), (Object)errMsg, (String)errTitle, (int)0);
                            ((Cancelable)wizardEvent).cancel();
                        } else {
                            this.ctx.setSchemaContent(xsdContent);
                            this.getSchemaInfoFromContent(xsdContent);
                        }
                    }
                    if (this.ctx.isAttachment()) {
                        this.getAttachmentSchemaContent(wizardEvent);
                    }
                } else {
                    MDSProvider provider = MDSHelper.getResourcePaletteMDSProvider((String)this.ctx.getMDSConnectionName());
                    Workspace app = Ide.getActiveWorkspace();
                    MDSHelper.createMDSEntry((Workspace)app, (MDSProvider)provider, (String)"/soa/b2b", (boolean)false, (boolean)false);
                    String schemaURLStr = this.ctx.getDocumentDefinition().getDefinitionFilename();
                    if (schemaURLStr == null || schemaURLStr.trim().equals("")) {
                        String errTitle = this.ctx.getResourceBundle().getString("ERROR_TITLE");
                        String errMsg = this.ctx.getResourceBundle().getString("DDP_NO_SCHEMA_FOUND");
                        MultiLineOptionPane.showMessageDialog((Component)this.ctx.getParentFrame(), (Object)errMsg, (String)errTitle, (int)0);
                        ((Cancelable)wizardEvent).cancel();
                    } else {
                        this.getSchemaInfoFromURL(schemaURLStr);
                        if (this.ctx.isAttachment()) {
                            this.getAttachmentSchemaInfoFromURL(ORAMDS_ATTACHMENT);
                        }
                    }
                }
            } else {
                if (this.ctx.isOpaque()) {
                    this.ctx.setSchemaTargetNamespace(OPAQUE_NAMESPACE);
                    ArrayList<String> rootElemList = new ArrayList<String>();
                    rootElemList.add(OPAQUE_ROOTELEMENT);
                    this.ctx.setRootElementList(rootElemList);
                }
                if (this.ctx.isAttachment()) {
                    this.getAttachmentSchemaContent(wizardEvent);
                }
            }
            this.ctx.setOpAttribute("UIDocRef", this.ctx.getDocumentDefinition().getDocRef());
            if (this.routingCB.isSelected()) {
                this.ctx.setOpAttribute("UIRouting", "true");
            }
            ImageWizardPage tempwp = null;
            if (!this.ctx.isAny()) {
                if (this.ctx.getRootElementList() == null || this.ctx.getRootElementList().size() < 1) {
                    String xsdStr = this.ctx.getMDSConnectionName() != null ? this.ctx.getDocumentDefinition().getDefinitionFilename() : this.ctx.getSchemaContent();
                    ((Cancelable)wizardEvent).cancel();
                    this.displayNoRootElementError(xsdStr);
                } else if (this.ctx.getRootElementList().size() == 1) {
                    this.ctx.setSelectedRootElement((String)this.ctx.getRootElementList().get(0));
                    this.removePages();
                    if (this.ctx.isAqType()) {
                        this.addPagesForAQ();
                    }
                    if (this.ctx.isJmsType()) {
                        this.addPagesForJMS();
                    }
                    this.addFinishPage();
                    if (!AdapterWizardContext.IS_STANDALONE_TESTING && !this.m_wcontext.isStandalone()) {
                        HelpSystem.getHelpSystem().registerTopic((JComponent)this.m_wcontext._finish_page.getContent(), "b2bjdev_wiz_fin");
                    }
                    this.setFinishPage();
                } else if (this.ctx.getRootElementList().size() > 1) {
                    this.removePages();
                    tempwp = new ImageWizardPage(null, this._getImage(), "");
                    if (!AdapterWizardContext.IS_STANDALONE_TESTING && !this.m_wcontext.isStandalone()) {
                        HelpSystem.getHelpSystem().registerTopic((JComponent)tempwp.getContent(), "b2bjdev_root_elem");
                    }
                    B2BRootElementPage rePage = new B2BRootElementPage(this.m_wcontext, tempwp, this.ctx.getRootElementList());
                    if (this.ctx.isAqType()) {
                        this.addPagesForAQ();
                    }
                    if (this.ctx.isJmsType()) {
                        this.addPagesForJMS();
                    }
                    this.addFinishPage();
                    this.setFinishPage();
                }
            } else {
                this.removePages();
                if (this.ctx.isAqType()) {
                    this.addPagesForAQ();
                }
                if (this.ctx.isJmsType()) {
                    this.addPagesForJMS();
                }
                this.addFinishPage();
                this.setFinishPage();
            }
            this.ctx.setServiceName(this.m_wcontext._write_service_name);
            this.ctx.setFullWSDLFilename(this.m_wcontext._write_wsdl_name);
            String unencodedwsdlFilename = this.m_wcontext._write_service_name + ".wsdl";
            String wsdlFilename = URLEncoder.encode(unencodedwsdlFilename, "UTF-8").replaceAll("%", "-");
            this.ctx.setWSDLFilename(wsdlFilename);
        }
        catch (Exception e) {
            String errTitle = this.ctx.getResourceBundle().getString("ERROR_TITLE");
            MessageFormat msgFormat = new MessageFormat(this.ctx.getResourceBundle().getString("XSD_LOAD_ERROR"));
            Object[] msgVals = new Object[]{e.getLocalizedMessage()};
            String errMsg = msgFormat.format(msgVals);
            MultiLineOptionPane.showMessageDialog((Component)this.ctx.getParentFrame(), (Object)errMsg, (String)errTitle, (int)0);
            e.printStackTrace();
            ((Cancelable)wizardEvent).cancel();
        }
    }

    private void getAttachmentSchemaContent(WizardEvent wizardEvent) {
        try {
            String attachXsdContent = this.ctx.getB2BWebServiceClient().getDocDef(ATTACHMENT_DOCREF);
            if (attachXsdContent == null || attachXsdContent.trim().equals("")) {
                String errTitle = this.ctx.getResourceBundle().getString("ERROR_TITLE");
                String errMsg = this.ctx.getResourceBundle().getString("DDP_NO_SCHEMA_FOUND");
                MultiLineOptionPane.showMessageDialog((Component)this.ctx.getParentFrame(), (Object)errMsg, (String)errTitle, (int)0);
                ((Cancelable)wizardEvent).cancel();
            } else {
                this.ctx.setAttachSchemaContent(attachXsdContent);
                this.getAttachSchemaInfoFromContent(attachXsdContent);
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    private void displayNoRootElementError(String xsdContent) {
        String errTitle = this.ctx.getResourceBundle().getString("ERROR_TITLE");
        String errMsg = this.ctx.getResourceBundle().getString("NO_ROOT_ELEM_FOUND_ERROR");
        MultiLineOptionPane.showMessageDialog((Component)this.ctx.getParentFrame(), (Object)errMsg, (String)errTitle, (int)0);
        System.out.println("***** No root element found in schema *****");
        System.out.println(xsdContent);
        System.out.println("*******************************************\n");
    }

    private void getSchemaInfoFromURL(String urlStr) throws Exception {
        if (urlStr == null || urlStr.trim().equals("")) {
            return;
        }
        URL schemaURL = URLFactory.newURL((String)urlStr);
        GrammarInfo gInfo = new GrammarInfo(schemaURL);
        String tns = gInfo.getTargetNamespace();
        this.ctx.setSchemaTargetNamespace(tns);
        List rootElemList = gInfo.getGlobalElementsNames();
        this.ctx.setRootElementList(rootElemList);
    }

    private void getAttachmentSchemaInfoFromURL(String urlStr) throws Exception {
        if (urlStr == null || urlStr.trim().equals("")) {
            return;
        }
        URL schemaURL = URLFactory.newURL((String)urlStr);
        GrammarInfo gInfo = new GrammarInfo(schemaURL);
        String tns = gInfo.getTargetNamespace();
        this.ctx.setAttachSchemaNamespace(tns);
        List rootElemList = gInfo.getGlobalElementsNames();
        this.ctx.setAttachRootElement((String)rootElemList.get(0));
    }

    private void getSchemaInfoFromContent(String xsdContent) throws Exception {
        ByteArrayInputStream is = new ByteArrayInputStream(xsdContent.getBytes());
        XSDBuilder builder = new XSDBuilder();
        XMLSchema schema = builder.build((InputStream)is, null);
        String tns = schema.getSchemaTargetNS();
        XMLSchemaNode schemaNode = schema.getSchemaByTargetNS(tns);
        XSDNode[] xsdNodes = schemaNode.getElementSet();
        ArrayList<String> rootElemList = new ArrayList<String>();
        for (int i = 0; i < xsdNodes.length; ++i) {
            XSDNode currNode = xsdNodes[i];
            rootElemList.add(currNode.getName());
        }
        this.ctx.setSchemaTargetNamespace(tns);
        this.ctx.setRootElementList(rootElemList);
    }

    private void getAttachSchemaInfoFromContent(String xsdContent) throws Exception {
        ByteArrayInputStream is = new ByteArrayInputStream(xsdContent.getBytes());
        XSDBuilder builder = new XSDBuilder();
        XMLSchema schema = builder.build((InputStream)is, null);
        String tns = schema.getSchemaTargetNS();
        XMLSchemaNode schemaNode = schema.getSchemaByTargetNS(tns);
        XSDNode[] xsdNodes = schemaNode.getElementSet();
        String rootElem = "";
        int i = 0;
        if (i < xsdNodes.length) {
            XSDNode currNode = xsdNodes[i];
            rootElem = currNode.getName();
        }
        this.ctx.setAttachSchemaNamespace(tns);
        this.ctx.setAttachRootElement(rootElem);
    }

    private void setFinishPage() {
        String finish_info = null;
        String finish_prompt = null;
        MessageFormat msgformat = null;
        Object[] obj = null;
        if (this.m_wcontext._read_service != null) {
            msgformat = new MessageFormat(this.ctx.getResourceBundle().getString("FP_FN_UPD_PROMPT"));
            obj = new Object[]{this.m_wcontext._read_service_name};
            finish_prompt = msgformat.format(obj);
            msgformat = new MessageFormat(this.ctx.getResourceBundle().getString("FP_FN_SUMMARY"));
            obj = new Object[]{this.m_wcontext._write_wsdl_name};
            finish_info = msgformat.format(obj);
        } else {
            msgformat = new MessageFormat(this.ctx.getResourceBundle().getString("FP_FN_PROMPT"));
            obj = new Object[]{this.m_wcontext._write_service_name};
            finish_prompt = msgformat.format(obj);
            msgformat = new MessageFormat(this.ctx.getResourceBundle().getString("FP_FN_SUMMARY"));
            obj = new Object[]{this.m_wcontext._write_wsdl_name};
            finish_info = msgformat.format(obj);
        }
        this.setFinishPageContents(finish_prompt, finish_info);
    }

    private void addPagesForAQ() {
        ImageWizardPage tempwp = null;
        this.m_wcontext._target_namespace_prefix = "http://xmlns.oracle.com/pcbpel/adapter/aq/";
        String encodedname = null;
        try {
            encodedname = URLEncoder.encode(this.getCleanName(this.m_wcontext._write_service_name), "UTF-8").replaceAll("%", "-");
        }
        catch (UnsupportedEncodingException eexcep) {
            eexcep.printStackTrace();
        }
        this.m_wcontext._target_namespace = this.m_wcontext._target_namespace_prefix + encodedname + "/";
        AQAdapterContext aqContext = new AQAdapterContext();
        this.m_wcontext._ascontext = aqContext;
        this.m_wcontext._service_type = "AQ";
        aqContext.b2bContext = this.ctx;
        this.m_wcontext._adapterWizardFinish = new FileAdapterFinish();
        tempwp = new ImageWizardPage(null, this._getImage(), this.getTranslatedString("CM_CN_PAGE_TITLE"));
        if (!AdapterWizardContext.IS_STANDALONE_TESTING && !this.m_wcontext.isStandalone()) {
            HelpSystem.getHelpSystem().registerTopic((JComponent)tempwp.getContent(), "b2bjdev_wiz_serv_conn");
        }
        ConnectionPage connPage = new ConnectionPage(this.m_wcontext, tempwp);
    }

    private void addPagesForJMS() {
        ImageWizardPage tempwp = null;
        this.m_wcontext._target_namespace_prefix = "http://xmlns.oracle.com/pcbpel/adapter/jms/";
        String encodedname = null;
        try {
            encodedname = URLEncoder.encode(this.getCleanName(this.m_wcontext._write_service_name), "UTF-8").replaceAll("%", "-");
        }
        catch (UnsupportedEncodingException eexcep) {
            eexcep.printStackTrace();
        }
        this.m_wcontext._target_namespace = this.m_wcontext._target_namespace_prefix + encodedname + "/";
        JMSContext jmsContext = new JMSContext();
        this.m_wcontext._ascontext = jmsContext;
        this.m_wcontext._service_type = "Jms";
        jmsContext.b2bContext = this.ctx;
        this.m_wcontext._adapterWizardFinish = new JmsAdapterFinish();
        tempwp = new ImageWizardPage(null, this._getImage(), this.getTranslatedString("JMS_PR_PAGE_TITLE"));
        JmsAdapterProviderPage dsp = new JmsAdapterProviderPage(this.m_wcontext, tempwp);
    }

    public String getCleanName(String displayName) {
        return displayName.replaceAll("[\\x2e\\s\\n\\r!\"#$%&'()*+,-./:;<=>?@[\\\\]^_`{|}~]", "_");
    }

    private final class TreeLoader
    implements Runnable {
        private ParentObj root = null;
        private Exception e = null;

        public TreeLoader(ParentObj root) {
            this.root = root;
        }

        public TreeLoader(Exception e) {
            this.e = e;
        }

        @Override
        public void run() {
            try {
                if (this.e == null) {
                    B2BDocDefPage.this.docDefTree.loadTree(this.root);
                    if (B2BDocDefPage.this.m_wcontext._read_b2b_uiext != null) {
                        String selectedDocRef = B2BDocDefPage.this.m_wcontext._read_b2b_uiext.getAttributeValue("UIDocRef");
                        B2BDocDefPage.this.docDefTree.selectDocDefNode(selectedDocRef, false);
                    }
                    this.updateControls();
                } else {
                    B2BDocDefPage.this.docDefTree.displayError();
                    this.updateControls();
                    this.displayErrorMsgBox(this.e);
                    this.e.printStackTrace();
                }
            }
            catch (Exception e) {
                this.updateControls();
                this.displayErrorMsgBox(e);
                e.printStackTrace();
            }
        }

        private void updateControls() {
            B2BDocDefPage.this.updateControlsAfterTreeLoad();
        }

        private void displayErrorMsgBox(Exception e) {
            String errTitle = B2BDocDefPage.this.ctx.getResourceBundle().getString("ERROR_TITLE");
            MessageFormat msgFormat = new MessageFormat(B2BDocDefPage.this.ctx.getResourceBundle().getString("DDP_LOADING_ERROR_MSG"));
            Object[] msgVals = new Object[]{e.getLocalizedMessage()};
            String errMsg = msgFormat.format(msgVals);
            MultiLineOptionPane.showMessageDialog((Component)B2BDocDefPage.this.ctx.getParentFrame(), (Object)errMsg, (String)errTitle, (int)0);
        }
    }

    private final class DocDefGetter
    implements Runnable {
        private String searchStr = null;
        private boolean routingFlag = false;

        public DocDefGetter() {
        }

        public DocDefGetter(boolean isRouting) {
            this.routingFlag = isRouting;
        }

        public DocDefGetter(String searchStr) {
            this.searchStr = searchStr;
        }

        public DocDefGetter(String searchStr, boolean isRouting) {
            this.searchStr = searchStr;
            this.routingFlag = isRouting;
        }

        @Override
        public void run() {
            try {
                ParentObj treeRoot = null;
                if (this.searchStr == null || this.searchStr.trim().equals("")) {
                    B2BDocDefPage.this.ctx.getDataAccess().setRoutingIdFlag(B2BDocDefPage.this.ctx.getRoutingFlag());
                    treeRoot = B2BDocDefPage.this.ctx.getRoutingFlag() ? B2BDocDefPage.this.ctx.getDataAccess().getDocDefsWithRouting() : B2BDocDefPage.this.ctx.getDataAccess().getDocumentDefinitions();
                } else {
                    B2BDocDefPage.this.ctx.getDataAccess().setRoutingIdFlag(B2BDocDefPage.this.ctx.getRoutingFlag());
                    treeRoot = B2BDocDefPage.this.ctx.getDataAccess().getDocumentDefinitions(this.searchStr);
                }
                SwingUtilities.invokeLater(new TreeLoader(treeRoot));
            }
            catch (Exception e) {
                SwingUtilities.invokeLater(new TreeLoader(e));
            }
        }
    }
}

