/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.b2b;

import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.wsdl.Definition;
import javax.wsdl.Operation;
import javax.wsdl.Service;
import oracle.bali.ewt.wizard.Wizard;
import oracle.ide.model.Project;
import oracle.tip.b2b.ws.client.B2BMetadataWSPortClient;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.b2b.ConnInfo;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.b2b.DataAccess;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.b2b.DocDefObj;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.wsdl.B2BUIExtensions;

public class B2BContext {
    private static final String B2B = "B2B";
    public static final String UICONNNAME = "UIConnectionName";
    public static final String UIPORT = "UIPort";
    public static final String UIDOCREFTYPE = "UIDocRefType";
    public static final String UIDOCREF = "UIDocRef";
    public static final String UIROUTING = "UIRouting";
    public static final String UIATTACHMENT = "UIAttachment";
    public static final String UISERVER = "UISOAServer";
    public static final String DOCREF_ANYTYPE = "anyType";
    public static final String DOCREF_OPAQUE = "Opaque";
    public static final String DOCREF_MDS = "MDS";
    public static final String DOCREF_MDSCONNNAME = "UIMDSConnectionName";
    public static final String DOCREF_FS = "FileSystem";
    public static final String DOCREF_SCHEMAFILE = "UISchemaFile";
    public static final String DOCREF_SCHEMAROOTELEMENT = "UISchemaRootElement";
    public static final String TRUE = "true";
    public static final String FALSE = "false";
    public static final String ROUTING_ID = "DOC_ROUTING_ID";
    private String serviceName;
    private DocDefObj docDefObj;
    private ResourceBundle resourceBundle;
    private Wizard wizard;
    private JFrame parentFrame;
    private String fullWSDLFilename;
    private String wsdlFilename;
    private DataAccess dataAccess;
    private boolean isInbound;
    private boolean isOpaque;
    private boolean isAny;
    private boolean isFileSystem;
    private String operation;
    private String wsdlTargetNamespace;
    private String schemaTargetNamespace;
    private String portType;
    private String selectedRootElement;
    private List rootElementList;
    private Project jdevProj;
    private String b2bConfigURL;
    private String role;
    private String mdsConnName;
    private String schemaContent;
    private String fullSchemaFilename;
    private boolean routingFlag = false;
    private List pageList = new ArrayList();
    private Hashtable opAttributes = new Hashtable();
    private boolean isAqType = false;
    private boolean isJmsType = false;
    private String relativeBrowseSchemaPath;
    private String browseSchemaRootElement;
    private boolean isAttachment = false;
    private String attachSchemaContent;
    private String attachSchemaNamespace;
    private String attachRootElement;
    private String dirPath;
    private String schemaDir;
    public B2BUIExtensions _write_b2b_uiext;
    public B2BUIExtensions _read_b2b_uiext;
    public Definition _read_definition = null;
    public String _read_service_documentation = null;
    public Service _read_service = null;
    public Operation _read_operation = null;
    private B2BMetadataWSPortClient b2bWSClient;

    public void setResourceBundle(ResourceBundle resourceBundle) {
        this.resourceBundle = resourceBundle;
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    protected void setWizard(Wizard wizard) {
        this.wizard = wizard;
    }

    protected Wizard getWizard() {
        return this.wizard;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    protected void setDocumentDefinition(DocDefObj docDefObj) {
        this.docDefObj = docDefObj;
    }

    public DocDefObj getDocumentDefinition() {
        return this.docDefObj;
    }

    public void setDirectory(String dirPath) {
        this.dirPath = dirPath;
        this.schemaDir = dirPath + File.separator + "xsd";
    }

    public String getDirectory() {
        return this.dirPath;
    }

    public String getSchemaDirectory() {
        return this.schemaDir;
    }

    public void setParentFrame(JFrame parentFrame) {
        this.parentFrame = parentFrame;
    }

    public JFrame getParentFrame() {
        return this.parentFrame;
    }

    public void setFullWSDLFilename(String fullWSDLFilename) {
        this.fullWSDLFilename = fullWSDLFilename;
    }

    public String getFullWSDLFilename() {
        return this.fullWSDLFilename;
    }

    public void setWSDLFilename(String wsdlFilename) {
        this.wsdlFilename = wsdlFilename;
    }

    public String getWSDLFilename() {
        return this.wsdlFilename;
    }

    public void setDataAccess(DataAccess dataAccess) {
        this.dataAccess = dataAccess;
    }

    public DataAccess getDataAccess() {
        return this.dataAccess;
    }

    public void setIsInbound(boolean isInbound) {
        this.isInbound = isInbound;
    }

    public boolean isInbound() {
        return this.isInbound;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public String getOperation() {
        return this.operation;
    }

    public void setRootElementList(List rootElementList) {
        this.rootElementList = rootElementList;
    }

    public List getRootElementList() {
        return this.rootElementList;
    }

    public void setWSDLTargetNamespace(String targetNamespace) {
        this.wsdlTargetNamespace = targetNamespace;
    }

    public String getWSDLTargetNamespace() {
        return this.wsdlTargetNamespace;
    }

    public void setSchemaTargetNamespace(String targetNamespace) {
        this.schemaTargetNamespace = targetNamespace;
    }

    public String getSchemaTargetNamespace() {
        return this.schemaTargetNamespace;
    }

    public void setSelectedRootElement(String selectedRootElement) {
        this.selectedRootElement = selectedRootElement;
    }

    public String getSelectedRootElement() {
        return this.selectedRootElement;
    }

    public void setPortType(String portType) {
        this.portType = portType;
    }

    public String getPortType() {
        return this.portType;
    }

    public void setSchemaContent(String schemaContent) {
        this.schemaContent = schemaContent;
    }

    public String getSchemaContent() {
        return this.schemaContent;
    }

    public void setFullSchemaFilename(String fullSchemaFilename) {
        this.fullSchemaFilename = fullSchemaFilename;
    }

    public String getFullSchemaFilename() {
        return this.fullSchemaFilename;
    }

    public void initializeB2BWebServiceClient(ConnInfo connInfo) throws Exception {
        this.b2bWSClient = new B2BMetadataWSPortClient();
        this.b2bWSClient.setEndpoint(connInfo.getEndpoint());
        this.b2bWSClient.setUsername(connInfo.getUsername());
        this.b2bWSClient.setPassword(connInfo.getPassword());
    }

    public B2BMetadataWSPortClient getB2BWebServiceClient() {
        return this.b2bWSClient;
    }

    public void setProject(Project jdevProj) {
        this.jdevProj = jdevProj;
    }

    public Project getProject() {
        return this.jdevProj;
    }

    public void setB2BConfigURL(String url) {
        this.b2bConfigURL = url;
    }

    public void setMDSConnectionName(String mdsConnName) {
        this.mdsConnName = mdsConnName;
    }

    public String getB2BConfigURL() {
        return this.b2bConfigURL;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public String getRole() {
        return this.role;
    }

    public String getServiceType() {
        return B2B;
    }

    public String getMDSConnectionName() {
        return this.mdsConnName;
    }

    public String getSchemaFilename(String schemaURL) {
        if (schemaURL == null) {
            return null;
        }
        int start = schemaURL.lastIndexOf("/") + 1;
        if (start > -1) {
            return schemaURL.substring(start, schemaURL.length());
        }
        return null;
    }

    public List getXSDDirStructure(String url) {
        String SOA_B2B = "oramds:/soa/b2b/";
        String SLASH = "/";
        ArrayList<String> dirStructure = new ArrayList<String>();
        if (url == null) {
            return dirStructure;
        }
        int start = url.indexOf("oramds:/soa/b2b/");
        int end = url.lastIndexOf("/") + 1;
        if (start > -1 && end > -1) {
            String dirStr = url.substring(start += "oramds:/soa/b2b/".length(), end);
            boolean done = false;
            start = 0;
            end = dirStr.indexOf("/");
            while (!done) {
                if (start > -1 && end > -1) {
                    String currDir = dirStr.substring(start, end).trim();
                    if (currDir != null && !currDir.equals("")) {
                        dirStructure.add(currDir);
                    }
                    start = ++end;
                    end = dirStr.indexOf("/", end);
                }
                if (start > -1 && end > -1) continue;
                done = true;
            }
        }
        return dirStructure;
    }

    public String getRelativeXsdDirStr(List xsdDirStructure, boolean forWSDL) {
        String dirStructStr = "";
        String separator = File.separator;
        if (forWSDL) {
            separator = "/";
        }
        if (xsdDirStructure == null || xsdDirStructure.size() < 1) {
            return separator;
        }
        for (String currDir : xsdDirStructure) {
            if (currDir == null || (currDir = currDir.trim()).equals("")) continue;
            dirStructStr = dirStructStr + separator + currDir;
        }
        if (!dirStructStr.equals("")) {
            dirStructStr = dirStructStr + separator;
        }
        return dirStructStr;
    }

    public void setOpaque(boolean isOpaque) {
        this.isOpaque = isOpaque;
    }

    public boolean isOpaque() {
        return this.isOpaque;
    }

    public void setAny(boolean isAny) {
        this.isAny = isAny;
    }

    public boolean isAny() {
        return this.isAny;
    }

    public void setRoutingFlag(boolean routingFlag) {
        this.routingFlag = routingFlag;
    }

    public boolean getRoutingFlag() {
        return this.routingFlag;
    }

    public List getPages() {
        return this.pageList;
    }

    public void addPage(JPanel p) {
        this.pageList.add(p);
    }

    public void removePage(Object p) {
        this.pageList.remove(p);
    }

    public void setOpAttribute(String attr_name, String attr_value) {
        this.opAttributes.put(attr_name, attr_value);
    }

    public Hashtable getOpAttributes() {
        return this.opAttributes;
    }

    public void removeOpAttribute(String attr_name) {
        this.opAttributes.remove(attr_name);
    }

    public void setAqType(boolean isAqType) {
        this.isAqType = isAqType;
    }

    public boolean isAqType() {
        return this.isAqType;
    }

    public void setJmsType(boolean isJmsType) {
        this.isJmsType = isJmsType;
    }

    public boolean isJmsType() {
        return this.isJmsType;
    }

    public void setAttachment(boolean isAttachment) {
        this.isAttachment = isAttachment;
    }

    public boolean isAttachment() {
        return this.isAttachment;
    }

    public void setAttachSchemaContent(String attachSchemaContent) {
        this.attachSchemaContent = attachSchemaContent;
    }

    public String getAttachSchemaContent() {
        return this.attachSchemaContent;
    }

    public void setAttachSchemaNamespace(String attachSchemaNamespace) {
        this.attachSchemaNamespace = attachSchemaNamespace;
    }

    public String getAttachSchemaNamespace() {
        return this.attachSchemaNamespace;
    }

    public void setAttachRootElement(String attachRootElement) {
        this.attachRootElement = attachRootElement;
    }

    public String getAttachRootElement() {
        return this.attachRootElement;
    }

    public void setFileSystem(boolean isFileSystem) {
        this.isFileSystem = isFileSystem;
    }

    public boolean isFileSystem() {
        return this.isFileSystem;
    }

    public void setRelativeBrowseSchemaPath(String relativeBrowseSchemaPath) {
        this.relativeBrowseSchemaPath = relativeBrowseSchemaPath;
    }

    public String getRelativeBrowseSchemaPath() {
        return this.relativeBrowseSchemaPath;
    }

    public void setBrowseSchemaRootElement(String browseSchemaRootElement) {
        this.browseSchemaRootElement = browseSchemaRootElement;
    }

    public String getBrowseSchemaRootElement() {
        return this.browseSchemaRootElement;
    }
}

