/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.b2b;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.net.URLConnection;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.bali.ewt.event.Cancelable;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.ewt.wizard.ImageWizardPage;
import oracle.bali.ewt.wizard.WizardEvent;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.help.HelpSystem;
import oracle.jdeveloper.deploy.meta.Platform;
import oracle.jdeveloper.deploy.meta.PlatformType;
import oracle.jdeveloper.server.connection.AppServer;
import oracle.jdeveloper.server.connection.AppServerManager;
import oracle.jdeveloper.server.dt.panels.AppServerConnectionsPanel;
import oracle.rc.asadapter.connection.AppServerConnection;
import oracle.rc.asadapter.connection.AppServerProvider;
import oracle.rc.asadapter.connection.ConnectionDescriptor;
import oracle.rc.asadapter.connection.Presentation;
import oracle.rc.asadapter.connection.PresentationType;
import oracle.rc.asadapter.http.HttpConnectionManager;
import oracle.rc.asadapter.weblogic.connection.Weblogic10Descriptor;
import oracle.tip.b2b.ws.client.B2BMetadataWSPortClient;
import oracle.tip.tools.ide.common.ui.statusglasspane.StatusGlassPane;
import oracle.tip.tools.ide.common.utils.MultiLineOptionPane;
import oracle.tip.tools.ide.fabric.asbrowser.ASBrowserHelper;
import oracle.tip.tools.ide.fabric.asbrowser.SOAServerObject;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.AdapterWizardContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.b2b.B2BContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.b2b.ConnInfo;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.file.FileAdapterSchemaPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.techAdapterWizardPage;

public class B2BAppServerConnPage
extends techAdapterWizardPage
implements ItemListener,
DocumentListener,
FocusListener {
    private static final String URL_PATH = "/integration/services/b2b/B2BMetadataWSPort";
    private static final String DEFAULT_PORT = "7001";
    private B2BContext ctx;
    private JPanel pagePanel;
    private MultiLineLabel introLabel;
    private ConnInfo selectedConnInfo;
    private AppServerConnectionsPanel appConnPanel;
    private JPanel appConnDetailsPanel;
    private JLabel appConnUserLabel;
    private JLabel appConnUser;
    private JLabel appConnHostLabel;
    private JLabel appConnHost;
    private JPanel httpPortPanel;
    private JLabel httpPortLabel;
    private JTextField httpPortTF;
    private JPanel soaServerPanel;
    private JLabel soaServerLabel;
    private JComboBox soaServerCB;
    private JButton testB2BButton;
    boolean invalidConnectionNameForUpdate = false;
    private String soaHttpPort;
    private String soaHostName;
    private boolean isSOASSLPort = false;
    private List<SOAServerObject> soaServerList;

    public B2BAppServerConnPage(AdapterWizardContext wcontext, ImageWizardPage iwp) {
        this.setContextAndPage(wcontext, iwp);
        if (!AdapterWizardContext.IS_STANDALONE_TESTING && !this.m_wcontext.isStandalone()) {
            HelpSystem.getHelpSystem().registerTopic((JComponent)this.m_page.getContent(), "b2bjdev_wiz_conn");
        }
        this.ctx = (B2BContext)wcontext._ascontext;
        this.init();
    }

    private void init() {
        this.setLayout(new GridBagLayout());
        this.pagePanel = new JPanel();
        this.pagePanel.setLayout(new GridBagLayout());
        String introTxt = this.ctx.getResourceBundle().getString("ASC_INTRO");
        String httpPortTxt = this.ctx.getResourceBundle().getString("ASC_HTTP_PORT");
        String httpPortTip = this.ctx.getResourceBundle().getString("ASC_HTTP_PORT_TIP");
        String soaServerTxt = this.ctx.getResourceBundle().getString("ASC_SOA_SERVER");
        String soaServerTip = this.ctx.getResourceBundle().getString("ASC_SOA_SERVER_TIP");
        String testB2BBtnTxt = this.ctx.getResourceBundle().getString("B2B_TESTBTN_TXT");
        String testB2BBtnTip = this.ctx.getResourceBundle().getString("B2B_TESTBTN_TIP");
        String appConnPanelUserTxt = this.ctx.getResourceBundle().getString("ASC_USER_NAME");
        String appConnPanelHostTxt = this.ctx.getResourceBundle().getString("ASC_HOST_NAME");
        this.introLabel = new MultiLineLabel(WordWrapper.getTextWrapper(), introTxt);
        String[] oracleTypes = new String[]{null};
        this.appConnPanel = new AppServerConnectionsPanel(AppServerManager.getInstance());
        this.appConnPanel.setConnectionPrompt(null);
        this.appConnPanel.getConnectionsCombo().addFocusListener(this);
        this.appConnPanel.getConnectionsCombo().addItemListener(this);
        this.m_page.setInitialFocus((Component)this.appConnPanel.getConnectionsCombo());
        this.appConnDetailsPanel = new JPanel(new GridBagLayout());
        this.appConnDetailsPanel.setBorder(BorderFactory.createEtchedBorder());
        this.appConnUserLabel = new JLabel(appConnPanelUserTxt);
        this.appConnHostLabel = new JLabel(appConnPanelHostTxt);
        this.appConnUser = new JLabel();
        this.appConnHost = new JLabel();
        this.appConnDetailsPanel.add((Component)this.appConnUserLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.appConnDetailsPanel.add((Component)this.appConnUser, new GridBagConstraints(1, 0, 2, 1, 50.0, 0.0, 18, 2, new Insets(5, 10, 0, 0), 0, 0));
        this.appConnDetailsPanel.add((Component)this.appConnHostLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.appConnDetailsPanel.add((Component)this.appConnHost, new GridBagConstraints(1, 1, 2, 1, 50.0, 0.0, 18, 2, new Insets(5, 10, 5, 0), 0, 0));
        this.soaServerPanel = new JPanel();
        this.soaServerLabel = new JLabel(StringUtils.stripMnemonic((String)soaServerTxt));
        this.soaServerCB = new JComboBox();
        this.soaServerLabel.setLabelFor(this.soaServerCB);
        this.soaServerLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)soaServerTxt));
        this.soaServerCB.setToolTipText(soaServerTip);
        this.soaServerCB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    B2BAppServerConnPage.this.setSOAHttpPort();
                }
            }
        });
        this.soaServerPanel.setLayout(new GridBagLayout());
        this.testB2BButton = new JButton(StringUtils.stripMnemonic((String)testB2BBtnTxt));
        this.testB2BButton.setToolTipText(testB2BBtnTip);
        this.testB2BButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)testB2BBtnTxt));
        this.testB2BButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                B2BAppServerConnPage.this.handleB2BTest();
            }
        });
        this.soaServerPanel.add((Component)this.soaServerLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.soaServerPanel.add((Component)this.soaServerCB, new GridBagConstraints(1, 0, 2, 1, 50.0, 0.0, 18, 2, new Insets(0, 10, 0, 0), 0, 0));
        this.soaServerPanel.add((Component)this.testB2BButton, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 18, 0, new Insets(0, 10, 0, 0), 0, 0));
        this.add((Component)this.introLabel, new GridBagConstraints(0, 0, 0, 1, 1.0, 0.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.appConnPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(10, 0, 0, 0), 0, 0));
        this.add((Component)this.appConnDetailsPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 18, 2, new Insets(10, 0, 0, 0), 0, 0));
        this.add((Component)this.soaServerPanel, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 18, 2, new Insets(10, 5, 0, 0), 0, 0));
        this.add((Component)new JPanel(), new GridBagConstraints(0, 4, 1, 0, 1.0, 1.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        if (this.m_wcontext._read_service != null) {
            this.initFromExistingWSDL();
        } else {
            this.m_page.setCanAdvance(false);
        }
    }

    protected void initFromExistingWSDL() {
        if (this.m_wcontext._read_b2b_uiext != null && !this.m_wcontext.isStandalone() && !AdapterWizardContext.IS_STANDALONE_TESTING) {
            String connName = this.m_wcontext._read_b2b_uiext.getAttributeValue("UIConnectionName");
            if (!this.isConnNameValid(connName)) {
                this.invalidConnectionNameForUpdate = true;
            }
            this.appConnPanel.setConnectionName(connName);
        }
    }

    private void populateSOAServerList() {
        final String connName = this.appConnPanel.getConnectionName();
        this.soaServerCB.removeAllItems();
        final StatusGlassPane status = new StatusGlassPane((Component)this);
        status.enableUserInput(false);
        status.setStatusMessage(this.ctx.getResourceBundle().getString("WAIT_MSG"), this.ctx.getResourceBundle().getString("SRV_INFO_MSG"));
        this.m_page.setCanAdvance(false);
        Runnable r = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    B2BAppServerConnPage.this.setSelectedConnInfo(connName);
                    if (B2BAppServerConnPage.this.selectedConnInfo != null) {
                        B2BAppServerConnPage.this.appConnUser.setText(B2BAppServerConnPage.this.selectedConnInfo.getUsername());
                        B2BAppServerConnPage.this.appConnHost.setText(B2BAppServerConnPage.this.selectedConnInfo.getJMXHostName());
                    }
                    AppServer selAppServ = AppServerManager.getInstance().getAppServer(connName);
                    AppServerConnection conn = selAppServ.getConnection();
                    B2BAppServerConnPage.this.soaServerList = ASBrowserHelper.listSOAServers((AppServerConnection)conn);
                    Runnable r1 = new Runnable(){

                        @Override
                        public void run() {
                            if (B2BAppServerConnPage.this.soaServerList != null) {
                                String soaServerName;
                                Iterator i = B2BAppServerConnPage.this.soaServerList.iterator();
                                SOAServerObject obj = null;
                                while (i.hasNext()) {
                                    obj = (SOAServerObject)i.next();
                                    if (obj == null) continue;
                                    B2BAppServerConnPage.this.soaServerCB.addItem(obj.getServerName());
                                }
                                if (B2BAppServerConnPage.this.soaServerCB.getItemCount() == 1) {
                                    B2BAppServerConnPage.this.soaServerCB.setEnabled(false);
                                    if (obj.getSslPort() > 0) {
                                        B2BAppServerConnPage.this.soaHttpPort = String.valueOf(obj.getSslPort());
                                        B2BAppServerConnPage.this.isSOASSLPort = true;
                                    } else {
                                        B2BAppServerConnPage.this.soaHttpPort = String.valueOf(obj.getPort());
                                        B2BAppServerConnPage.this.isSOASSLPort = false;
                                    }
                                    B2BAppServerConnPage.this.soaHostName = obj.getHostName();
                                    B2BAppServerConnPage.this.m_page.setCanAdvance(true);
                                } else {
                                    B2BAppServerConnPage.this.soaServerCB.addItem("");
                                    B2BAppServerConnPage.this.soaServerCB.setEnabled(true);
                                    B2BAppServerConnPage.this.soaServerCB.setSelectedItem("");
                                    B2BAppServerConnPage.this.m_page.setCanAdvance(false);
                                }
                                if (!(B2BAppServerConnPage.this.m_wcontext._read_b2b_uiext == null || (soaServerName = B2BAppServerConnPage.this.m_wcontext._read_b2b_uiext.getAttributeValue("UISOAServer")) == null && soaServerName.equals(""))) {
                                    B2BAppServerConnPage.this.soaServerCB.setSelectedItem(soaServerName);
                                    B2BAppServerConnPage.this.setSOAHttpPort();
                                    B2BAppServerConnPage.this.m_page.setCanAdvance(true);
                                }
                            }
                        }
                    };
                    SwingUtilities.invokeLater(r1);
                }
                catch (Exception e) {
                    MultiLineOptionPane.showMessageDialog((Component)B2BAppServerConnPage.this.ctx.getParentFrame(), (Object)B2BAppServerConnPage.this.ctx.getResourceBundle().getString("ASC_APP_SERVER_CONN_INIT_ERROR"), (String)B2BAppServerConnPage.this.ctx.getResourceBundle().getString("ERROR_TITLE"), (int)0);
                    status.enableUserInput(true);
                }
                finally {
                    status.enableUserInput(true);
                }
            }
        };
        new Thread(r).start();
    }

    private void updatePageState() {
        final String connName = this.appConnPanel.getConnectionName();
        final StatusGlassPane status = new StatusGlassPane((Component)this);
        status.enableUserInput(false);
        status.setStatusMessage(this.ctx.getResourceBundle().getString("WAIT_MSG"), this.ctx.getResourceBundle().getString("SRV_INFO_MSG"));
        this.m_page.setCanAdvance(false);
        Runnable r = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    final String httpPort = B2BAppServerConnPage.this.getSOAHttpPort(connName);
                    Runnable r1 = new Runnable(){

                        @Override
                        public void run() {
                            B2BAppServerConnPage.this.httpPortTF.setText("");
                            if (httpPort != null) {
                                B2BAppServerConnPage.this.httpPortTF.setText(httpPort);
                            } else {
                                B2BAppServerConnPage.this.httpPortTF.setText(B2BAppServerConnPage.DEFAULT_PORT);
                            }
                            B2BAppServerConnPage.this.httpPortTF.requestFocus();
                            if (connName == null || connName.trim().equals("") || httpPort == null || httpPort.trim().equals("")) {
                                B2BAppServerConnPage.this.m_page.setCanAdvance(false);
                                status.enableUserInput(true);
                            } else {
                                B2BAppServerConnPage.this.m_page.setCanAdvance(true);
                            }
                        }
                    };
                    SwingUtilities.invokeLater(r1);
                }
                catch (Exception e) {
                    MultiLineOptionPane.showMessageDialog((Component)B2BAppServerConnPage.this.ctx.getParentFrame(), (Object)B2BAppServerConnPage.this.ctx.getResourceBundle().getString("ASC_APP_SERVER_CONN_INIT_ERROR"), (String)B2BAppServerConnPage.this.ctx.getResourceBundle().getString("ERROR_TITLE"), (int)0);
                    status.enableUserInput(true);
                }
                finally {
                    status.enableUserInput(true);
                }
            }
        };
        new Thread(r).start();
    }

    private void initPageState() {
        String connName = this.appConnPanel.getConnectionName();
        String httpPort = this.httpPortTF.getText().trim();
        if (connName == null || connName.trim().equals("") || httpPort == null || httpPort.trim().equals("")) {
            this.m_page.setCanAdvance(false);
        } else {
            this.m_page.setCanAdvance(true);
        }
    }

    private String getSOAHttpPort(String connName) {
        this.soaHttpPort = DEFAULT_PORT;
        boolean soaServerError = true;
        try {
            SOAServerObject serverObj = null;
            if (this.soaServerList != null) {
                serverObj = this.soaServerList.get(0);
                if (serverObj.getSslPort() > 0) {
                    this.soaHttpPort = String.valueOf(serverObj.getSslPort());
                    this.isSOASSLPort = true;
                } else {
                    this.soaHttpPort = String.valueOf(serverObj.getPort());
                    this.isSOASSLPort = false;
                }
                this.soaHostName = serverObj.getHostName();
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        if (this.soaHttpPort != null) {
            return this.soaHttpPort;
        }
        return this.soaHttpPort;
    }

    private void setSOAHttpPort() {
        this.soaHttpPort = DEFAULT_PORT;
        String soaServerName = (String)this.soaServerCB.getSelectedItem();
        if (soaServerName.equals("")) {
            this.m_page.setCanAdvance(false);
            return;
        }
        try {
            SOAServerObject serverObj2 = null;
            if (this.soaServerList != null) {
                for (SOAServerObject serverObj2 : this.soaServerList) {
                    if (!serverObj2.getServerName().equals(soaServerName)) continue;
                    if (serverObj2.getSslPort() > 0) {
                        this.soaHttpPort = String.valueOf(serverObj2.getSslPort());
                        this.isSOASSLPort = true;
                    } else {
                        this.soaHttpPort = String.valueOf(serverObj2.getPort());
                        this.isSOASSLPort = false;
                    }
                    this.soaHostName = serverObj2.getHostName();
                    this.m_page.setCanAdvance(true);
                }
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    @Override
    public void wizardValidatePage(WizardEvent wizardEvent) {
        try {
            String connName = this.appConnPanel.getConnectionName();
            this.selectedConnInfo.setHttpPort(this.soaHttpPort);
            this.selectedConnInfo.setSoaHostName(this.soaHostName);
            this.selectedConnInfo.setSOASSLPort(this.isSOASSLPort);
            this.ctx.initializeB2BWebServiceClient(this.selectedConnInfo);
            this.ctx.setB2BConfigURL(this.selectedConnInfo.getB2BConfigURL());
            this.ctx.setOpAttribute("UIConnectionName", connName);
            this.ctx.setOpAttribute("UISOAServer", (String)this.soaServerCB.getSelectedItem());
            this.ctx.setServiceName(this.m_wcontext._write_service_name);
        }
        catch (Exception e) {
            ((Cancelable)wizardEvent).cancel();
            MultiLineOptionPane.showMessageDialog((Component)this.ctx.getParentFrame(), (Object)this.ctx.getResourceBundle().getString("ASC_APP_SERVER_CONN_INIT_ERROR"), (String)this.ctx.getResourceBundle().getString("ERROR_TITLE"), (int)0);
            e.printStackTrace();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            this.populateSOAServerList();
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.initPageState();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.initPageState();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.initPageState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initConnInfo(String connName) {
        try {
            final String httpPort = this.getSOAHttpPort(connName);
            Runnable r1 = new Runnable(){

                @Override
                public void run() {
                    B2BAppServerConnPage.this.httpPortTF.setText("");
                    if (httpPort != null) {
                        B2BAppServerConnPage.this.httpPortTF.setText(httpPort);
                    } else {
                        B2BAppServerConnPage.this.httpPortTF.setText(B2BAppServerConnPage.DEFAULT_PORT);
                    }
                    B2BAppServerConnPage.this.httpPortTF.requestFocus();
                }
            };
            SwingUtilities.invokeLater(r1);
            final String connString = connName;
            Runnable r = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        String httpPort;
                        AppServer selAppServ = AppServerManager.getInstance().getAppServer(connString);
                        AppServerConnection conn = selAppServ.getConnection();
                        Presentation pres = conn.getPresentation(PresentationType.HTTP);
                        HttpConnectionManager httpMgr = (HttpConnectionManager)pres.get();
                        URLConnection url = null;
                        try {
                            url = httpMgr.getURLConnection(B2BAppServerConnPage.URL_PATH, null);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        Platform p = selAppServ.getPlatform();
                        PlatformType ptype = p.getType();
                        if (ptype.equals((Object)PlatformType.WEBLOGIC)) {
                            Weblogic10Descriptor desc = (Weblogic10Descriptor)ConnectionDescriptor.newInstance(Weblogic10Descriptor.class, (AppServerProvider)conn.getAppServerProvider());
                            B2BAppServerConnPage.this.selectedConnInfo = new ConnInfo((ConnectionDescriptor)desc);
                        }
                        if ((httpPort = String.valueOf(httpMgr.getHttpPort())) != null) {
                            B2BAppServerConnPage.this.httpPortTF.setText(httpPort);
                        }
                    }
                    catch (Exception e) {
                        B2BAppServerConnPage.this.httpPortTF.setText("6790");
                        B2BAppServerConnPage.this.setCursor(new Cursor(0));
                        B2BAppServerConnPage.this.httpPortTF.setEnabled(true);
                        B2BAppServerConnPage.this.testB2BButton.setEnabled(true);
                    }
                    finally {
                        B2BAppServerConnPage.this.setCursor(new Cursor(0));
                        B2BAppServerConnPage.this.httpPortTF.setEnabled(true);
                        B2BAppServerConnPage.this.testB2BButton.setEnabled(true);
                    }
                }
            };
        }
        catch (Exception e) {
            MultiLineOptionPane.showMessageDialog((Component)this.ctx.getParentFrame(), (Object)this.ctx.getResourceBundle().getString("ASC_APP_SERVER_CONN_INIT_ERROR"), (String)this.ctx.getResourceBundle().getString("ERROR_TITLE"), (int)0);
            this.m_wcontext._parentFrame.setCursor(new Cursor(0));
            this.httpPortTF.setEnabled(true);
            this.testB2BButton.setEnabled(true);
        }
        finally {
            this.m_wcontext._parentFrame.setCursor(new Cursor(0));
            this.httpPortTF.setEnabled(true);
            this.testB2BButton.setEnabled(true);
        }
    }

    private void handleB2BTest() {
        final StatusGlassPane status = new StatusGlassPane((Component)this);
        status.enableUserInput(false);
        status.setStatusMessage(this.ctx.getResourceBundle().getString("WAIT_MSG"), this.ctx.getResourceBundle().getString("B2B_CONNECT_MSG"));
        Runnable r = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                String connName = B2BAppServerConnPage.this.appConnPanel.getConnectionName();
                try {
                    B2BAppServerConnPage.this.selectedConnInfo.setHttpPort(B2BAppServerConnPage.this.soaHttpPort);
                    B2BAppServerConnPage.this.selectedConnInfo.setSoaHostName(B2BAppServerConnPage.this.soaHostName);
                    B2BAppServerConnPage.this.selectedConnInfo.setSOASSLPort(B2BAppServerConnPage.this.isSOASSLPort);
                    B2BMetadataWSPortClient b2bWSClient = new B2BMetadataWSPortClient();
                    b2bWSClient.setEndpoint(B2BAppServerConnPage.this.selectedConnInfo.getEndpoint());
                    b2bWSClient.setUsername(B2BAppServerConnPage.this.selectedConnInfo.getUsername());
                    b2bWSClient.setPassword(B2BAppServerConnPage.this.selectedConnInfo.getPassword());
                    String docDefXML = b2bWSClient.getAllDocuments(null);
                    status.enableUserInput(true);
                    MultiLineOptionPane.showMessageDialog((Component)B2BAppServerConnPage.this.ctx.getParentFrame(), (Object)B2BAppServerConnPage.this.ctx.getResourceBundle().getString("B2B_TEST_SUCCESS_MSG"), (String)B2BAppServerConnPage.this.ctx.getResourceBundle().getString("SUCCESS_TITLE"), (int)1);
                }
                catch (Exception e) {
                    status.enableUserInput(true);
                    MultiLineOptionPane.showMessageDialog((Component)B2BAppServerConnPage.this.ctx.getParentFrame(), (Object)B2BAppServerConnPage.this.ctx.getResourceBundle().getString("ASC_APP_SERVER_CONN_INIT_ERROR"), (String)B2BAppServerConnPage.this.ctx.getResourceBundle().getString("ERROR_TITLE"), (int)0);
                    e.printStackTrace();
                }
                finally {
                    status.enableUserInput(true);
                }
            }
        };
        new Thread(r).start();
    }

    @Override
    public void focusGained(FocusEvent e) {
        if (this.invalidConnectionNameForUpdate && e.getSource().equals(this.appConnPanel.getConnectionsCombo())) {
            this.invalidConnectionNameForUpdate = false;
            String connName = this.m_wcontext._read_b2b_uiext.getAttributeValue("UIConnectionName");
            String wsdlpath = this.m_wcontext._update_wsdl_path;
            if (wsdlpath.length() > 132) {
                String temp_str = FileAdapterSchemaPage.string_replaceAll(wsdlpath, '/', '\\');
                wsdlpath = temp_str.substring(temp_str.lastIndexOf("\\") + 1);
            }
            MessageFormat msgformat = new MessageFormat(this.m_wcontext._bundle.getString("CM_CN_CONNECTION_NAME_NOT_FOUND_MSG"));
            Object[] obj = new Object[]{connName, wsdlpath};
            MultiLineOptionPane.showMessageDialog((Component)this.m_wcontext._parentFrame, (Object)msgformat.format(obj), (String)this.m_wcontext._bundle.getString("CM_CN_CONNECTION_ERROR_TITLE"), (int)0);
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
    }

    private boolean isConnNameValid(String connName) {
        for (int i = 0; i < this.appConnPanel.getConnectionsCombo().getItemCount(); ++i) {
            String conn = (String)this.appConnPanel.getConnectionsCombo().getItemAt(i);
            if (!conn.equals(connName)) continue;
            return true;
        }
        return false;
    }

    private void setSelectedConnInfo(String connName) throws Exception {
        AppServer selAppServ = AppServerManager.getInstance().getAppServer(connName);
        AppServerConnection conn = selAppServ.getConnection();
        Presentation httpMgr = conn.getPresentation(PresentationType.HTTP);
        Platform p = selAppServ.getPlatform();
        PlatformType ptype = p.getType();
        if (ptype.equals((Object)PlatformType.WEBLOGIC)) {
            Weblogic10Descriptor desc = (Weblogic10Descriptor)ConnectionDescriptor.newInstance(Weblogic10Descriptor.class, (AppServerProvider)conn.getAppServerProvider());
            this.selectedConnInfo = new ConnInfo((ConnectionDescriptor)desc);
        }
    }

    public void enableUserInput(final boolean bEnable) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                B2BAppServerConnPage.this.httpPortTF.setEnabled(bEnable);
                B2BAppServerConnPage.this.testB2BButton.setEnabled(bEnable);
                if (bEnable) {
                    B2BAppServerConnPage.this.m_wcontext._parentFrame.setCursor(new Cursor(0));
                } else {
                    B2BAppServerConnPage.this.m_wcontext._parentFrame.setCursor(new Cursor(3));
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            SwingUtilities.invokeLater(r);
        }
    }
}

