/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.aq.metadata;

import java.awt.Component;
import java.text.MessageFormat;
import oracle.tip.tools.ide.common.utils.MultiLineOptionPane;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.AdapterWizardContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.util.StringUtil;
import oracle.xml.parser.v2.NSResolver;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XSLException;
import oracle.xml.sql.query.OracleXMLQuery;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLSchemaUtil {
    public static final int XML_SCHEMA_DEFINITION = 0;
    public static final int FULL_ROOT_ELEMENT_NAME = 1;
    public static final int ROOT_ELEMENT_NAME = 2;
    public static final int XML_SCHEMA_TARGET_NAMESPACE = 3;
    public static final int GENERATED_FILE_NAME = 4;
    static final int MAX_INFO_ENTRIES = 5;

    public static String[] getXMLSchemaInfoObjectQueue(AdapterWizardContext wcontext, String dbSchema, String queueTable) {
        try {
            String query = "SELECT user_data FROM " + dbSchema + "." + queueTable;
            OracleXMLQuery qry = new OracleXMLQuery(wcontext._connection, query);
            Document[] docs = qry.getXMLSchema();
            NodeList nl = XMLSchemaUtil.select(docs[0], "/xsd:schema/xsd:element/xsd:complexType/xsd:sequence/xsd:element/xsd:complexType/xsd:sequence/xsd:element");
            int matches = nl.getLength();
            String typeElem = null;
            String fullTypeElem = null;
            String namespace = null;
            for (int i = 0; i < matches; ++i) {
                NamedNodeMap nnm = nl.item(i).getAttributes();
                String attrVal = ((Attr)nnm.getNamedItem("type")).getValue();
                if (attrVal.indexOf(58) < 0) continue;
                typeElem = attrVal.substring(attrVal.indexOf(58) + 1);
                namespace = "http://xmlns.oracle.com/xdb/" + attrVal.substring(0, attrVal.indexOf(58));
                fullTypeElem = attrVal;
                break;
            }
            if (fullTypeElem == null) {
                MessageFormat msgformat = new MessageFormat(wcontext._bundle.getString("AQ_MD_ROOT_ELEM_NOTF"));
                Object[] obj = new Object[]{dbSchema, docs[0]};
                MultiLineOptionPane.showMessageDialog((Component)wcontext._parentFrame, (Object)msgformat.format(obj), (String)wcontext._bundle.getString("CM_WZ_SQL_EXCEPTION_TITLE"), (int)0);
            }
            Element root = docs[1].getDocumentElement();
            root.setAttribute("elementFormDefault", "unqualified");
            root.setAttribute("attributeFormDefault", "qualified");
            XMLElement element = (XMLElement)docs[1].createElement("element");
            element.setAttribute("name", typeElem);
            element.setAttribute("type", fullTypeElem);
            root.appendChild((Node)element);
            String tempxml = docs[1].toString();
            int inds = tempxml.lastIndexOf("xmlns=\"\"");
            if (inds > 0) {
                String temp1;
                tempxml = temp1 = tempxml.substring(0, inds) + tempxml.substring(inds + 8);
            }
            tempxml = StringUtil.replaceAll(tempxml, "type=\"hexBinary\"", "type=\"base64Binary\"");
            String[] returnInfo = new String[5];
            returnInfo[0] = tempxml;
            returnInfo[1] = fullTypeElem;
            returnInfo[2] = typeElem;
            returnInfo[3] = namespace;
            return returnInfo;
        }
        catch (Exception xsle) {
            MessageFormat msgformat = new MessageFormat(wcontext._bundle.getString("AQ_MD_XML_SCHEMA_GET_ERR"));
            Object[] obj = new Object[]{dbSchema, queueTable, xsle.getMessage()};
            MultiLineOptionPane.showMessageDialog((Component)wcontext._parentFrame, (Object)msgformat.format(obj), (String)wcontext._bundle.getString("CM_WZ_SQL_EXCEPTION_TITLE"), (int)0);
            return null;
        }
    }

    private static NodeList select(Document d, String pattern) throws XSLException {
        return XMLSchemaUtil.select((XMLDocument)d, pattern);
    }

    private static NodeList select(XMLDocument d, String pattern) throws XSLException {
        return d.selectNodes(pattern, (NSResolver)d.getDocumentElement());
    }
}

