/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.aq.metadata;

import java.util.Formatter;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.aq.metadata.XMLUtil;

public class XMLEncoder {
    private static String ENCODED_COLON = "_x003A_";

    private static String encodeName(String name, boolean nmtoken) {
        StringBuilder sb = new StringBuilder();
        int length = name.length();
        for (int i = 0; i < length; ++i) {
            char c = name.charAt(i);
            if (XMLEncoder.isInvalid(c, i == 0 && !nmtoken)) {
                new Formatter(sb).format("_x%1$0#4x_", c);
                continue;
            }
            if (c == '_' && i + 6 < length && name.charAt(i + 1) == 'x' && name.charAt(i + 6) == '_') {
                sb.append("_x005F_");
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    static boolean isInvalid(char c, boolean firstOnlyLetter) {
        if (c == ':') {
            return false;
        }
        if (firstOnlyLetter) {
            return !XMLUtil.isNameStart(c);
        }
        return !XMLUtil.isName(c);
    }

    public static String encodeName(String name) {
        return XMLEncoder.encodeName(name, false);
    }

    public static String encodeNmToken(String name) {
        return XMLEncoder.encodeName(name, true);
    }

    public static String encodeLocalName(String name) {
        String encoded = XMLEncoder.encodeName(name);
        int pos = encoded.indexOf(58);
        if (pos == -1) {
            return encoded;
        }
        return encoded.replace(":", ENCODED_COLON);
    }
}

