/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.aq.metadata;

import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.aq.metadata.DbObjectNode;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.aq.metadata.SchemaObject;

public class Attribute {
    private boolean isSelected = false;
    private String m_name;
    private String m_fullName;
    SchemaObject oType;
    SchemaObject elType = null;
    private DbObjectNode dbObj = null;

    Attribute(String name, SchemaObject ot) {
        this.m_name = name;
        this.oType = ot;
    }

    Attribute(String name, String fullName, SchemaObject ot) {
        this.m_name = name;
        this.m_fullName = fullName != null && !fullName.equals("") ? fullName + "." + name : name;
        this.oType = ot;
    }

    Attribute(String name, String full, SchemaObject ot, SchemaObject et) {
        this(name, full, ot);
        if (et != null && et.getName() != null) {
            this.elType = et;
        }
    }

    public boolean isPrimitive() {
        return this.oType.isPrimitive() || this.isArray() && this.elType.isPrimitive();
    }

    public boolean isArray() {
        return this.elType != null;
    }

    public String getType() {
        return this.oType.getName();
    }

    public String getName() {
        return this.m_name;
    }

    public String getFullName() {
        return this.m_fullName;
    }

    public void setDbObject(DbObjectNode dbObj) {
        this.dbObj = dbObj;
    }

    public DbObjectNode getDbObjectNode() {
        return this.dbObj;
    }

    public String getFullType() {
        return this.oType.getSchema() + "." + this.oType.getName();
    }

    public String toString() {
        String retstr = this.getName() + " (";
        retstr = this.isPrimitive() ? retstr + this.getType() + ")" : retstr + this.getFullType() + ")";
        return retstr;
    }
}

