/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.aq.metadata;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Vector;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.AdapterWizardContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.aq.metadata.AQQueue;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.aq.metadata.Attribute;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.aq.metadata.DbObjectNode;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.aq.metadata.PrimitiveNode;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.aq.metadata.SchemaObject;

public class AdtNode
extends DbObjectNode {
    private AdapterWizardContext m_wcontext;
    private Attribute m_parentAttr;
    private Vector m_attributes = null;
    private AQQueue m_queue;
    private Vector m_possibleXML_ContainerAttributes = null;
    private boolean m_hasBlob = false;
    private boolean m_hasText = false;

    AdtNode(AdapterWizardContext wcontext, Attribute attribute, AQQueue queue) {
        this.m_wcontext = wcontext;
        this.m_parentAttr = attribute;
        this.m_queue = queue;
    }

    private void loadFields(Connection con, String username) throws SQLException {
        SchemaObject ot = this.m_parentAttr.oType;
        SchemaObject et = this.m_parentAttr.elType;
        SchemaObject t = this.m_parentAttr.isArray() ? et : ot;
        try {
            this.m_attributes = new Vector();
            this.m_possibleXML_ContainerAttributes = new Vector();
            String query = null;
            String u = con.getMetaData().getUserName().toLowerCase();
            String s = t.getSchema().toLowerCase();
            PreparedStatement stmt = null;
            if (s.equals(u)) {
                query = "Select attr_name, attr_type_name, attr_type_owner, length from user_type_attrs  where type_name = ? order by attr_no";
                stmt = con.prepareStatement(query);
                stmt.setString(1, t.getName());
            } else {
                query = "Select attr_name, attr_type_name, attr_type_owner, length from all_type_attrs  where type_name = ? and owner= ? order by attr_no";
                stmt = con.prepareStatement(query);
                stmt.setString(1, t.getName());
                stmt.setString(2, t.getSchema());
            }
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                String name = rs.getString("attr_name");
                SchemaObject otype = new SchemaObject(rs.getString("attr_type_owner"), rs.getString("attr_type_name"), rs.getInt("length"));
                SchemaObject etype = null;
                if (!otype.isPrimitive()) {
                    query = "Select elem_type_name, elem_type_owner from all_coll_types where type_name = ?and owner= ?";
                    PreparedStatement stmt1 = con.prepareStatement(query);
                    stmt1.setString(1, otype.getName());
                    stmt1.setString(2, otype.getSchema());
                    ResultSet rs1 = stmt1.executeQuery();
                    if (rs1.next()) {
                        etype = new SchemaObject(rs1.getString("elem_type_owner"), rs1.getString("elem_type_name"));
                    }
                    rs1.close();
                    stmt1.close();
                } else if (!this.m_hasBlob && AdtNode.isBlob(otype.getName())) {
                    this.m_hasBlob = true;
                } else if (!this.m_hasText && AdtNode.isText(otype.getName())) {
                    this.m_hasText = true;
                }
                Attribute attr = new Attribute(name, this.m_parentAttr.getFullName(), otype, etype);
                this.m_attributes.addElement(attr);
                if (!otype.isPrimitive() || !AdtNode.isBlob(otype.getName()) && !AdtNode.isText(otype.getName())) continue;
                this.m_queue.addBlob(attr.getName(), attr.getFullName(), otype.getName(), otype.getLength());
                this.m_possibleXML_ContainerAttributes.addElement(attr);
            }
            rs.close();
            stmt.close();
        }
        catch (SQLException se) {
            MessageFormat msgformat = new MessageFormat(this.m_wcontext._bundle.getString("AQ_MD_NODE_LOAD_FLD"));
            Object[] obj = new Object[]{se.getMessage()};
            SQLException lnkSe = new SQLException(msgformat.format(obj));
            lnkSe.setNextException(se);
            throw lnkSe;
        }
    }

    public static boolean isBlob(String typeName) {
        return typeName != null && (typeName.equalsIgnoreCase("LONG") || typeName.equalsIgnoreCase("LONG RAW") || typeName.equalsIgnoreCase("BLOB") || typeName.equalsIgnoreCase("CLOB") || typeName.equalsIgnoreCase("NCLOB"));
    }

    public static boolean isBinary(String typeName) {
        return typeName != null && (typeName.equalsIgnoreCase("LONG") || typeName.equalsIgnoreCase("LONG RAW") || typeName.equalsIgnoreCase("BLOB"));
    }

    public static boolean isText(String typeName) {
        return typeName != null && (typeName.equalsIgnoreCase("CHAR") || typeName.equalsIgnoreCase("VARCHAR2") || typeName.equalsIgnoreCase("NCHAR") || typeName.equalsIgnoreCase("NVARCHAR2") || typeName.equalsIgnoreCase("RAW"));
    }

    public boolean hasText() {
        return this.m_hasText;
    }

    public boolean hasBlob() {
        return this.m_hasBlob;
    }

    @Override
    public String toString() {
        return this.m_parentAttr.toString();
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public boolean isObject() {
        return true;
    }

    @Override
    public boolean isArray() {
        return false;
    }

    @Override
    public String getType() {
        return this.m_parentAttr.getType();
    }

    @Override
    public void loadChildren(Connection con, String userName) throws SQLException {
        this.loadFields(con, userName);
        for (int i = 0; i < this.m_attributes.size(); ++i) {
            DbObjectNode newNode;
            Attribute attr = (Attribute)this.m_attributes.elementAt(i);
            if (attr.isPrimitive()) {
                PrimitiveNode primNode = new PrimitiveNode(attr.getName(), attr.isArray());
                primNode.setSchemaObject(attr.oType);
                newNode = primNode;
            } else {
                newNode = new AdtNode(this.m_wcontext, attr, this.m_queue);
            }
            newNode.loadChildren(con, userName);
            if (newNode instanceof AdtNode) {
                if (((AdtNode)newNode).hasBlob()) {
                    this.m_hasBlob = true;
                }
                if (((AdtNode)newNode).hasText()) {
                    this.m_hasText = true;
                }
            }
            attr.setDbObject(newNode);
        }
    }

    public String getFullType() {
        return this.m_parentAttr.getFullType();
    }

    public Vector getAttributes() {
        return this.m_attributes;
    }

    public Vector getPossibleXMLContainerAttributes() {
        return this.m_possibleXML_ContainerAttributes;
    }
}

