/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.aq.metadata;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.Vector;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.AdapterWizardContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.aq.metadata.AdtNode;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.aq.metadata.Attribute;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.aq.metadata.DbObjectNode;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.aq.metadata.PrimitiveNode;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.aq.metadata.SchemaObject;

public class AQQueue {
    private static final int NAME = 0;
    private static final int FULLNAME = 1;
    private static final int TYPENAME = 2;
    private static final int LENGTH = 3;
    private Vector m_lobFields = new Vector();
    private Vector m_binFields = new Vector();
    private DbObjectNode m_aqType;
    private SchemaObject m_schemaObj;
    private String m_queueName;
    private boolean m_isMultiConsumer = false;
    private boolean m_isObject = false;
    private boolean m_isRaw = false;
    private boolean m_hasBlob = false;
    private boolean m_hasText = false;
    private AdapterWizardContext m_wcontext;

    public AQQueue(AdapterWizardContext wcontext, SchemaObject schemaObject, String queueName, String recipients, String queueType) {
        this.m_wcontext = wcontext;
        this.m_schemaObj = schemaObject;
        this.m_queueName = queueName;
        this.m_isMultiConsumer = recipients.equalsIgnoreCase("MULTIPLE");
        this.m_isObject = queueType.equalsIgnoreCase("OBJECT");
    }

    public void loadChildren(Connection con, String userName) throws SQLException {
        try {
            String schemaName = this.m_schemaObj.getSchema();
            String query = "Select data_type, data_type_owner from all_tab_columns  where table_name ='" + this.m_schemaObj.getName().toUpperCase() + "' and owner='" + schemaName.toUpperCase() + "' and column_name = 'USER_DATA'";
            Statement stmt = con.createStatement();
            ResultSet rs = stmt.executeQuery(query);
            while (rs.next()) {
                String typeName = rs.getString("data_type");
                String typeOwner = rs.getString("data_type_owner");
                SchemaObject typeObj = new SchemaObject(typeOwner, typeName);
                if (typeOwner == null || typeOwner.equals("")) {
                    this.m_aqType = new PrimitiveNode(typeName, false);
                    this.m_isRaw = true;
                    continue;
                }
                this.m_aqType = new AdtNode(this.m_wcontext, new Attribute(typeOwner, typeObj), this);
                this.m_aqType.loadChildren(con, userName);
                this.m_hasBlob = ((AdtNode)this.m_aqType).hasBlob();
                this.m_hasText = ((AdtNode)this.m_aqType).hasText();
            }
            rs.close();
            stmt.close();
        }
        catch (SQLException se) {
            MessageFormat msgformat = new MessageFormat(this.m_wcontext._bundle.getString("AQ_MD_QUEUE_NODE_ERR"));
            Object[] obj = new Object[]{se.getMessage()};
            SQLException lnkSe = new SQLException(msgformat.format(obj));
            lnkSe.setNextException(se);
            throw lnkSe;
        }
    }

    public String getQueueName() {
        return this.m_queueName;
    }

    public String getType() {
        return this.m_aqType.getType();
    }

    public DbObjectNode getDbObjectNode() {
        return this.m_aqType;
    }

    public String getTableName() {
        return this.m_schemaObj.getName();
    }

    public String getTableSchema() {
        return this.m_schemaObj.getSchema();
    }

    public String toString() {
        return this.m_queueName + ": " + this.m_aqType;
    }

    public boolean isRaw() {
        return this.m_isRaw;
    }

    public boolean hasBlob() {
        return this.m_hasBlob;
    }

    public boolean hasText() {
        return this.m_hasText;
    }

    public boolean isMultiConsumer() {
        return this.m_isMultiConsumer;
    }

    public String[] getPayloadFields() {
        if (!this.m_lobFields.isEmpty()) {
            String[] lobFields = new String[this.m_lobFields.size()];
            for (int i = 0; i < this.m_lobFields.size(); ++i) {
                String[] blobInfo = (String[])this.m_lobFields.elementAt(i);
                lobFields[i] = blobInfo[1] + ": " + blobInfo[2];
                if (!AdtNode.isText(blobInfo[2])) continue;
                int n = i;
                lobFields[n] = lobFields[n] + "(" + blobInfo[3] + ")";
            }
            return lobFields;
        }
        return null;
    }

    public boolean isBlobField(String fullName) {
        return this.m_binFields.contains(fullName);
    }

    void addBlob(String name, String fullName, String type, String len) {
        String[] blobInfo = new String[]{name, fullName, type, len};
        this.m_lobFields.addElement(blobInfo);
        if (AdtNode.isBinary(type)) {
            this.m_binFields.add(fullName);
        }
    }
}

