/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.aq;

import java.awt.Component;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.tip.tools.ide.common.utils.MultiLineOptionPane;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.AdapterWizardContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.aq.AQAdapterContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.aq.AQAdapterQueueTreeNode;

public class AQAdapterQueueTree
extends JTree
implements TreeSelectionListener {
    AdapterWizardContext m_wcontext;
    AQAdapterContext aqcontext;
    AQAdapterQueueTreeNode root;
    String m_schema_name;
    String m_queueName;
    String m_queueType;
    String m_objectName;
    JEWTDialog m_currdiag;
    String alltype;
    String rawtype;
    String objtype;
    String xgtype;
    String wfbestype;
    String b2btype;
    String singleconsume;
    String multiconsume;

    public AQAdapterQueueTree(AdapterWizardContext wcontext, String schema_name, String queueName, String queueType, String objectName, JEWTDialog curdiag) {
        this.m_wcontext = wcontext;
        this.aqcontext = (AQAdapterContext)this.m_wcontext._ascontext;
        this.m_currdiag = curdiag;
        this.addTreeSelectionListener(this);
        this.alltype = this.getTranslatedString("AQ_SL_ALL_TYPES");
        this.rawtype = this.getTranslatedString("AQ_SL_RAW_TYPE");
        this.objtype = this.getTranslatedString("AQ_SL_OBJECT_TYPE");
        this.xgtype = this.getTranslatedString("AQ_SL_XMLGATEWAY_TYPE");
        this.wfbestype = this.getTranslatedString("AQ_SL_WFBES_TYPE");
        this.b2btype = this.getTranslatedString("AQ_SL_B2B_TYPE");
        this.singleconsume = this.getTranslatedString("AQ_SL_SINGLE_CONSUMER");
        this.multiconsume = this.getTranslatedString("AQ_SL_MULTI_CONSUMER");
        this.setVisible(true);
        this.setShowsRootHandles(true);
        this.createNodes(schema_name, queueName, queueType, objectName, false);
    }

    protected void createNodes(String schema_name_in, String queueName, String queueType, String objectName, boolean isExpanded) {
        int qcnt2;
        AQAdapterQueueTreeNode pkgNode2;
        String query;
        String base_query2;
        this.m_schema_name = schema_name_in;
        this.m_queueName = queueName;
        this.m_queueType = queueType;
        this.m_objectName = objectName;
        if (!queueType.equals(this.objtype)) {
            this.m_objectName = null;
        }
        if (this.m_queueName != null && this.m_queueName.equals("%")) {
            this.m_queueName = null;
        }
        if (this.m_objectName != null && this.m_objectName.equals("%")) {
            this.m_objectName = null;
        }
        List nameList = null;
        int qcnt = 0;
        int totalcnt = 0;
        String base_query = "select aq.name from all_queues aq, all_queue_tables qt where aq.owner = ? and qt.owner = ? and aq.queue_table = qt.queue_table and aq.queue_type = 'NORMAL_QUEUE' ";
        if (schema_name_in.equals(this.getTranslatedString("CM_WZ_DBSCHEMA_CONNECTION_USER_DEFAULT"))) {
            if (!AdapterWizardContext.IS_STANDALONE_TESTING && !this.m_wcontext.isStandalone()) {
                this.m_schema_name = this.m_wcontext.dbConnectionInfo.getUsername().toUpperCase();
            } else if (this.m_wcontext.isStandalone()) {
                if (!AdapterWizardContext.IS_STANDALONE_TESTING) {
                    try {
                        this.m_schema_name = this.m_wcontext._connection.getMetaData().getUserName();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
        }
        AQAdapterQueueTreeNode pkgNode = null;
        MessageFormat msgformat = new MessageFormat(this.m_wcontext._bundle.getString("AQ_SL_SCHEMA_QUEUES_NODE"));
        String qnodetext = msgformat.format(new Object[]{this.m_schema_name});
        this.root = new AQAdapterQueueTreeNode(qnodetext, true);
        DefaultTreeModel treeModel = new DefaultTreeModel(this.root);
        this.setModel(treeModel);
        if (this.m_queueType.equals(this.alltype) || this.m_queueType.equals(this.rawtype)) {
            base_query2 = base_query + "and qt.type = 'RAW' ";
            query = base_query2 + "and recipients = 'MULTIPLE'";
            pkgNode = new AQAdapterQueueTreeNode(this.rawtype, true);
            this.root.add(pkgNode);
            nameList = this.queryQueueNameList(query);
            qcnt = nameList.size();
            totalcnt += qcnt;
            pkgNode2 = new AQAdapterQueueTreeNode(this.multiconsume + "(" + qcnt + ")", true);
            pkgNode.add(pkgNode2);
            this.addNodes(pkgNode2, nameList);
            query = base_query2 + "and recipients = 'SINGLE'";
            nameList = this.queryQueueNameList(query);
            qcnt2 = nameList.size();
            totalcnt += qcnt2;
            pkgNode2 = new AQAdapterQueueTreeNode(this.singleconsume + "(" + qcnt2 + ")", true);
            pkgNode.add(pkgNode2);
            this.addNodes(pkgNode2, nameList);
            pkgNode.m_nodetext = this.rawtype + "(" + (qcnt += qcnt2) + ")";
        }
        if (this.m_queueType.equals(this.alltype) || this.m_queueType.equals(this.objtype)) {
            base_query2 = base_query + "and qt.type = 'OBJECT' " + "and qt.object_type not like '%." + "ECXMSG" + "' " + "and qt.object_type not like '%." + "WF_EVENT_T" + "' " + "and qt.object_type not like '%." + "IP_MESSAGE_TYPE" + "' " + "and qt.object_type not like '%." + "AQ$_JMS_" + "%' ";
            query = base_query2 + "and recipients = 'MULTIPLE'";
            nameList = this.queryQueueNameList(query);
            qcnt = nameList.size();
            totalcnt += qcnt;
            pkgNode = new AQAdapterQueueTreeNode(this.objtype, true);
            this.root.add(pkgNode);
            pkgNode2 = new AQAdapterQueueTreeNode(this.multiconsume + "(" + qcnt + ")", true);
            pkgNode.add(pkgNode2);
            this.addNodes(pkgNode2, nameList);
            query = base_query2 + "and recipients = 'SINGLE'";
            nameList = this.queryQueueNameList(query);
            qcnt2 = nameList.size();
            totalcnt += qcnt2;
            pkgNode2 = new AQAdapterQueueTreeNode(this.singleconsume + "(" + qcnt2 + ")", true);
            pkgNode.add(pkgNode2);
            this.addNodes(pkgNode2, nameList);
            pkgNode.m_nodetext = this.objtype + "(" + (qcnt += qcnt2) + ")";
        }
        if (this.m_queueType.equals(this.alltype) || this.m_queueType.equals(this.xgtype)) {
            query = base_query + "and qt.type = 'OBJECT' and qt.object_type like '%." + "ECXMSG" + "' ";
            nameList = this.queryQueueNameList(query);
            qcnt = nameList.size();
            totalcnt += qcnt;
            pkgNode = new AQAdapterQueueTreeNode(this.xgtype + "(" + qcnt + ")", true);
            this.addNodes(pkgNode, nameList);
            this.root.add(pkgNode);
        }
        if (this.m_queueType.equals(this.alltype) || this.m_queueType.equals(this.wfbestype)) {
            query = base_query + "and qt.type = 'OBJECT' and qt.object_type like '%." + "WF_EVENT_T" + "' ";
            nameList = this.queryQueueNameList(query);
            qcnt = nameList.size();
            totalcnt += qcnt;
            pkgNode = new AQAdapterQueueTreeNode(this.wfbestype + "(" + qcnt + ")", true);
            this.addNodes(pkgNode, nameList);
            this.root.add(pkgNode);
        }
        if (this.m_queueType.equals(this.alltype) || this.m_queueType.equals(this.b2btype)) {
            query = base_query + "and qt.type = 'OBJECT' and qt.object_type like '%." + "IP_MESSAGE_TYPE" + "' ";
            nameList = this.queryQueueNameList(query);
            qcnt = nameList.size();
            totalcnt += qcnt;
            pkgNode = new AQAdapterQueueTreeNode(this.b2btype + "(" + qcnt + ")", true);
            this.addNodes(pkgNode, nameList);
            this.root.add(pkgNode);
        }
        if (totalcnt < 25) {
            for (int i = 0; i < this.getRowCount(); ++i) {
                this.expandRow(i);
            }
        } else {
            this.expandRow(0);
        }
    }

    private List queryQueueNameList(String query_in) {
        String query = query_in;
        boolean haveQueueName = false;
        boolean haveObjectName = false;
        ArrayList<String> nameList = new ArrayList<String>();
        ResultSet rs = null;
        if (this.m_queueName != null && this.m_queueName.length() > 0) {
            haveQueueName = true;
            query = query + "and aq.name like ? ";
        }
        if (this.m_objectName != null && this.m_objectName.length() > 0) {
            haveObjectName = true;
            query = query + "and qt.object_type like ? ";
        }
        query = query + "order by aq.name ";
        try {
            PreparedStatement pstmt = this.m_wcontext._connection.prepareStatement(query);
            pstmt.setString(1, this.m_schema_name);
            pstmt.setString(2, this.m_schema_name);
            if (haveQueueName) {
                pstmt.setString(3, this.m_queueName);
                if (haveObjectName) {
                    pstmt.setString(4, this.m_objectName);
                }
            } else if (haveObjectName) {
                pstmt.setString(3, this.m_objectName);
            }
            rs = pstmt.executeQuery();
            while (rs.next()) {
                nameList.add(rs.getString("NAME"));
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException sqlex) {
            sqlex.printStackTrace();
            MessageFormat msgformat = new MessageFormat(this.m_wcontext._bundle.getString("AQ_SL_SQL_SCHEMA_ERROR_MSG"));
            Object[] obj = new Object[]{sqlex.getLocalizedMessage()};
            MultiLineOptionPane.showMessageDialog((Component)this.m_wcontext._parentFrame, (Object)msgformat.format(obj), (String)this.m_wcontext._bundle.getString("CM_WZ_SQL_EXCEPTION_TITLE"), (int)0);
        }
        return nameList;
    }

    private void addNodes(AQAdapterQueueTreeNode pkgNode, List nameList) {
        int ncnt = nameList.size();
        for (int ii = 0; ii < ncnt; ++ii) {
            pkgNode.add(new AQAdapterQueueTreeNode((String)nameList.get(ii), false));
        }
    }

    public String getTranslatedString(String messageKey) {
        return this.m_wcontext._bundle.getString(messageKey);
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        AQAdapterQueueTreeNode dmtnode = (AQAdapterQueueTreeNode)this.getLastSelectedPathComponent();
        if (dmtnode == null) {
            return;
        }
        if (dmtnode.isHeader()) {
            this.m_currdiag.setOKButtonEnabled(false);
        } else {
            this.m_currdiag.setOKButtonEnabled(true);
        }
    }
}

