/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.aq;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Operation;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.xml.namespace.QName;
import oracle.bali.ewt.event.Cancelable;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.ewt.wizard.ImageWizardPage;
import oracle.bali.ewt.wizard.WizardEvent;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Project;
import oracle.tip.tools.ide.common.ui.NCNameField;
import oracle.tip.tools.ide.fabric.api.WsdlInfo;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.AdapterWizardContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.aq.AQAdapterContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.aq.AQAdapterObjectPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.aq.AQAdapterParameterPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.aq.AQAdapterQueueNamePage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.aq.AQAdapterSchemaPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.file.FileAdapterOperationPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.techAdapterWizardPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.wsdl.JcaBinding;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.wsdl.JcaOperation;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.wsdl.PCInboundBinding;

public class AQAdapterOperationPage
extends techAdapterWizardPage
implements ActionListener,
DocumentListener {
    ButtonGroup group = new ButtonGroup();
    private MultiLineLabel introPrompt;
    private JLabel operationTypePrompt = new JLabel();
    private JRadioButton dequeueRB = new JRadioButton();
    private JRadioButton enqueueRB = new JRadioButton();
    private JRadioButton enqDequeueRB = new JRadioButton();
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private JLabel operationNamePrompt = new JLabel();
    private NCNameField operationName = new NCNameField();
    private JLabel operationName2Prompt = new JLabel();
    private NCNameField operationName2 = new NCNameField();
    private JPanel spacerPanel = new JPanel();
    private AQAdapterContext aqcontext = null;

    public AQAdapterOperationPage(AdapterWizardContext wcontext, ImageWizardPage iwp) {
        try {
            this.setContextAndPage(wcontext, iwp);
            this.aqcontext = (AQAdapterContext)this.m_wcontext._ascontext;
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        String intro = this.getTranslatedString("AQ_OP_INTRO_PROMPT");
        String opprompt = this.getTranslatedString("AQ_OP_OPERATION_TYPE_PROMPT");
        String dequeueRBtext = this.getTranslatedString("AQ_OP_DEQUEUE_BUTTON");
        String dequeueTip = this.getTranslatedString("AQ_OP_DEQUEUE_TIP");
        String enqueueRBtext = this.getTranslatedString("AQ_OP_ENQUEUE_BUTTON");
        String enqueueTip = this.getTranslatedString("AQ_OP_ENQUEUE_TIP");
        String enqDequeueRBtext = this.getTranslatedString("AQ_OP_ENQDEQ_BUTTON");
        String enqDequeueTip = this.getTranslatedString("AQ_OP_ENQDEQ_TIP");
        String opname = this.getTranslatedString("AQ_OP_OPERATION_NAME_PROMPT");
        String opnameTip = this.getTranslatedString("AQ_OP_OPERATION_NAME_TIP");
        String opname2 = this.getTranslatedString("AQ_OP_OPERATION_DEQ_PROMPT");
        String opname2Tip = this.getTranslatedString("AQ_OP_OPERATION_NAME_TIP");
        if (this.aqcontext._isOracleAppsAdapter) {
            if (this.aqcontext._OAspecialType == null) {
                intro = this.getTranslatedString("AQ_OP_INTRO_PROMPT_OA_CUSTOM_QUEUE");
            } else if (this.aqcontext._OAspecialType.equals("ECXMSG")) {
                intro = this.getTranslatedString("AQ_OP_INTRO_PROMPT_OA_XMLGATEWAY");
            } else if (this.aqcontext._OAspecialType.equals("WF_EVENT_T")) {
                intro = this.getTranslatedString("AQ_OP_INTRO_PROMPT_OA_WFBES");
            }
        }
        this.setLayout(this.gridBagLayout1);
        this.introPrompt = new MultiLineLabel(WordWrapper.getTextWrapper(), intro);
        this.operationTypePrompt.setText(opprompt);
        this.operationTypePrompt.setLabelFor(this.dequeueRB);
        this.dequeueRB.setText(StringUtils.stripMnemonic((String)dequeueRBtext));
        this.dequeueRB.setMnemonic(StringUtils.getMnemonicKeyCode((String)dequeueRBtext));
        this.dequeueRB.setToolTipText(dequeueTip);
        this.dequeueRB.getAccessibleContext().setAccessibleDescription(dequeueTip);
        this.dequeueRB.getAccessibleContext().setAccessibleName(dequeueRBtext);
        this.enqueueRB.setText(StringUtils.stripMnemonic((String)enqueueRBtext));
        this.enqueueRB.setMnemonic(StringUtils.getMnemonicKeyCode((String)enqueueRBtext));
        this.enqueueRB.setToolTipText(enqueueTip);
        this.enqueueRB.getAccessibleContext().setAccessibleDescription(enqueueTip);
        this.enqueueRB.getAccessibleContext().setAccessibleName(enqueueRBtext);
        this.enqDequeueRB.setText(StringUtils.stripMnemonic((String)enqDequeueRBtext));
        this.enqDequeueRB.setMnemonic(StringUtils.getMnemonicKeyCode((String)enqDequeueRBtext));
        this.enqDequeueRB.setToolTipText(enqDequeueTip);
        this.enqDequeueRB.getAccessibleContext().setAccessibleDescription(enqDequeueTip);
        this.enqDequeueRB.getAccessibleContext().setAccessibleName(enqDequeueRBtext);
        this.operationNamePrompt.setText(StringUtils.stripMnemonic((String)opname));
        this.operationNamePrompt.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)opname));
        this.operationNamePrompt.setLabelFor((Component)this.operationName);
        this.operationName.setToolTipText(opnameTip);
        this.operationName.getAccessibleContext().setAccessibleDescription(opnameTip);
        this.operationName.getAccessibleContext().setAccessibleName(opname);
        this.operationName.getDocument().addDocumentListener(this);
        this.operationName2Prompt.setText(StringUtils.stripMnemonic((String)opname2));
        this.operationName2Prompt.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)opname2));
        this.operationName2Prompt.setLabelFor((Component)this.operationName2);
        this.operationName2.setToolTipText(opname2Tip);
        this.operationName2.getAccessibleContext().setAccessibleDescription(opname2Tip);
        this.operationName2.getAccessibleContext().setAccessibleName(opname2);
        this.operationName2.getDocument().addDocumentListener(this);
        this.add((Component)this.introPrompt, new GridBagConstraints(0, 0, 0, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.operationTypePrompt, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(30, 0, 5, 0), 0, 0));
        this.add((Component)this.dequeueRB, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 16, 0, new Insets(0, 12, 0, 0), 0, 0));
        this.add((Component)this.enqueueRB, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 12, 0, 0), 0, 0));
        this.add((Component)this.enqDequeueRB, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 12, 0, 0), 0, 0));
        this.add((Component)this.operationNamePrompt, new GridBagConstraints(0, 6, 1, 1, 0.0, 1.0, 18, 0, new Insets(20, 0, 0, 0), 0, 0));
        this.add((Component)this.operationName, new GridBagConstraints(1, 6, 1, 1, 1.0, 0.0, 18, 2, new Insets(20, 12, 0, 0), 0, 0));
        this.add((Component)this.operationName2Prompt, new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.add((Component)this.operationName2, new GridBagConstraints(1, 7, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 12, 0, 0), 0, 0));
        this.add((Component)this.spacerPanel, new GridBagConstraints(0, 8, 0, 0, 0.0, 10.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.group.add(this.dequeueRB);
        this.group.add(this.enqueueRB);
        this.group.add(this.enqDequeueRB);
        this.dequeueRB.addActionListener(this);
        this.enqueueRB.addActionListener(this);
        this.enqDequeueRB.addActionListener(this);
        this.operationName.setText(null);
        this.operationName2Prompt.setVisible(false);
        this.operationName2.setVisible(false);
        this.m_page.setInitialFocus((Component)this.dequeueRB);
        this.m_page.setCanAdvance(false);
        if (this.m_wcontext._read_service != null) {
            JcaOperation jop = this.m_wcontext._read_jca_operation;
            this.operationName.setText(this.m_wcontext._read_operation_name);
            this.m_page.setCanAdvance(true);
            String uiTransPrimitive = this.getUITransmissionPrimitiveFromWSDL();
            if (uiTransPrimitive != null) {
                if (uiTransPrimitive.equals("Request-response")) {
                    this.aqcontext.initFromWSDLMultiOp(this.m_wcontext);
                    this.enqDequeueRB.setSelected(true);
                    this.operationName2.setText(this.aqcontext.inboundOperation.getName());
                    this.operationName2Prompt.setVisible(true);
                    this.operationName2.setVisible(true);
                    this.setCommonPagesForDequeueAndEnqueue();
                }
            } else if (this.m_wcontext._isInboundOperation) {
                this.dequeueRB.setSelected(true);
                this.setPagesForDequeueOperation();
            } else {
                this.enqueueRB.setSelected(true);
                this.setPagesForEnqueueOperation();
            }
            this.disableAllControls();
            String tempstr = jop.getAttributeValue("QueueName");
            tempstr = jop.getAttributeValue("DatabaseSchema");
            tempstr = jop.getAttributeValue("ObjectFieldName");
            tempstr = jop.getAttributeValue("PayloadHeaderRequired");
            tempstr = jop.getAttributeValue("SchemaValidation");
            if (this.m_wizard.getCurrentPageIndex() == 0) {
                this.wizardValidatePage(null);
            }
        }
        if (this.m_wcontext._importedWsdlInfo != null) {
            this.operationName.setText(this.m_wcontext._write_operation_name);
            this.operationName.setEditable(false);
            this.setOperationTypeForExistingWSDL();
        }
    }

    private void setOperationTypeForExistingWSDL() {
        if (this.m_wcontext._importedWsdlInfo != null) {
            if (this.m_wcontext._importedWsdlInfo.getReplyPorttype() != null) {
                this.enqDequeueRB.setSelected(true);
                this.enqueueRB.setEnabled(false);
                this.dequeueRB.setEnabled(false);
                this.m_wcontext._isInboundOperation = false;
                this.aqcontext._isEnqueueDequeue = true;
                AQAdapterContext.direction = "Both";
                this.operationName.setText(this.m_wcontext._write_operation_name);
                this.operationName2Prompt.setVisible(true);
                this.operationName2.setVisible(true);
                this.operationName2.setEditable(false);
                this.operationName2.setText(this.m_wcontext._write_operation2_name);
                this.operationNamePrompt.setText(StringUtils.stripMnemonic((String)this.getTranslatedString("AQ_OP_OPERATION_ENQ_PROMPT")));
                this.operationNamePrompt.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)this.getTranslatedString("AQ_OP_OPERATION_ENQ_PROMPT")));
                this.setCommonPagesForDequeueAndEnqueue();
            } else {
                this.enqDequeueRB.setEnabled(false);
                this.enqueueRB.setEnabled(true);
                this.dequeueRB.setEnabled(true);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String tempOpName = this.operationName.getText().trim();
        this.removePages();
        this.m_page.setCanAdvance(true);
        if (e.getSource() == this.dequeueRB) {
            this.operationName2Prompt.setVisible(false);
            this.operationName2.setVisible(false);
            this.operationNamePrompt.setText(StringUtils.stripMnemonic((String)this.getTranslatedString("AQ_OP_OPERATION_NAME_PROMPT")));
            this.operationNamePrompt.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)this.getTranslatedString("AQ_OP_OPERATION_NAME_PROMPT")));
            this.m_wcontext._isInboundOperation = true;
            this.aqcontext._isEnqueueDequeue = false;
            AQAdapterContext.direction = "Outbound";
            if (tempOpName == null || tempOpName.length() == 0) {
                this.operationName.setText(this.getTranslatedString("AQ_OP_NAME_DEQUEUE_SUFFIX"));
            } else if (this.m_wcontext._read_service == null && this.m_wcontext._importedWsdlInfo == null) {
                this.operationName.setText(FileAdapterOperationPage.updateOperationName(tempOpName, this.getTranslatedString("AQ_OP_NAME_ENQUEUE_SUFFIX"), "%%**", this.getTranslatedString("AQ_OP_NAME_DEQUEUE_SUFFIX")));
            }
            this.setPagesForDequeueOperation();
        } else if (e.getSource() == this.enqueueRB) {
            this.operationName2Prompt.setVisible(false);
            this.operationName2.setVisible(false);
            this.operationNamePrompt.setText(StringUtils.stripMnemonic((String)this.getTranslatedString("AQ_OP_OPERATION_NAME_PROMPT")));
            this.operationNamePrompt.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)this.getTranslatedString("AQ_OP_OPERATION_NAME_PROMPT")));
            this.m_wcontext._isInboundOperation = false;
            this.aqcontext._isEnqueueDequeue = false;
            AQAdapterContext.direction = "Inbound";
            if (tempOpName == null || tempOpName.length() == 0) {
                this.operationName.setText(this.getTranslatedString("AQ_OP_NAME_ENQUEUE_SUFFIX"));
            } else if (this.m_wcontext._read_service == null && this.m_wcontext._importedWsdlInfo == null) {
                this.operationName.setText(FileAdapterOperationPage.updateOperationName(tempOpName, this.getTranslatedString("AQ_OP_NAME_DEQUEUE_SUFFIX"), "%%**", this.getTranslatedString("AQ_OP_NAME_ENQUEUE_SUFFIX")));
            }
            this.setPagesForEnqueueOperation();
        } else {
            this.m_wcontext._isInboundOperation = false;
            this.aqcontext._isEnqueueDequeue = true;
            AQAdapterContext.direction = "Both";
            this.operationName.setText(this.getTranslatedString("AQ_OP_NAME_ENQUEUE_SUFFIX"));
            this.operationName2Prompt.setVisible(true);
            this.operationName2.setVisible(true);
            this.operationName2.setText(this.getTranslatedString("AQ_OP_NAME_DEQUEUE_SUFFIX"));
            this.operationNamePrompt.setText(StringUtils.stripMnemonic((String)this.getTranslatedString("AQ_OP_OPERATION_ENQ_PROMPT")));
            this.operationNamePrompt.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)this.getTranslatedString("AQ_OP_OPERATION_ENQ_PROMPT")));
            this.setCommonPagesForDequeueAndEnqueue();
        }
    }

    private void setPagesForDequeueOperation() {
        this.setCommonPagesForDequeueAndEnqueue();
    }

    private void setPagesForEnqueueOperation() {
        this.setCommonPagesForDequeueAndEnqueue();
    }

    private void setCommonPagesForDequeueAndEnqueue() {
        if (!this.aqcontext._isOracleAppsAdapter || this.aqcontext._OAspecialType == null) {
            ImageWizardPage tempwp = new ImageWizardPage(null, this._getImage(), this.getTranslatedString("AQ_SL_QUEUE_NAME_PAGE_TITLE"));
            if (!AdapterWizardContext.IS_STANDALONE_TESTING && !this.m_wcontext.isStandalone()) {
                if (this.aqcontext._isEnqueueDequeue) {
                    HelpSystem.getHelpSystem().registerTopic((JComponent)tempwp.getContent(), "bpmjdev_adp_wiz_aq_enqdeq");
                } else {
                    HelpSystem.getHelpSystem().registerTopic((JComponent)tempwp.getContent(), "bpmjdev_adp_wiz_aq_qname");
                }
            }
            AQAdapterQueueNamePage aQAdapterQueueNamePage = new AQAdapterQueueNamePage(this.m_wcontext, tempwp);
        }
        this.addFinishPage();
    }

    private void disableAllControls() {
        this.dequeueRB.setEnabled(false);
        this.enqueueRB.setEnabled(false);
        this.enqDequeueRB.setEnabled(false);
        this.operationName.setEditable(false);
        this.operationName2.setEditable(false);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.checkDoc(e);
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.checkDoc(e);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.checkDoc(e);
    }

    private void checkDoc(DocumentEvent e) {
        String tempstr = this.operationName.getText().trim();
        if (tempstr != null && tempstr.length() > 0 && this.isOperationSelected()) {
            this.m_page.setCanAdvance(true);
        } else {
            this.m_page.setCanAdvance(false);
        }
    }

    private boolean isOperationSelected() {
        return this.dequeueRB.isSelected() || this.enqueueRB.isSelected() || this.enqDequeueRB.isSelected();
    }

    @Override
    public void wizardValidatePage(WizardEvent event) {
        this.m_wcontext._wizard.setCursor(new Cursor(3));
        if (this.aqcontext._isOracleAppsAdapter) {
            boolean ok;
            if (this.aqcontext._OAspecialType == null) {
                return;
            }
            if (this.aqcontext._OAspecialType.equals("ECXMSG")) {
                this.aqcontext._queue_schema_name = AQAdapterContext.OA_QUEUE_NAME_XML_GATEWAY_SCHEMA;
                this.aqcontext._queue_name = this.m_wcontext._isInboundOperation ? "ECX_OUTBOUND" : "ECX_INBOUND";
            }
            if (this.aqcontext._OAspecialType.equals("WF_EVENT_T")) {
                this.aqcontext._queue_schema_name = "APPLSYS";
                this.aqcontext._queue_name = this.m_wcontext._isInboundOperation ? "WF_OUT" : "WF_IN";
            }
            if (!(ok = AQAdapterQueueNamePage.queryQueueForProperties(this.m_wcontext, this.aqcontext))) {
                this.m_wcontext._wizard.setCursor(new Cursor(0));
                ((Cancelable)event).cancel();
                return;
            }
            this.removePages();
            ImageWizardPage tempwp = null;
            if (this.aqcontext._OAspecialType.equals("WF_EVENT_T")) {
                tempwp = new ImageWizardPage(null, this._getImage(), this.getTranslatedString("AQ_QP_PARAMETER_PAGE_TITLE"));
                if (!AdapterWizardContext.IS_STANDALONE_TESTING && !this.m_wcontext.isStandalone()) {
                    HelpSystem.getHelpSystem().registerTopic((JComponent)tempwp.getContent(), "bpmjdev_adp_wiz_aq_qparam");
                }
                AQAdapterParameterPage dsp4 = new AQAdapterParameterPage(this.m_wcontext, tempwp);
            }
            tempwp = new ImageWizardPage(null, this._getImage(), this.getTranslatedString("FA_SC_TITLE"));
            if (!AdapterWizardContext.IS_STANDALONE_TESTING && !this.m_wcontext.isStandalone()) {
                HelpSystem.getHelpSystem().registerTopic((JComponent)tempwp.getContent(), "bpmjdev_adp_wiz_message");
            }
            AQAdapterSchemaPage dsp3 = new AQAdapterSchemaPage(this.m_wcontext, tempwp);
            this.addFinishPage();
        }
        this.m_wcontext._wizard.setCursor(new Cursor(0));
    }

    @Override
    public void buildWSDL() throws WSDLException, Exception {
        JcaOperation jop = null;
        if (this.aqcontext._isOracleAppsAdapter) {
            this.createCommonOperationObjects(this.operationName.getText().trim());
            jop = this.m_wcontext._write_jca_operation;
            if (this.aqcontext._OAspecialType == null) {
                if (this.m_wcontext._isInboundOperation) {
                    jop.setAttributeValue("ActivationSpec", "oracle.tip.adapter.apps.AppsCustomQueueDequeueActivationSpec");
                } else {
                    jop.setAttributeValue("InteractionSpec", "oracle.tip.adapter.apps.AppsCustomQueueEnqueueInteractionSpec");
                }
            } else if (this.aqcontext._OAspecialType.equals("ECXMSG")) {
                if (this.m_wcontext._isInboundOperation) {
                    jop.setAttributeValue("ActivationSpec", "oracle.tip.adapter.apps.AppsXMLGatewayDequeueActivationSpec");
                } else {
                    jop.setAttributeValue("InteractionSpec", "oracle.tip.adapter.apps.AppsXMLGatewayEnqueueInteractionSpec");
                }
            } else if (this.aqcontext._OAspecialType.equals("WF_EVENT_T")) {
                if (this.m_wcontext._isInboundOperation) {
                    jop.setAttributeValue("ActivationSpec", "oracle.tip.adapter.apps.AppsWFBesQueueDequeueActivationSpec");
                } else {
                    jop.setAttributeValue("InteractionSpec", "oracle.tip.adapter.apps.AppsWFBesQueueEnqueueInteractionSpec");
                }
            }
            if (this.aqcontext._OAspecialType != null) {
                String[] xmlSchemaInfo = AQAdapterObjectPage.generateAdtSchema(this.m_wcontext);
                AQAdapterObjectPage.generatePayloadHeaderSchema(this.m_wcontext, xmlSchemaInfo);
            }
        } else if (this.enqueueRB.isSelected() || this.dequeueRB.isSelected()) {
            this.createCommonOperationObjects(this.operationName.getText().trim());
            jop = this.m_wcontext._write_jca_operation;
            if (this.m_wcontext._isInboundOperation) {
                jop.setAttributeValue("ActivationSpec", "oracle.tip.adapter.aq.inbound.AQDequeueActivationSpec");
            } else {
                jop.setAttributeValue("InteractionSpec", "oracle.tip.adapter.aq.outbound.AQEnqueueInteractionSpec");
            }
        } else if (this.enqDequeueRB.isSelected()) {
            this.createEnqDequeueOperationObjects();
        }
        if (this.aqcontext._isOracleAppsAdapter && this.aqcontext._OAspecialType != null) {
            jop.setAttributeValue("QueueName", this.aqcontext._queue_name);
            if (!this.aqcontext._schemaIsDefault) {
                jop.setAttributeValue("DatabaseSchema", this.aqcontext._queue_schema_name);
            }
            if (this.aqcontext._payloadField != null) {
                jop.setAttributeValue("ObjectFieldName", this.aqcontext._payloadField);
            }
        }
    }

    private void createEnqDequeueOperationObjects() throws WSDLException {
        String inboundPortTypeName = null;
        PortType inboundPortType = null;
        String outboundPortTypeName = null;
        PortType outboundPortType = null;
        if (this.m_wcontext._importedWsdlInfo != null) {
            outboundPortTypeName = this.m_wcontext._importedWsdlInfo.getRequestPorttype().getLocalPart();
            outboundPortType = WsdlInfo.getPorttypeByQname((Project)this.m_wcontext._project, (QName)this.m_wcontext._importedWsdlInfo.getRequestPorttype());
            inboundPortTypeName = this.m_wcontext._importedWsdlInfo.getReplyPorttype().getLocalPart();
            inboundPortType = WsdlInfo.getPorttypeByQname((Project)this.m_wcontext._project, (QName)this.m_wcontext._importedWsdlInfo.getReplyPorttype());
        } else {
            inboundPortTypeName = "Dequeue" + this.m_wcontext.PortType_suffix;
            inboundPortType = this.createPortType(inboundPortTypeName);
            outboundPortTypeName = "Enqueue" + this.m_wcontext.PortType_suffix;
            outboundPortType = this.createPortType(outboundPortTypeName);
        }
        this.createWSDLBindingsForEnqDeqAsync(inboundPortType, outboundPortType, this.operationName2.getText().trim(), this.operationName.getText().trim(), "Request-response");
        this.createPartnerLinkType(this.operationName2.getText().trim(), this.operationName.getText().trim(), inboundPortType, outboundPortType);
        JcaOperation jop = this.aqcontext.outboundJcaOperation;
        jop.setAttributeValue("InteractionSpec", "oracle.tip.adapter.aq.outbound.AQEnqueueInteractionSpec");
        jop = this.aqcontext.inboundJcaOperation;
        jop.setAttributeValue("ActivationSpec", "oracle.tip.adapter.aq.inbound.AQDequeueActivationSpec");
    }

    public void createWSDLBindingsForEnqDeqAsync(PortType inboundPortType, PortType outboundPortType, String inboundOperationName, String outboundOperationName, String uiTransmissionPrimitive) throws WSDLException {
        this.m_wcontext._write_definition.addNamespace(AdapterWizardContext.PC_NAMESPACE, AdapterWizardContext.PC_NAMESPACE_URI);
        Definition def = this.m_wcontext._write_definition;
        Service service = this.m_wcontext._write_service;
        Operation inboundOp = null;
        if (this.m_wcontext._importedWsdlInfo == null) {
            inboundOp = def.createOperation();
            inboundOp.setName(inboundOperationName);
            inboundOp.setUndefined(false);
            inboundPortType.addOperation(inboundOp);
        } else {
            inboundOp = inboundPortType.getOperation(inboundOperationName, null, null);
        }
        this.aqcontext.inboundOperation = inboundOp;
        Binding inboundBinding = def.createBinding();
        inboundBinding.setPortType(inboundPortType);
        inboundBinding.setQName(new QName(this.m_wcontext._target_namespace, inboundOperationName + this.m_wcontext.Binding_suffix));
        inboundBinding.setUndefined(false);
        def.addBinding(inboundBinding);
        PCInboundBinding pcib = (PCInboundBinding)this.m_wcontext._extReg.createExtension(PCInboundBinding.PARENT_CLASS, PCInboundBinding.FIELD_ELEMENT_TYPE);
        pcib.setAttributeValue("UITransmissionPrimitive", uiTransmissionPrimitive);
        inboundBinding.addExtensibilityElement((ExtensibilityElement)pcib);
        BindingOperation inboundBindingOp = def.createBindingOperation();
        inboundBindingOp.setName(inboundOperationName);
        inboundBinding.addBindingOperation(inboundBindingOp);
        this.m_wcontext._write_operation_physical = inboundBindingOp;
        JcaOperation injop = (JcaOperation)this.m_wcontext._extReg.createExtension(JcaOperation.PARENT_CLASS, JcaOperation.FIELD_ELEMENT_TYPE);
        this.m_wcontext._write_operation_physical.addExtensibilityElement((ExtensibilityElement)injop);
        this.aqcontext.inboundJcaOperation = injop;
        Port inPort = this.m_wcontext._write_port;
        inPort.setName(inboundOperationName + this.m_wcontext.Port_suffix);
        inPort.setBinding(inboundBinding);
        Operation outboundOp = null;
        if (this.m_wcontext._importedWsdlInfo == null) {
            outboundOp = def.createOperation();
            outboundOp.setName(outboundOperationName);
            outboundOp.setUndefined(false);
            outboundPortType.addOperation(outboundOp);
        } else {
            outboundOp = outboundPortType.getOperation(outboundOperationName, null, null);
        }
        this.aqcontext.outboundOperation = outboundOp;
        Binding outboundBinding = def.createBinding();
        outboundBinding.setPortType(outboundPortType);
        outboundBinding.setQName(new QName(this.m_wcontext._target_namespace, outboundOperationName + this.m_wcontext.Binding_suffix));
        outboundBinding.setUndefined(false);
        def.addBinding(outboundBinding);
        JcaBinding jcaBinding = (JcaBinding)this.m_wcontext._extReg.createExtension(JcaBinding.PARENT_CLASS, JcaBinding.FIELD_ELEMENT_TYPE);
        jcaBinding.setAttributeValue("UITransmissionPrimitive", uiTransmissionPrimitive);
        outboundBinding.addExtensibilityElement((ExtensibilityElement)jcaBinding);
        BindingOperation outboundBindingOp = def.createBindingOperation();
        outboundBindingOp.setName(outboundOperationName);
        outboundBinding.addBindingOperation(outboundBindingOp);
        this.m_wcontext._write_operation_physical = outboundBindingOp;
        JcaOperation outjop = (JcaOperation)this.m_wcontext._extReg.createExtension(JcaOperation.PARENT_CLASS, JcaOperation.FIELD_ELEMENT_TYPE);
        this.m_wcontext._write_operation_physical.addExtensibilityElement((ExtensibilityElement)outjop);
        this.aqcontext.outboundJcaOperation = outjop;
        Port outPort = def.createPort();
        outPort.setName(outboundOperationName + this.m_wcontext.Port_suffix);
        outPort.setBinding(outboundBinding);
        service.addPort(outPort);
        this.m_wcontext._write_port2 = outPort;
        this.m_wcontext._write_port2.addExtensibilityElement((ExtensibilityElement)this.m_wcontext._write_jca_address);
    }

    private String getUITransmissionPrimitiveFromWSDL() {
        String uiTransmissionPrimitive = null;
        Definition def = this.m_wcontext._read_definition;
        Map bindings = def.getBindings();
        for (Binding bind : bindings.values()) {
            List bext = bind.getExtensibilityElements();
            for (Object ext : bext) {
                if (ext instanceof JcaBinding) {
                    JcaBinding jbind = (JcaBinding)ext;
                    uiTransmissionPrimitive = jbind.getAttributeValue("UITransmissionPrimitive");
                } else if (ext instanceof PCInboundBinding) {
                    PCInboundBinding pcbind = (PCInboundBinding)ext;
                    uiTransmissionPrimitive = pcbind.getAttributeValue("UITransmissionPrimitive");
                }
                if (uiTransmissionPrimitive == null || uiTransmissionPrimitive.trim().equals("")) continue;
                return uiTransmissionPrimitive;
            }
        }
        return uiTransmissionPrimitive;
    }
}

