/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.aq;

import java.util.Vector;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.AdapterWizardContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.aq.AQAdapterContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.aq.metadata.AdtNode;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.aq.metadata.Attribute;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.aq.metadata.DbObjectNode;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.aq.metadata.PrimitiveNode;

public class AQAdapterFieldTree
extends JTree
implements TreeSelectionListener {
    AdapterWizardContext m_wcontext;
    AQAdapterContext aqcontext;
    DefaultMutableTreeNode root;
    JEWTDialog m_currdiag;

    public AQAdapterFieldTree(AdapterWizardContext wcontext, DbObjectNode dbnode, JEWTDialog curdiag) {
        this.m_wcontext = wcontext;
        this.aqcontext = (AQAdapterContext)this.m_wcontext._ascontext;
        this.m_currdiag = curdiag;
        this.addTreeSelectionListener(this);
        this.setVisible(true);
        this.setShowsRootHandles(true);
        if (dbnode != null) {
            this.createNodes(dbnode);
        }
    }

    protected void createNodes(DbObjectNode dbnode) {
        int i;
        Object pkgNode = null;
        String fnodetext = ((AdtNode)dbnode).getFullType();
        this.root = new DefaultMutableTreeNode(fnodetext);
        DefaultTreeModel treeModel = new DefaultTreeModel(this.root);
        this.setModel(treeModel);
        AdtNode adtn = (AdtNode)dbnode;
        Vector attrs = adtn.getAttributes();
        Vector XMLattrs = adtn.getPossibleXMLContainerAttributes();
        for (i = 0; i < attrs.size(); ++i) {
            Attribute attr = (Attribute)attrs.elementAt(i);
            DbObjectNode dbnode2 = attr.getDbObjectNode();
            if (dbnode2 instanceof PrimitiveNode && !XMLattrs.contains(attr)) continue;
            this.addNodes(this.root, attr);
        }
        for (i = 0; i < 25; ++i) {
            this.expandRow(i);
        }
    }

    private void addNodes(DefaultMutableTreeNode pkgNode, Attribute attr) {
        DbObjectNode dbnode = attr.getDbObjectNode();
        DefaultMutableTreeNode new_pkgNode = new DefaultMutableTreeNode(attr);
        pkgNode.add(new_pkgNode);
        if (!(dbnode instanceof PrimitiveNode)) {
            AdtNode adtn = (AdtNode)dbnode;
            Vector attrs = adtn.getAttributes();
            Vector XMLattrs = adtn.getPossibleXMLContainerAttributes();
            for (int i = 0; i < attrs.size(); ++i) {
                Attribute next_attr = (Attribute)attrs.elementAt(i);
                if (next_attr.isPrimitive() && !XMLattrs.contains(next_attr)) continue;
                this.addNodes(new_pkgNode, next_attr);
            }
        }
    }

    public String getTranslatedString(String messageKey) {
        return this.m_wcontext._bundle.getString(messageKey);
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        DefaultMutableTreeNode dmtnode = (DefaultMutableTreeNode)this.getLastSelectedPathComponent();
        if (dmtnode == null) {
            return;
        }
        Object uobj = dmtnode.getUserObject();
        if (!(uobj instanceof Attribute)) {
            this.m_currdiag.setOKButtonEnabled(false);
            return;
        }
        Attribute attr = (Attribute)uobj;
        DbObjectNode dbnode = attr.getDbObjectNode();
        if (dbnode instanceof PrimitiveNode) {
            this.m_currdiag.setOKButtonEnabled(true);
        } else {
            System.out.println(dbnode.getType());
            if ("XMLTYPE".equals(dbnode.getType())) {
                this.m_currdiag.setOKButtonEnabled(true);
            } else {
                this.m_currdiag.setOKButtonEnabled(false);
            }
        }
    }
}

