/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.util;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.tip.tools.ide.common.utils.MultiLineOptionPane;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.util.IREPExtractor;

class IRepExtractorGUI
extends JDialog
implements WindowListener {
    HashMap properties;
    private JProgressBar progressBar;
    private boolean isTaskDone = false;
    protected IRepExtractorGUI progressBarDialog;
    private MultiLineLabel progressLabel;
    private Thread worker = null;
    private Frame parentFrame;
    JButton cancelB = new JButton("Cancel");

    public IRepExtractorGUI(HashMap properties, JFrame f) {
        super(f, "IRepExtractor", true);
        this.parentFrame = f;
        this.properties = properties;
        this.progressBarDialog = this;
        this.init();
    }

    public void init() {
        String processingText = "Extracting irep data file..";
        GridBagLayout gridBagLayout = new GridBagLayout();
        JPanel panel = new JPanel();
        panel.setLayout(gridBagLayout);
        panel.setSize(400, 500);
        this.progressLabel = new MultiLineLabel(processingText);
        this.progressBar = new JProgressBar();
        this.progressBar.setIndeterminate(true);
        panel.add((Component)this.progressLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 2, new Insets(15, 20, 20, 20), 0, 0));
        panel.add((Component)this.progressBar, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 20, 20, 20), 0, 0));
        this.setContentPane(panel);
        this.centerWindow();
        this.setModal(false);
        this.runThread();
        if (!this.isTaskDone) {
            this.pack();
            this.setVisible(true);
        }
    }

    private void centerWindow() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = this.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        this.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
    }

    private void runThread() {
        this.worker = new Thread(new Runnable(){

            @Override
            public void run() {
                String driver = (String)IRepExtractorGUI.this.properties.get("DRIVER");
                String dburl = (String)IRepExtractorGUI.this.properties.get("DBURL");
                String user = (String)IRepExtractorGUI.this.properties.get("USER");
                String passwd = (String)IRepExtractorGUI.this.properties.get("PASSWD");
                String outdir = (String)IRepExtractorGUI.this.properties.get("OUTDIR");
                String database = (String)IRepExtractorGUI.this.properties.get("DATABASE");
                try {
                    IREPExtractor.invoke(driver, dburl, user, passwd, outdir, database);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    MultiLineOptionPane.showMessageDialog((Component)IRepExtractorGUI.this.progressBarDialog, (Object)("Irep data file creation failed due to :\n" + e.getMessage()), (String)"", (int)0);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    MultiLineOptionPane.showMessageDialog((Component)IRepExtractorGUI.this.parentFrame, (Object)("Irep data file creation failed due to :\n" + e.getMessage()), (String)"", (int)0);
                }
                IRepExtractorGUI.this.isTaskDone = true;
                String msg = "Successfully created and stored " + IREPExtractor.outfile + " corresponding to database " + database + " at " + outdir;
                MultiLineOptionPane.showMessageDialog((Component)IRepExtractorGUI.this.parentFrame, (Object)msg, (String)"IRep data file created");
                IRepExtractorGUI.this.worker = null;
                IRepExtractorGUI.this.progressBarDialog.dispose();
            }
        });
        this.worker.start();
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        if (this.worker != null && !this.isTaskDone) {
            int value = JOptionPane.showConfirmDialog(this.parentFrame, "Irep data file creation is not complete yet.\nAre you sure you want to abort the operation?", "Operation interrupted", 0, 2);
            if (value == 0) {
                this.worker.interrupt();
            } else {
                return;
            }
        }
        this.worker = null;
        this.dispose();
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }
}

