/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.util;

import com.sun.org.apache.xml.internal.serialize.OutputFormat;
import com.sun.org.apache.xml.internal.serialize.XMLSerializer;
import java.io.File;
import java.io.FileWriter;
import java.net.URL;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import oracle.jdbc.driver.OracleDriver;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.common.AppsAdapterContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.common.ConnectionPool;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.common.DBAccess;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.util.DbProcArgument;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.util.GenericNode;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.util.IrepProcArgument;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.util.MiscCPThread;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.util.MiscViewThread;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.util.PLSQLPackageThread;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.util.XMLGThread;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public final class IREPExtractor {
    private static String addProductFamilies_q;
    private static String addProducts_q;
    private static String addEntities_q;
    private static String addXMLG_q;
    private static String addPLSQL_q;
    private static String addProcedure_q;
    private static String isOverloaded_q;
    private static String addParameters_q;
    private static String addOpenInterfaces_q;
    private static String addInterfaceCP_q;
    private static String addInterfaceTable_q;
    private static String addInterfaceView_q;
    private static String addStandaloneCP_q;
    private static String addStandaloneView_q;
    private static String getIrepProcArgs_q;
    private static String getDbProcArgs_q;
    private static PreparedStatement getIrepProcArgs_ps;
    private static PreparedStatement getDbProcArgs_ps;
    private static PreparedStatement addProductFamilies_ps;
    private static PreparedStatement addProducts_ps;
    private static PreparedStatement addEntities_ps;
    private static PreparedStatement addProcedure_ps;
    private static PreparedStatement isOverloaded_ps;
    private static PreparedStatement addParameters_ps;
    private static PreparedStatement addOpenInterfaces_ps;
    private static PreparedStatement addInterfaceCP_ps;
    private static PreparedStatement addInterfaceTable_ps;
    private static PreparedStatement addInterfaceView_ps;
    private static long startTime;
    public static int current_progress;
    public static int max_progress;
    public static boolean completed;
    private static String searchPLSQLApi_q;
    private static String searchXMLGApi_q;
    private static String searchStandaloneViewApi_q;
    private static String searchStandaloneCPApi_q;
    private static boolean init;
    private static boolean initPS;
    private static boolean DEBUG;
    private static Document doc;
    private static Element root;
    private static Connection con;
    private static HashSet<String> hs;
    public static ConnectionPool cPool;
    public static String outfile;

    public static synchronized void initQueries(boolean initPreparedStatements) throws Exception {
        if (init) {
            if (initPreparedStatements) {
                if (initPS) {
                    return;
                }
                IREPExtractor.initPSs();
            } else {
                return;
            }
        }
        current_progress = Integer.MIN_VALUE;
        max_progress = Integer.MAX_VALUE;
        completed = true;
        URL fileURL = IREPExtractor.class.getClassLoader().getResource("oracle/tip/tools/ide/pm/modules/bizintegration/adapter/apps/data/IRepQueries.xml");
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document queryDoc = builder.parse(fileURL.openStream());
        addProductFamilies_q = ((Element)((Element)queryDoc.getElementsByTagName("PRODUCT_FAMILY").item(0)).getElementsByTagName("QUERY").item(0)).getChildNodes().item(0).getNodeValue();
        addProducts_q = ((Element)((Element)queryDoc.getElementsByTagName("PRODUCT").item(0)).getElementsByTagName("QUERY").item(0)).getChildNodes().item(0).getNodeValue();
        addEntities_q = ((Element)((Element)queryDoc.getElementsByTagName("BUSINESS_ENTITY").item(0)).getElementsByTagName("QUERY").item(0)).getChildNodes().item(0).getNodeValue();
        addXMLG_q = ((Element)((Element)queryDoc.getElementsByTagName("XMLGATEWAY").item(0)).getElementsByTagName("QUERY").item(0)).getChildNodes().item(0).getNodeValue();
        addPLSQL_q = ((Element)((Element)queryDoc.getElementsByTagName("PLSQL").item(0)).getElementsByTagName("QUERY").item(0)).getChildNodes().item(0).getNodeValue();
        isOverloaded_q = ((Element)((Element)queryDoc.getElementsByTagName("ISOVERLOADED").item(0)).getElementsByTagName("QUERY").item(0)).getChildNodes().item(0).getNodeValue();
        addParameters_q = ((Element)((Element)queryDoc.getElementsByTagName("API_PARAMETER").item(0)).getElementsByTagName("QUERY").item(0)).getChildNodes().item(0).getNodeValue();
        addProcedure_q = ((Element)((Element)queryDoc.getElementsByTagName("PROCEDURE").item(0)).getElementsByTagName("QUERY").item(0)).getChildNodes().item(0).getNodeValue();
        addOpenInterfaces_q = ((Element)((Element)queryDoc.getElementsByTagName("OPEN_INTERFACE").item(0)).getElementsByTagName("QUERY").item(0)).getChildNodes().item(0).getNodeValue();
        addInterfaceCP_q = ((Element)((Element)queryDoc.getElementsByTagName("OPEN_INTERFACE_CP").item(0)).getElementsByTagName("QUERY").item(0)).getChildNodes().item(0).getNodeValue();
        addInterfaceTable_q = ((Element)((Element)queryDoc.getElementsByTagName("OPEN_INTERFACE_TABLE").item(0)).getElementsByTagName("QUERY").item(0)).getChildNodes().item(0).getNodeValue();
        addInterfaceView_q = ((Element)((Element)queryDoc.getElementsByTagName("OPEN_INTERFACE_VIEW").item(0)).getElementsByTagName("QUERY").item(0)).getChildNodes().item(0).getNodeValue();
        addStandaloneCP_q = ((Element)((Element)queryDoc.getElementsByTagName("STANDALONE_CP").item(0)).getElementsByTagName("QUERY").item(0)).getChildNodes().item(0).getNodeValue();
        addStandaloneView_q = ((Element)((Element)queryDoc.getElementsByTagName("STANDALONE_INTERFACE_VIEW").item(0)).getElementsByTagName("QUERY").item(0)).getChildNodes().item(0).getNodeValue();
        searchPLSQLApi_q = ((Element)((Element)queryDoc.getElementsByTagName("PLSQL").item(0)).getElementsByTagName("SEARCH_QUERY2").item(0)).getChildNodes().item(0).getNodeValue();
        searchXMLGApi_q = ((Element)((Element)queryDoc.getElementsByTagName("XMLGATEWAY").item(0)).getElementsByTagName("SEARCH_QUERY2").item(0)).getChildNodes().item(0).getNodeValue();
        getIrepProcArgs_q = ((Element)((Element)queryDoc.getElementsByTagName("GET_IREP_PROC_ARGUMENTS").item(0)).getElementsByTagName("QUERY").item(0)).getChildNodes().item(0).getNodeValue();
        getDbProcArgs_q = ((Element)((Element)queryDoc.getElementsByTagName("GET_DB_PROC_ARGUMENTS").item(0)).getElementsByTagName("QUERY").item(0)).getChildNodes().item(0).getNodeValue();
        searchStandaloneCPApi_q = ((Element)((Element)queryDoc.getElementsByTagName("STANDALONE_CP").item(0)).getElementsByTagName("SEARCH_QUERY2").item(0)).getChildNodes().item(0).getNodeValue();
        searchStandaloneViewApi_q = ((Element)((Element)queryDoc.getElementsByTagName("STANDALONE_INTERFACE_VIEW").item(0)).getElementsByTagName("SEARCH_QUERY2").item(0)).getChildNodes().item(0).getNodeValue();
        if (initPreparedStatements) {
            IREPExtractor.initPSs();
        }
        IREPExtractor.initializeEDI();
        init = true;
    }

    public static synchronized void initPSs() throws Exception {
        if (con == null) {
            throw new SQLException("Connection object not initlized!, unable to initialize iRep Queries");
        }
        addProductFamilies_ps = con.prepareStatement(addProductFamilies_q);
        addProducts_ps = con.prepareStatement(addProducts_q);
        addEntities_ps = con.prepareStatement(addEntities_q);
        addProcedure_ps = con.prepareStatement(addProcedure_q);
        isOverloaded_ps = con.prepareStatement(isOverloaded_q);
        addParameters_ps = con.prepareStatement(addParameters_q);
        addOpenInterfaces_ps = con.prepareStatement(addOpenInterfaces_q);
        addInterfaceCP_ps = con.prepareStatement(addInterfaceCP_q);
        addInterfaceTable_ps = con.prepareStatement(addInterfaceTable_q);
        addInterfaceView_ps = con.prepareStatement(addInterfaceView_q);
        getIrepProcArgs_ps = con.prepareStatement(getIrepProcArgs_q);
        getDbProcArgs_ps = con.prepareStatement(getDbProcArgs_q);
        initPS = true;
    }

    public static final void createIRepDump() {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            doc = builder.newDocument();
            root = doc.createElement("ProductFamily");
            root.setAttribute("version", "1.0");
            doc.appendChild(root);
            ArrayList productFamilies = IREPExtractor.addProductFamilies(root);
            ArrayList products = null;
            ArrayList entities = null;
            max_progress = productFamilies.size() + 1;
            int i = 0;
            while (i < productFamilies.size()) {
                GenericNode familyNode = (GenericNode)productFamilies.get(i);
                products = IREPExtractor.addProducts(familyNode.node, familyNode.shortName);
                for (int j = 0; j < products.size(); ++j) {
                    GenericNode productNode = (GenericNode)products.get(j);
                    entities = IREPExtractor.addEntities(productNode.node, productNode.shortName);
                    for (int k = 0; k < entities.size(); ++k) {
                        String description;
                        String fullName;
                        String shortName;
                        Text text;
                        Element desc;
                        String fullName2;
                        GenericNode entityNode = (GenericNode)entities.get(k);
                        String entityName = entityNode.shortName;
                        XMLGThread xmlgO = new XMLGThread(entityName, cPool);
                        Thread xmlgT = new Thread(xmlgO);
                        xmlgT.start();
                        MiscCPThread miscCPO = new MiscCPThread(entityName, cPool);
                        Thread miscCPT = new Thread(miscCPO);
                        miscCPT.start();
                        MiscViewThread miscViewO = new MiscViewThread(entityName, cPool);
                        Thread miscViewT = new Thread(miscViewO);
                        miscViewT.start();
                        PLSQLPackageThread plsqlO = new PLSQLPackageThread(entityName, cPool);
                        Thread plsqlT = new Thread(plsqlO);
                        plsqlT.start();
                        Element openInterfaceNode = doc.createElement("OpenInterfaces");
                        entityNode.node.appendChild(openInterfaceNode);
                        Element edi = doc.createElement("EDI");
                        entityNode.node.appendChild(edi);
                        IREPExtractor.addOpenInterfaces(entityName, openInterfaceNode, edi);
                        if (DEBUG) {
                            System.out.println("OpenInterface Processing Complete.");
                        }
                        xmlgT.join();
                        Element xmlg = doc.createElement("XMLGateway");
                        entityNode.node.appendChild(xmlg);
                        ArrayList<String> list = xmlgO.list;
                        for (int xmlgC = 0; xmlgC < list.size(); xmlgC += 4) {
                            Element map = doc.createElement("xmlgatewaymap");
                            String mapCode = list.get(xmlgC);
                            fullName2 = list.get(xmlgC + 1);
                            String direction = list.get(xmlgC + 2);
                            String description2 = list.get(xmlgC + 3);
                            map.setAttribute("shortname", mapCode);
                            map.setAttribute("fullname", fullName2);
                            map.setAttribute("direction", direction);
                            desc = doc.createElement("description");
                            text = doc.createTextNode(description2);
                            desc.appendChild(text);
                            map.appendChild(desc);
                            xmlg.appendChild(map);
                        }
                        list = null;
                        xmlgO.cleanup();
                        xmlgO = null;
                        xmlgT = null;
                        if (DEBUG) {
                            System.out.println("XMLGateway Processing Complete.");
                        }
                        miscCPT.join();
                        Element miscCP = doc.createElement("CONCURRENT_PROGRAMS");
                        entityNode.node.appendChild(miscCP);
                        list = miscCPO.list;
                        for (int miscCPC = 0; miscCPC < list.size(); miscCPC += 3) {
                            Text text2;
                            Element desc2;
                            shortName = list.get(miscCPC);
                            fullName = list.get(miscCPC + 1);
                            description = list.get(miscCPC + 2);
                            if (hs.contains(shortName)) {
                                Element ediprog = doc.createElement("edigateway");
                                ediprog.setAttribute("shortname", shortName);
                                ediprog.setAttribute("fullname", fullName);
                                desc2 = doc.createElement("description");
                                text2 = doc.createTextNode(description);
                                desc2.appendChild(text2);
                                ediprog.appendChild(desc2);
                                edi.appendChild(ediprog);
                            }
                            Element cpprog = doc.createElement("StandaloneCP");
                            cpprog.setAttribute("shortname", shortName);
                            cpprog.setAttribute("fullname", fullName);
                            desc2 = doc.createElement("description");
                            text2 = doc.createTextNode(description);
                            desc2.appendChild(text2);
                            cpprog.appendChild(desc2);
                            miscCP.appendChild(cpprog);
                        }
                        list = null;
                        miscCPO.cleanup();
                        miscCPO = null;
                        miscCPT = null;
                        if (DEBUG) {
                            System.out.println("StandaloneCPs Processing Complete.");
                        }
                        miscViewT.join();
                        Element miscView = doc.createElement("INTERFACE_VIEWS");
                        entityNode.node.appendChild(miscView);
                        list = miscViewO.list;
                        for (int miscVC = 0; miscVC < list.size(); miscVC += 4) {
                            shortName = list.get(miscVC);
                            fullName = list.get(miscVC + 1);
                            description = list.get(miscVC + 2);
                            String owner = list.get(miscVC + 3);
                            Element view = doc.createElement("StandaloneView");
                            view.setAttribute("shortname", shortName);
                            view.setAttribute("fullname", fullName);
                            view.setAttribute("owner", owner.toUpperCase());
                            desc = doc.createElement("description");
                            text = doc.createTextNode(description);
                            desc.appendChild(text);
                            view.appendChild(desc);
                            miscView.appendChild(view);
                        }
                        list = null;
                        miscViewO.cleanup();
                        miscViewT = null;
                        miscViewO = null;
                        if (DEBUG) {
                            System.out.println("StandaloneViews Processing Complete.");
                        }
                        plsqlT.join();
                        Element plsql = doc.createElement("PLSQL");
                        entityNode.node.appendChild(plsql);
                        list = plsqlO.list;
                        for (int plsqlC = 0; plsqlC < list.size(); plsqlC += 4) {
                            int classId = Integer.parseInt(list.get(plsqlC));
                            String packageName = list.get(plsqlC + 1);
                            fullName2 = list.get(plsqlC + 2);
                            String description3 = list.get(plsqlC + 3);
                            Element pkg = null;
                            pkg = doc.createElement("package");
                            pkg.setAttribute("shortname", packageName);
                            pkg.setAttribute("fullname", fullName2);
                            pkg.setAttribute("description", description3);
                            plsql.appendChild(pkg);
                            IREPExtractor.addProcedure(pkg, packageName, classId);
                        }
                        list = null;
                        plsqlO.cleanup();
                        plsqlT = null;
                        plsqlO = null;
                        if (!DEBUG) continue;
                        System.out.println("PLSQL Processing Complete.");
                    }
                }
                ++i;
                ++current_progress;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(2);
        }
    }

    public static final ArrayList addProductFamilies(Node parent) throws Exception {
        ResultSet rs = null;
        Element pf = null;
        ArrayList<GenericNode> v = new ArrayList<GenericNode>();
        try {
            rs = addProductFamilies_ps.executeQuery();
            while (rs.next()) {
                pf = doc.createElement("Productfamily");
                String shortName = rs.getString(1);
                String fullName = rs.getString(2);
                pf.setAttribute("shortname", shortName);
                pf.setAttribute("fullname", fullName);
                parent.appendChild(pf);
                v.add(new GenericNode(shortName, fullName, pf));
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            try {
                rs.close();
            }
            catch (Exception ex) {}
        }
        return v;
    }

    public static final ArrayList addProducts(Node parent, String family) throws Exception {
        ResultSet rs = null;
        Element prod = null;
        ArrayList<GenericNode> v = new ArrayList<GenericNode>();
        try {
            addProducts_ps.setString(1, family);
            rs = addProducts_ps.executeQuery();
            while (rs.next()) {
                prod = doc.createElement("Product");
                String shortName = rs.getString(1);
                String fullName = rs.getString(2);
                prod.setAttribute("shortname", shortName);
                prod.setAttribute("fullname", fullName);
                parent.appendChild(prod);
                v.add(new GenericNode(shortName, fullName, prod));
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            try {
                rs.close();
            }
            catch (Exception ex) {}
        }
        return v;
    }

    public static final ArrayList addEntities(Node parent, String product) throws Exception {
        ResultSet rs = null;
        Element bentity = null;
        ArrayList<GenericNode> v = new ArrayList<GenericNode>();
        try {
            addEntities_ps.setString(1, product);
            addEntities_ps.setString(2, product);
            rs = addEntities_ps.executeQuery();
            while (rs.next()) {
                bentity = doc.createElement("BusinessEntity");
                String shortName = rs.getString(1);
                String fullName = rs.getString(2);
                bentity.setAttribute("shortname", shortName);
                bentity.setAttribute("fullname", fullName);
                parent.appendChild(bentity);
                v.add(new GenericNode(shortName, fullName, bentity));
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            try {
                rs.close();
            }
            catch (Exception ex) {}
        }
        return v;
    }

    public static final ArrayList<String> addXMLG(String entityName, Connection conn, String searchString) throws Exception {
        return IREPExtractor.addXMLG(entityName, conn, searchString, false);
    }

    public static final ArrayList<String> addXMLG(String entityName, Connection conn, String searchString, boolean searching) throws Exception {
        PreparedStatement ps = null;
        ResultSet rs = null;
        String iface = "XMLGATEWAY";
        ArrayList<Object> ret = new ArrayList<Object>();
        try {
            Object mapCode;
            if (searching) {
                ps = conn.prepareStatement(searchXMLGApi_q);
                ps.setString(1, searchString);
            } else {
                ps = conn.prepareStatement(addXMLG_q);
                ps.setString(1, iface);
                ps.setString(2, entityName);
                ps.setString(3, entityName);
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                mapCode = rs.getString(1);
                String fullName = rs.getString(2);
                String direction = rs.getString(3);
                String description = rs.getString(4);
                ret.add(mapCode);
                ret.add(fullName);
                ret.add(direction);
                ret.add(description);
                if (!searching) continue;
                ret.add(rs.getString(5));
            }
            mapCode = ret;
            return mapCode;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            try {
                rs.close();
                ps.close();
            }
            catch (Exception ex) {}
        }
    }

    public static final ArrayList<String> addPLSQL(String entityName, Connection conn, String searchString) throws Exception {
        return IREPExtractor.addPLSQL(entityName, conn, searchString, false);
    }

    public static final ArrayList<String> addPLSQL(String entityName, Connection conn, String searchString, boolean searching) throws Exception {
        PreparedStatement ps = null;
        ResultSet rs = null;
        String iface = "PLSQL";
        ArrayList<String> list = new ArrayList<String>();
        try {
            if (searching) {
                ps = conn.prepareStatement(searchPLSQLApi_q);
                ps.setString(1, searchString);
            } else {
                ps = conn.prepareStatement(addPLSQL_q);
                ps.setString(1, iface);
                ps.setString(2, entityName);
                ps.setString(3, entityName);
            }
            rs = ps.executeQuery();
            String packageName = null;
            while (rs.next()) {
                int classId = rs.getInt(1);
                packageName = rs.getString(2);
                String fullName = rs.getString(3);
                String description = rs.getString(4);
                list.add(classId + "");
                list.add(packageName);
                list.add(fullName);
                list.add(description);
                if (!searching) continue;
                String lookupCode = rs.getString(5);
                list.add(lookupCode);
            }
            ArrayList<String> classId = list;
            return classId;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            try {
                rs.close();
                ps.close();
            }
            catch (Exception ex) {}
        }
    }

    public static final void addProcedure(Node parent, String packageName, int classId) throws Exception {
        ResultSet rs = null;
        Element proc = null;
        try {
            addProcedure_ps.setInt(1, classId);
            rs = addProcedure_ps.executeQuery();
            while (rs.next()) {
                String fullName = rs.getString(1);
                String functionName = rs.getString(2);
                String description = rs.getString(3);
                int sequence = rs.getInt(4);
                int functionID = rs.getInt(5);
                String owner = "APPS";
                proc = doc.createElement("procedure");
                proc.setAttribute("shortname", functionName);
                proc.setAttribute("fullname", fullName);
                int noOfOverload = IREPExtractor.getOverloadValues(packageName, functionName);
                int real_overload = 0;
                if (noOfOverload == 0) {
                    real_overload = 0;
                } else {
                    ArrayList<IrepProcArgument> irepArgList = new ArrayList<IrepProcArgument>();
                    getIrepProcArgs_ps.setInt(1, functionID);
                    getIrepProcArgs_ps.setInt(2, sequence);
                    ResultSet rs1 = getIrepProcArgs_ps.executeQuery();
                    while (rs1.next()) {
                        IrepProcArgument obj = new IrepProcArgument(rs1.getString(1), rs1.getString(2), rs1.getString(3), rs1.getInt(4));
                        irepArgList.add(obj);
                    }
                    for (int overload = 1; overload <= noOfOverload; ++overload) {
                        ArrayList<DbProcArgument> dbArgList = new ArrayList<DbProcArgument>();
                        getDbProcArgs_ps.setString(1, packageName);
                        getDbProcArgs_ps.setString(2, owner);
                        getDbProcArgs_ps.setString(3, owner);
                        getDbProcArgs_ps.setString(4, functionName);
                        getDbProcArgs_ps.setString(5, packageName);
                        getDbProcArgs_ps.setInt(6, overload);
                        ResultSet rs2 = getDbProcArgs_ps.executeQuery();
                        while (rs2.next()) {
                            DbProcArgument obj = new DbProcArgument(rs2.getString(1), rs2.getString(2), rs2.getString(3), rs2.getString(4), rs2.getString(5), rs2.getString(6), rs2.getInt(7));
                            dbArgList.add(obj);
                        }
                        if (irepArgList.size() != dbArgList.size() || !IREPExtractor.compareArguments(irepArgList, dbArgList)) continue;
                        real_overload = overload;
                        break;
                    }
                }
                proc.setAttribute("overload", "" + real_overload);
                proc.setAttribute("description", description);
                parent.appendChild(proc);
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            try {
                rs.close();
            }
            catch (Exception ex) {}
        }
    }

    public static final int getOverloadValues(String packageName, String functionName) throws Exception {
        ResultSet rs = null;
        ArrayList ret = new ArrayList();
        try {
            isOverloaded_ps.setString(1, packageName);
            isOverloaded_ps.setString(2, DBAccess.getAppsSchema());
            isOverloaded_ps.setString(3, DBAccess.getAppsSchema());
            isOverloaded_ps.setString(4, functionName);
            isOverloaded_ps.setString(5, packageName);
            rs = isOverloaded_ps.executeQuery();
            if (rs.next()) {
                int n = rs.getInt(1);
                return n;
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            try {
                rs.close();
            }
            catch (Exception ex) {}
        }
        return 0;
    }

    public static final void addParameters(Node parent, int functionId, int sequence, String packageName, String functionName) throws Exception {
        ResultSet rs = null;
        Element param = null;
        try {
            addParameters_ps.setInt(1, functionId);
            addParameters_ps.setInt(2, sequence);
            addParameters_ps.setString(3, packageName);
            addParameters_ps.setString(4, DBAccess.getAppsSchema());
            addParameters_ps.setString(5, DBAccess.getAppsSchema());
            addParameters_ps.setString(6, functionName);
            addParameters_ps.setString(7, packageName);
            rs = addParameters_ps.executeQuery();
            while (rs.next()) {
                String paramName = rs.getString(1);
                String owner = rs.getString(2);
                String dataType = rs.getString(3);
                String type = rs.getString(4);
                String dir = rs.getString(5);
                int position = rs.getInt(6);
                int seq = rs.getInt(7);
                param = doc.createElement("parameter");
                String str = paramName + "@" + owner + "@" + dataType + "@" + type + "@" + dir + "@" + position + "@" + seq;
                Text text = doc.createTextNode(str);
                param.appendChild(text);
                parent.appendChild(param);
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            try {
                rs.close();
            }
            catch (Exception ex) {}
        }
    }

    public static final void addOpenInterfaces(String entityName, Element openInterfaceNode, Element edi) throws Exception {
        PreparedStatement ps = null;
        ResultSet rs = null;
        Element parent = openInterfaceNode;
        try {
            ps = addOpenInterfaces_ps;
            ps.setString(1, entityName);
            ps.setString(2, entityName);
            rs = ps.executeQuery();
            while (rs.next()) {
                int classId = rs.getInt(1);
                String shortName = rs.getString(2);
                String fullName = rs.getString(3);
                String description = rs.getString(4);
                Element iface = doc.createElement("OpenInterface");
                iface.setAttribute("shortname", shortName);
                iface.setAttribute("fullname", fullName);
                iface.setAttribute("description", description);
                parent.appendChild(iface);
                IREPExtractor.addinterfaceCP(classId, iface, edi);
                IREPExtractor.addinterfaceTable(classId, iface);
                IREPExtractor.addinterfaceView(classId, iface);
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            try {
                rs.close();
            }
            catch (Exception ex) {}
        }
    }

    public static final void addinterfaceCP(int classId, Element openInterfaceNode, Element edi) throws Exception {
        ResultSet rs = null;
        Element cp = doc.createElement("ConcurrentPrograms");
        openInterfaceNode.appendChild(cp);
        String nodeName1 = "concurrentprogram";
        String nodeName2 = "edigateway";
        try {
            addInterfaceCP_ps.setInt(1, classId);
            rs = addInterfaceCP_ps.executeQuery();
            while (rs.next()) {
                Text text;
                Element desc;
                String shortName = rs.getString(1);
                String fullName = rs.getString(2);
                String description = rs.getString(3);
                if (hs.contains(shortName)) {
                    Element ediprog = doc.createElement(nodeName2);
                    ediprog.setAttribute("shortname", shortName);
                    ediprog.setAttribute("fullname", fullName);
                    desc = doc.createElement("description");
                    text = doc.createTextNode(description);
                    desc.appendChild(text);
                    ediprog.appendChild(desc);
                    edi.appendChild(ediprog);
                }
                Element cpprog = doc.createElement(nodeName1);
                cpprog.setAttribute("shortname", shortName);
                cpprog.setAttribute("fullname", fullName);
                desc = doc.createElement("description");
                text = doc.createTextNode(description);
                desc.appendChild(text);
                cpprog.appendChild(desc);
                cp.appendChild(cpprog);
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            try {
                rs.close();
            }
            catch (Exception ex) {}
        }
    }

    public static final void addinterfaceTable(int classId, Element openInterfaceNode) throws Exception {
        if (classId == 4223) {
            // empty if block
        }
        ResultSet rs = null;
        Element itable = doc.createElement("OpenInterfaceTable");
        openInterfaceNode.appendChild(itable);
        try {
            addInterfaceTable_ps.setInt(1, classId);
            rs = addInterfaceTable_ps.executeQuery();
            while (rs.next()) {
                String shortName;
                String fullName = shortName = rs.getString(1);
                String description = rs.getString(2);
                String owner = rs.getString(4);
                Element iface = doc.createElement("InterfaceTable");
                iface.setAttribute("shortname", shortName);
                iface.setAttribute("fullname", fullName);
                iface.setAttribute("owner", owner.toUpperCase());
                Element desc = doc.createElement("description");
                Text text = doc.createTextNode(description);
                desc.appendChild(text);
                iface.appendChild(desc);
                itable.appendChild(iface);
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            try {
                rs.close();
            }
            catch (Exception ex) {}
        }
    }

    public static final void addinterfaceView(int classId, Element openInterfaceNode) throws Exception {
        ResultSet rs = null;
        Element iview = doc.createElement("OpenInterfaceView");
        openInterfaceNode.appendChild(iview);
        try {
            addInterfaceView_ps.setInt(1, classId);
            rs = addInterfaceView_ps.executeQuery();
            while (rs.next()) {
                String shortName;
                String fullName = shortName = rs.getString(1);
                String description = rs.getString(2);
                String owner = rs.getString(4);
                Element iface = doc.createElement("InterfaceView");
                iface.setAttribute("shortname", shortName);
                iface.setAttribute("fullname", fullName);
                iface.setAttribute("owner", owner.toUpperCase());
                Element desc = doc.createElement("description");
                Text text = doc.createTextNode(description);
                desc.appendChild(text);
                iface.appendChild(desc);
                iview.appendChild(iface);
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            try {
                rs.close();
            }
            catch (Exception ex) {}
        }
    }

    public static ArrayList<String> addStandaloneCPs(String entityName, Connection conn, String searchString) throws Exception {
        return IREPExtractor.addStandaloneCPs(entityName, conn, searchString, false);
    }

    public static ArrayList<String> addStandaloneCPs(String entityName, Connection conn, String searchString, boolean searching) throws Exception {
        ResultSet rs = null;
        ArrayList<Object> list = new ArrayList<Object>();
        PreparedStatement ps = null;
        try {
            Object shortName;
            if (searching) {
                ps = conn.prepareStatement(searchStandaloneCPApi_q);
                ps.setString(1, searchString);
            } else {
                ps = conn.prepareStatement(addStandaloneCP_q);
                ps.setString(1, entityName);
                ps.setString(2, entityName);
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                shortName = rs.getString(1);
                String fullName = rs.getString(2);
                String description = rs.getString(3);
                list.add(shortName);
                list.add(fullName);
                list.add(description);
                if (!searching) continue;
                list.add(rs.getString(4));
            }
            shortName = list;
            return shortName;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            try {
                rs.close();
                ps.close();
            }
            catch (Exception ex) {}
        }
    }

    public static ArrayList<String> addStandaloneViews(String entityName, Connection conn, String searchString) throws Exception {
        return IREPExtractor.addStandaloneViews(entityName, conn, searchString, false);
    }

    public static ArrayList<String> addStandaloneViews(String entityName, Connection conn, String searchString, boolean searching) throws Exception {
        ResultSet rs = null;
        ArrayList<Object> list = new ArrayList<Object>();
        PreparedStatement ps = null;
        try {
            Object shortName;
            if (searching) {
                ps = conn.prepareStatement(searchStandaloneViewApi_q);
                ps.setString(1, searchString);
            } else {
                ps = conn.prepareStatement(addStandaloneView_q);
                ps.setString(1, entityName);
                ps.setString(2, entityName);
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                Object fullName = shortName = rs.getString(1);
                String description = rs.getString(2);
                String owner = rs.getString(3);
                list.add(shortName);
                list.add(fullName);
                list.add(description);
                list.add(owner);
                if (!searching) continue;
                list.add(rs.getString(4));
            }
            shortName = list;
            return shortName;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            try {
                rs.close();
                ps.close();
            }
            catch (Exception ex) {}
        }
    }

    public static final void initializeEDI() {
        String[] ediprogs = new String[]{"ECEGPOI", "ECEPOI875", "ECEINI", "ECCATI", "ECEPOCI", "ECEPOI", "ECERRQI", "ECASNI", "ECESBNI", "ECESPSI", "ECEPSQI", "ECESSSI", "ECEPOO", "ECEINO", "ECEPOCO", "ECSSSO", "ECEADVO", "ECSPSO", "ECECDMO", "ECMVSTO", "ECEGASNO", "ECEGPOAO", "ECEPOAO", "ECEPOCAO", "ECEDSNO"};
        hs = new HashSet();
        for (int i = 0; i < ediprogs.length; ++i) {
            hs.add(ediprogs[i]);
        }
    }

    public static void setupPool() {
        String driver = AppsAdapterContext.test_driver;
        String url = AppsAdapterContext.test_connectString;
        String username = AppsAdapterContext.test_userName;
        String passwd = AppsAdapterContext.test_password;
        int initialConnections = 5;
        int maxConnections = 50;
        boolean waitIfBusy = true;
        try {
            cPool = new ConnectionPool(driver, url, username, passwd, initialConnections, maxConnections, waitIfBusy);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        try {
            if (args.length > 0 && args[0].equalsIgnoreCase("debug")) {
                DEBUG = true;
            }
            startTime = System.currentTimeMillis();
            IREPExtractor.setupPool();
            System.out.println("Time taken to setup pool = " + (double)(System.currentTimeMillis() - startTime) / 60000.0 + " min.");
            con = cPool.getConnection();
            System.out.println("Starting IRep Extraction ...");
            IREPExtractor.initQueries(true);
            System.out.println("Extracting iRep Objects");
            IREPExtractor.createIRepDump();
            System.out.println("Printing iRep Dump.");
            OutputFormat format = new OutputFormat(doc);
            format.setIndenting(true);
            XMLSerializer serializer = new XMLSerializer(new FileWriter(new File("d:\\IRep.xml")), format);
            serializer.serialize(doc);
            System.out.println("Finished iRep Extraction ...");
            System.out.println("Time taken = " + (double)(System.currentTimeMillis() - startTime) / 60000.0 + " min.");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                con.close();
            }
            catch (SQLException e1) {
                e1.printStackTrace();
            }
            cPool.closeAllConnections();
        }
    }

    public static void invoke(String driver, String dburl, String user, String passwd, String outdir, String database) throws Exception {
        int initialConnections = 5;
        int maxConnections = 50;
        boolean waitIfBusy = true;
        try {
            cPool = new ConnectionPool(driver, dburl, user, passwd, initialConnections, maxConnections, waitIfBusy);
            con = cPool.getConnection();
            IREPExtractor.initQueries(true);
            System.out.println("Extracting iRep Objects");
            IREPExtractor.createIRepDump();
            System.out.println("Printing iRep Dump.");
            OutputFormat format = new OutputFormat(doc);
            format.setIndenting(true);
            Date currentDate = new Date();
            int yyyy = currentDate.getYear() + 1900;
            int mm = currentDate.getMonth() + 1;
            int dd = currentDate.getDate();
            int hh = currentDate.getHours();
            int mm1 = currentDate.getMinutes();
            String ys = "" + yyyy;
            String ms = mm < 10 ? "0" + mm : "" + mm;
            String ds = dd < 10 ? "0" + dd : "" + dd;
            String hs = hh < 10 ? "0" + hh : "" + hh;
            String ms1 = mm1 < 10 ? "0" + mm1 : "" + mm1;
            outfile = "irep_data_" + database + "_" + ys + ms + ds + "_" + hs + ms1 + ".dat";
            File outdirF = new File(outdir);
            if (!outdirF.exists()) {
                outdirF.mkdir();
            }
            String finalfile = outdir + File.separatorChar + outfile;
            XMLSerializer serializer = new XMLSerializer(new FileWriter(new File(finalfile)), format);
            serializer.serialize(doc);
            ++current_progress;
            System.out.println("Finished iRep Extraction ...");
            System.out.println("Time taken = " + (double)(System.currentTimeMillis() - startTime) / 60000.0 + " min.");
            completed = true;
        }
        catch (Exception e) {
            System.out.println("Error while extracting irep data file");
            System.out.println(e);
            throw e;
        }
        finally {
            try {
                con.close();
            }
            catch (SQLException e1) {
                e1.printStackTrace();
            }
            cPool.closeAllConnections();
        }
    }

    public static void main1(String[] argv) throws Exception {
        DriverManager.registerDriver((Driver)new OracleDriver());
        con = DriverManager.getConnection("jdbc:oracle:thin:@ap6052rt.us.oracle.com:1521:irep11it", "apps_read_only", argv[0]);
        startTime = System.currentTimeMillis();
        IREPExtractor.initQueries(true);
        String pkg = "HR_ASSIGNMENT_API";
        String func = "CREATE_GB_SECONDARY_EMP_ASG";
        int func_id = 29066;
        String owner = "APPS";
        int irep_overload = 1;
        isOverloaded_ps.setString(1, pkg);
        isOverloaded_ps.setString(2, func);
        isOverloaded_ps.setString(3, pkg);
        ResultSet rs = isOverloaded_ps.executeQuery();
        ArrayList<Integer> overloadList = new ArrayList<Integer>();
        while (rs.next()) {
            overloadList.add(rs.getInt(1));
        }
        int real_overload = 0;
        if (overloadList.size() == 0) {
            real_overload = 0;
        } else {
            ArrayList<IrepProcArgument> irepArgList = new ArrayList<IrepProcArgument>();
            getIrepProcArgs_ps.setInt(1, func_id);
            getIrepProcArgs_ps.setInt(2, irep_overload);
            ResultSet rs1 = getIrepProcArgs_ps.executeQuery();
            while (rs1.next()) {
                IrepProcArgument obj = new IrepProcArgument(rs1.getString(1), rs1.getString(2), rs1.getString(3), rs1.getInt(4));
                irepArgList.add(obj);
            }
            for (int i = 0; i < overloadList.size(); ++i) {
                int overload = (Integer)overloadList.get(i);
                ArrayList<DbProcArgument> dbArgList = new ArrayList<DbProcArgument>();
                getDbProcArgs_ps.setString(1, pkg);
                getDbProcArgs_ps.setString(2, owner);
                getDbProcArgs_ps.setString(3, owner);
                getDbProcArgs_ps.setString(4, func);
                getDbProcArgs_ps.setString(5, pkg);
                getDbProcArgs_ps.setInt(6, overload);
                ResultSet rs2 = getDbProcArgs_ps.executeQuery();
                while (rs2.next()) {
                    DbProcArgument obj = new DbProcArgument(rs2.getString(1), rs2.getString(2), rs2.getString(3), rs2.getString(4), rs2.getString(5), rs2.getString(6), rs2.getInt(7));
                    dbArgList.add(obj);
                }
                if (irepArgList.size() != dbArgList.size() || !IREPExtractor.compareArguments(irepArgList, dbArgList)) continue;
                real_overload = overload;
                break;
            }
        }
        System.out.println("real_overload = " + real_overload);
    }

    private static boolean compareArguments(ArrayList<IrepProcArgument> irepArgList, ArrayList<DbProcArgument> dbArgList) {
        for (int i = 0; i < irepArgList.size(); ++i) {
            boolean result = false;
            IrepProcArgument irepArg = irepArgList.get(i);
            DbProcArgument dbArg = dbArgList.get(i);
            if (irepArg.name.equals(dbArg.name)) {
                if (irepArg.sequence == dbArg.position) {
                    String dbType;
                    String irepType = irepArg.type.substring(irepArg.type.indexOf(".") + 1);
                    String string = dbArg.type_subname == null ? (dbArg.type_name == null ? (dbArg.pls_type == null ? dbArg.data_type : dbArg.pls_type) : dbArg.type_name) : (dbType = dbArg.type_subname);
                    if (irepType.equals(dbType)) {
                        String irepinout;
                        String dbinout = dbArg.in_out;
                        String string2 = irepArg.direction.equals("I") ? "IN" : (irepArg.direction.equals("O") ? "OUT" : (irepinout = irepArg.direction.equals("B") ? "IN/OUT" : irepArg.direction));
                        if (dbinout.equals(irepinout)) continue;
                        return false;
                    }
                    return false;
                }
                return false;
            }
            return false;
        }
        return true;
    }

    static void cleanUp() throws Exception {
    }

    static {
        startTime = 0L;
        current_progress = Integer.MIN_VALUE;
        max_progress = Integer.MAX_VALUE;
        completed = false;
        init = false;
        initPS = false;
        DEBUG = false;
        doc = null;
        root = null;
        con = null;
        hs = null;
        cPool = null;
    }
}

