/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.util;

import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public class CPManager {
    public static final String WRAPPER_FILE_NAME = "XX_BPEL_FND_REQUEST_WRAPPER.sql";
    public static String cpSpecWrapperDML = null;
    public static String cpBodyWrapperDML = null;
    public Connection conn = null;
    public String projectPath = null;

    public CPManager() {
    }

    public CPManager(Connection connection, String projectPath) {
        this.conn = connection;
        this.projectPath = projectPath;
    }

    public void validateCPWrapper() {
        block5: {
            block4: {
                if (cpBodyWrapperDML == null) break block4;
                if (cpSpecWrapperDML != null) break block5;
            }
            this.loadCPWrapperDML();
        }
        if (!this.isCPWrapperOnDB()) {
            this.installCPWrapper();
        }
        this.writeCPWrapperToProject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeCPWrapperToProject() {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(this.projectPath + System.getProperty("file.separator") + WRAPPER_FILE_NAME);
            fos.write(cpSpecWrapperDML.getBytes());
            fos.write("\n/\n".getBytes());
            fos.write(cpBodyWrapperDML.getBytes());
            fos.write("\n/\n".getBytes());
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isCPWrapperOnDB() {
        boolean result = false;
        PreparedStatement pstmt = null;
        ResultSet rset = null;
        try {
            pstmt = this.conn.prepareStatement("select object_name from user_objects where object_name='XX_BPEL_FND_REQUEST_WRAPPER'");
            rset = pstmt.executeQuery();
            result = rset.next();
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
        }
        finally {
            try {
                if (rset != null) {
                    rset.close();
                }
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (SQLException sqle) {}
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void installCPWrapper() {
        CallableStatement cStmt = null;
        try {
            cStmt = this.conn.prepareCall(cpSpecWrapperDML);
            cStmt.executeUpdate();
            cStmt.close();
            cStmt = this.conn.prepareCall(cpBodyWrapperDML);
            cStmt.executeUpdate();
            cStmt.close();
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
        }
        finally {
            if (cStmt != null) {
                try {
                    cStmt.close();
                }
                catch (SQLException sqle) {
                    sqle.printStackTrace();
                }
            }
        }
    }

    public void loadCPWrapperDML() {
        CPDMLHandler cpHandler;
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setValidating(true);
        CPDMLHandler lh = cpHandler = new CPDMLHandler();
        try {
            SAXParser saxParser = factory.newSAXParser();
            saxParser.setProperty("http://xml.org/sax/properties/lexical-handler", lh);
            saxParser.parse(this.getClass().getResourceAsStream("CPDMLs.xml"), (DefaultHandler)cpHandler);
        }
        catch (SAXException saxe) {
            saxe.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
        }
        cpSpecWrapperDML = cpHandler.getCPSpecificationDML();
        cpBodyWrapperDML = cpHandler.getCPBodyDML();
    }

    private class CPDMLHandler
    extends DefaultHandler
    implements LexicalHandler {
        String fndRequestSWrapperDML = null;
        String fndRequestBWrapperDML = null;
        boolean foundCPDML = false;
        boolean inSpec = false;
        StringBuffer tmpCDATA;
        boolean inCDATA = false;

        private CPDMLHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) {
            if (qName.equals("CP_DML") && atts.getValue(atts.getIndex("NAME")).equals("FND_REQUEST_WRAPPER")) {
                this.foundCPDML = true;
                if (atts.getValue(atts.getIndex("TYPE")).equals("PACKAGE SPECIFICATION")) {
                    this.inSpec = true;
                }
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            if (qName.equals("CP_DML")) {
                this.foundCPDML = false;
                this.inSpec = false;
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            if (this.inCDATA) {
                this.tmpCDATA.append(new String(ch, start, length));
            }
        }

        @Override
        public void comment(char[] ch, int start, int length) {
        }

        @Override
        public void endCDATA() {
            this.inCDATA = false;
            if (this.inSpec) {
                this.fndRequestSWrapperDML = this.tmpCDATA.toString();
            } else {
                this.fndRequestBWrapperDML = this.tmpCDATA.toString();
            }
            this.tmpCDATA = null;
        }

        @Override
        public void endDTD() {
        }

        @Override
        public void endEntity(String name) {
        }

        @Override
        public void startCDATA() {
            this.inCDATA = true;
            this.tmpCDATA = new StringBuffer();
        }

        @Override
        public void startDTD(String name, String publicId, String systemId) {
        }

        @Override
        public void startEntity(String name) {
        }

        public String getCPSpecificationDML() {
            return this.fndRequestSWrapperDML;
        }

        public String getCPBodyDML() {
            return this.fndRequestBWrapperDML;
        }
    }
}

