/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.util;

import java.sql.SQLException;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.AdapterWizardContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.DatabaseConnectionInfo;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.common.AppsAdapterContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.common.ConnectionPool;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.iRep.post11510.LocalIRepDBAccess;

public class BgThread
extends Thread {
    String driver;
    String url;
    String username;
    String passwd;
    int maxcons = 50;
    int initcons = 5;
    boolean waitIfBusy = true;
    ConnectionPool pool = null;

    public BgThread(AdapterWizardContext context) {
        if (AdapterWizardContext.IS_STANDALONE_TESTING) {
            this.driver = AppsAdapterContext.test_driver;
            this.url = AppsAdapterContext.test_connectString;
            this.username = AppsAdapterContext.test_userName;
            this.passwd = AppsAdapterContext.test_password;
        } else {
            DatabaseConnectionInfo condes = context.dbConnectionInfo;
            this.driver = condes.getDriverClassName();
            this.url = condes.getConnectionURL();
            this.username = condes.getUsername();
            this.passwd = condes.getPassword();
        }
    }

    @Override
    public void run() {
        try {
            this.pool = new ConnectionPool(this.driver, this.url, this.username, this.passwd, this.initcons, this.maxcons, this.waitIfBusy);
            LocalIRepDBAccess.setConnPool(this.pool);
            LocalIRepDBAccess.createIRepPackagesList();
            LocalIRepDBAccess.createIRepXmlgList();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public ConnectionPool getPool() {
        return this.pool;
    }

    public void setPool(ConnectionPool pool) {
        this.pool = pool;
    }
}

