/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.noniRep;

import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JTree;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.common.AppsAdapterContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.common.DBAccess;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.common.Filter;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.common.metadata.tree.GenericTreeNode;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.noniRep.AppFileAccess;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.noniRep.GenericTreeModel;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.noniRep.ModuleTreeExpansionListener;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.noniRep.WFEventObjectPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.noniRep.metadata.ECXProductFamiliesNode;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.noniRep.metadata.EDIModulesNode;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.noniRep.metadata.ModulesNode;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.noniRep.metadata.WFEventsINInterfaceNode;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.noniRep.metadata.WFEventsOUTInterfaceNode;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.util.StringUtil;

class EBSTreeMaker
extends JPanel {
    private JTree tree = null;
    GenericTreeModel treeModel = null;

    public static JTree getTree(String mode) {
        if ("DB_MODE".equals(mode)) {
            return EBSTreeMaker.getEBSDbTree();
        }
        if ("XMLG_MODE".equals(mode)) {
            return EBSTreeMaker.getEBSXmlgTree();
        }
        if ("EDI_MODE".equals(mode)) {
            return EBSTreeMaker.getEBSEdiTree();
        }
        if ("WFEVENT_MODE".equals(mode)) {
            return EBSTreeMaker.getWFEventTree();
        }
        return null;
    }

    private static JTree getEBSDbTree() {
        GenericTreeModel treeModel = EBSTreeMaker.getDbTreeModel();
        JTree tree = new JTree(treeModel);
        tree.addTreeExpansionListener(new ModuleTreeExpansionListener(treeModel));
        return tree;
    }

    private static JTree getEBSXmlgTree() {
        GenericTreeModel treeModel = EBSTreeMaker.getXmlgTreeModel();
        JTree tree = new JTree(treeModel);
        tree.addTreeExpansionListener(new ModuleTreeExpansionListener(treeModel));
        return tree;
    }

    private static JTree getEBSEdiTree() {
        GenericTreeModel treeModel = EBSTreeMaker.getEdiTreeModel();
        JTree tree = new JTree(treeModel);
        tree.addTreeExpansionListener(new ModuleTreeExpansionListener(treeModel));
        return tree;
    }

    static GenericTreeModel getDbTreeModel() {
        ModulesNode rootNode = new ModulesNode(AppsAdapterContext.getResourceBundle().getString("OA_MB_MODULES"), null);
        GenericTreeNode[] temp = DBAccess.getModules(rootNode);
        rootNode.childrens = temp;
        return new GenericTreeModel(rootNode);
    }

    private static GenericTreeModel getXmlgTreeModel() {
        System.out.println("getXMLgTreeModel");
        ECXProductFamiliesNode rootNode = new ECXProductFamiliesNode(AppsAdapterContext.getResourceBundle().getString("OA_MB_MODULES"), null);
        GenericTreeNode[] temp = AppFileAccess.getProductFamilies(rootNode);
        rootNode.childrens = temp;
        return new GenericTreeModel(rootNode);
    }

    static GenericTreeModel getEdiTreeModel() {
        EDIModulesNode rootNode = new EDIModulesNode(AppsAdapterContext.getResourceBundle().getString("OA_MB_MODULES"), null);
        GenericTreeNode[] temp = AppFileAccess.getModules(rootNode);
        rootNode.childrens = temp;
        return new GenericTreeModel(rootNode);
    }

    static GenericTreeModel getSearchTreeModel(Filter filter) {
        GenericTreeNode node;
        String rawObjName = StringUtil.replaceAll(filter.getObjectName(), "\\_", "_");
        GenericTreeNode rootNode = new GenericTreeNode(AppsAdapterContext.getResourceBundle().getString("OA_MB_SEARCH_FOR") + " " + rawObjName, null);
        String objName = filter.getObjectName();
        Vector<GenericTreeNode> v = new Vector<GenericTreeNode>();
        GenericTreeNode[] temp = null;
        if (filter.isTableSelected()) {
            node = DBAccess.getNumberTableFound(objName, rootNode);
            v.addElement(node);
        }
        if (filter.isViewSelected()) {
            node = DBAccess.getNumberViewFound(objName, rootNode);
            v.addElement(node);
        }
        if (filter.isPackageSelected()) {
            node = DBAccess.getNumberPackageFound(objName, rootNode);
            v.addElement(node);
        }
        if (filter.isCPSelected()) {
            node = DBAccess.getNumberCPFound(objName, rootNode);
            System.out.println("getNumberCPFound called");
            v.addElement(node);
        }
        if (v.size() > 0) {
            temp = new GenericTreeNode[v.size()];
            for (int i = 0; i < v.size(); ++i) {
                temp[i] = (GenericTreeNode)v.elementAt(i);
            }
        }
        rootNode.childrens = temp;
        return new GenericTreeModel(rootNode);
    }

    private static JTree getWFEventTree() {
        GenericTreeModel treeModel = EBSTreeMaker.getWfEventTreeModel();
        JTree tree = new JTree(treeModel);
        tree.addTreeExpansionListener(new ModuleTreeExpansionListener(treeModel));
        return tree;
    }

    private static GenericTreeModel getWfEventTreeModel() {
        System.out.println("getWfEventTreeModel");
        GenericTreeNode rootNode = null;
        Object inb = null;
        Object outb = null;
        GenericTreeNode[] children = new GenericTreeNode[1];
        rootNode = new GenericTreeNode("Modules", null);
        children[0] = WFEventObjectPage.direction.equalsIgnoreCase("Inbound") ? new WFEventsINInterfaceNode("Inbound Business Events", rootNode) : new WFEventsOUTInterfaceNode("Outbound Business Events", rootNode);
        rootNode.childrens = children;
        return new GenericTreeModel(rootNode);
    }
}

