/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.noniRep;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.bali.share.nls.StringUtils;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.common.AppsAdapterContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.common.Filter;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.noniRep.EBSBrowserWindow;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.util.StringUtil;

public class EBSDBSearchPanel
extends JPanel
implements Filter {
    public static final String TABLE_TYPE = "table";
    public static final String VIEW_TYPE = "view";
    public static final String API_TYPE = "api";
    public static final String CP_TYPE = "cp";
    private JTextField objNameTF = null;
    private JCheckBox tableCB = null;
    private JCheckBox viewCB = null;
    private JCheckBox apiCB = null;
    private JCheckBox cpCB = null;
    JButton searchB = null;
    JButton moduleViewB = null;
    private EBSBrowserWindow browser = null;

    public EBSDBSearchPanel(EBSBrowserWindow browser) {
        this.browser = browser;
        this.jbInit();
    }

    private void jbInit() {
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        this.setLayout(gbl);
        JLabel objNameL = new JLabel(StringUtils.stripMnemonic((String)AppsAdapterContext.getResourceBundle().getString("OA_MB_OBJECT_NAME")));
        objNameL.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)EBSBrowserWindow.getTranslatedString("OA_MB_OBJECT_NAME")));
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.fill = 0;
        gbc.anchor = 12;
        gbl.setConstraints(objNameL, gbc);
        this.add(objNameL);
        this.objNameTF = new JTextField(10);
        this.objNameTF.getDocument().addDocumentListener(new ObjectNameTFListener());
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 50.0;
        gbc.weighty = 0.0;
        gbc.fill = 2;
        gbc.anchor = 18;
        gbl.setConstraints(this.objNameTF, gbc);
        this.add(this.objNameTF);
        objNameL.setLabelFor(this.objNameTF);
        this.tableCB = new JCheckBox(new ObjectSelectedAction(StringUtils.stripMnemonic((String)AppsAdapterContext.getResourceBundle().getString("OA_MB_TABLES"))));
        this.tableCB.setMnemonic(StringUtils.getMnemonicKeyCode((String)EBSBrowserWindow.getTranslatedString("OA_MB_TABLES")));
        this.tableCB.setDisplayedMnemonicIndex(EBSBrowserWindow.getTranslatedString("OA_MB_TABLES").indexOf("&"));
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.weightx = 5.0;
        gbc.weighty = 0.0;
        gbc.fill = 0;
        gbc.anchor = 18;
        gbl.setConstraints(this.tableCB, gbc);
        this.add(this.tableCB);
        this.viewCB = new JCheckBox(new ObjectSelectedAction(StringUtils.stripMnemonic((String)AppsAdapterContext.getResourceBundle().getString("OA_MB_VIEWS"))));
        this.viewCB.setMnemonic(StringUtils.getMnemonicKeyCode((String)EBSBrowserWindow.getTranslatedString("OA_MB_VIEWS")));
        this.viewCB.setDisplayedMnemonicIndex(EBSBrowserWindow.getTranslatedString("OA_MB_VIEWS").indexOf("&"));
        gbc.gridx = 3;
        gbc.gridy = 0;
        gbc.weightx = 5.0;
        gbc.weighty = 0.0;
        gbc.fill = 0;
        gbc.anchor = 18;
        gbl.setConstraints(this.viewCB, gbc);
        this.add(this.viewCB);
        this.apiCB = new JCheckBox(new ObjectSelectedAction(StringUtils.stripMnemonic((String)AppsAdapterContext.getResourceBundle().getString("OA_MB_APIS"))));
        this.apiCB.setMnemonic(StringUtils.getMnemonicKeyCode((String)EBSBrowserWindow.getTranslatedString("OA_MB_APIS")));
        this.apiCB.setDisplayedMnemonicIndex(EBSBrowserWindow.getTranslatedString("OA_MB_APIS").indexOf("&"));
        gbc.gridx = 4;
        gbc.gridy = 0;
        gbc.weightx = 5.0;
        gbc.weighty = 0.0;
        gbc.fill = 0;
        gbc.anchor = 18;
        gbl.setConstraints(this.apiCB, gbc);
        this.add(this.apiCB);
        this.cpCB = new JCheckBox(new ObjectSelectedAction(StringUtils.stripMnemonic((String)AppsAdapterContext.getResourceBundle().getString("OA_MB_CPS"))));
        this.cpCB.setMnemonic(StringUtils.getMnemonicKeyCode((String)EBSBrowserWindow.getTranslatedString("OA_MB_CPS")));
        this.cpCB.setDisplayedMnemonicIndex(EBSBrowserWindow.getTranslatedString("OA_MB_CPS").indexOf("&"));
        gbc.gridx = 5;
        gbc.gridy = 0;
        gbc.weightx = 5.0;
        gbc.weighty = 0.0;
        gbc.fill = 0;
        gbc.anchor = 18;
        gbl.setConstraints(this.cpCB, gbc);
        this.add(this.cpCB);
        this.searchB = new JButton(this.browser.getSearchAction());
        this.searchB.setMnemonic(StringUtils.getMnemonicKeyCode((String)EBSBrowserWindow.getTranslatedString("OA_MB_SEARCH_BUTTON")));
        this.searchB.setDisplayedMnemonicIndex(EBSBrowserWindow.getTranslatedString("OA_MB_SEARCH_BUTTON").indexOf("&"));
        gbc.gridx = 6;
        gbc.gridy = 0;
        gbc.weightx = 5.0;
        gbc.weighty = 0.0;
        gbc.fill = 0;
        gbc.anchor = 18;
        gbl.setConstraints(this.searchB, gbc);
        this.add(this.searchB);
        this.searchB.setEnabled(false);
        this.moduleViewB = new JButton(this.browser.getModuleViewAction());
        this.moduleViewB.setMnemonic(StringUtils.getMnemonicKeyCode((String)EBSBrowserWindow.getTranslatedString("OA_MB_BROWSE_BUTTON")));
        this.moduleViewB.setDisplayedMnemonicIndex(EBSBrowserWindow.getTranslatedString("OA_MB_BROWSE_BUTTON").indexOf("&"));
        gbc.gridx = 7;
        gbc.gridy = 0;
        gbc.weightx = 5.0;
        gbc.weighty = 0.0;
        gbc.fill = 0;
        gbc.anchor = 18;
        gbl.setConstraints(this.moduleViewB, gbc);
        this.add(this.moduleViewB);
    }

    @Override
    public String getObjectName() {
        String temp = this.objNameTF.getText();
        temp = StringUtil.replaceAll(temp, "_", "\\_");
        return temp;
    }

    public void setObjectName(String objname) {
        this.objNameTF.setText(StringUtil.replaceAll(objname, "\\_", "_"));
        this.handleSearchButton();
    }

    public String getType() {
        if (this.isTableSelected()) {
            return TABLE_TYPE;
        }
        if (this.isViewSelected()) {
            return VIEW_TYPE;
        }
        if (this.isPackageSelected()) {
            return API_TYPE;
        }
        if (this.isCPSelected()) {
            return CP_TYPE;
        }
        return null;
    }

    public void setType(String type) {
        if (type == null) {
            return;
        }
        if (type.equals(TABLE_TYPE)) {
            this.tableCB.setSelected(true);
        } else if (type.equals(VIEW_TYPE)) {
            this.viewCB.setSelected(true);
        } else if (type.equals(API_TYPE)) {
            this.apiCB.setSelected(true);
        } else if (type.equals(CP_TYPE)) {
            this.cpCB.setSelected(true);
        }
        this.handleSearchButton();
    }

    public void clearFilterPanel() {
        this.tableCB.setSelected(false);
        this.viewCB.setSelected(false);
        this.apiCB.setSelected(false);
        this.cpCB.setSelected(false);
        this.setObjectName("");
    }

    @Override
    public boolean isTableSelected() {
        return this.tableCB.isSelected();
    }

    @Override
    public boolean isViewSelected() {
        return this.viewCB.isSelected();
    }

    @Override
    public boolean isPackageSelected() {
        return this.apiCB.isSelected();
    }

    @Override
    public boolean isCPSelected() {
        return this.cpCB.isSelected();
    }

    private void handleSearchButton() {
        boolean objNameValid = false;
        String objName = this.objNameTF.getText();
        if (objName != null) {
            objNameValid = !"".equals(objName = objName.trim());
        }
        if (objNameValid && (this.isTableSelected() || this.isViewSelected() || this.isCPSelected() || this.isPackageSelected())) {
            this.searchB.setEnabled(true);
        } else {
            this.searchB.setEnabled(false);
        }
    }

    class ObjectNameTFListener
    implements DocumentListener {
        ObjectNameTFListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            EBSDBSearchPanel.this.handleSearchButton();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            EBSDBSearchPanel.this.handleSearchButton();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            EBSDBSearchPanel.this.handleSearchButton();
        }
    }

    class ObjectSelectedAction
    extends AbstractAction {
        public ObjectSelectedAction(String name) {
            super(name);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            EBSDBSearchPanel.this.handleSearchButton();
        }
    }
}

