/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.noniRep;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.TreeExpansionListener;
import oracle.bali.share.nls.StringUtils;
import oracle.tip.tools.ide.common.utils.MultiLineOptionPane;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.common.AppsAdapterContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.common.DBAccess;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.common.Filter;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.common.metadata.Attribute;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.common.metadata.DtdInfo;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.common.metadata.ISMessageType;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.common.metadata.ProcedureParam;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.common.metadata.SchemaObject;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.common.metadata.SelectedCols;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.common.metadata.Selection;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.common.metadata.WFEventInfo;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.common.metadata.tree.GenericTreeNode;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.noniRep.DetailPanel;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.noniRep.EBSDBSearchPanel;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.noniRep.EBSTreeMaker;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.noniRep.GenericTreeCellRenderer;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.noniRep.GenericTreeModel;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.noniRep.ModuleTreeExpansionListener;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.noniRep.SearchTreeExpansionListener;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.noniRep.metadata.ModuleNode;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.noniRep.metadata.ModulesNode;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.noniRep.metadata.ProcedureNode;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.noniRep.metadata.TableNode;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.noniRep.metadata.ViewNode;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.noniRep.metadata.WFEventNode;

public class EBSBrowserWindow
extends JDialog {
    public static String[] cpArgNames;
    public static final String DB_MODE = "DB_MODE";
    public static final String XMLG_MODE = "XMLG_MODE";
    public static final String WFEVENT_MODE = "WFEVENT_MODE";
    public static final String EDI_MODE = "EDI_MODE";
    public static String mode;
    private Filter filter = null;
    private JPanel filterP = null;
    private Selection selection = null;
    private DetailPanel detailPanel = null;
    JScrollPane ebizTreeSP = null;
    private JTree ebizTree = null;
    private String m_appName = null;
    private SelectedCols selCols = null;
    private static EBSBrowserWindow window;
    private ISMessageType msgType = null;
    private String m_search_string = null;
    private String m_search_type = null;

    public EBSBrowserWindow(String mode, String appName, Connection con, SelectedCols selCols, Frame parentFrame, ISMessageType msgType, String title, String search_string, String search_type) {
        super(parentFrame, title, true);
        this.init(mode, appName, selCols, parentFrame, msgType, search_string, search_type);
    }

    public EBSBrowserWindow(SelectedCols selCols, Frame parentFrame, String mode) {
        super(parentFrame, true);
        this.init(mode, null, selCols, parentFrame, null, null, null);
        this.setTitle(EBSBrowserWindow.getTranslatedString("OA_MB_DTD_BROWSER_TITLE"));
    }

    public void init(String mode, String appName, SelectedCols selCols, Frame parentFrame, ISMessageType msgType, String search_string, String search_type) {
        this.m_appName = appName;
        this.m_search_string = search_string;
        this.m_search_type = search_type;
        EBSBrowserWindow.mode = mode == null || "".equals(mode) ? DB_MODE : mode;
        this.msgType = msgType;
        this.selCols = selCols;
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                EBSBrowserWindow.this.dispose();
            }
        });
        window = this;
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    @Override
    public void setVisible(boolean show) {
        if (!show) {
            return;
        }
        this.setSize(new Dimension(1024, 675));
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        this.getContentPane().setLayout(gbl);
        this.filterP = this.getFilterPanel(mode);
        if (this.filterP instanceof Filter) {
            this.filter = (Filter)((Object)this.filterP);
        }
        if (this.m_search_type != null && this.filterP instanceof EBSDBSearchPanel) {
            EBSDBSearchPanel efp = (EBSDBSearchPanel)this.filterP;
            efp.setObjectName(this.m_search_string);
            efp.setType(this.m_search_type);
        }
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 100.0;
        gbc.weighty = 5.0;
        gbc.fill = 2;
        gbc.anchor = 18;
        gbc.insets = new Insets(10, 10, 10, 10);
        gbl.setConstraints(this.filterP, gbc);
        this.getContentPane().add(this.filterP);
        this.ebizTree = this.getTree(mode);
        this.ebizTree.getSelectionModel().setSelectionMode(1);
        this.ebizTreeSP = new JScrollPane(this.ebizTree);
        this.detailPanel = this.getDetailPanel(mode);
        this.ebizTree.addTreeSelectionListener(this.detailPanel);
        this.ebizTree.setCellRenderer(new GenericTreeCellRenderer());
        JSplitPane splitPane = new JSplitPane();
        splitPane.setDividerLocation(300);
        splitPane.setLeftComponent(this.ebizTreeSP);
        splitPane.setRightComponent(this.detailPanel);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 100.0;
        gbc.weighty = 100.0;
        gbc.fill = 1;
        gbc.anchor = 18;
        gbc.insets = new Insets(10, 10, 10, 10);
        gbl.setConstraints(splitPane, gbc);
        this.getContentPane().add(splitPane);
        if (this.m_appName != null) {
            GenericTreeModel gtm = (GenericTreeModel)this.ebizTree.getModel();
            ModulesNode msn = (ModulesNode)gtm.getRoot();
            Enumeration mods = msn.children();
            int modindex = 0;
            int ii = 1;
            while (mods.hasMoreElements()) {
                GenericTreeNode gtn = (GenericTreeNode)mods.nextElement();
                if (this.m_appName.equals(gtn.name)) {
                    modindex = ii;
                    break;
                }
                ++ii;
            }
            if (modindex > 0) {
                this.ebizTree.expandRow(modindex);
                this.ebizTree.scrollRowToVisible(modindex);
            }
        }
        KeyStroke escape = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction escapeAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EBSBrowserWindow.this.dispose();
            }
        };
        this.getRootPane().getInputMap(2).put(escape, "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", escapeAction);
        this.centerWindow();
        super.setVisible(show);
    }

    public void setVisible2(boolean show, SelectedCols selCols) {
        this.selCols = selCols;
        this.detailPanel = this.getDetailPanel(mode);
        super.setVisible(show);
    }

    private JTree getTree(String mode) {
        return EBSTreeMaker.getTree(mode);
    }

    private DetailPanel getDetailPanel(String mode) {
        if (this.detailPanel != null) {
            return this.detailPanel;
        }
        this.detailPanel = new DetailPanel(this, mode);
        this.selection = this.detailPanel;
        return this.detailPanel;
    }

    private JPanel getFilterPanel(String mode) {
        if (DB_MODE.equalsIgnoreCase(mode)) {
            return new EBSDBSearchPanel(this);
        }
        if (XMLG_MODE.equalsIgnoreCase(mode)) {
            JPanel introP = new JPanel();
            introP.setLayout(new GridBagLayout());
            JLabel introLB = new JLabel();
            introLB.setText(EBSBrowserWindow.getTranslatedString("OA_MB_DTDS_INTRO"));
            introP.add((Component)introLB, new GridBagConstraints(0, 0, 0, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            return introP;
        }
        if (EDI_MODE.equalsIgnoreCase(mode)) {
            JPanel introP = new JPanel();
            introP.setLayout(new GridBagLayout());
            JLabel introLB = new JLabel();
            introLB.setText(EBSBrowserWindow.getTranslatedString("OA_MB_EC_INTRO"));
            introP.add((Component)introLB, new GridBagConstraints(0, 0, 0, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            return introP;
        }
        return new JPanel();
    }

    public static EBSBrowserWindow getWindow() {
        return window;
    }

    public AbstractAction getSearchAction() {
        return new SearchAction(StringUtils.stripMnemonic((String)EBSBrowserWindow.getTranslatedString("OA_MB_SEARCH_BUTTON")));
    }

    public AbstractAction getModuleViewAction() {
        return new ModuleViewAction(StringUtils.stripMnemonic((String)EBSBrowserWindow.getTranslatedString("OA_MB_BROWSE_BUTTON")));
    }

    public AbstractAction getDBDoneAction() {
        return new DBDoneAction(StringUtils.stripMnemonic((String)EBSBrowserWindow.getTranslatedString("OA_MB_APPLY_BUTTON")));
    }

    public AbstractAction getEDIDoneAction() {
        return new EDIDoneAction(StringUtils.stripMnemonic((String)EBSBrowserWindow.getTranslatedString("OA_MB_APPLY_BUTTON")));
    }

    public AbstractAction getXMLGDoneAction() {
        return new XMLGDoneAction(StringUtils.stripMnemonic((String)EBSBrowserWindow.getTranslatedString("OA_MB_APPLY_BUTTON")));
    }

    public AbstractAction getCancelAction() {
        return new CancelAction(EBSBrowserWindow.getTranslatedString("OA_MB_CANCEL_BUTTON"));
    }

    Action getWFEventDoneAction() {
        return new WFEventDoneAction(StringUtils.stripMnemonic((String)EBSBrowserWindow.getTranslatedString("OA_MB_APPLY_BUTTON")));
    }

    private void importTableViewAttributes(TableNode node, Attribute[] selAttrs) {
        this.selCols.createType(node.getQTableName());
        this.selCols.setToAdd(true);
        if (selAttrs != null) {
            for (int i = 0; i < selAttrs.length; ++i) {
                Attribute attr = selAttrs[i];
                this.selCols.addAttribute(node.getQTableName(), attr.name, attr.oType.toString(), attr.getArrayType());
            }
        } else {
            for (int i = 0; i < node.attributes.length; ++i) {
                Attribute attr = node.attributes[i];
                this.selCols.addAttribute(node.getQTableName(), attr.name, attr.oType.toString(), attr.getArrayType());
            }
        }
    }

    private void importProcArguments(ProcedureNode node, Attribute[] selAttrs) {
        block11: {
            int count;
            block12: {
                if (node == null) break block11;
                if (this.msgType != null && this.msgType.isEBSWFQ()) {
                    this.selCols.createProcedureForEBSWFQ(node.toString(), node.getOverload());
                } else {
                    this.selCols.createProcedure(node.getProcedureName(), node.getOverload());
                }
                this.selCols.setToAdd(true);
                count = 0;
                if (node.packageName != null && node.packageName.equals("CONCURRENT_PROGRAM")) {
                    int i;
                    SchemaObject oType0 = new SchemaObject(null, "NUMBER");
                    SchemaObject oType = new SchemaObject(null, "VARCHAR2");
                    SchemaObject oType1 = new SchemaObject(null, "BOOLEAN");
                    this.selCols.setToAdd(true);
                    this.selCols.addArgument(null, oType0.toString(), null, true, false, "OUT", 0, 0, "NUMBER", node.getOverload());
                    this.selCols.addArgument("APPLICATION", oType.toString(), null, false, true, "IN", 1, 0, "VARCHAR2", node.getOverload());
                    this.selCols.addArgument("PROGRAM", oType.toString(), null, false, true, "IN", 2, 0, "VARCHAR2", node.getOverload());
                    this.selCols.addArgument("DESCRIPTION", oType.toString(), null, false, true, "IN", 3, 0, "VARCHAR2", node.getOverload());
                    this.selCols.addArgument("START_TIME", oType.toString(), null, false, true, "IN", 4, 0, "VARCHAR2", node.getOverload());
                    this.selCols.addArgument("SUB_REQUEST", oType1.toString(), null, false, true, "IN", 5, 0, "BOOLEAN", node.getOverload());
                    for (i = 1; i <= 100; ++i) {
                        String arg = "ARGUMENT" + i;
                        this.selCols.addArgument(arg, oType.toString(), null, false, true, "IN", i + 5, 0, "VARCHAR2", node.getOverload());
                    }
                    cpArgNames = new String[node.params.length];
                    for (i = 0; i < node.params.length; ++i) {
                        EBSBrowserWindow.cpArgNames[i] = (node.params[i].name == null ? "" : node.params[i].name).replaceAll("[ ]*", "");
                        EBSBrowserWindow.cpArgNames[i] = cpArgNames[i].replaceAll("[:]", "_");
                    }
                    count = 105;
                    return;
                }
                if (selAttrs == null) break block12;
                for (int i = 0; i < selAttrs.length; ++i) {
                    ProcedureParam attr = (ProcedureParam)selAttrs[i];
                    this.addAttributeRecursively(attr);
                    this.selCols.setToAdd(true);
                    if (node.packageName != null && node.packageName.equals("CONCURRENT_PROGRAM")) {
                        this.selCols.addArgument(attr.origName, attr.elType != null ? attr.elType.toString() : attr.oType.toString(), attr.elType != null ? attr.oType.toString() : null, attr.isOut, attr.isIn, attr.inoutstr, attr.position + count, attr.sequence, attr.datatype, attr.overload);
                        continue;
                    }
                    if (this.msgType != null && this.msgType.isEBSWFQ()) {
                        this.selCols.addArgumentForEBSWFQ(node.toString(), attr.name, attr.elType != null ? attr.elType.toString() : attr.oType.toString(), attr.elType != null ? attr.oType.toString() : null, attr.isOut, attr.isIn, attr.inoutstr, attr.position + count, attr.sequence, attr.datatype, attr.overload);
                        continue;
                    }
                    String str0 = attr.name;
                    String str1 = attr.elType != null ? attr.elType.toString() : attr.oType.toString();
                    String str2 = attr.elType != null ? attr.oType.toString() : null;
                    String str3 = "" + attr.isOut;
                    String str4 = "" + attr.isIn;
                    String str5 = attr.inoutstr;
                    String str6 = "" + attr.position + count;
                    String str7 = attr.datatype;
                    this.selCols.addArgument(attr.name, attr.elType != null ? attr.elType.toString() : attr.oType.toString(), attr.elType != null ? attr.oType.toString() : null, attr.isOut, attr.isIn, attr.inoutstr, attr.position + count, attr.sequence, attr.datatype, attr.overload);
                }
                break block11;
            }
            if (node.params == null) break block11;
            for (int i = 0; i < node.params.length; ++i) {
                ProcedureParam attr = node.params[i];
                this.addAttributeRecursively(attr);
                this.selCols.setToAdd(true);
                if (node.packageName != null && node.packageName.equals("CONCURRENT_PROGRAM")) {
                    this.selCols.addArgument(attr.origName, attr.elType != null ? attr.elType.toString() : attr.oType.toString(), attr.elType != null ? attr.oType.toString() : null, attr.isOut, attr.isIn, attr.inoutstr, attr.position + count, attr.sequence, attr.datatype, attr.overload);
                    continue;
                }
                if (this.msgType != null && this.msgType.isEBSWFQ()) {
                    this.selCols.addArgumentForEBSWFQ(node.toString(), attr.name, attr.elType != null ? attr.elType.toString() : attr.oType.toString(), attr.elType != null ? attr.oType.toString() : null, attr.isOut, attr.isIn, attr.inoutstr, attr.position + count, attr.sequence, attr.datatype, attr.overload);
                    continue;
                }
                String str0 = attr.name;
                String str1 = attr.elType != null ? attr.elType.toString() : attr.oType.toString();
                String str2 = attr.elType != null ? attr.oType.toString() : null;
                String str3 = "" + attr.isOut;
                String str4 = "" + attr.isIn;
                String str5 = attr.inoutstr;
                String str6 = "" + attr.position + count;
                String str7 = attr.datatype;
                this.selCols.addArgument(attr.name, attr.elType != null ? attr.elType.toString() : attr.oType.toString(), attr.elType != null ? attr.oType.toString() : null, attr.isOut, attr.isIn, attr.inoutstr, attr.position + count, attr.sequence, attr.datatype, attr.overload);
            }
        }
    }

    private void addAttributeRecursively(Attribute attr) {
        if (attr.isPrimitive()) {
            return;
        }
        try {
            attr.createType(this.selCols);
        }
        catch (SelectedCols.AlreadyExist ex) {
            MultiLineOptionPane.showMessageDialog((Component)JOptionPane.getRootFrame(), (Object)("Type " + attr.toString() + " already exists. Will use existing definition."), (String)"Problem", (int)2);
        }
        this.selCols.setToAdd(false);
        Attribute[] attrs = DBAccess.getAdtAttributes(attr);
        if (attrs != null) {
            for (int i = 0; i < attrs.length; ++i) {
                Attribute childAttr = attrs[i];
                if (!childAttr.isPrimitive()) {
                    this.addAttributeRecursively(childAttr);
                }
                attr.addAttribute(this.selCols, childAttr);
            }
        }
    }

    private void centerWindow() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = this.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        this.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
    }

    public static String getTranslatedString(String messageKey) {
        return AppsAdapterContext.getResourceBundle().getString(messageKey);
    }

    static {
        mode = null;
        window = null;
    }

    class CancelAction
    extends AbstractAction {
        CancelAction(String name) {
            super(name);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            EBSBrowserWindow.this.dispose();
        }
    }

    class EDIDoneAction
    extends AbstractAction {
        EDIDoneAction(String name) {
            super(name);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GenericTreeNode node = (GenericTreeNode)EBSBrowserWindow.this.ebizTree.getSelectionPath().getLastPathComponent();
            ProcedureNode procNode = (ProcedureNode)node;
            Attribute[] params = EBSBrowserWindow.this.selection.getSelectedAttributes();
            EBSBrowserWindow.this.importProcArguments(procNode, params);
            GenericTreeNode gtn = node.parent;
            while (gtn != null) {
                if (gtn instanceof ModuleNode) {
                    EBSBrowserWindow.this.selCols.setModuleName(gtn.name);
                    break;
                }
                gtn = gtn.parent;
            }
            EBSBrowserWindow.this.dispose();
        }
    }

    class WFEventDoneAction
    extends AbstractAction {
        WFEventDoneAction(String name) {
            super(name);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GenericTreeNode node = (GenericTreeNode)EBSBrowserWindow.this.ebizTree.getSelectionPath().getLastPathComponent();
            WFEventNode nod = (WFEventNode)node;
            ArrayList v = DBAccess.getWFEventDetails(nod.name);
            WFEventInfo wfeventInfo = new WFEventInfo((String)v.get(0), (String)v.get(1), (String)v.get(2), (String)v.get(3), (String)v.get(4), (String)v.get(5), (String)v.get(6), (String)v.get(7), (String)v.get(8), (String)v.get(9), nod.direction);
            EBSBrowserWindow.this.selCols.setWFEventInfo(wfeventInfo);
            if (nod.direction.equalsIgnoreCase("INBOUND")) {
                SchemaObject oType0 = new SchemaObject(null, "NUMBER");
                SchemaObject oType = new SchemaObject(null, "VARCHAR2");
                SchemaObject oType1 = new SchemaObject(null, "DATE");
                EBSBrowserWindow.this.selCols.createProcedure("XX_BPEL_RAISE_EVENT.WF_EVENT$RAISE", 0);
                EBSBrowserWindow.this.selCols.setToAdd(true);
                EBSBrowserWindow.this.selCols.addArgument(null, oType0.toString(), null, true, false, "OUT", 0, 0, "VARCHAR2", 0);
                EBSBrowserWindow.this.selCols.addArgument("EVENT_NAME", oType.toString(), null, false, true, "IN", 1, 0, "VARCHAR2", 0);
                EBSBrowserWindow.this.selCols.addArgument("EVENT_DATA", oType.toString(), null, false, true, "IN", 2, 0, "VARCHAR2", 0);
                int i = 1;
                EBSBrowserWindow.this.selCols.addArgument("SEND_DATE", oType1.toString(), null, false, true, "IN", 3, 0, "DATE", 0);
                int j = 4;
                while (i <= 100) {
                    String arg = "PARAMETER_NAME" + i;
                    EBSBrowserWindow.this.selCols.addArgument(arg, oType.toString(), null, false, true, "IN", j, 0, "VARCHAR2", 0);
                    arg = "PARAMETER_VALUE" + i;
                    EBSBrowserWindow.this.selCols.addArgument(arg, oType.toString(), null, false, true, "IN", j + 1, 0, "VARCHAR2", 0);
                    ++i;
                    j += 2;
                }
            }
            EBSBrowserWindow.this.dispose();
        }
    }

    class XMLGDoneAction
    extends AbstractAction {
        XMLGDoneAction(String name) {
            super(name);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GenericTreeNode node = (GenericTreeNode)EBSBrowserWindow.this.ebizTree.getSelectionPath().getLastPathComponent();
            String mapName = node.name;
            DtdInfo dtdInfo = DBAccess.getDtdDetailsFromMap(mapName);
            if (dtdInfo == null) {
                return;
            }
            EBSBrowserWindow.this.selCols.setDtdInfo(dtdInfo);
            EBSBrowserWindow.this.dispose();
        }
    }

    class DBDoneAction
    extends AbstractAction {
        DBDoneAction(String name) {
            super(name);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GenericTreeNode node = (GenericTreeNode)EBSBrowserWindow.this.ebizTree.getSelectionPath().getLastPathComponent();
            if (node instanceof TableNode || node instanceof ViewNode) {
                TableNode tableNode = (TableNode)node;
                Attribute[] selAttrs = EBSBrowserWindow.this.selection.getSelectedAttributes();
                EBSBrowserWindow.this.importTableViewAttributes(tableNode, selAttrs);
            } else if (node instanceof ProcedureNode) {
                ProcedureNode procNode = (ProcedureNode)node;
                Attribute[] params = EBSBrowserWindow.this.selection.getSelectedAttributes();
                EBSBrowserWindow.this.importProcArguments(procNode, params);
            } else if (node instanceof WFEventNode) {
                WFEventNode nod = (WFEventNode)node;
                ArrayList v = DBAccess.getWFEventDetails(nod.name);
                WFEventInfo wfeventInfo = new WFEventInfo((String)v.get(0), (String)v.get(1), (String)v.get(2), (String)v.get(3), (String)v.get(4), (String)v.get(5), (String)v.get(6), (String)v.get(7), (String)v.get(8), (String)v.get(9), nod.direction);
                EBSBrowserWindow.this.selCols.setWFEventInfo(wfeventInfo);
                if (nod.direction.equalsIgnoreCase("INBOUND")) {
                    SchemaObject oType0 = new SchemaObject(null, "NUMBER");
                    SchemaObject oType = new SchemaObject(null, "VARCHAR2");
                    SchemaObject oType1 = new SchemaObject(null, "DATE");
                    EBSBrowserWindow.this.selCols.createProcedure("XX_BPEL_RAISE_EVENT.WF_EVENT$RAISE", 0);
                    EBSBrowserWindow.this.selCols.setToAdd(true);
                    EBSBrowserWindow.this.selCols.addArgument(null, oType0.toString(), null, true, false, "OUT", 0, 0, "VARCHAR2", 0);
                    EBSBrowserWindow.this.selCols.addArgument("EVENT_NAME", oType.toString(), null, false, true, "IN", 1, 0, "VARCHAR2", 0);
                    EBSBrowserWindow.this.selCols.addArgument("EVENT_DATA", oType.toString(), null, false, true, "IN", 2, 0, "VARCHAR2", 0);
                    int i = 1;
                    EBSBrowserWindow.this.selCols.addArgument("SEND_DATE", oType1.toString(), null, false, true, "IN", 3, 0, "DATE", 0);
                    int j = 4;
                    while (i <= 100) {
                        String arg = "PARAMETER_NAME" + i;
                        EBSBrowserWindow.this.selCols.addArgument(arg, oType.toString(), null, false, true, "IN", j, 0, "VARCHAR2", 0);
                        arg = "PARAMETER_VALUE" + i;
                        EBSBrowserWindow.this.selCols.addArgument(arg, oType.toString(), null, false, true, "IN", j + 1, 0, "VARCHAR2", 0);
                        ++i;
                        j += 2;
                    }
                }
            }
            GenericTreeNode gtn = node.parent;
            while (gtn != null) {
                if (gtn instanceof ModuleNode) {
                    EBSBrowserWindow.this.selCols.setModuleName(gtn.name);
                    break;
                }
                gtn = gtn.parent;
            }
            if (EBSBrowserWindow.this.filterP instanceof EBSDBSearchPanel) {
                EBSDBSearchPanel efp = (EBSDBSearchPanel)EBSBrowserWindow.this.filterP;
                EBSBrowserWindow.this.selCols.setSearch(efp.getObjectName(), efp.getType());
            }
            EBSBrowserWindow.this.dispose();
        }
    }

    class ModuleViewAction
    extends AbstractAction {
        ModuleViewAction(String name) {
            super(name);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            EBSBrowserWindow.this.ebizTreeSP.getVerticalScrollBar().setValue(0);
            EBSBrowserWindow.this.ebizTreeSP.getHorizontalScrollBar().setValue(0);
            if (EBSBrowserWindow.this.filterP instanceof EBSDBSearchPanel) {
                EBSDBSearchPanel efp = (EBSDBSearchPanel)EBSBrowserWindow.this.filterP;
                efp.clearFilterPanel();
            }
            GenericTreeModel dbTreeModel = EBSTreeMaker.getDbTreeModel();
            TreeExpansionListener[] expListeners = EBSBrowserWindow.this.ebizTree.getTreeExpansionListeners();
            for (int i = 0; i < expListeners.length; ++i) {
                if (!(expListeners[i] instanceof SearchTreeExpansionListener) && !(expListeners[i] instanceof ModuleTreeExpansionListener)) continue;
                EBSBrowserWindow.this.ebizTree.removeTreeExpansionListener(expListeners[i]);
                break;
            }
            EBSBrowserWindow.this.ebizTree.setModel(dbTreeModel);
            EBSBrowserWindow.this.ebizTree.addTreeExpansionListener(new ModuleTreeExpansionListener(dbTreeModel));
            EBSBrowserWindow.this.ebizTree.setShowsRootHandles(true);
            EBSBrowserWindow.this.detailPanel.clearTable();
        }
    }

    class SearchAction
    extends AbstractAction {
        SearchAction(String name) {
            super(name);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!this.isUserInputValid()) {
                return;
            }
            EBSBrowserWindow.this.ebizTreeSP.getVerticalScrollBar().setValue(0);
            EBSBrowserWindow.this.ebizTreeSP.getHorizontalScrollBar().setValue(0);
            EBSBrowserWindow.getWindow().setCursor(Cursor.getPredefinedCursor(3));
            GenericTreeModel searchTreeModel = EBSTreeMaker.getSearchTreeModel(EBSBrowserWindow.this.filter);
            TreeExpansionListener[] expListeners = EBSBrowserWindow.this.ebizTree.getTreeExpansionListeners();
            for (int i = 0; i < expListeners.length; ++i) {
                if (!(expListeners[i] instanceof ModuleTreeExpansionListener) && !(expListeners[i] instanceof SearchTreeExpansionListener)) continue;
                EBSBrowserWindow.this.ebizTree.removeTreeExpansionListener(expListeners[i]);
                break;
            }
            EBSBrowserWindow.this.ebizTree.setModel(searchTreeModel);
            EBSBrowserWindow.this.ebizTree.addTreeExpansionListener(new SearchTreeExpansionListener(searchTreeModel, EBSBrowserWindow.this.filter));
            EBSBrowserWindow.this.ebizTree.setShowsRootHandles(true);
            EBSBrowserWindow.this.detailPanel.clearTable();
            EBSBrowserWindow.getWindow().setCursor(Cursor.getPredefinedCursor(0));
        }

        private boolean isUserInputValid() {
            String objName = EBSBrowserWindow.this.filter.getObjectName();
            if (objName == null) {
                return false;
            }
            if (objName != null) {
                objName = objName.trim();
            }
            if ("".equals(objName)) {
                return false;
            }
            return EBSBrowserWindow.this.filter.isTableSelected() || EBSBrowserWindow.this.filter.isViewSelected() || EBSBrowserWindow.this.filter.isPackageSelected() || EBSBrowserWindow.this.filter.isCPSelected();
        }
    }
}

