/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.noniRep;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.tree.TreePath;
import oracle.bali.share.nls.StringUtils;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.common.DBAccess;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.common.metadata.Attribute;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.common.metadata.DtdInfo;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.common.metadata.ProcedureParam;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.common.metadata.Selection;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.common.metadata.WFEventInfo;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.common.metadata.detailpanel.DBTableModel;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.common.metadata.detailpanel.DTDTableModel;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.common.metadata.detailpanel.EBSTableModel;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.common.metadata.detailpanel.ProcTableModel;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.common.metadata.detailpanel.WFEventTableModel;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.noniRep.EBSBrowserWindow;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.noniRep.metadata.MapNode;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.noniRep.metadata.ProcedureNode;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.noniRep.metadata.TableNode;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.noniRep.metadata.ViewNode;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.noniRep.metadata.WFEventNode;

public class DetailPanel
extends JPanel
implements TreeSelectionListener,
Selection {
    private EBSBrowserWindow browser = null;
    private String mode = null;
    private JTable detailTable = null;
    private JScrollPane tableSP = null;
    private JLabel payloadL = null;
    private JTextArea payloadTA = null;
    private JScrollPane payloadTASP = null;
    private JButton doneB = null;
    private JButton cancelB = null;
    private TableModel detailTableModel = null;

    public DetailPanel(EBSBrowserWindow browser, String mode) {
        this.browser = browser;
        this.mode = mode;
        this.jbInit();
    }

    private void jbInit() {
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        this.setLayout(gbl);
        this.detailTable = new JTable();
        this.detailTable.setAutoResizeMode(4);
        this.tableSP = new JScrollPane(this.detailTable);
        if ("XMLG_MODE".equals(this.mode)) {
            this.tableSP.setPreferredSize(new Dimension(100, 85));
            gbc.fill = 2;
            gbc.weightx = 100.0;
            gbc.weighty = 0.0;
        } else {
            gbc.fill = 1;
            gbc.weightx = 100.0;
            gbc.weighty = 100.0;
        }
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        gbc.anchor = 18;
        gbc.insets = new Insets(10, 10, 10, 10);
        gbl.setConstraints(this.tableSP, gbc);
        this.add(this.tableSP);
        if ("XMLG_MODE".equals(this.mode)) {
            this.payloadL = new JLabel("Payload");
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.gridwidth = 1;
            gbc.weightx = 0.0;
            gbc.weighty = 0.0;
            gbc.fill = 1;
            gbc.anchor = 18;
            gbc.insets = new Insets(10, 10, 0, 10);
            gbl.setConstraints(this.payloadL, gbc);
            this.add(this.payloadL);
            this.payloadTA = new JTextArea();
            this.payloadTA.setEditable(false);
            this.payloadTASP = new JScrollPane(this.payloadTA);
            this.payloadTASP.setPreferredSize(new Dimension(100, 100));
            this.payloadTASP.setVerticalScrollBarPolicy(20);
            this.payloadTASP.setHorizontalScrollBarPolicy(30);
            gbc.gridx = 0;
            gbc.gridy = 2;
            gbc.gridwidth = 2;
            gbc.weightx = 0.0;
            gbc.weighty = 100.0;
            gbc.fill = 1;
            gbc.anchor = 18;
            gbc.insets = new Insets(0, 10, 0, 10);
            gbl.setConstraints(this.payloadTASP, gbc);
            this.add(this.payloadTASP);
        }
        Action doneAction = null;
        doneAction = "XMLG_MODE".equals(this.mode) ? this.browser.getXMLGDoneAction() : ("EDI_MODE".equals(this.mode) ? this.browser.getEDIDoneAction() : ("WFEVENT_MODE".equals(this.mode) ? this.browser.getWFEventDoneAction() : this.browser.getDBDoneAction()));
        this.doneB = new JButton(doneAction);
        this.doneB.setMnemonic(StringUtils.getMnemonicKeyCode((String)EBSBrowserWindow.getTranslatedString("OA_MB_APPLY_BUTTON")));
        this.doneB.setDisplayedMnemonicIndex(EBSBrowserWindow.getTranslatedString("OA_MB_APPLY_BUTTON").indexOf("&"));
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.gridwidth = -1;
        gbc.weightx = 50.0;
        gbc.weighty = 0.0;
        gbc.fill = 0;
        gbc.anchor = 13;
        gbc.insets = new Insets(10, 10, 10, 10);
        gbl.setConstraints(this.doneB, gbc);
        this.add(this.doneB);
        this.doneB.setEnabled(false);
        this.cancelB = new JButton(this.browser.getCancelAction());
        this.cancelB.setMnemonic(27);
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.gridwidth = 1;
        gbc.weightx = 50.0;
        gbc.weighty = 0.0;
        gbc.fill = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(10, 10, 10, 10);
        gbl.setConstraints(this.cancelB, gbc);
        this.add(this.cancelB);
        this.cancelB.setEnabled(true);
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        EBSBrowserWindow.getWindow().setCursor(Cursor.getPredefinedCursor(3));
        TreePath path = e.getPath();
        Object[] pathElements = path.getPath();
        Object obj = path.getLastPathComponent();
        this.doneB.setEnabled(true);
        if (obj instanceof TableNode || obj instanceof ViewNode) {
            TableNode node = null;
            Attribute[] attributes = null;
            if (obj instanceof ViewNode) {
                node = (ViewNode)obj;
                attributes = DBAccess.getViewAttributes(node.name, node.schemaName);
            } else if (obj instanceof TableNode) {
                node = (TableNode)obj;
                attributes = DBAccess.getTableAttributes(node.name, node.schemaName);
            }
            this.detailTableModel = null;
            node.setAttributes(attributes);
            this.detailTableModel = new DBTableModel(node.getAttributes());
            this.setModel(this.detailTableModel);
        } else if (obj instanceof WFEventNode) {
            this.clear();
            this.doneB.setEnabled(true);
            WFEventNode node = (WFEventNode)obj;
            this.detailTableModel = null;
            ArrayList v = DBAccess.getWFEventDetails(node.name);
            this.detailTableModel = new WFEventTableModel(new WFEventInfo((String)v.get(0), (String)v.get(1), (String)v.get(2), (String)v.get(3), (String)v.get(4), (String)v.get(5), (String)v.get(6), (String)v.get(7), (String)v.get(8), (String)v.get(9), node.direction));
            this.setModel(this.detailTableModel);
        } else if (obj instanceof ProcedureNode) {
            ProcedureNode procNode = (ProcedureNode)obj;
            this.detailTableModel = null;
            if ("CONCURRENT_PROGRAM".equals(procNode.packageName)) {
                String procName = procNode.name;
                ProcedureParam[] procParams = DBAccess.getCPAttributes(procName);
                procNode.setParams(procParams);
                this.detailTableModel = new ProcTableModel(procParams);
            } else {
                String procName = procNode.name;
                String pkgName = procNode.packageName;
                String objectId = procNode.objectId;
                int overload = procNode.getOverload();
                ProcedureParam[] procParams = DBAccess.getProcAttributes(procName, pkgName, objectId, overload);
                procNode.setParams(procParams);
                this.detailTableModel = new ProcTableModel(procParams);
            }
            this.setModel(this.detailTableModel);
        } else if (obj instanceof MapNode) {
            MapNode mapNode = (MapNode)obj;
            String mapName = mapNode.name;
            DtdInfo dtdInfo = DBAccess.getDtdDetailsFromMap(mapName);
            if (dtdInfo != null) {
                this.detailTableModel = null;
                this.detailTableModel = new DTDTableModel(dtdInfo);
                this.setModel(this.detailTableModel);
                this.payloadTA.setText(dtdInfo.payload);
                this.payloadTA.setCaretPosition(0);
            } else {
                this.clear();
            }
        } else {
            this.clear();
        }
        this.invalidate();
        EBSBrowserWindow.getWindow().setCursor(Cursor.getPredefinedCursor(0));
    }

    @Override
    public Attribute[] getSelectedAttributes() {
        int[] selRows = this.detailTable.getSelectedRows();
        EBSTableModel model = (EBSTableModel)this.detailTable.getModel();
        Attribute[] selAttrs = model.getSelectedAttributes(selRows);
        return selAttrs;
    }

    private void clear() {
        this.clearTable();
        if ("XMLG_MODE".equals(this.mode)) {
            this.payloadTA.setText("");
        }
        this.doneB.setEnabled(false);
    }

    void clearTable() {
        this.detailTableModel = null;
        this.detailTableModel = new DefaultTableModel();
        this.setModel(this.detailTableModel);
        this.invalidate();
    }

    private void setModel(TableModel tableModel) {
        TableColumn tc;
        int numCols;
        this.detailTable.setModel(tableModel);
        TableColumnModel tcm = this.detailTable.getColumnModel();
        if (tcm != null && (numCols = tcm.getColumnCount()) > 0 && (tc = tcm.getColumn(0)) != null) {
            tc.setPreferredWidth(Math.max(300, 20));
        }
    }
}

