/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.noniRep;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.common.DBAccess;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.common.metadata.ProcedureParam;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.common.metadata.SchemaObject;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.common.metadata.tree.GenericTreeNode;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.noniRep.EBSBrowserWindow;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.noniRep.ECObjectPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.noniRep.XMLGObjectPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.noniRep.metadata.ECXProductFamilyNode;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.noniRep.metadata.ECXProductNode;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.noniRep.metadata.EDIModuleNode;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.noniRep.metadata.MapNode;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.noniRep.metadata.OthersNode;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.noniRep.metadata.ProcedureNode;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AppFileAccess {
    static Document edi_doc;
    static Document xmlg_doc;
    static String filename;
    static AppFileAccess appFileAccess;
    static HashSet mapsActuallyPresent;
    static ArrayList extraMapsPresent;

    public static void buildDoc() {
        try {
            appFileAccess = new AppFileAccess();
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            if ("EDI_MODE".equals(EBSBrowserWindow.mode)) {
                URL fileURL = appFileAccess.getClass().getClassLoader().getResource("oracle/tip/tools/ide/pm/modules/bizintegration/adapter/apps/data/EDIGateway.xml");
                edi_doc = builder.parse(fileURL.openStream());
            } else if ("XMLG_MODE".equals(EBSBrowserWindow.mode)) {
                URL fileURL = appFileAccess.getClass().getClassLoader().getResource("oracle/tip/tools/ide/pm/modules/bizintegration/adapter/apps/data/XMLGateway.xml");
                xmlg_doc = builder.parse(fileURL.openStream());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("File not found : " + e);
        }
    }

    public static GenericTreeNode[] getModules(GenericTreeNode parent) {
        int i;
        GenericTreeNode[] childrens = null;
        Vector<String> v = new Vector<String>();
        String name = null;
        String shortName = null;
        int j = 0;
        String dir = ECObjectPage.mode;
        if (edi_doc == null) {
            AppFileAccess.buildDoc();
        }
        NodeList l = edi_doc.getElementsByTagName(dir);
        Node node = l.item(0);
        NodeList productList = node.getChildNodes();
        for (i = 0; i < productList.getLength(); ++i) {
            Node child = productList.item(i);
            if (!child.getNodeName().equalsIgnoreCase("product")) continue;
            NamedNodeMap nodeMap = child.getAttributes();
            Node shortNameNode = nodeMap.getNamedItem("shortname");
            Node fullNameNode = nodeMap.getNamedItem("fullname");
            v.add(shortNameNode.getNodeValue());
            v.add(fullNameNode.getNodeValue());
        }
        if (v.size() > 0) {
            childrens = new GenericTreeNode[v.size() / 2];
            for (i = 0; i < v.size(); ++i) {
                shortName = (String)v.elementAt(i);
                name = (String)v.elementAt(++i);
                childrens[j++] = new EDIModuleNode(shortName, name, parent);
            }
        }
        return childrens;
    }

    public static GenericTreeNode[] getCPs(String moduleName, GenericTreeNode parent) {
        int i;
        System.out.println("modulename = " + moduleName);
        System.out.println("parent = " + parent);
        GenericTreeNode[] childrens = null;
        Vector<ProcedureNode> v = new Vector<ProcedureNode>();
        Object name = null;
        Object objOwner = null;
        if (edi_doc == null) {
            AppFileAccess.buildDoc();
        }
        String dir = ECObjectPage.mode;
        NodeList l = edi_doc.getElementsByTagName(dir);
        Node node = l.item(0);
        NodeList productList = node.getChildNodes();
        for (i = 0; i < productList.getLength(); ++i) {
            NamedNodeMap nodeMap;
            Node n;
            Node child = productList.item(i);
            if (!child.getNodeName().equalsIgnoreCase("product") || !(n = (nodeMap = child.getAttributes()).getNamedItem("shortname")).getNodeValue().equalsIgnoreCase(moduleName)) continue;
            NodeList listOfCPNodes = child.getChildNodes();
            for (int j = 0; j < listOfCPNodes.getLength(); ++j) {
                Node cp = listOfCPNodes.item(j);
                if (!cp.getNodeName().equalsIgnoreCase("cp")) continue;
                NamedNodeMap nm = cp.getAttributes();
                Node nameNode = nm.getNamedItem("shortname");
                Node fullNameNode = nm.getNamedItem("fullname");
                v.addElement(new ProcedureNode("CONCURRENT_PROGRAM", nameNode.getNodeValue(), fullNameNode.getNodeValue(), parent, 0));
            }
        }
        if (v.size() > 0) {
            childrens = new GenericTreeNode[v.size()];
            for (i = 0; i < v.size(); ++i) {
                childrens[i] = (ProcedureNode)v.elementAt(i);
            }
            return childrens;
        }
        return childrens;
    }

    public static ProcedureParam[] getCPAttributes(String progName) {
        int i;
        ProcedureParam[] params = null;
        Vector<ProcedureParam> v = new Vector<ProcedureParam>();
        int count = 1;
        if (edi_doc == null) {
            AppFileAccess.buildDoc();
        }
        NodeList l = edi_doc.getElementsByTagName("cp");
        for (i = 0; i < l.getLength(); ++i) {
            Node cp = l.item(i);
            NamedNodeMap attr = cp.getAttributes();
            Node nameNode = attr.getNamedItem("name");
            if (!nameNode.getNodeValue().equalsIgnoreCase(progName)) continue;
            NodeList parameters = cp.getChildNodes();
            for (int j = 0; j < parameters.getLength(); ++j) {
                Node param = parameters.item(j);
                if (!"param".equalsIgnoreCase(param.getNodeName())) continue;
                SchemaObject otype = new SchemaObject(null, "VARCHAR2");
                String name = param.getFirstChild().getNodeValue();
                ProcedureParam col = new ProcedureParam(name, otype, null, true, false, "IN", count, 0, "VARCHAR2", 0);
                v.addElement(col);
                ++count;
            }
            break;
        }
        if (v.size() > 0) {
            params = new ProcedureParam[v.size()];
            for (i = 0; i < v.size(); ++i) {
                params[i] = (ProcedureParam)v.elementAt(i);
            }
            return params;
        }
        return params;
    }

    public static GenericTreeNode[] getProductFamilies(GenericTreeNode parent) {
        int i;
        GenericTreeNode[] childrens = null;
        Vector<String> v = new Vector<String>();
        String name = null;
        String shortName = null;
        int t = 0;
        String direction = XMLGObjectPage.direction;
        System.out.println("getProductFamilies:  " + direction);
        if (xmlg_doc == null) {
            AppFileAccess.buildDoc();
        }
        System.out.println("Initializing the maps from database.");
        AppFileAccess.initializeMapsFromDB();
        System.out.println("Initializion of maps complete.");
        NodeList l = xmlg_doc.getElementsByTagName(direction);
        if (l == null) {
            return childrens;
        }
        Node node = l.item(0);
        NodeList productFamilyList = node.getChildNodes();
        for (i = 0; i < productFamilyList.getLength(); ++i) {
            Node aFamily = productFamilyList.item(i);
            if (!"productfamily".equalsIgnoreCase(aFamily.getNodeName())) continue;
            NamedNodeMap nodeMap = aFamily.getAttributes();
            Node shortNameNode = nodeMap.getNamedItem("shortname");
            Node fullNameNode = nodeMap.getNamedItem("fullname");
            v.add(shortNameNode.getNodeValue());
            v.add(fullNameNode.getNodeValue());
        }
        childrens = new GenericTreeNode[v.size() / 2 + 1];
        for (i = 0; i < v.size(); ++i) {
            shortName = (String)v.elementAt(i);
            name = (String)v.elementAt(++i);
            childrens[t++] = new ECXProductFamilyNode(shortName, name, parent);
        }
        childrens[t] = new OthersNode("Others", "Others", parent);
        System.out.println("Families obtained.");
        return childrens;
    }

    public static GenericTreeNode[] getProducts(String family, GenericTreeNode parent) {
        int i;
        GenericTreeNode[] childrens = null;
        Vector<String> v = new Vector<String>();
        String name = null;
        String shortName = null;
        int t = 0;
        String direction = XMLGObjectPage.direction;
        if (xmlg_doc == null) {
            AppFileAccess.buildDoc();
        }
        NodeList l = xmlg_doc.getElementsByTagName(direction);
        Node node = l.item(0);
        NodeList productFamilyList = node.getChildNodes();
        for (i = 0; i < productFamilyList.getLength(); ++i) {
            NamedNodeMap nodeMap;
            Node shortNameNode;
            Node aFamily = productFamilyList.item(i);
            if (!"productfamily".equalsIgnoreCase(aFamily.getNodeName()) || !family.equalsIgnoreCase((shortNameNode = (nodeMap = aFamily.getAttributes()).getNamedItem("shortname")).getNodeValue())) continue;
            NodeList productList = aFamily.getChildNodes();
            for (int j = 0; j < productList.getLength(); ++j) {
                Node aProduct = productList.item(j);
                if (!"product".equalsIgnoreCase(aProduct.getNodeName())) continue;
                NamedNodeMap nodeMap1 = aProduct.getAttributes();
                Node shortNameNode1 = nodeMap1.getNamedItem("shortname");
                Node fullNameNode1 = nodeMap1.getNamedItem("fullname");
                v.add(shortNameNode1.getNodeValue());
                v.add(fullNameNode1.getNodeValue());
            }
        }
        childrens = new GenericTreeNode[v.size() / 2];
        for (i = 0; i < v.size(); ++i) {
            shortName = (String)v.elementAt(i);
            name = (String)v.elementAt(++i);
            childrens[t++] = new ECXProductNode(shortName, name, parent);
        }
        return childrens;
    }

    public static GenericTreeNode[] getMaps(String product, GenericTreeNode parent) {
        GenericTreeNode[] childrens = null;
        Vector<String> v = new Vector<String>();
        String name = null;
        Object shortName = null;
        boolean t = false;
        String direction = XMLGObjectPage.direction;
        System.out.println("getMaps:  " + direction);
        if (xmlg_doc == null) {
            AppFileAccess.buildDoc();
        }
        NodeList l = xmlg_doc.getElementsByTagName(direction);
        Node node = l.item(0);
        NodeList productFamilyList = node.getChildNodes();
        for (int i = 0; i < productFamilyList.getLength(); ++i) {
            Node aFamily = productFamilyList.item(i);
            if (!"productfamily".equalsIgnoreCase(aFamily.getNodeName())) continue;
            NodeList productList = aFamily.getChildNodes();
            for (int j = 0; j < productList.getLength(); ++j) {
                NamedNodeMap nodeMap;
                Node shortNameNode;
                Node aProduct = productList.item(j);
                if (!"product".equalsIgnoreCase(aProduct.getNodeName()) || !product.equalsIgnoreCase((shortNameNode = (nodeMap = aProduct.getAttributes()).getNamedItem("shortname")).getNodeValue())) continue;
                NodeList mapList = aProduct.getChildNodes();
                for (int k = 0; k < mapList.getLength(); ++k) {
                    Node aMap = mapList.item(k);
                    if (!"xmlgatewaymap".equalsIgnoreCase(aMap.getNodeName())) continue;
                    nodeMap = aMap.getAttributes();
                    shortNameNode = nodeMap.getNamedItem("shortname");
                    Node fullNameNode = nodeMap.getNamedItem("fullname");
                    if (!mapsActuallyPresent.contains(shortNameNode.getNodeValue())) continue;
                    v.add(shortNameNode.getNodeValue());
                    v.add(fullNameNode.getNodeValue());
                }
            }
        }
        childrens = new GenericTreeNode[v.size() / 2];
        int j = 0;
        for (int i = 0; i < v.size(); i += 2) {
            name = (String)v.elementAt(i);
            String fullName = (String)v.elementAt(i + 1);
            childrens[j] = new MapNode(name, fullName, parent);
            ++j;
        }
        System.out.println("getMaps: Maps Obtained  ");
        return childrens;
    }

    public static void initializeMapsFromDB() {
        NodeList listOfMaps = xmlg_doc.getElementsByTagName("xmlgatewaymap");
        ArrayList<String> v = new ArrayList<String>();
        for (int i = 0; i < listOfMaps.getLength(); ++i) {
            Node mapNode = listOfMaps.item(i);
            if (mapNode == null) continue;
            NamedNodeMap attributeNode = mapNode.getAttributes();
            Node shortNameNode = attributeNode.getNamedItem("shortname");
            v.add(shortNameNode.getNodeValue());
        }
        mapsActuallyPresent = DBAccess.getActualMapsPresent(v);
        DBAccess.direction = XMLGObjectPage.direction;
        extraMapsPresent = DBAccess.getExtraMapsPresent(v);
    }

    public static GenericTreeNode[] getExtraMaps(String product, GenericTreeNode parent) {
        ArrayList v = extraMapsPresent;
        GenericTreeNode[] childrens = new GenericTreeNode[v.size()];
        for (int i = 0; i < v.size(); ++i) {
            childrens[i] = new MapNode((String)v.get(i), "", parent);
        }
        System.out.println("getExtraMaps: Maps Obtained  ");
        return childrens;
    }

    static {
        appFileAccess = null;
        mapsActuallyPresent = null;
        extraMapsPresent = null;
    }
}

